/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.dynamicdatamapping.webdav;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.webdav.BaseResourceImpl;
import com.liferay.portal.kernel.webdav.Resource;
import com.liferay.portal.kernel.webdav.WebDAVException;
import com.liferay.portal.kernel.webdav.WebDAVRequest;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.dynamicdatamapping.NoSuchStructureException;
import com.liferay.portlet.dynamicdatamapping.NoSuchTemplateException;
import com.liferay.portlet.dynamicdatamapping.model.DDMStructure;
import com.liferay.portlet.dynamicdatamapping.model.DDMTemplate;
import com.liferay.portlet.dynamicdatamapping.service.DDMStructureLocalServiceUtil;
import com.liferay.portlet.dynamicdatamapping.service.DDMStructureServiceUtil;
import com.liferay.portlet.dynamicdatamapping.service.DDMTemplateLocalServiceUtil;
import com.liferay.portlet.dynamicdatamapping.service.DDMTemplateServiceUtil;
import com.liferay.portlet.dynamicdatamapping.webdav.DDMStructureResourceImpl;
import com.liferay.portlet.dynamicdatamapping.webdav.DDMTemplateResourceImpl;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class DDMWebDavUtil {
    public static final String TYPE_STRUCTURES = "Structures";
    public static final String TYPE_TEMPLATES = "Templates";

    public static int addResource(WebDAVRequest webDavRequest, long classNameId) throws Exception {
        String[] pathArray = webDavRequest.getPathArray();
        if (pathArray.length != 4) {
            return 403;
        }
        String type = pathArray[2];
        String typeId = pathArray[3];
        if (type.equals(TYPE_STRUCTURES)) {
            HttpServletRequest request = webDavRequest.getHttpServletRequest();
            String xsd = StringUtil.read((InputStream)request.getInputStream());
            String defaultLocale = LocalizationUtil.getDefaultLocale((String)xsd);
            HashMap<Locale, String> nameMap = new HashMap<Locale, String>();
            nameMap.put(LocaleUtil.fromLanguageId((String)defaultLocale), typeId);
            ServiceContext serviceContext = new ServiceContext();
            serviceContext.setAddGroupPermissions(true);
            serviceContext.setAddGuestPermissions(true);
            DDMStructureLocalServiceUtil.addStructure((long)webDavRequest.getUserId(), (long)webDavRequest.getGroupId(), (long)classNameId, nameMap, null, (String)xsd, (ServiceContext)serviceContext);
            return 201;
        }
        if (type.equals(TYPE_TEMPLATES)) {
            return 403;
        }
        return 403;
    }

    public static int deleteResource(WebDAVRequest webDAVRequest, String rootPath, String token, long classNameId) throws WebDAVException {
        Object model;
        block7: {
            Resource resource;
            block6: {
                resource = DDMWebDavUtil.getResource(webDAVRequest, rootPath, token, classNameId);
                if (resource != null) break block6;
                return 404;
            }
            model = resource.getModel();
            if (!(model instanceof DDMStructure)) break block7;
            DDMStructure structure = (DDMStructure)model;
            DDMStructureServiceUtil.deleteStructure((long)structure.getStructureId());
            return 204;
        }
        try {
            if (model instanceof DDMTemplate) {
                DDMTemplate template = (DDMTemplate)model;
                DDMTemplateServiceUtil.deleteTemplate((long)template.getTemplateId());
                return 204;
            }
            return 403;
        }
        catch (PortalException portalException) {
            return 403;
        }
        catch (Exception e2) {
            throw new WebDAVException((Throwable)e2);
        }
    }

    public static Resource getResource(WebDAVRequest webDAVRequest, String rootPath, String token, long classNameId) throws WebDAVException {
        block13: {
            String typeId;
            String type;
            block14: {
                try {
                    String[] pathArray = webDAVRequest.getPathArray();
                    if (pathArray.length == 2) {
                        String path = String.valueOf(rootPath) + webDAVRequest.getPath();
                        return new BaseResourceImpl(path, "", token);
                    }
                    if (pathArray.length == 3) {
                        String type2 = pathArray[2];
                        return DDMWebDavUtil.toResource(webDAVRequest, type2, rootPath, false);
                    }
                    if (pathArray.length != 4) break block13;
                    type = pathArray[2];
                    typeId = pathArray[3];
                    if (!type.equals(TYPE_STRUCTURES)) break block14;
                    try {
                        DDMStructure structure = null;
                        try {
                            structure = DDMStructureLocalServiceUtil.getStructure((long)GetterUtil.getLong((String)typeId));
                        }
                        catch (NumberFormatException numberFormatException) {
                            structure = DDMStructureLocalServiceUtil.getStructure((long)webDAVRequest.getGroupId(), (long)classNameId, (String)typeId);
                        }
                        return DDMWebDavUtil.toResource(webDAVRequest, structure, rootPath, false);
                    }
                    catch (NoSuchStructureException noSuchStructureException) {
                        return null;
                    }
                }
                catch (Exception e2) {
                    throw new WebDAVException((Throwable)e2);
                }
            }
            if (!type.equals(TYPE_TEMPLATES)) break block13;
            try {
                DDMTemplate template = null;
                try {
                    template = DDMTemplateLocalServiceUtil.getTemplate((long)GetterUtil.getLong((String)typeId));
                }
                catch (NumberFormatException numberFormatException) {
                    template = DDMTemplateLocalServiceUtil.getTemplate((long)webDAVRequest.getGroupId(), (long)classNameId, (String)typeId);
                }
                return DDMWebDavUtil.toResource(webDAVRequest, template, rootPath, false);
            }
            catch (NoSuchTemplateException noSuchTemplateException) {
                return null;
            }
        }
        return null;
    }

    public static int putResource(WebDAVRequest webDAVRequest, String rootPath, String token, long classNameId) throws WebDAVException {
        Object model;
        block6: {
            Resource resource = DDMWebDavUtil.getResource(webDAVRequest, rootPath, token, classNameId);
            if (resource == null) {
                return DDMWebDavUtil.addResource(webDAVRequest, classNameId);
            }
            model = resource.getModel();
            if (!(model instanceof DDMStructure)) break block6;
            DDMStructure structure = (DDMStructure)model;
            HttpServletRequest request = webDAVRequest.getHttpServletRequest();
            String xsd = StringUtil.read((InputStream)request.getInputStream());
            DDMStructureServiceUtil.updateStructure((long)structure.getGroupId(), (long)structure.getParentStructureId(), (long)structure.getClassNameId(), (String)structure.getStructureKey(), (Map)structure.getNameMap(), (Map)structure.getDescriptionMap(), (String)xsd, (ServiceContext)new ServiceContext());
            return 201;
        }
        try {
            if (model instanceof DDMTemplate) {
                DDMTemplate template = (DDMTemplate)model;
                HttpServletRequest request = webDAVRequest.getHttpServletRequest();
                String script = StringUtil.read((InputStream)request.getInputStream());
                DDMTemplateServiceUtil.updateTemplate((long)template.getTemplateId(), (Map)template.getNameMap(), (Map)template.getDescriptionMap(), (String)template.getType(), (String)template.getMode(), (String)template.getLanguage(), (String)script, (boolean)template.isCacheable(), (boolean)template.isSmallImage(), (String)template.getSmallImageURL(), null, (ServiceContext)new ServiceContext());
                return 201;
            }
            return 403;
        }
        catch (PortalException portalException) {
            return 403;
        }
        catch (Exception e2) {
            throw new WebDAVException((Throwable)e2);
        }
    }

    public static Resource toResource(WebDAVRequest webDAVRequest, DDMStructure structure, String rootPath, boolean appendPath) {
        String parentPath = String.valueOf(rootPath) + webDAVRequest.getPath();
        String name = "";
        if (appendPath) {
            name = String.valueOf(structure.getStructureId());
        }
        return new DDMStructureResourceImpl(structure, parentPath, name);
    }

    public static Resource toResource(WebDAVRequest webDAVRequest, DDMTemplate template, String rootPath, boolean appendPath) {
        String parentPath = String.valueOf(rootPath) + webDAVRequest.getPath();
        String name = "";
        if (appendPath) {
            name = String.valueOf(template.getTemplateId());
        }
        return new DDMTemplateResourceImpl(template, parentPath, name);
    }

    public static Resource toResource(WebDAVRequest webDAVRequest, String type, String rootPath, boolean appendPath) {
        String parentPath = String.valueOf(rootPath) + webDAVRequest.getPath();
        String name = "";
        if (appendPath) {
            name = type;
        }
        BaseResourceImpl resource = new BaseResourceImpl(parentPath, name, type);
        resource.setModel((Object)type);
        return resource;
    }
}

