/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.dynamicdatamapping.util;

import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portlet.dynamicdatamapping.model.DDMStructure;
import com.liferay.portlet.dynamicdatamapping.storage.Field;
import com.liferay.portlet.dynamicdatamapping.storage.Fields;
import com.liferay.portlet.dynamicdatamapping.util.DDMIndexer;
import java.io.Serializable;
import java.util.Date;
import java.util.Locale;

public class DDMIndexerImpl
implements DDMIndexer {
    private static Log _log = LogFactoryUtil.getLog(DDMIndexerImpl.class);

    public void addAttributes(Document document, DDMStructure ddmStructure, Fields fields) {
        for (Field field : fields) {
            try {
                String indexType = ddmStructure.getFieldProperty(field.getName(), "indexType");
                if (Validator.isNull((String)indexType)) continue;
                Locale[] localeArray = LanguageUtil.getAvailableLocales();
                int n = localeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Locale locale = localeArray[n2];
                    String name = this.encodeName(ddmStructure.getStructureId(), field.getName(), locale);
                    Serializable value = field.getValue(locale);
                    if (value instanceof Boolean) {
                        document.addKeyword(name, (Boolean)value);
                    } else if (value instanceof Boolean[]) {
                        document.addKeyword(name, (Boolean[])value);
                    } else if (value instanceof Date) {
                        document.addDate(name, (Date)value);
                    } else if (value instanceof Date[]) {
                        document.addDate(name, (Date[])value);
                    } else if (value instanceof Double) {
                        document.addKeyword(name, (Double)value);
                    } else if (value instanceof Double[]) {
                        document.addKeyword(name, (Double[])value);
                    } else if (value instanceof Integer) {
                        document.addKeyword(name, (Integer)value);
                    } else if (value instanceof Integer[]) {
                        document.addKeyword(name, (Integer[])value);
                    } else if (value instanceof Object[]) {
                        String[] valuesString = ArrayUtil.toStringArray((Object[])((Object[])value));
                        if (indexType.equals("keyword")) {
                            document.addKeyword(name, valuesString);
                        } else {
                            document.addText(name, valuesString);
                        }
                    } else {
                        String valueString = String.valueOf(value);
                        String type = field.getType();
                        if (type.equals("radio") || type.equals("select")) {
                            JSONArray jsonArray = JSONFactoryUtil.createJSONArray((String)valueString);
                            String[] stringArray = ArrayUtil.toStringArray((JSONArray)jsonArray);
                            if (indexType.equals("keyword")) {
                                document.addKeyword(name, stringArray);
                            } else {
                                document.addText(name, stringArray);
                            }
                        } else if (indexType.equals("keyword")) {
                            document.addKeyword(name, valueString);
                        } else {
                            document.addText(name, valueString);
                        }
                    }
                    ++n2;
                }
            }
            catch (Exception e2) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)e2, (Throwable)e2);
            }
        }
    }

    public String encodeName(long ddmStructureId, String fieldName) {
        return this.encodeName(ddmStructureId, fieldName, null);
    }

    public String encodeName(long ddmStructureId, String fieldName, Locale locale) {
        StringBundler sb = new StringBundler(7);
        sb.append("ddm");
        sb.append("/");
        sb.append(ddmStructureId);
        sb.append("/");
        sb.append(fieldName);
        if (Validator.isNotNull((Object)locale)) {
            sb.append("_");
            sb.append(LocaleUtil.toLanguageId((Locale)locale));
        }
        return sb.toString();
    }
}

