/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.dynamicdatamapping.storage;

import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.kernel.xml.XPath;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.dynamicdatamapping.model.DDMContent;
import com.liferay.portlet.dynamicdatamapping.model.DDMStorageLink;
import com.liferay.portlet.dynamicdatamapping.model.DDMStructure;
import com.liferay.portlet.dynamicdatamapping.service.DDMContentLocalServiceUtil;
import com.liferay.portlet.dynamicdatamapping.service.DDMStorageLinkLocalServiceUtil;
import com.liferay.portlet.dynamicdatamapping.service.DDMStructureLocalServiceUtil;
import com.liferay.portlet.dynamicdatamapping.storage.BaseStorageAdapter;
import com.liferay.portlet.dynamicdatamapping.storage.Fields;
import com.liferay.portlet.dynamicdatamapping.storage.query.ComparisonOperator;
import com.liferay.portlet.dynamicdatamapping.storage.query.Condition;
import com.liferay.portlet.dynamicdatamapping.storage.query.FieldCondition;
import com.liferay.portlet.dynamicdatamapping.storage.query.FieldConditionImpl;
import com.liferay.portlet.dynamicdatamapping.storage.query.Junction;
import com.liferay.portlet.dynamicdatamapping.storage.query.LogicalOperator;
import com.liferay.portlet.dynamicdatamapping.util.DDMUtil;
import com.liferay.portlet.dynamicdatamapping.util.DDMXMLUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class XMLStorageAdapter
extends BaseStorageAdapter {
    protected long doCreate(long companyId, long ddmStructureId, Fields fields, ServiceContext serviceContext) throws Exception {
        long classNameId = PortalUtil.getClassNameId((String)DDMContent.class.getName());
        DDMContent ddmContent = DDMContentLocalServiceUtil.addContent((long)serviceContext.getUserId(), (long)serviceContext.getScopeGroupId(), (String)DDMStorageLink.class.getName(), null, (String)DDMXMLUtil.getXML((Fields)fields), (ServiceContext)serviceContext);
        DDMStorageLinkLocalServiceUtil.addStorageLink((long)classNameId, (long)ddmContent.getPrimaryKey(), (long)ddmStructureId, (ServiceContext)serviceContext);
        return ddmContent.getPrimaryKey();
    }

    protected void doDeleteByClass(long classPK) throws Exception {
        DDMContentLocalServiceUtil.deleteDDMContent((long)classPK);
        DDMStorageLinkLocalServiceUtil.deleteClassStorageLink((long)classPK);
    }

    protected void doDeleteByDDMStructure(long ddmStructureId) throws Exception {
        List ddmStorageLinks = DDMStorageLinkLocalServiceUtil.getStructureStorageLinks((long)ddmStructureId);
        for (DDMStorageLink ddmStorageLink : ddmStorageLinks) {
            DDMContentLocalServiceUtil.deleteDDMContent((long)ddmStorageLink.getClassPK());
        }
        DDMStorageLinkLocalServiceUtil.deleteStructureStorageLinks((long)ddmStructureId);
    }

    protected List<Fields> doGetFieldsListByClasses(long ddmStructureId, long[] classPKs, List<String> fieldNames, OrderByComparator orderByComparator) throws Exception {
        return this._doQuery(ddmStructureId, classPKs, fieldNames, null, orderByComparator);
    }

    protected List<Fields> doGetFieldsListByDDMStructure(long ddmStructureId, List<String> fieldNames, OrderByComparator orderByComparator) throws Exception {
        return this._doQuery(ddmStructureId, fieldNames, null, orderByComparator);
    }

    protected Map<Long, Fields> doGetFieldsMapByClasses(long ddmStructureId, long[] classPKs, List<String> fieldNames) throws Exception {
        return this._doQuery(ddmStructureId, classPKs, fieldNames);
    }

    protected List<Fields> doQuery(long ddmStructureId, List<String> fieldNames, Condition condition, OrderByComparator orderByComparator) throws Exception {
        return this._doQuery(ddmStructureId, fieldNames, condition, orderByComparator);
    }

    protected int doQueryCount(long ddmStructureId, Condition condition) throws Exception {
        long[] classPKs;
        XPath conditionXPath = null;
        if (condition != null) {
            conditionXPath = this._parseCondition(condition);
        }
        int count = 0;
        long[] lArray = classPKs = this._getStructureClassPKs(ddmStructureId);
        int n = classPKs.length;
        int n2 = 0;
        while (n2 < n) {
            long classPK = lArray[n2];
            DDMContent ddmContent = DDMContentLocalServiceUtil.getContent((long)classPK);
            Document document = SAXReaderUtil.read((String)ddmContent.getXml());
            if (conditionXPath == null || conditionXPath != null && conditionXPath.booleanValueOf((Object)document)) {
                ++count;
            }
            ++n2;
        }
        return count;
    }

    protected void doUpdate(long classPK, Fields fields, boolean mergeFields, ServiceContext serviceContext) throws Exception {
        DDMContent ddmContent = DDMContentLocalServiceUtil.getContent((long)classPK);
        ddmContent.setModifiedDate(serviceContext.getModifiedDate(null));
        if (mergeFields) {
            fields = DDMUtil.mergeFields((Fields)fields, (Fields)this.getFields(classPK));
        }
        ddmContent.setXml(DDMXMLUtil.getXML((Fields)fields));
        DDMContentLocalServiceUtil.updateContent((long)ddmContent.getPrimaryKey(), (String)ddmContent.getName(), (String)ddmContent.getDescription(), (String)ddmContent.getXml(), (ServiceContext)serviceContext);
    }

    private List<Fields> _doQuery(long ddmStructureId, List<String> fieldNames, Condition condition, OrderByComparator orderByComparator) throws Exception {
        return this._doQuery(ddmStructureId, this._getStructureClassPKs(ddmStructureId), fieldNames, condition, orderByComparator);
    }

    private Map<Long, Fields> _doQuery(long ddmStructureId, long[] classPKs, List<String> fieldNames) throws Exception {
        HashMap<Long, Fields> fieldsMap = new HashMap<Long, Fields>();
        List<Fields> fieldsList = this._doQuery(ddmStructureId, classPKs, fieldNames, null, null);
        int i2 = 0;
        while (i2 < fieldsList.size()) {
            Fields fields = fieldsList.get(i2);
            fieldsMap.put(classPKs[i2], fields);
            ++i2;
        }
        return fieldsMap;
    }

    private List<Fields> _doQuery(long ddmStructureId, long[] classPKs, List<String> fieldNames, Condition condition, OrderByComparator orderByComparator) throws Exception {
        ArrayList<Fields> fieldsList = new ArrayList<Fields>();
        XPath conditionXPath = null;
        if (condition != null) {
            conditionXPath = this._parseCondition(condition);
        }
        DDMStructure ddmStructure = DDMStructureLocalServiceUtil.getDDMStructure((long)ddmStructureId);
        long[] lArray = classPKs;
        int n = classPKs.length;
        int n2 = 0;
        while (n2 < n) {
            long classPK = lArray[n2];
            DDMContent ddmContent = DDMContentLocalServiceUtil.getContent((long)classPK);
            Fields fields = DDMXMLUtil.getFields((DDMStructure)ddmStructure, (XPath)conditionXPath, (String)ddmContent.getXml(), fieldNames);
            fieldsList.add(fields);
            ++n2;
        }
        if (orderByComparator != null) {
            Collections.sort(fieldsList, orderByComparator);
        }
        return fieldsList;
    }

    private long[] _getStructureClassPKs(long ddmStructureId) throws Exception {
        ArrayList<Long> classPKs = new ArrayList<Long>();
        List ddmStorageLinks = DDMStorageLinkLocalServiceUtil.getStructureStorageLinks((long)ddmStructureId);
        for (DDMStorageLink ddmStorageLink : ddmStorageLinks) {
            classPKs.add(ddmStorageLink.getClassPK());
        }
        return ArrayUtil.toArray((Long[])classPKs.toArray(new Long[classPKs.size()]));
    }

    private XPath _parseCondition(Condition condition) {
        StringBundler sb = new StringBundler(4);
        sb.append("//dynamic-element");
        sb.append("[");
        sb.append(this._toXPath(condition));
        sb.append("]");
        return SAXReaderUtil.createXPath((String)sb.toString());
    }

    private String _toXPath(Condition condition) {
        StringBundler sb = new StringBundler();
        if (condition.isJunction()) {
            sb.append("(");
            sb.append(this._toXPath((Junction)condition));
            sb.append(")");
        } else {
            sb.append(this._toXPath((FieldConditionImpl)condition));
        }
        return sb.toString();
    }

    private String _toXPath(FieldCondition fieldCondition) {
        StringBundler sb = new StringBundler(6);
        sb.append("(@name=");
        String name = HtmlUtil.escapeXPathAttribute((String)String.valueOf(fieldCondition.getName()));
        sb.append(name);
        ComparisonOperator comparisonOperator = fieldCondition.getComparisonOperator();
        if (comparisonOperator.equals((Object)ComparisonOperator.LIKE)) {
            sb.append(" and matches(dynamic-content, ");
        } else {
            sb.append(" and dynamic-content= ");
        }
        String value = HtmlUtil.escapeXPathAttribute((String)String.valueOf(fieldCondition.getValue()));
        sb.append(value);
        if (comparisonOperator.equals((Object)ComparisonOperator.LIKE)) {
            sb.append(")");
        }
        sb.append(")");
        return sb.toString();
    }

    private String _toXPath(Junction junction) {
        StringBundler sb = new StringBundler();
        LogicalOperator logicalOperator = junction.getLogicalOperator();
        String logicalOperatorString = logicalOperator.toString();
        Iterator itr = junction.iterator();
        while (itr.hasNext()) {
            Condition condition = (Condition)itr.next();
            sb.append(this._toXPath(condition));
            if (!itr.hasNext()) continue;
            sb.append(" ");
            sb.append(logicalOperatorString.toLowerCase());
            sb.append(" ");
        }
        return sb.toString();
    }
}

