/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.dynamicdatamapping.service.permission;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portlet.dynamicdatamapping.model.DDMStructure;
import com.liferay.portlet.dynamicdatamapping.service.DDMStructureLocalServiceUtil;

public class DDMStructurePermission {
    public static void check(PermissionChecker permissionChecker, DDMStructure structure, String actionId) throws PortalException {
        if (!DDMStructurePermission.contains(permissionChecker, structure, actionId)) {
            throw new PrincipalException();
        }
    }

    public static void check(PermissionChecker permissionChecker, long groupId, long classNameId, String structureKey, String actionId) throws PortalException, SystemException {
        if (!DDMStructurePermission.contains(permissionChecker, groupId, classNameId, structureKey, actionId)) {
            throw new PrincipalException();
        }
    }

    public static void check(PermissionChecker permissionChecker, long structureId, String actionId) throws PortalException, SystemException {
        if (!DDMStructurePermission.contains(permissionChecker, structureId, actionId)) {
            throw new PrincipalException();
        }
    }

    public static boolean contains(PermissionChecker permissionChecker, DDMStructure structure, String actionId) {
        if (permissionChecker.hasOwnerPermission(structure.getCompanyId(), DDMStructure.class.getName(), structure.getStructureId(), structure.getUserId(), actionId)) {
            return true;
        }
        return permissionChecker.hasPermission(structure.getGroupId(), DDMStructure.class.getName(), structure.getStructureId(), actionId);
    }

    public static boolean contains(PermissionChecker permissionChecker, long groupId, long classNameId, String structureKey, String actionId) throws PortalException, SystemException {
        DDMStructure structure = DDMStructureLocalServiceUtil.getStructure((long)groupId, (long)classNameId, (String)structureKey);
        return DDMStructurePermission.contains(permissionChecker, structure, actionId);
    }

    public static boolean contains(PermissionChecker permissionChecker, long structureId, String actionId) throws PortalException, SystemException {
        DDMStructure structure = DDMStructureLocalServiceUtil.getStructure((long)structureId);
        return DDMStructurePermission.contains(permissionChecker, structure, actionId);
    }
}

