/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.dynamicdatamapping.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Image;
import com.liferay.portal.model.User;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.persistence.ImageUtil;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PrefsPropsUtil;
import com.liferay.portlet.dynamicdatamapping.NoSuchTemplateException;
import com.liferay.portlet.dynamicdatamapping.RequiredTemplateException;
import com.liferay.portlet.dynamicdatamapping.TemplateDuplicateTemplateKeyException;
import com.liferay.portlet.dynamicdatamapping.TemplateNameException;
import com.liferay.portlet.dynamicdatamapping.TemplateScriptException;
import com.liferay.portlet.dynamicdatamapping.TemplateSmallImageNameException;
import com.liferay.portlet.dynamicdatamapping.TemplateSmallImageSizeException;
import com.liferay.portlet.dynamicdatamapping.model.DDMStructure;
import com.liferay.portlet.dynamicdatamapping.model.DDMTemplate;
import com.liferay.portlet.dynamicdatamapping.service.base.DDMTemplateLocalServiceBaseImpl;
import com.liferay.portlet.dynamicdatamapping.util.DDMXMLUtil;
import com.liferay.portlet.journal.model.JournalArticle;
import com.liferay.portlet.journal.service.persistence.JournalArticleUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class DDMTemplateLocalServiceImpl
extends DDMTemplateLocalServiceBaseImpl {
    private static Log _log = LogFactoryUtil.getLog(DDMTemplateLocalServiceImpl.class);

    public DDMTemplate addTemplate(long userId, long groupId, long classNameId, long classPK, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, String type, String mode, String language, String script, ServiceContext serviceContext) throws PortalException, SystemException {
        return this.addTemplate(userId, groupId, classNameId, classPK, null, nameMap, descriptionMap, type, mode, language, script, false, false, null, null, serviceContext);
    }

    public DDMTemplate addTemplate(long userId, long groupId, long classNameId, long classPK, String templateKey, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, String type, String mode, String language, String script, boolean cacheable, boolean smallImage, String smallImageURL, File smallImageFile, ServiceContext serviceContext) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        Date now = new Date();
        templateKey = Validator.isNull((String)templateKey) ? String.valueOf(this.counterLocalService.increment()) : templateKey.trim().toUpperCase();
        script = this.formatScript(type, language, script);
        byte[] smallImageBytes = null;
        if (smallImage) {
            try {
                smallImageBytes = FileUtil.getBytes((File)smallImageFile);
            }
            catch (IOException iOException) {}
            if (smallImageBytes == null || Validator.isUrl((String)smallImageURL)) {
                smallImage = false;
            }
        }
        this.validate(groupId, classNameId, templateKey, nameMap, script, smallImage, smallImageURL, smallImageFile, smallImageBytes);
        long templateId = this.counterLocalService.increment();
        DDMTemplate template = this.ddmTemplatePersistence.create(templateId);
        template.setUuid(serviceContext.getUuid());
        template.setGroupId(groupId);
        template.setCompanyId(user.getCompanyId());
        template.setUserId(user.getUserId());
        template.setUserName(user.getFullName());
        template.setCreateDate(serviceContext.getCreateDate(now));
        template.setModifiedDate(serviceContext.getModifiedDate(now));
        template.setClassNameId(classNameId);
        template.setClassPK(classPK);
        template.setTemplateKey(templateKey);
        template.setNameMap(nameMap);
        template.setDescriptionMap(descriptionMap);
        template.setType(type);
        template.setMode(mode);
        template.setLanguage(language);
        template.setScript(script);
        template.setCacheable(cacheable);
        template.setSmallImage(smallImage);
        template.setSmallImageId(this.counterLocalService.increment());
        template.setSmallImageURL(smallImageURL);
        this.ddmTemplatePersistence.update((BaseModel)template);
        if (serviceContext.isAddGroupPermissions() || serviceContext.isAddGuestPermissions()) {
            this.addTemplateResources(template, serviceContext.isAddGroupPermissions(), serviceContext.isAddGuestPermissions());
        } else {
            this.addTemplateResources(template, serviceContext.getGroupPermissions(), serviceContext.getGuestPermissions());
        }
        this.saveImages(smallImage, template.getSmallImageId(), smallImageFile, smallImageBytes);
        return template;
    }

    public void addTemplateResources(DDMTemplate template, boolean addGroupPermissions, boolean addGuestPermissions) throws PortalException, SystemException {
        this.resourceLocalService.addResources(template.getCompanyId(), template.getGroupId(), template.getUserId(), DDMTemplate.class.getName(), template.getTemplateId(), false, addGroupPermissions, addGuestPermissions);
    }

    public void addTemplateResources(DDMTemplate template, String[] groupPermissions, String[] guestPermissions) throws PortalException, SystemException {
        this.resourceLocalService.addModelResources(template.getCompanyId(), template.getGroupId(), template.getUserId(), DDMTemplate.class.getName(), template.getTemplateId(), groupPermissions, guestPermissions);
    }

    public DDMTemplate copyTemplate(long userId, long templateId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, ServiceContext serviceContext) throws PortalException, SystemException {
        DDMTemplate template = this.ddmTemplatePersistence.findByPrimaryKey(templateId);
        File smallImageFile = this.copySmallImage(template);
        return this.addTemplate(userId, template.getGroupId(), template.getClassNameId(), template.getClassPK(), null, nameMap, descriptionMap, template.getType(), template.getMode(), template.getLanguage(), template.getScript(), template.isCacheable(), template.isSmallImage(), template.getSmallImageURL(), smallImageFile, serviceContext);
    }

    public DDMTemplate copyTemplate(long userId, long templateId, ServiceContext serviceContext) throws PortalException, SystemException {
        DDMTemplate template = this.ddmTemplatePersistence.findByPrimaryKey(templateId);
        File smallImageFile = this.copySmallImage(template);
        return this.addTemplate(userId, template.getGroupId(), template.getClassNameId(), template.getClassPK(), null, template.getNameMap(), template.getDescriptionMap(), template.getType(), template.getMode(), template.getLanguage(), template.getScript(), template.isCacheable(), template.isSmallImage(), template.getSmallImageURL(), smallImageFile, serviceContext);
    }

    public List<DDMTemplate> copyTemplates(long userId, long classNameId, long oldClassPK, long newClassPK, String type, ServiceContext serviceContext) throws PortalException, SystemException {
        ArrayList<DDMTemplate> newTemplates = new ArrayList<DDMTemplate>();
        List oldTemplates = this.ddmTemplatePersistence.findByC_C_T(classNameId, oldClassPK, type);
        for (DDMTemplate oldTemplate : oldTemplates) {
            DDMTemplate newTemplate = this.copyTemplate(userId, oldTemplate.getTemplateId(), serviceContext);
            newTemplates.add(newTemplate);
        }
        return newTemplates;
    }

    public void deleteTemplate(DDMTemplate template) throws PortalException, SystemException {
        DDMStructure structure;
        if (template.getClassNameId() == PortalUtil.getClassNameId((String)DDMStructure.class.getName()) && (structure = this.ddmStructureLocalService.fetchDDMStructure(template.getClassPK())) != null && structure.getClassNameId() == PortalUtil.getClassNameId((String)JournalArticle.class.getName())) {
            Group companyGroup = this.groupLocalService.getCompanyGroup(template.getCompanyId());
            if (template.getGroupId() == companyGroup.getGroupId() ? JournalArticleUtil.countByTemplateId((String)template.getTemplateKey()) > 0 : JournalArticleUtil.countByG_T((long)template.getGroupId(), (String)template.getTemplateKey()) > 0) {
                throw new RequiredTemplateException();
            }
        }
        this.ddmTemplatePersistence.remove((BaseModel)template);
        this.resourceLocalService.deleteResource(template.getCompanyId(), DDMTemplate.class.getName(), 4, template.getTemplateId());
        this.systemEventLocalService.addSystemEvent(template.getGroupId(), DDMTemplate.class.getName(), template.getTemplateId(), template.getUuid(), 1);
    }

    public void deleteTemplate(long templateId) throws PortalException, SystemException {
        DDMTemplate template = this.ddmTemplatePersistence.findByPrimaryKey(templateId);
        this.deleteTemplate(template);
    }

    public void deleteTemplates(long groupId) throws PortalException, SystemException {
        List templates = this.ddmTemplatePersistence.findByGroupId(groupId);
        for (DDMTemplate template : templates) {
            this.deleteTemplate(template);
        }
    }

    public DDMTemplate fetchTemplate(long groupId, long classNameId, String templateKey) throws SystemException {
        templateKey = templateKey.trim().toUpperCase();
        return this.ddmTemplatePersistence.fetchByG_C_T(groupId, classNameId, templateKey);
    }

    public DDMTemplate fetchTemplate(long groupId, long classNameId, String templateKey, boolean includeGlobalTemplates) throws PortalException, SystemException {
        DDMTemplate template = this.ddmTemplatePersistence.fetchByG_C_T(groupId, classNameId, templateKey = templateKey.trim().toUpperCase());
        if (template != null || !includeGlobalTemplates) {
            return template;
        }
        Group group = this.groupPersistence.findByPrimaryKey(groupId);
        Group companyGroup = this.groupLocalService.getCompanyGroup(group.getCompanyId());
        return this.ddmTemplatePersistence.fetchByG_C_T(companyGroup.getGroupId(), classNameId, templateKey);
    }

    public DDMTemplate fetchTemplate(String uuid, long groupId) throws SystemException {
        return this.ddmTemplatePersistence.fetchByUUID_G(uuid, groupId);
    }

    public DDMTemplate getTemplate(long templateId) throws PortalException, SystemException {
        return this.ddmTemplatePersistence.findByPrimaryKey(templateId);
    }

    public DDMTemplate getTemplate(long groupId, long classNameId, String templateKey) throws PortalException, SystemException {
        templateKey = templateKey.trim().toUpperCase();
        return this.ddmTemplatePersistence.findByG_C_T(groupId, classNameId, templateKey);
    }

    public DDMTemplate getTemplate(long groupId, long classNameId, String templateKey, boolean includeGlobalTemplates) throws PortalException, SystemException {
        DDMTemplate template = this.ddmTemplatePersistence.fetchByG_C_T(groupId, classNameId, templateKey = templateKey.trim().toUpperCase());
        if (template != null) {
            return template;
        }
        if (!includeGlobalTemplates) {
            throw new NoSuchTemplateException("No DDMTemplate exists with the template key " + templateKey);
        }
        Group group = this.groupPersistence.findByPrimaryKey(groupId);
        Group companyGroup = this.groupLocalService.getCompanyGroup(group.getCompanyId());
        return this.ddmTemplatePersistence.findByG_C_T(companyGroup.getGroupId(), classNameId, templateKey);
    }

    public DDMTemplate getTemplateBySmallImageId(long smallImageId) throws PortalException, SystemException {
        return this.ddmTemplatePersistence.findBySmallImageId(smallImageId);
    }

    public List<DDMTemplate> getTemplates(long classPK) throws SystemException {
        return this.ddmTemplatePersistence.findByClassPK(classPK);
    }

    public List<DDMTemplate> getTemplates(long groupId, long classNameId) throws SystemException {
        return this.ddmTemplatePersistence.findByG_C(groupId, classNameId);
    }

    public List<DDMTemplate> getTemplates(long groupId, long classNameId, long classPK) throws SystemException {
        return this.ddmTemplatePersistence.findByG_C_C(groupId, classNameId, classPK);
    }

    public List<DDMTemplate> getTemplates(long groupId, long classNameId, long classPK, String type) throws SystemException {
        return this.ddmTemplatePersistence.findByG_C_C_T(groupId, classNameId, classPK, type);
    }

    public List<DDMTemplate> getTemplates(long groupId, long classNameId, long classPK, String type, String mode) throws SystemException {
        return this.ddmTemplatePersistence.findByG_C_C_T_M(groupId, classNameId, classPK, type, mode);
    }

    public List<DDMTemplate> getTemplatesByClassPK(long groupId, long classPK) throws SystemException {
        return this.ddmTemplatePersistence.findByG_CPK(groupId, classPK);
    }

    public List<DDMTemplate> getTemplatesByClassPK(long groupId, long classPK, int start, int end) throws SystemException {
        return this.ddmTemplatePersistence.findByG_CPK(groupId, classPK, start, end);
    }

    public List<DDMTemplate> getTemplatesByClassPK(long[] groupIds, long classPK) throws SystemException {
        return this.ddmTemplatePersistence.findByG_CPK(groupIds, classPK);
    }

    public int getTemplatesByClassPKCount(long groupId, long classPK) throws SystemException {
        return this.ddmTemplatePersistence.countByG_CPK(groupId, classPK);
    }

    public List<DDMTemplate> getTemplatesByStructureClassNameId(long groupId, long structureClassNameId, int start, int end, OrderByComparator orderByComparator) throws SystemException {
        return this.ddmTemplateFinder.findByG_SC(groupId, structureClassNameId, start, end, orderByComparator);
    }

    public int getTemplatesCount(long groupId) throws SystemException {
        return this.ddmTemplatePersistence.countByGroupId(groupId);
    }

    public int getTemplatesCount(long groupId, long classNameId) throws SystemException {
        return this.ddmTemplatePersistence.countByG_C(groupId, classNameId);
    }

    public List<DDMTemplate> search(long companyId, long groupId, long classNameId, long classPK, String keywords, String type, String mode, int start, int end, OrderByComparator orderByComparator) throws SystemException {
        return this.ddmTemplateFinder.findByKeywords(companyId, groupId, classNameId, classPK, keywords, type, mode, start, end, orderByComparator);
    }

    public List<DDMTemplate> search(long companyId, long groupId, long classNameId, long classPK, String name, String description, String type, String mode, String language, boolean andOperator, int start, int end, OrderByComparator orderByComparator) throws SystemException {
        return this.ddmTemplateFinder.findByC_G_C_C_N_D_T_M_L(companyId, groupId, classNameId, classPK, name, description, type, mode, language, andOperator, start, end, orderByComparator);
    }

    public List<DDMTemplate> search(long companyId, long[] groupIds, long[] classNameIds, long[] classPKs, String keywords, String type, String mode, int start, int end, OrderByComparator orderByComparator) throws SystemException {
        return this.ddmTemplateFinder.findByKeywords(companyId, groupIds, classNameIds, classPKs, keywords, type, mode, start, end, orderByComparator);
    }

    public List<DDMTemplate> search(long companyId, long[] groupIds, long[] classNameIds, long[] classPKs, String name, String description, String type, String mode, String language, boolean andOperator, int start, int end, OrderByComparator orderByComparator) throws SystemException {
        return this.ddmTemplateFinder.findByC_G_C_C_N_D_T_M_L(companyId, groupIds, classNameIds, classPKs, name, description, type, mode, language, andOperator, start, end, orderByComparator);
    }

    public int searchCount(long companyId, long groupId, long classNameId, long classPK, String keywords, String type, String mode) throws SystemException {
        return this.ddmTemplateFinder.countByKeywords(companyId, groupId, classNameId, classPK, keywords, type, mode);
    }

    public int searchCount(long companyId, long groupId, long classNameId, long classPK, String name, String description, String type, String mode, String language, boolean andOperator) throws SystemException {
        return this.ddmTemplateFinder.countByC_G_C_C_N_D_T_M_L(companyId, groupId, classNameId, classPK, name, description, type, mode, language, andOperator);
    }

    public int searchCount(long companyId, long[] groupIds, long[] classNameIds, long[] classPKs, String keywords, String type, String mode) throws SystemException {
        return this.ddmTemplateFinder.countByKeywords(companyId, groupIds, classNameIds, classPKs, keywords, type, mode);
    }

    public int searchCount(long companyId, long[] groupIds, long[] classNameIds, long[] classPKs, String name, String description, String type, String mode, String language, boolean andOperator) throws SystemException {
        return this.ddmTemplateFinder.countByC_G_C_C_N_D_T_M_L(companyId, groupIds, classNameIds, classPKs, name, description, type, mode, language, andOperator);
    }

    public DDMTemplate updateTemplate(long templateId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, String type, String mode, String language, String script, boolean cacheable, boolean smallImage, String smallImageURL, File smallImageFile, ServiceContext serviceContext) throws PortalException, SystemException {
        script = this.formatScript(type, language, script);
        byte[] smallImageBytes = null;
        try {
            smallImageBytes = FileUtil.getBytes((File)smallImageFile);
        }
        catch (IOException iOException) {}
        this.validate(nameMap, script, smallImage, smallImageURL, smallImageFile, smallImageBytes);
        DDMTemplate template = this.ddmTemplateLocalService.getDDMTemplate(templateId);
        template.setModifiedDate(serviceContext.getModifiedDate(null));
        template.setNameMap(nameMap);
        template.setDescriptionMap(descriptionMap);
        template.setType(type);
        template.setMode(mode);
        template.setLanguage(language);
        template.setScript(script);
        template.setCacheable(cacheable);
        template.setSmallImage(smallImage);
        template.setSmallImageURL(smallImageURL);
        this.ddmTemplatePersistence.update((BaseModel)template);
        this.saveImages(smallImage, template.getSmallImageId(), smallImageFile, smallImageBytes);
        return template;
    }

    protected File copySmallImage(DDMTemplate template) throws SystemException {
        Image smallImage;
        File smallImageFile = null;
        if (template.isSmallImage() && Validator.isNull((String)template.getSmallImageURL()) && (smallImage = ImageUtil.fetchByPrimaryKey((long)template.getSmallImageId())) != null) {
            smallImageFile = FileUtil.createTempFile((String)smallImage.getType());
            try {
                FileUtil.write((File)smallImageFile, (byte[])smallImage.getTextObj());
            }
            catch (IOException ioe) {
                _log.error((Object)ioe, (Throwable)ioe);
            }
        }
        return smallImageFile;
    }

    protected String formatScript(String type, String language, String script) throws PortalException {
        if (type.equals("form") || language.equals("xsl")) {
            try {
                script = DDMXMLUtil.formatXML((String)script);
            }
            catch (Exception exception) {
                throw new TemplateScriptException();
            }
        }
        return script;
    }

    protected void saveImages(boolean smallImage, long smallImageId, File smallImageFile, byte[] smallImageBytes) throws PortalException, SystemException {
        if (smallImage) {
            if (smallImageFile != null && smallImageBytes != null) {
                this.imageLocalService.updateImage(smallImageId, smallImageBytes);
            }
        } else {
            this.imageLocalService.deleteImage(smallImageId);
        }
    }

    protected void validate(long groupId, long classNameId, String templateKey, Map<Locale, String> nameMap, String script, boolean smallImage, String smallImageURL, File smallImageFile, byte[] smallImageBytes) throws PortalException, SystemException {
        DDMTemplate template = this.ddmTemplatePersistence.fetchByG_C_T(groupId, classNameId, templateKey = templateKey.trim().toUpperCase());
        if (template != null) {
            throw new TemplateDuplicateTemplateKeyException();
        }
        this.validate(nameMap, script, smallImage, smallImageURL, smallImageFile, smallImageBytes);
    }

    protected void validate(Map<Locale, String> nameMap, String script, boolean smallImage, String smallImageURL, File smallImageFile, byte[] smallImageBytes) throws PortalException, SystemException {
        long smallImageMaxSize;
        this.validateName(nameMap);
        if (Validator.isNull((String)script)) {
            throw new TemplateScriptException();
        }
        String[] imageExtensions = PrefsPropsUtil.getStringArray("dynamic.data.mapping.image.extensions", ",");
        if (!smallImage || Validator.isNotNull((String)smallImageURL) || smallImageFile == null || smallImageBytes == null) {
            return;
        }
        String smallImageName = smallImageFile.getName();
        if (smallImageName != null) {
            boolean validSmallImageExtension = false;
            int i2 = 0;
            while (i2 < imageExtensions.length) {
                if ("*".equals(imageExtensions[i2]) || StringUtil.endsWith((String)smallImageName, (String)imageExtensions[i2])) {
                    validSmallImageExtension = true;
                    break;
                }
                ++i2;
            }
            if (!validSmallImageExtension) {
                throw new TemplateSmallImageNameException(smallImageName);
            }
        }
        if ((smallImageMaxSize = PrefsPropsUtil.getLong("dynamic.data.mapping.image.small.max.size")) > 0L && (smallImageBytes == null || (long)smallImageBytes.length > smallImageMaxSize)) {
            throw new TemplateSmallImageSizeException();
        }
    }

    protected void validateName(Map<Locale, String> nameMap) throws PortalException {
        String name = nameMap.get(LocaleUtil.getDefault());
        if (Validator.isNull((String)name)) {
            throw new TemplateNameException();
        }
    }
}

