/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.dynamicdatamapping.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.dynamicdatamapping.model.DDMStructure;
import com.liferay.portlet.dynamicdatamapping.service.base.DDMStructureServiceBaseImpl;
import com.liferay.portlet.dynamicdatamapping.service.permission.DDMPermission;
import com.liferay.portlet.dynamicdatamapping.service.permission.DDMStructurePermission;
import com.liferay.portlet.dynamicdatamapping.util.DDMDisplay;
import com.liferay.portlet.dynamicdatamapping.util.DDMUtil;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class DDMStructureServiceImpl
extends DDMStructureServiceBaseImpl {
    public DDMStructure addStructure(long userId, long groupId, long classNameId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, String xsd, ServiceContext serviceContext) throws PortalException, SystemException {
        DDMDisplay ddmDisplay = DDMUtil.getDDMDisplay((ServiceContext)serviceContext);
        DDMPermission.check(this.getPermissionChecker(), serviceContext.getScopeGroupId(), ddmDisplay.getResourceName(), ddmDisplay.getAddStructureActionId());
        return this.ddmStructureLocalService.addStructure(this.getUserId(), groupId, classNameId, nameMap, descriptionMap, xsd, serviceContext);
    }

    public DDMStructure addStructure(long groupId, long parentStructureId, long classNameId, String structureKey, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, String xsd, String storageType, int type, ServiceContext serviceContext) throws PortalException, SystemException {
        DDMDisplay ddmDisplay = DDMUtil.getDDMDisplay((ServiceContext)serviceContext);
        DDMPermission.check(this.getPermissionChecker(), serviceContext.getScopeGroupId(), ddmDisplay.getResourceName(), ddmDisplay.getAddStructureActionId());
        return this.ddmStructureLocalService.addStructure(this.getUserId(), groupId, parentStructureId, classNameId, structureKey, nameMap, descriptionMap, xsd, storageType, type, serviceContext);
    }

    public DDMStructure addStructure(long userId, long groupId, String parentStructureKey, long classNameId, String structureKey, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, String xsd, String storageType, int type, ServiceContext serviceContext) throws PortalException, SystemException {
        DDMDisplay ddmDisplay = DDMUtil.getDDMDisplay((ServiceContext)serviceContext);
        DDMPermission.check(this.getPermissionChecker(), serviceContext.getScopeGroupId(), ddmDisplay.getResourceName(), ddmDisplay.getAddStructureActionId());
        return this.ddmStructureLocalService.addStructure(userId, groupId, parentStructureKey, classNameId, structureKey, nameMap, descriptionMap, xsd, storageType, type, serviceContext);
    }

    public DDMStructure copyStructure(long structureId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, ServiceContext serviceContext) throws PortalException, SystemException {
        DDMDisplay ddmDisplay = DDMUtil.getDDMDisplay((ServiceContext)serviceContext);
        DDMPermission.check(this.getPermissionChecker(), serviceContext.getScopeGroupId(), ddmDisplay.getResourceName(), ddmDisplay.getAddStructureActionId());
        return this.ddmStructureLocalService.copyStructure(this.getUserId(), structureId, nameMap, descriptionMap, serviceContext);
    }

    public DDMStructure copyStructure(long structureId, ServiceContext serviceContext) throws PortalException, SystemException {
        DDMDisplay ddmDisplay = DDMUtil.getDDMDisplay((ServiceContext)serviceContext);
        DDMPermission.check(this.getPermissionChecker(), serviceContext.getScopeGroupId(), ddmDisplay.getResourceName(), ddmDisplay.getAddStructureActionId());
        return this.ddmStructureLocalService.copyStructure(this.getUserId(), structureId, serviceContext);
    }

    public void deleteStructure(long structureId) throws PortalException, SystemException {
        DDMStructurePermission.check(this.getPermissionChecker(), structureId, "DELETE");
        this.ddmStructureLocalService.deleteStructure(structureId);
    }

    public DDMStructure fetchStructure(long groupId, long classNameId, String structureKey) throws PortalException, SystemException {
        DDMStructure ddmStructure = this.ddmStructurePersistence.fetchByG_C_S(groupId, classNameId, structureKey);
        if (ddmStructure != null) {
            DDMStructurePermission.check(this.getPermissionChecker(), ddmStructure, "VIEW");
        }
        return ddmStructure;
    }

    public DDMStructure getStructure(long structureId) throws PortalException, SystemException {
        DDMStructurePermission.check(this.getPermissionChecker(), structureId, "VIEW");
        return this.ddmStructurePersistence.findByPrimaryKey(structureId);
    }

    public DDMStructure getStructure(long groupId, long classNameId, String structureKey) throws PortalException, SystemException {
        DDMStructurePermission.check(this.getPermissionChecker(), groupId, classNameId, structureKey, "VIEW");
        return this.ddmStructureLocalService.getStructure(groupId, classNameId, structureKey);
    }

    public DDMStructure getStructure(long groupId, long classNameId, String structureKey, boolean includeGlobalStructures) throws PortalException, SystemException {
        DDMStructurePermission.check(this.getPermissionChecker(), groupId, classNameId, structureKey, "VIEW");
        return this.ddmStructureLocalService.getStructure(groupId, classNameId, structureKey, includeGlobalStructures);
    }

    public List<DDMStructure> getStructures(long groupId) throws SystemException {
        return this.ddmStructurePersistence.filterFindByGroupId(groupId);
    }

    public List<DDMStructure> getStructures(long[] groupIds) throws SystemException {
        return this.ddmStructurePersistence.filterFindByGroupId(groupIds);
    }

    public List<DDMStructure> search(long companyId, long[] groupIds, long[] classNameIds, String keywords, int start, int end, OrderByComparator orderByComparator) throws SystemException {
        return this.ddmStructureFinder.filterFindByKeywords(companyId, groupIds, classNameIds, keywords, start, end, orderByComparator);
    }

    public List<DDMStructure> search(long companyId, long[] groupIds, long[] classNameIds, String name, String description, String storageType, int type, boolean andOperator, int start, int end, OrderByComparator orderByComparator) throws SystemException {
        return this.ddmStructureFinder.filterFindByC_G_C_N_D_S_T(companyId, groupIds, classNameIds, name, description, storageType, type, andOperator, start, end, orderByComparator);
    }

    public int searchCount(long companyId, long[] groupIds, long[] classNameIds, String keywords) throws SystemException {
        return this.ddmStructureFinder.filterCountByKeywords(companyId, groupIds, classNameIds, keywords);
    }

    public int searchCount(long companyId, long[] groupIds, long[] classNameIds, String name, String description, String storageType, int type, boolean andOperator) throws SystemException {
        return this.ddmStructureFinder.filterCountByC_G_C_N_D_S_T(companyId, groupIds, classNameIds, name, description, storageType, type, andOperator);
    }

    public DDMStructure updateStructure(long groupId, long parentStructureId, long classNameId, String structureKey, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, String xsd, ServiceContext serviceContext) throws PortalException, SystemException {
        DDMStructurePermission.check(this.getPermissionChecker(), groupId, classNameId, structureKey, "UPDATE");
        return this.ddmStructureLocalService.updateStructure(groupId, parentStructureId, classNameId, structureKey, nameMap, descriptionMap, xsd, serviceContext);
    }

    public DDMStructure updateStructure(long structureId, long parentStructureId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, String xsd, ServiceContext serviceContext) throws PortalException, SystemException {
        DDMStructurePermission.check(this.getPermissionChecker(), structureId, "UPDATE");
        return this.ddmStructureLocalService.updateStructure(structureId, parentStructureId, nameMap, descriptionMap, xsd, serviceContext);
    }
}

