/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.dynamicdatamapping.lar;

import com.liferay.portal.kernel.lar.BaseStagedModelDataHandler;
import com.liferay.portal.kernel.lar.ExportImportHelperUtil;
import com.liferay.portal.kernel.lar.ExportImportPathUtil;
import com.liferay.portal.kernel.lar.ManifestSummary;
import com.liferay.portal.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.model.ClassedModel;
import com.liferay.portal.model.Image;
import com.liferay.portal.model.StagedModel;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.persistence.ImageUtil;
import com.liferay.portlet.dynamicdatamapping.TemplateDuplicateTemplateKeyException;
import com.liferay.portlet.dynamicdatamapping.model.DDMStructure;
import com.liferay.portlet.dynamicdatamapping.model.DDMTemplate;
import com.liferay.portlet.dynamicdatamapping.service.DDMStructureLocalServiceUtil;
import com.liferay.portlet.dynamicdatamapping.service.DDMTemplateLocalServiceUtil;
import com.liferay.portlet.dynamicdatamapping.service.persistence.DDMTemplateUtil;
import java.io.File;
import java.util.Map;

public class DDMTemplateStagedModelDataHandler
extends BaseStagedModelDataHandler<DDMTemplate> {
    public static final String[] CLASS_NAMES = new String[]{DDMTemplate.class.getName()};
    private static Log _log = LogFactoryUtil.getLog(DDMTemplateStagedModelDataHandler.class);

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    public String getDisplayName(DDMTemplate template) {
        return template.getNameCurrentValue();
    }

    public String getManifestSummaryKey(StagedModel stagedModel) {
        if (stagedModel == null) {
            return DDMTemplate.class.getName();
        }
        DDMTemplate template = (DDMTemplate)stagedModel;
        return ManifestSummary.getManifestSummaryKey((String)DDMTemplate.class.getName(), (String)template.getClassName());
    }

    protected DDMTemplate addTemplate(long userId, long groupId, DDMTemplate template, long classPK, File smallFile, ServiceContext serviceContext) throws Exception {
        DDMTemplate newTemplate = null;
        try {
            return DDMTemplateLocalServiceUtil.addTemplate((long)userId, (long)groupId, (long)template.getClassNameId(), (long)classPK, (String)template.getTemplateKey(), (Map)template.getNameMap(), (Map)template.getDescriptionMap(), (String)template.getType(), (String)template.getMode(), (String)template.getLanguage(), (String)template.getScript(), (boolean)template.isCacheable(), (boolean)template.isSmallImage(), (String)template.getSmallImageURL(), (File)smallFile, (ServiceContext)serviceContext);
        }
        catch (TemplateDuplicateTemplateKeyException templateDuplicateTemplateKeyException) {
            newTemplate = DDMTemplateLocalServiceUtil.addTemplate((long)userId, (long)groupId, (long)template.getClassNameId(), (long)classPK, null, (Map)template.getNameMap(), (Map)template.getDescriptionMap(), (String)template.getType(), (String)template.getMode(), (String)template.getLanguage(), (String)template.getScript(), (boolean)template.isCacheable(), (boolean)template.isSmallImage(), (String)template.getSmallImageURL(), (File)smallFile, (ServiceContext)serviceContext);
            if (_log.isWarnEnabled()) {
                StringBundler sb = new StringBundler(4);
                sb.append("A template with the key ");
                sb.append(template.getTemplateKey());
                sb.append(" already exists. The new generated key is ");
                sb.append(newTemplate.getTemplateKey());
                _log.warn((Object)sb.toString());
            }
            return newTemplate;
        }
    }

    protected void doExportStagedModel(PortletDataContext portletDataContext, DDMTemplate template) throws Exception {
        DDMStructure structure = DDMStructureLocalServiceUtil.fetchStructure((long)template.getClassPK());
        if (structure != null) {
            StagedModelDataHandlerUtil.exportStagedModel((PortletDataContext)portletDataContext, (StagedModel)structure);
        }
        Element templateElement = portletDataContext.getExportDataElement((ClassedModel)template);
        if (template.isSmallImage()) {
            Image smallImage = ImageUtil.fetchByPrimaryKey((long)template.getSmallImageId());
            if (Validator.isNotNull((String)template.getSmallImageURL())) {
                String smallImageURL = ExportImportHelperUtil.replaceExportContentReferences((PortletDataContext)portletDataContext, (StagedModel)template, (Element)templateElement, (String)template.getSmallImageURL().concat(" "), (boolean)true);
                template.setSmallImageURL(smallImageURL);
            } else if (smallImage != null) {
                String smallImagePath = ExportImportPathUtil.getModelPath((StagedModel)template, (String)(String.valueOf(smallImage.getImageId()) + "." + template.getSmallImageType()));
                templateElement.addAttribute("small-image-path", smallImagePath);
                template.setSmallImageType(smallImage.getType());
                portletDataContext.addZipEntry(smallImagePath, smallImage.getTextObj());
            }
        }
        if (portletDataContext.getBooleanParameter("dynamic_data_mapping", "embedded-assets")) {
            String content = ExportImportHelperUtil.replaceExportContentReferences((PortletDataContext)portletDataContext, (StagedModel)template, (Element)templateElement, (String)template.getScript(), (boolean)true);
            template.setScript(content);
        }
        portletDataContext.addClassedModel(templateElement, ExportImportPathUtil.getModelPath((StagedModel)template), (ClassedModel)template, "dynamic_data_mapping");
    }

    protected void doImportStagedModel(PortletDataContext portletDataContext, DDMTemplate template) throws Exception {
        long userId = portletDataContext.getUserId(template.getUserUuid());
        Map structureIds = portletDataContext.getNewPrimaryKeysMap(DDMStructure.class);
        String structurePath = ExportImportPathUtil.getModelPath((PortletDataContext)portletDataContext, (String)DDMStructure.class.getName(), (long)template.getClassPK());
        DDMStructure structure = (DDMStructure)portletDataContext.getZipEntryAsObject(structurePath);
        if (structure != null) {
            StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)portletDataContext, (StagedModel)structure);
        }
        long classPK = MapUtil.getLong((Map)structureIds, (long)template.getClassPK(), (long)template.getClassPK());
        File smallFile = null;
        if (template.isSmallImage()) {
            byte[] bytes;
            Element element = portletDataContext.getImportDataStagedModelElement((StagedModel)template);
            String smallImagePath = element.attributeValue("small-image-path");
            if (Validator.isNotNull((String)template.getSmallImageURL())) {
                String smallImageURL = ExportImportHelperUtil.replaceImportContentReferences((PortletDataContext)portletDataContext, (Element)element, (String)template.getSmallImageURL(), (boolean)true);
                template.setSmallImageURL(smallImageURL);
            } else if (Validator.isNotNull((String)smallImagePath) && (bytes = portletDataContext.getZipEntryAsByteArray(smallImagePath)) != null) {
                smallFile = FileUtil.createTempFile((String)template.getSmallImageType());
                FileUtil.write((File)smallFile, (byte[])bytes);
            }
        }
        ServiceContext serviceContext = portletDataContext.createServiceContext((StagedModel)template, "dynamic_data_mapping");
        DDMTemplate importedTemplate = null;
        if (portletDataContext.isDataStrategyMirror()) {
            DDMTemplate existingTemplate = DDMTemplateUtil.fetchByUUID_G((String)template.getUuid(), (long)portletDataContext.getScopeGroupId());
            if (existingTemplate == null) {
                serviceContext.setUuid(template.getUuid());
                importedTemplate = this.addTemplate(userId, portletDataContext.getScopeGroupId(), template, classPK, smallFile, serviceContext);
            } else {
                importedTemplate = DDMTemplateLocalServiceUtil.updateTemplate((long)existingTemplate.getTemplateId(), (Map)template.getNameMap(), (Map)template.getDescriptionMap(), (String)template.getType(), (String)template.getMode(), (String)template.getLanguage(), (String)template.getScript(), (boolean)template.isCacheable(), (boolean)template.isSmallImage(), (String)template.getSmallImageURL(), (File)smallFile, (ServiceContext)serviceContext);
            }
        } else {
            importedTemplate = this.addTemplate(userId, portletDataContext.getScopeGroupId(), template, classPK, smallFile, serviceContext);
        }
        portletDataContext.importClassedModel((ClassedModel)template, (ClassedModel)importedTemplate, "dynamic_data_mapping");
        Map ddmTemplateKeys = portletDataContext.getNewPrimaryKeysMap(DDMTemplate.class + ".ddmTemplateKey");
        ddmTemplateKeys.put(template.getTemplateKey(), importedTemplate.getTemplateKey());
    }
}

