/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.dynamicdatamapping.lar;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.lar.BaseStagedModelDataHandler;
import com.liferay.portal.kernel.lar.ExportImportPathUtil;
import com.liferay.portal.kernel.lar.ManifestSummary;
import com.liferay.portal.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.model.ClassedModel;
import com.liferay.portal.model.StagedModel;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portlet.dynamicdatamapping.model.DDMStructure;
import com.liferay.portlet.dynamicdatamapping.service.DDMStructureLocalServiceUtil;
import com.liferay.portlet.dynamicdatamapping.service.persistence.DDMStructureUtil;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class DDMStructureStagedModelDataHandler
extends BaseStagedModelDataHandler<DDMStructure> {
    public static final String[] CLASS_NAMES = new String[]{DDMStructure.class.getName()};

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    public String getDisplayName(DDMStructure structure) {
        return structure.getNameCurrentValue();
    }

    public String getManifestSummaryKey(StagedModel stagedModel) {
        if (stagedModel == null) {
            return DDMStructure.class.getName();
        }
        DDMStructure structure = (DDMStructure)stagedModel;
        return ManifestSummary.getManifestSummaryKey((String)DDMStructure.class.getName(), (String)structure.getClassName());
    }

    protected void doExportStagedModel(PortletDataContext portletDataContext, DDMStructure structure) throws Exception {
        Element structureElement = portletDataContext.getExportDataElement((ClassedModel)structure);
        long defaultUserId = UserLocalServiceUtil.getDefaultUserId((long)structure.getCompanyId());
        if (defaultUserId == structure.getUserId()) {
            structureElement.addAttribute("preloaded", "true");
        }
        portletDataContext.addClassedModel(structureElement, ExportImportPathUtil.getModelPath((StagedModel)structure), (ClassedModel)structure, "dynamic_data_mapping");
    }

    protected void doImportStagedModel(PortletDataContext portletDataContext, DDMStructure structure) throws Exception {
        this.prepareLanguagesForImport(structure);
        long userId = portletDataContext.getUserId(structure.getUserUuid());
        ServiceContext serviceContext = portletDataContext.createServiceContext((StagedModel)structure, "dynamic_data_mapping");
        DDMStructure importedStructure = null;
        if (portletDataContext.isDataStrategyMirror()) {
            Element element = portletDataContext.getImportDataStagedModelElement((StagedModel)structure);
            boolean preloaded = GetterUtil.getBoolean((String)element.attributeValue("preloaded"));
            DDMStructure existingStructure = null;
            existingStructure = !preloaded ? DDMStructureUtil.fetchByUUID_G((String)structure.getUuid(), (long)portletDataContext.getScopeGroupId()) : DDMStructureUtil.fetchByG_C_S((long)portletDataContext.getScopeGroupId(), (long)structure.getClassNameId(), (String)structure.getStructureKey());
            if (existingStructure == null) {
                serviceContext.setUuid(structure.getUuid());
                importedStructure = DDMStructureLocalServiceUtil.addStructure((long)userId, (long)portletDataContext.getScopeGroupId(), (long)structure.getParentStructureId(), (long)structure.getClassNameId(), (String)structure.getStructureKey(), (Map)structure.getNameMap(), (Map)structure.getDescriptionMap(), (String)structure.getXsd(), (String)structure.getStorageType(), (int)structure.getType(), (ServiceContext)serviceContext);
            } else {
                importedStructure = DDMStructureLocalServiceUtil.updateStructure((long)existingStructure.getStructureId(), (long)structure.getParentStructureId(), (Map)structure.getNameMap(), (Map)structure.getDescriptionMap(), (String)structure.getXsd(), (ServiceContext)serviceContext);
            }
        } else {
            importedStructure = DDMStructureLocalServiceUtil.addStructure((long)userId, (long)portletDataContext.getScopeGroupId(), (long)structure.getParentStructureId(), (long)structure.getClassNameId(), (String)structure.getStructureKey(), (Map)structure.getNameMap(), (Map)structure.getDescriptionMap(), (String)structure.getXsd(), (String)structure.getStorageType(), (int)structure.getType(), (ServiceContext)serviceContext);
        }
        portletDataContext.importClassedModel((ClassedModel)structure, (ClassedModel)importedStructure, "dynamic_data_mapping");
        Map ddmStructureKeys = portletDataContext.getNewPrimaryKeysMap(DDMStructure.class + ".ddmStructureKey");
        ddmStructureKeys.put(structure.getStructureKey(), importedStructure.getStructureKey());
    }

    protected void prepareLanguagesForImport(DDMStructure structure) throws PortalException {
        Locale defaultLocale = LocaleUtil.fromLanguageId((String)structure.getDefaultLanguageId());
        Locale[] availableLocales = LocaleUtil.fromLanguageIds((List)structure.getAvailableLanguageIds());
        Locale defaultImportLocale = LocalizationUtil.getDefaultImportLocale((String)DDMStructure.class.getName(), (long)structure.getPrimaryKey(), (Locale)defaultLocale, (Locale[])availableLocales);
        structure.prepareLocalizedFieldsForImport(defaultImportLocale);
    }
}

