/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.dynamicdatalists.service.permission;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portlet.dynamicdatalists.model.DDLRecordSet;
import com.liferay.portlet.dynamicdatalists.service.DDLRecordSetLocalServiceUtil;

public class DDLRecordSetPermission {
    public static void check(PermissionChecker permissionChecker, DDLRecordSet recordSet, String actionId) throws PortalException {
        if (!DDLRecordSetPermission.contains(permissionChecker, recordSet, actionId)) {
            throw new PrincipalException();
        }
    }

    public static void check(PermissionChecker permissionChecker, long recordSetId, String actionId) throws PortalException, SystemException {
        if (!DDLRecordSetPermission.contains(permissionChecker, recordSetId, actionId)) {
            throw new PrincipalException();
        }
    }

    public static void check(PermissionChecker permissionChecker, long groupId, String recordSetKey, String actionId) throws PortalException, SystemException {
        if (!DDLRecordSetPermission.contains(permissionChecker, groupId, recordSetKey, actionId)) {
            throw new PrincipalException();
        }
    }

    public static boolean contains(PermissionChecker permissionChecker, DDLRecordSet recordSet, String actionId) {
        if (permissionChecker.hasOwnerPermission(recordSet.getCompanyId(), DDLRecordSet.class.getName(), recordSet.getRecordSetId(), recordSet.getUserId(), actionId)) {
            return true;
        }
        return permissionChecker.hasPermission(recordSet.getGroupId(), DDLRecordSet.class.getName(), recordSet.getRecordSetId(), actionId);
    }

    public static boolean contains(PermissionChecker permissionChecker, long recordSetId, String actionId) throws PortalException, SystemException {
        DDLRecordSet recordSet = DDLRecordSetLocalServiceUtil.getRecordSet((long)recordSetId);
        return DDLRecordSetPermission.contains(permissionChecker, recordSet, actionId);
    }

    public static boolean contains(PermissionChecker permissionChecker, long groupId, String recordSetKey, String actionId) throws PortalException, SystemException {
        DDLRecordSet recordSet = DDLRecordSetLocalServiceUtil.getRecordSet((long)groupId, (String)recordSetKey);
        return DDLRecordSetPermission.contains(permissionChecker, recordSet, actionId);
    }
}

