/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.dynamicdatalists.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.User;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.dynamicdatalists.RecordSetDDMStructureIdException;
import com.liferay.portlet.dynamicdatalists.RecordSetDuplicateRecordSetKeyException;
import com.liferay.portlet.dynamicdatalists.RecordSetNameException;
import com.liferay.portlet.dynamicdatalists.model.DDLRecordSet;
import com.liferay.portlet.dynamicdatalists.service.base.DDLRecordSetLocalServiceBaseImpl;
import com.liferay.portlet.dynamicdatamapping.model.DDMStructure;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class DDLRecordSetLocalServiceImpl
extends DDLRecordSetLocalServiceBaseImpl {
    public DDLRecordSet addRecordSet(long userId, long groupId, long ddmStructureId, String recordSetKey, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, int minDisplayRows, int scope, ServiceContext serviceContext) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        if (Validator.isNull((String)recordSetKey)) {
            recordSetKey = String.valueOf(this.counterLocalService.increment());
        }
        Date now = new Date();
        this.validate(groupId, ddmStructureId, recordSetKey, nameMap);
        long recordSetId = this.counterLocalService.increment();
        DDLRecordSet recordSet = this.ddlRecordSetPersistence.create(recordSetId);
        recordSet.setUuid(serviceContext.getUuid());
        recordSet.setGroupId(groupId);
        recordSet.setCompanyId(user.getCompanyId());
        recordSet.setUserId(user.getUserId());
        recordSet.setUserName(user.getFullName());
        recordSet.setCreateDate(serviceContext.getCreateDate(now));
        recordSet.setModifiedDate(serviceContext.getModifiedDate(now));
        recordSet.setDDMStructureId(ddmStructureId);
        recordSet.setRecordSetKey(recordSetKey);
        recordSet.setNameMap(nameMap);
        recordSet.setDescriptionMap(descriptionMap);
        recordSet.setMinDisplayRows(minDisplayRows);
        recordSet.setScope(scope);
        this.ddlRecordSetPersistence.update((BaseModel)recordSet);
        if (serviceContext.isAddGroupPermissions() || serviceContext.isAddGuestPermissions()) {
            this.addRecordSetResources(recordSet, serviceContext.isAddGroupPermissions(), serviceContext.isAddGuestPermissions());
        } else {
            this.addRecordSetResources(recordSet, serviceContext.getGroupPermissions(), serviceContext.getGuestPermissions());
        }
        long classNameId = PortalUtil.getClassNameId(DDLRecordSet.class);
        this.ddmStructureLinkLocalService.addStructureLink(classNameId, recordSetId, ddmStructureId, serviceContext);
        return recordSet;
    }

    public void addRecordSetResources(DDLRecordSet recordSet, boolean addGroupPermissions, boolean addGuestPermissions) throws PortalException, SystemException {
        this.resourceLocalService.addResources(recordSet.getCompanyId(), recordSet.getGroupId(), recordSet.getUserId(), DDLRecordSet.class.getName(), recordSet.getRecordSetId(), false, addGroupPermissions, addGuestPermissions);
    }

    public void addRecordSetResources(DDLRecordSet recordSet, String[] groupPermissions, String[] guestPermissions) throws PortalException, SystemException {
        this.resourceLocalService.addModelResources(recordSet.getCompanyId(), recordSet.getGroupId(), recordSet.getUserId(), DDLRecordSet.class.getName(), recordSet.getRecordSetId(), groupPermissions, guestPermissions);
    }

    public void deleteRecordSet(DDLRecordSet recordSet) throws PortalException, SystemException {
        this.ddlRecordSetPersistence.remove((BaseModel)recordSet);
        this.resourceLocalService.deleteResource(recordSet.getCompanyId(), DDLRecordSet.class.getName(), 4, recordSet.getRecordSetId());
        this.ddlRecordLocalService.deleteRecords(recordSet.getRecordSetId());
        this.ddmStructureLinkLocalService.deleteClassStructureLink(recordSet.getRecordSetId());
        this.workflowDefinitionLinkLocalService.deleteWorkflowDefinitionLink(recordSet.getCompanyId(), recordSet.getGroupId(), DDLRecordSet.class.getName(), recordSet.getRecordSetId(), 0L);
    }

    public void deleteRecordSet(long recordSetId) throws PortalException, SystemException {
        DDLRecordSet recordSet = this.ddlRecordSetPersistence.findByPrimaryKey(recordSetId);
        this.deleteRecordSet(recordSet);
    }

    public void deleteRecordSet(long groupId, String recordSetKey) throws PortalException, SystemException {
        DDLRecordSet recordSet = this.ddlRecordSetPersistence.findByG_R(groupId, recordSetKey);
        this.deleteRecordSet(recordSet);
    }

    public void deleteRecordSets(long groupId) throws PortalException, SystemException {
        List recordSets = this.ddlRecordSetPersistence.findByGroupId(groupId);
        for (DDLRecordSet recordSet : recordSets) {
            this.deleteRecordSet(recordSet);
        }
    }

    public DDLRecordSet fetchRecordSet(long groupId, String recordSetKey) throws SystemException {
        return this.ddlRecordSetPersistence.fetchByG_R(groupId, recordSetKey);
    }

    public DDLRecordSet getRecordSet(long recordSetId) throws PortalException, SystemException {
        return this.ddlRecordSetPersistence.findByPrimaryKey(recordSetId);
    }

    public DDLRecordSet getRecordSet(long groupId, String recordSetKey) throws PortalException, SystemException {
        return this.ddlRecordSetPersistence.findByG_R(groupId, recordSetKey);
    }

    public List<DDLRecordSet> getRecordSets(long groupId) throws SystemException {
        return this.ddlRecordSetPersistence.findByGroupId(groupId);
    }

    public int getRecordSetsCount(long groupId) throws SystemException {
        return this.ddlRecordSetPersistence.countByGroupId(groupId);
    }

    public List<DDLRecordSet> search(long companyId, long groupId, String keywords, int scope, int start, int end, OrderByComparator orderByComparator) throws SystemException {
        return this.ddlRecordSetFinder.findByKeywords(companyId, groupId, keywords, scope, start, end, orderByComparator);
    }

    public List<DDLRecordSet> search(long companyId, long groupId, String name, String description, int scope, boolean andOperator, int start, int end, OrderByComparator orderByComparator) throws SystemException {
        return this.ddlRecordSetFinder.findByC_G_N_D_S(companyId, groupId, name, description, scope, andOperator, start, end, orderByComparator);
    }

    public int searchCount(long companyId, long groupId, String keywords, int scope) throws SystemException {
        return this.ddlRecordSetFinder.countByKeywords(companyId, groupId, keywords, scope);
    }

    public int searchCount(long companyId, long groupId, String name, String description, int scope, boolean andOperator) throws SystemException {
        return this.ddlRecordSetFinder.countByC_G_N_D_S(companyId, groupId, name, description, scope, andOperator);
    }

    public DDLRecordSet updateMinDisplayRows(long recordSetId, int minDisplayRows, ServiceContext serviceContext) throws PortalException, SystemException {
        DDLRecordSet recordSet = this.ddlRecordSetPersistence.findByPrimaryKey(recordSetId);
        recordSet.setModifiedDate(serviceContext.getModifiedDate(null));
        recordSet.setMinDisplayRows(minDisplayRows);
        this.ddlRecordSetPersistence.update((BaseModel)recordSet);
        return recordSet;
    }

    public DDLRecordSet updateRecordSet(long recordSetId, long ddmStructureId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, int minDisplayRows, ServiceContext serviceContext) throws PortalException, SystemException {
        DDLRecordSet recordSet = this.ddlRecordSetPersistence.findByPrimaryKey(recordSetId);
        return this.doUpdateRecordSet(ddmStructureId, nameMap, descriptionMap, minDisplayRows, serviceContext, recordSet);
    }

    public DDLRecordSet updateRecordSet(long groupId, long ddmStructureId, String recordSetKey, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, int minDisplayRows, ServiceContext serviceContext) throws PortalException, SystemException {
        DDLRecordSet recordSet = this.ddlRecordSetPersistence.findByG_R(groupId, recordSetKey);
        return this.doUpdateRecordSet(ddmStructureId, nameMap, descriptionMap, minDisplayRows, serviceContext, recordSet);
    }

    protected DDLRecordSet doUpdateRecordSet(long ddmStructureId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, int minDisplayRows, ServiceContext serviceContext, DDLRecordSet recordSet) throws PortalException, SystemException {
        this.validateDDMStructureId(ddmStructureId);
        this.validateName(nameMap);
        recordSet.setModifiedDate(serviceContext.getModifiedDate(null));
        recordSet.setDDMStructureId(ddmStructureId);
        recordSet.setNameMap(nameMap);
        recordSet.setDescriptionMap(descriptionMap);
        recordSet.setMinDisplayRows(minDisplayRows);
        this.ddlRecordSetPersistence.update((BaseModel)recordSet);
        return recordSet;
    }

    protected void validate(long groupId, long ddmStructureId, String recordSetKey, Map<Locale, String> nameMap) throws PortalException, SystemException {
        DDLRecordSet recordSet;
        this.validateDDMStructureId(ddmStructureId);
        if (Validator.isNotNull((String)recordSetKey) && (recordSet = this.ddlRecordSetPersistence.fetchByG_R(groupId, recordSetKey)) != null) {
            RecordSetDuplicateRecordSetKeyException rsdrske = new RecordSetDuplicateRecordSetKeyException();
            rsdrske.setRecordSetKey(recordSet.getRecordSetKey());
            throw rsdrske;
        }
        this.validateName(nameMap);
    }

    protected void validateDDMStructureId(long ddmStructureId) throws PortalException, SystemException {
        DDMStructure ddmStructure = this.ddmStructurePersistence.fetchByPrimaryKey(ddmStructureId);
        if (ddmStructure == null) {
            throw new RecordSetDDMStructureIdException();
        }
    }

    protected void validateName(Map<Locale, String> nameMap) throws PortalException {
        String name = nameMap.get(LocaleUtil.getDefault());
        if (Validator.isNull((String)name)) {
            throw new RecordSetNameException();
        }
    }
}

