/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.dynamicdatalists.lar;

import com.liferay.portal.kernel.lar.BaseStagedModelDataHandler;
import com.liferay.portal.kernel.lar.ExportImportPathUtil;
import com.liferay.portal.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.model.ClassedModel;
import com.liferay.portal.model.StagedModel;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.dynamicdatalists.model.DDLRecordSet;
import com.liferay.portlet.dynamicdatalists.service.DDLRecordSetLocalServiceUtil;
import com.liferay.portlet.dynamicdatalists.service.persistence.DDLRecordSetUtil;
import com.liferay.portlet.dynamicdatamapping.model.DDMStructure;
import com.liferay.portlet.dynamicdatamapping.model.DDMTemplate;
import java.util.List;
import java.util.Map;

public class DDLRecordSetStagedModelDataHandler
extends BaseStagedModelDataHandler<DDLRecordSet> {
    public static final String[] CLASS_NAMES = new String[]{DDLRecordSet.class.getName()};

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    public String getDisplayName(DDLRecordSet recordSet) {
        return recordSet.getNameCurrentValue();
    }

    protected void doExportStagedModel(PortletDataContext portletDataContext, DDLRecordSet recordSet) throws Exception {
        DDMStructure ddmStructure = recordSet.getDDMStructure();
        StagedModelDataHandlerUtil.exportStagedModel((PortletDataContext)portletDataContext, (StagedModel)ddmStructure);
        List ddmTemplates = ddmStructure.getTemplates();
        Element recordSetElement = portletDataContext.getExportDataElement((ClassedModel)recordSet);
        for (DDMTemplate ddmTemplate : ddmTemplates) {
            StagedModelDataHandlerUtil.exportStagedModel((PortletDataContext)portletDataContext, (StagedModel)ddmTemplate);
            portletDataContext.addReferenceElement((StagedModel)recordSet, recordSetElement, (ClassedModel)ddmTemplate, "strong", false);
        }
        portletDataContext.addClassedModel(recordSetElement, ExportImportPathUtil.getModelPath((StagedModel)recordSet), (ClassedModel)recordSet, "dynamic_data_lists");
    }

    protected void doImportStagedModel(PortletDataContext portletDataContext, DDLRecordSet recordSet) throws Exception {
        long userId = portletDataContext.getUserId(recordSet.getUserUuid());
        String structurePath = ExportImportPathUtil.getModelPath((PortletDataContext)portletDataContext, (String)DDMStructure.class.getName(), (long)recordSet.getDDMStructureId());
        DDMStructure ddmStructure = (DDMStructure)portletDataContext.getZipEntryAsObject(structurePath);
        StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)portletDataContext, (StagedModel)ddmStructure);
        Map ddmStructureIds = portletDataContext.getNewPrimaryKeysMap(DDMStructure.class);
        long ddmStructureId = MapUtil.getLong((Map)ddmStructureIds, (long)recordSet.getDDMStructureId(), (long)recordSet.getDDMStructureId());
        List ddmTemplateElements = portletDataContext.getReferenceDataElements((StagedModel)recordSet, DDMTemplate.class);
        for (Element ddmTemplateElement : ddmTemplateElements) {
            StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)portletDataContext, (Element)ddmTemplateElement);
        }
        ServiceContext serviceContext = portletDataContext.createServiceContext((StagedModel)recordSet, "dynamic_data_lists");
        DDLRecordSet importedRecordSet = null;
        if (portletDataContext.isDataStrategyMirror()) {
            DDLRecordSet existingRecordSet = DDLRecordSetUtil.fetchByUUID_G((String)recordSet.getUuid(), (long)portletDataContext.getScopeGroupId());
            if (existingRecordSet == null) {
                serviceContext.setUuid(recordSet.getUuid());
                importedRecordSet = DDLRecordSetLocalServiceUtil.addRecordSet((long)userId, (long)portletDataContext.getScopeGroupId(), (long)ddmStructureId, (String)recordSet.getRecordSetKey(), (Map)recordSet.getNameMap(), (Map)recordSet.getDescriptionMap(), (int)recordSet.getMinDisplayRows(), (int)recordSet.getScope(), (ServiceContext)serviceContext);
            } else {
                importedRecordSet = DDLRecordSetLocalServiceUtil.updateRecordSet((long)existingRecordSet.getRecordSetId(), (long)ddmStructureId, (Map)recordSet.getNameMap(), (Map)recordSet.getDescriptionMap(), (int)recordSet.getMinDisplayRows(), (ServiceContext)serviceContext);
            }
        } else {
            importedRecordSet = DDLRecordSetLocalServiceUtil.addRecordSet((long)userId, (long)portletDataContext.getScopeGroupId(), (long)ddmStructureId, (String)recordSet.getRecordSetKey(), (Map)recordSet.getNameMap(), (Map)recordSet.getDescriptionMap(), (int)recordSet.getMinDisplayRows(), (int)recordSet.getScope(), (ServiceContext)serviceContext);
        }
        portletDataContext.importClassedModel((ClassedModel)recordSet, (ClassedModel)importedRecordSet, "dynamic_data_lists");
    }
}

