/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.dynamicdatalists.action;

import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.upload.UploadPortletRequest;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextFactory;
import com.liferay.portal.struts.PortletAction;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.documentlibrary.FileSizeException;
import com.liferay.portlet.dynamicdatalists.NoSuchRecordException;
import com.liferay.portlet.dynamicdatalists.action.ActionUtil;
import com.liferay.portlet.dynamicdatalists.model.DDLRecord;
import com.liferay.portlet.dynamicdatalists.service.DDLRecordLocalServiceUtil;
import com.liferay.portlet.dynamicdatalists.util.DDLUtil;
import com.liferay.portlet.dynamicdatamapping.StorageFieldRequiredException;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class EditRecordAction
extends PortletAction {
    @Override
    public void processAction(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        try {
            if (cmd.equals("add") || cmd.equals("update")) {
                this.updateRecord(actionRequest);
            } else if (cmd.equals("delete")) {
                this.deleteRecord(actionRequest);
            } else if (cmd.equals("revert")) {
                this.revertRecordVersion(actionRequest);
            }
            if (Validator.isNotNull((String)cmd)) {
                this.sendRedirect(actionRequest, actionResponse);
            }
        }
        catch (Exception e2) {
            if (e2 instanceof NoSuchRecordException || e2 instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)actionRequest, e2.getClass());
                this.setForward((PortletRequest)actionRequest, "portlet.dynamic_data_lists.error");
            }
            if (e2 instanceof FileSizeException || e2 instanceof StorageFieldRequiredException) {
                SessionErrors.add((PortletRequest)actionRequest, e2.getClass());
            }
            throw e2;
        }
    }

    @Override
    public ActionForward render(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        try {
            ActionUtil.getRecord((PortletRequest)renderRequest);
        }
        catch (Exception e2) {
            if (e2 instanceof NoSuchRecordException || e2 instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)renderRequest, e2.getClass());
                return mapping.findForward("portlet.dynamic_data_lists.error");
            }
            throw e2;
        }
        return mapping.findForward(this.getForward((PortletRequest)renderRequest, "portlet.dynamic_data_lists.edit_record"));
    }

    protected void deleteRecord(ActionRequest actionRequest) throws Exception {
        long recordId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"recordId");
        DDLRecordLocalServiceUtil.deleteRecord((long)recordId);
    }

    protected void revertRecordVersion(ActionRequest actionRequest) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long recordId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"recordId");
        String version = ParamUtil.getString((PortletRequest)actionRequest, (String)"version");
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)DDLRecord.class.getName(), (PortletRequest)actionRequest);
        DDLRecordLocalServiceUtil.revertRecordVersion((long)themeDisplay.getUserId(), (long)recordId, (String)version, (ServiceContext)serviceContext);
    }

    protected DDLRecord updateRecord(ActionRequest actionRequest) throws Exception {
        UploadPortletRequest uploadPortletRequest = PortalUtil.getUploadPortletRequest((PortletRequest)actionRequest);
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)DDLRecord.class.getName(), (UploadPortletRequest)uploadPortletRequest);
        long recordId = ParamUtil.getLong((ServiceContext)serviceContext, (String)"recordId");
        long recordSetId = ParamUtil.getLong((ServiceContext)serviceContext, (String)"recordSetId");
        return DDLUtil.updateRecord((long)recordId, (long)recordSetId, (boolean)true, (ServiceContext)serviceContext);
    }
}

