/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.util;

import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.image.ImageBag;
import com.liferay.portal.kernel.image.ImageToolUtil;
import com.liferay.portal.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactory;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.process.ClassPathUtil;
import com.liferay.portal.kernel.process.ProcessCallable;
import com.liferay.portal.kernel.process.ProcessException;
import com.liferay.portal.kernel.process.ProcessExecutor;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.ServerDetector;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StreamUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.SystemEnv;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xuggler.XugglerUtil;
import com.liferay.portal.log.Log4jLogFactoryImpl;
import com.liferay.portal.repository.liferayrepository.model.LiferayFileVersion;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.documentlibrary.NoSuchFileEntryException;
import com.liferay.portlet.documentlibrary.store.DLStoreUtil;
import com.liferay.portlet.documentlibrary.util.DLPreviewableProcessor;
import com.liferay.portlet.documentlibrary.util.DLUtil;
import com.liferay.portlet.documentlibrary.util.LiferayConverter;
import com.liferay.portlet.documentlibrary.util.LiferayVideoConverter;
import com.liferay.portlet.documentlibrary.util.LiferayVideoThumbnailConverter;
import com.liferay.portlet.documentlibrary.util.VideoProcessor;
import com.liferay.util.log4j.Log4JUtil;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Future;
import org.apache.commons.lang.time.StopWatch;

public class VideoProcessorImpl
extends DLPreviewableProcessor
implements VideoProcessor {
    private static final String[] _PREVIEW_TYPES = PropsValues.DL_FILE_ENTRY_PREVIEW_VIDEO_CONTAINERS;
    private static Log _log = LogFactoryUtil.getLog(VideoProcessorImpl.class);
    private List<Long> _fileVersionIds = new Vector<Long>();
    private Set<String> _videoMimeTypes = SetUtil.fromArray((Object[])PropsValues.DL_FILE_ENTRY_PREVIEW_VIDEO_MIME_TYPES);

    public void afterPropertiesSet() {
        boolean valid = true;
        if (_PREVIEW_TYPES.length == 0 || _PREVIEW_TYPES.length > 2) {
            valid = false;
        } else {
            String[] stringArray = _PREVIEW_TYPES;
            int n = _PREVIEW_TYPES.length;
            int n2 = 0;
            while (n2 < n) {
                String previewType = stringArray[n2];
                if (!previewType.equals("mp4") && !previewType.equals("ogv")) {
                    valid = false;
                    break;
                }
                ++n2;
            }
        }
        if (!valid && _log.isWarnEnabled()) {
            StringBundler sb = new StringBundler(5);
            sb.append("Liferay is incorrectly configured to generate video ");
            sb.append("previews using video containers other than MP4 or ");
            sb.append("OGV. Please change the property ");
            sb.append("dl.file.entry.preview.video.containers");
            sb.append(" in portal-ext.properties.");
            _log.warn((Object)sb.toString());
        }
        FileUtil.mkdirs((String)PREVIEW_TMP_PATH);
        FileUtil.mkdirs((String)THUMBNAIL_TMP_PATH);
    }

    public void generateVideo(FileVersion sourceFileVersion, FileVersion destinationFileVersion) throws Exception {
        this._generateVideo(sourceFileVersion, destinationFileVersion);
    }

    public InputStream getPreviewAsStream(FileVersion fileVersion, String type) throws Exception {
        return this.doGetPreviewAsStream(fileVersion, type);
    }

    public long getPreviewFileSize(FileVersion fileVersion, String type) throws Exception {
        return this.doGetPreviewFileSize(fileVersion, type);
    }

    public InputStream getThumbnailAsStream(FileVersion fileVersion, int index) throws Exception {
        return this.doGetThumbnailAsStream(fileVersion, index);
    }

    public long getThumbnailFileSize(FileVersion fileVersion, int index) throws Exception {
        return this.doGetThumbnailFileSize(fileVersion, index);
    }

    public Set<String> getVideoMimeTypes() {
        return this._videoMimeTypes;
    }

    public boolean hasVideo(FileVersion fileVersion) {
        boolean hasVideo = false;
        try {
            hasVideo = this._hasVideo(fileVersion);
            if (!hasVideo && this.isSupported(fileVersion)) {
                this._queueGeneration(null, fileVersion);
            }
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
        }
        return hasVideo;
    }

    public boolean isSupported(String mimeType) {
        if (Validator.isNull((String)mimeType)) {
            return false;
        }
        try {
            if (XugglerUtil.isEnabled()) {
                return this._videoMimeTypes.contains(mimeType);
            }
        }
        catch (Exception exception) {}
        return false;
    }

    public boolean isVideoSupported(FileVersion fileVersion) {
        return this.isSupported(fileVersion);
    }

    public boolean isVideoSupported(String mimeType) {
        return this.isSupported(mimeType);
    }

    public void trigger(FileVersion sourceFileVersion, FileVersion destinationFileVersion) {
        super.trigger(sourceFileVersion, destinationFileVersion);
        this._queueGeneration(sourceFileVersion, destinationFileVersion);
    }

    protected void deletePreviews(long companyId, long groupId, long fileEntryId, long fileVersionId) {
        String pathSegment = VideoProcessorImpl.getPathSegment((long)groupId, (long)fileEntryId, (long)fileVersionId, (boolean)true);
        String[] stringArray = _PREVIEW_TYPES;
        int n = _PREVIEW_TYPES.length;
        int n2 = 0;
        while (n2 < n) {
            String previewType = stringArray[n2];
            String path = String.valueOf(pathSegment) + "." + previewType;
            try {
                DLStoreUtil.deleteDirectory((long)companyId, (long)0L, (String)path);
            }
            catch (Exception exception) {}
            ++n2;
        }
    }

    protected void doExportGeneratedFiles(PortletDataContext portletDataContext, FileEntry fileEntry, Element fileEntryElement) throws Exception {
        this.exportThumbnails(portletDataContext, fileEntry, fileEntryElement, "video");
        this.exportPreviews(portletDataContext, fileEntry, fileEntryElement);
    }

    protected void doImportGeneratedFiles(PortletDataContext portletDataContext, FileEntry fileEntry, FileEntry importedFileEntry, Element fileEntryElement) throws Exception {
        this.importThumbnails(portletDataContext, fileEntry, importedFileEntry, fileEntryElement, "video");
        this.importPreviews(portletDataContext, fileEntry, importedFileEntry, fileEntryElement);
    }

    protected void exportPreviews(PortletDataContext portletDataContext, FileEntry fileEntry, Element fileEntryElement) throws Exception {
        FileVersion fileVersion = fileEntry.getFileVersion();
        if (!this.isSupported(fileVersion) || !this.hasPreviews(fileVersion)) {
            return;
        }
        if (!portletDataContext.isPerformDirectBinaryImport()) {
            if (_PREVIEW_TYPES.length == 0 || _PREVIEW_TYPES.length > 2) {
                return;
            }
            String[] stringArray = _PREVIEW_TYPES;
            int n = _PREVIEW_TYPES.length;
            int n2 = 0;
            while (n2 < n) {
                String previewType = stringArray[n2];
                if (previewType.equals("mp4") || previewType.equals("ogv")) {
                    this.exportPreview(portletDataContext, fileEntry, fileEntryElement, "video", previewType);
                }
                ++n2;
            }
        }
    }

    protected List<Long> getFileVersionIds() {
        return this._fileVersionIds;
    }

    protected String getPreviewType(FileVersion fileVersion) {
        return _PREVIEW_TYPES[0];
    }

    protected String[] getPreviewTypes() {
        return _PREVIEW_TYPES;
    }

    protected String getThumbnailType(FileVersion fileVersion) {
        return "jpg";
    }

    protected void importPreviews(PortletDataContext portletDataContext, FileEntry fileEntry, FileEntry importedFileEntry, Element fileEntryElement) throws Exception {
        if (_PREVIEW_TYPES.length == 0 || _PREVIEW_TYPES.length > 2) {
            return;
        }
        String[] stringArray = _PREVIEW_TYPES;
        int n = _PREVIEW_TYPES.length;
        int n2 = 0;
        while (n2 < n) {
            String previewType = stringArray[n2];
            if (previewType.equals("mp4") || previewType.equals("ogv")) {
                this.importPreview(portletDataContext, fileEntry, importedFileEntry, fileEntryElement, "video", previewType);
            }
            ++n2;
        }
    }

    protected void storeThumbnailImages(FileVersion fileVersion, File file) throws Exception {
        if (!this.hasThumbnail(fileVersion, 0)) {
            this.addFileToStore(fileVersion.getCompanyId(), "document_thumbnail/", this.getThumbnailFilePath(fileVersion, 0), file);
        }
        if (this.isThumbnailEnabled(1) || this.isThumbnailEnabled(2)) {
            ImageBag imageBag = ImageToolUtil.read((File)file);
            RenderedImage renderedImage = imageBag.getRenderedImage();
            this.storeThumbnailmage(fileVersion, renderedImage, 1);
            this.storeThumbnailmage(fileVersion, renderedImage, 2);
        }
    }

    private void _generateThumbnailXuggler(FileVersion fileVersion, File file, int height, int width) throws Exception {
        StopWatch stopWatch = null;
        if (_log.isInfoEnabled()) {
            stopWatch = new StopWatch();
            stopWatch.start();
        }
        String tempFileId = DLUtil.getTempFileId((long)fileVersion.getFileEntryId(), (String)fileVersion.getVersion());
        File thumbnailTempFile = this.getThumbnailTempFile(tempFileId);
        try {
            try {
                try {
                    if (PropsValues.DL_FILE_ENTRY_PREVIEW_FORK_PROCESS_ENABLED) {
                        LiferayVideoThumbnailProcessCallable processCallable = new LiferayVideoThumbnailProcessCallable(ServerDetector.getServerId(), PropsUtil.get("liferay.home"), Log4JUtil.getCustomLogSettings(), file.getCanonicalPath(), thumbnailTempFile, "jpg", height, width, PropsValues.DL_FILE_ENTRY_THUMBNAIL_VIDEO_FRAME_PERCENTAGE);
                        Future future = ProcessExecutor.execute((String)ClassPathUtil.getPortalClassPath(), (ProcessCallable)processCallable);
                        String processIdentity = String.valueOf(fileVersion.getFileVersionId());
                        this.futures.put(processIdentity, future);
                        future.get();
                    } else {
                        LiferayVideoThumbnailConverter liferayConverter = new LiferayVideoThumbnailConverter(file.getCanonicalPath(), thumbnailTempFile, "jpg", height, width, PropsValues.DL_FILE_ENTRY_THUMBNAIL_VIDEO_FRAME_PERCENTAGE);
                        ((LiferayConverter)liferayConverter).convert();
                    }
                }
                catch (CancellationException cancellationException) {
                    if (_log.isInfoEnabled()) {
                        _log.info((Object)("Cancellation received for " + fileVersion.getFileVersionId() + " " + fileVersion.getTitle()));
                    }
                }
                catch (Exception e2) {
                    _log.error((Object)e2, (Throwable)e2);
                }
                this.storeThumbnailImages(fileVersion, thumbnailTempFile);
                if (_log.isInfoEnabled()) {
                    _log.info((Object)("Xuggler generated a thumbnail for " + fileVersion.getTitle() + " in " + stopWatch));
                }
            }
            catch (Exception e3) {
                throw new SystemException((Throwable)e3);
            }
        }
        finally {
            FileUtil.delete((File)thumbnailTempFile);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void _generateVideo(FileVersion sourceFileVersion, FileVersion destinationFileVersion) throws Exception {
        block24: {
            block23: {
                block22: {
                    if (!XugglerUtil.isEnabled() || this._hasVideo(destinationFileVersion)) {
                        return;
                    }
                    inputStream = null;
                    previewTempFiles = new File[VideoProcessorImpl._PREVIEW_TYPES.length];
                    videoTempFile = null;
                    if (sourceFileVersion == null) break block22;
                    this.copy(sourceFileVersion, destinationFileVersion);
                    StreamUtil.cleanUp(inputStream);
                    this._fileVersionIds.remove(destinationFileVersion.getFileVersionId());
                    i = 0;
                    while (i < previewTempFiles.length) {
                        FileUtil.delete((File)previewTempFiles[i]);
                        ++i;
                    }
                    FileUtil.delete((File)videoTempFile);
                    return;
                }
                try {
                    try {
                        file = null;
                        if (!this.hasPreviews(destinationFileVersion) || !this.hasThumbnails(destinationFileVersion)) {
                            if (destinationFileVersion instanceof LiferayFileVersion) {
                                try {
                                    liferayFileVersion = (LiferayFileVersion)destinationFileVersion;
                                    file = liferayFileVersion.getFile(false);
                                }
                                catch (UnsupportedOperationException v0) {}
                            }
                            if (file == null) {
                                inputStream = destinationFileVersion.getContentStream(false);
                                videoTempFile = FileUtil.createTempFile((String)destinationFileVersion.getExtension());
                                FileUtil.write((File)videoTempFile, (InputStream)inputStream);
                                file = videoTempFile;
                            }
                        }
                        if (!this.hasPreviews(destinationFileVersion)) {
                            tempFileId = DLUtil.getTempFileId((long)destinationFileVersion.getFileEntryId(), (String)destinationFileVersion.getVersion());
                            i = 0;
                            while (i < VideoProcessorImpl._PREVIEW_TYPES.length) {
                                previewTempFiles[i] = this.getPreviewTempFile(tempFileId, VideoProcessorImpl._PREVIEW_TYPES[i]);
                                ++i;
                            }
                            try {
                                this._generateVideoXuggler(destinationFileVersion, file, previewTempFiles, PropsValues.DL_FILE_ENTRY_PREVIEW_VIDEO_HEIGHT, PropsValues.DL_FILE_ENTRY_PREVIEW_VIDEO_WIDTH);
                            }
                            catch (Exception e) {
                                VideoProcessorImpl._log.error((Object)e, (Throwable)e);
                            }
                        }
                        if (!this.hasThumbnails(destinationFileVersion)) {
                            try {
                                this._generateThumbnailXuggler(destinationFileVersion, file, PropsValues.DL_FILE_ENTRY_PREVIEW_VIDEO_HEIGHT, PropsValues.DL_FILE_ENTRY_PREVIEW_VIDEO_WIDTH);
                            }
                            catch (Exception e) {
                                VideoProcessorImpl._log.error((Object)e, (Throwable)e);
                            }
                        }
                        break block23;
                    }
                    catch (NoSuchFileEntryException v1) {
                        StreamUtil.cleanUp(inputStream);
                        this._fileVersionIds.remove(destinationFileVersion.getFileVersionId());
                        i = 0;
                        ** while (i < previewTempFiles.length)
                    }
                }
                catch (Throwable var9_15) {
                    StreamUtil.cleanUp(inputStream);
                    this._fileVersionIds.remove(destinationFileVersion.getFileVersionId());
                    i = 0;
                    ** while (i < previewTempFiles.length)
                }
lbl-1000:
                // 1 sources

                {
                    FileUtil.delete((File)previewTempFiles[i]);
                    ++i;
                    continue;
                }
lbl66:
                // 1 sources

                FileUtil.delete(videoTempFile);
                break block24;
lbl-1000:
                // 1 sources

                {
                    FileUtil.delete((File)previewTempFiles[i]);
                    ++i;
                    continue;
                }
lbl79:
                // 1 sources

                FileUtil.delete(videoTempFile);
                throw var9_15;
            }
            StreamUtil.cleanUp((InputStream)inputStream);
            this._fileVersionIds.remove(destinationFileVersion.getFileVersionId());
            i = 0;
            while (i < previewTempFiles.length) {
                FileUtil.delete((File)previewTempFiles[i]);
                ++i;
            }
            FileUtil.delete((File)videoTempFile);
        }
    }

    private void _generateVideoXuggler(FileVersion fileVersion, File sourceFile, File destinationFile, String containerType) throws Exception {
        if (this.hasPreview(fileVersion, containerType)) {
            return;
        }
        StopWatch stopWatch = null;
        if (_log.isInfoEnabled()) {
            stopWatch = new StopWatch();
            stopWatch.start();
        }
        if (PropsValues.DL_FILE_ENTRY_PREVIEW_FORK_PROCESS_ENABLED) {
            LiferayVideoProcessCallable processCallable = new LiferayVideoProcessCallable(ServerDetector.getServerId(), PropsUtil.get("liferay.home"), Log4JUtil.getCustomLogSettings(), sourceFile.getCanonicalPath(), destinationFile.getCanonicalPath(), containerType, PropsUtil.getProperties("dl.file.entry.preview.video.", false), PropsUtil.getProperties("xuggler.ffpreset.", true));
            Future future = ProcessExecutor.execute((String)ClassPathUtil.getPortalClassPath(), (ProcessCallable)processCallable);
            String processIdentity = Long.toString(fileVersion.getFileVersionId());
            this.futures.put(processIdentity, future);
            future.get();
        } else {
            LiferayVideoConverter liferayConverter = new LiferayVideoConverter(sourceFile.getCanonicalPath(), destinationFile.getCanonicalPath(), containerType, PropsUtil.getProperties("dl.file.entry.preview.video.", false), PropsUtil.getProperties("xuggler.ffpreset.", true));
            ((LiferayConverter)liferayConverter).convert();
        }
        this.addFileToStore(fileVersion.getCompanyId(), "document_preview/", this.getPreviewFilePath(fileVersion, containerType), destinationFile);
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Xuggler generated a " + containerType + " preview video for " + fileVersion.getTitle() + " in " + stopWatch));
        }
    }

    private void _generateVideoXuggler(FileVersion fileVersion, File sourceFile, File[] destinationFiles, int height, int width) {
        try {
            int i2 = 0;
            while (i2 < destinationFiles.length) {
                this._generateVideoXuggler(fileVersion, sourceFile, destinationFiles[i2], _PREVIEW_TYPES[i2]);
                ++i2;
            }
        }
        catch (CancellationException cancellationException) {
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Cancellation received for " + fileVersion.getFileVersionId() + " " + fileVersion.getTitle()));
            }
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
        }
    }

    private boolean _hasVideo(FileVersion fileVersion) throws Exception {
        if (!this.isSupported(fileVersion)) {
            return false;
        }
        return this.hasPreviews(fileVersion) && this.hasThumbnails(fileVersion);
    }

    private void _queueGeneration(FileVersion sourceFileVersion, FileVersion destinationFileVersion) {
        if (this._fileVersionIds.contains(destinationFileVersion.getFileVersionId()) || !this.isSupported(destinationFileVersion)) {
            return;
        }
        this._fileVersionIds.add(destinationFileVersion.getFileVersionId());
        this.sendGenerationMessage("liferay/document_library_video_processor", PropsValues.DL_FILE_ENTRY_PROCESSORS_TRIGGER_SYNCHRONOUSLY, sourceFileVersion, destinationFileVersion);
    }

    private static class LiferayVideoProcessCallable
    implements ProcessCallable<String> {
        private static final long serialVersionUID = 1L;
        private Map<String, String> _customLogSettings;
        private Properties _ffpresetProperties;
        private String _inputURL;
        private String _liferayHome;
        private String _outputURL;
        private String _serverId;
        private String _videoContainer;
        private Properties _videoProperties;

        public LiferayVideoProcessCallable(String serverId, String liferayHome, Map<String, String> customLogSettings, String inputURL, String outputURL, String videoContainer, Properties videoProperties, Properties ffpresetProperties) {
            this._serverId = serverId;
            this._liferayHome = liferayHome;
            this._customLogSettings = customLogSettings;
            this._inputURL = inputURL;
            this._outputURL = outputURL;
            this._videoContainer = videoContainer;
            this._videoProperties = videoProperties;
            this._ffpresetProperties = ffpresetProperties;
        }

        public String call() throws ProcessException {
            Properties systemProperties = System.getProperties();
            SystemEnv.setProperties((Properties)systemProperties);
            Class<?> clazz = this.getClass();
            ClassLoader classLoader = clazz.getClassLoader();
            Log4JUtil.initLog4J((String)this._serverId, (String)this._liferayHome, (ClassLoader)classLoader, (LogFactory)new Log4jLogFactoryImpl(), this._customLogSettings);
            try {
                LiferayVideoConverter liferayConverter = new LiferayVideoConverter(this._inputURL, this._outputURL, this._videoContainer, this._videoProperties, this._ffpresetProperties);
                ((LiferayConverter)liferayConverter).convert();
            }
            catch (Exception e2) {
                throw new ProcessException((Throwable)e2);
            }
            return "";
        }
    }

    private static class LiferayVideoThumbnailProcessCallable
    implements ProcessCallable<String> {
        private static final long serialVersionUID = 1L;
        private Map<String, String> _customLogSettings;
        private String _extension;
        private int _height;
        private String _inputURL;
        private String _liferayHome;
        private File _outputFile;
        private int _percentage;
        private String _serverId;
        private int _width;

        public LiferayVideoThumbnailProcessCallable(String serverId, String liferayHome, Map<String, String> customLogSettings, String inputURL, File outputFile, String extension, int height, int width, int percentage) {
            this._serverId = serverId;
            this._liferayHome = liferayHome;
            this._customLogSettings = customLogSettings;
            this._inputURL = inputURL;
            this._outputFile = outputFile;
            this._extension = extension;
            this._height = height;
            this._width = width;
            this._percentage = percentage;
        }

        public String call() throws ProcessException {
            Class<?> clazz = this.getClass();
            ClassLoader classLoader = clazz.getClassLoader();
            Properties systemProperties = System.getProperties();
            SystemEnv.setProperties((Properties)systemProperties);
            Log4JUtil.initLog4J((String)this._serverId, (String)this._liferayHome, (ClassLoader)classLoader, (LogFactory)new Log4jLogFactoryImpl(), this._customLogSettings);
            try {
                LiferayVideoThumbnailConverter liferayConverter = new LiferayVideoThumbnailConverter(this._inputURL, this._outputFile, this._extension, this._height, this._width, this._percentage);
                ((LiferayConverter)liferayConverter).convert();
            }
            catch (Exception e2) {
                throw new ProcessException((Throwable)e2);
            }
            return "";
        }
    }
}

