/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.util;

import com.liferay.portal.kernel.image.GhostscriptUtil;
import com.liferay.portal.kernel.image.ImageToolUtil;
import com.liferay.portal.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MimeTypesUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.documentlibrary.store.DLStoreUtil;
import com.liferay.portlet.documentlibrary.util.DLPreviewableProcessor;
import com.liferay.portlet.documentlibrary.util.DLUtil;
import com.liferay.portlet.documentlibrary.util.DocumentConversionUtil;
import com.liferay.portlet.documentlibrary.util.PDFProcessor;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.Future;
import javax.imageio.ImageIO;
import org.apache.commons.lang.time.StopWatch;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentCatalog;
import org.apache.pdfbox.pdmodel.PDPage;

public class PDFProcessorImpl
extends DLPreviewableProcessor
implements PDFProcessor {
    private static Log _log = LogFactoryUtil.getLog(PDFProcessorImpl.class);
    private List<Long> _fileVersionIds = new Vector<Long>();
    private boolean _ghostscriptInitialized = false;

    public void afterPropertiesSet() throws Exception {
        FileUtil.mkdirs((String)PREVIEW_TMP_PATH);
        FileUtil.mkdirs((String)THUMBNAIL_TMP_PATH);
    }

    public void generateImages(FileVersion sourceFileVersion, FileVersion destinationFileVersion) throws Exception {
        this._generateImages(sourceFileVersion, destinationFileVersion);
    }

    public InputStream getPreviewAsStream(FileVersion fileVersion, int index) throws Exception {
        return this.doGetPreviewAsStream(fileVersion, index, "png");
    }

    public int getPreviewFileCount(FileVersion fileVersion) {
        try {
            return this.doGetPreviewFileCount(fileVersion);
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
            return 0;
        }
    }

    public long getPreviewFileSize(FileVersion fileVersion, int index) throws Exception {
        return this.doGetPreviewFileSize(fileVersion, index);
    }

    public InputStream getThumbnailAsStream(FileVersion fileVersion, int index) throws Exception {
        return this.doGetThumbnailAsStream(fileVersion, index);
    }

    public long getThumbnailFileSize(FileVersion fileVersion, int index) throws Exception {
        return this.doGetThumbnailFileSize(fileVersion, index);
    }

    public boolean hasImages(FileVersion fileVersion) {
        boolean hasImages = false;
        try {
            hasImages = this._hasImages(fileVersion);
            if (!hasImages && this.isSupported(fileVersion)) {
                this._queueGeneration(null, fileVersion);
            }
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
        }
        return hasImages;
    }

    public boolean isDocumentSupported(FileVersion fileVersion) {
        return this.isSupported(fileVersion);
    }

    public boolean isDocumentSupported(String mimeType) {
        return this.isSupported(mimeType);
    }

    public boolean isSupported(String mimeType) {
        if (Validator.isNull((String)mimeType)) {
            return false;
        }
        if (mimeType.equals("application/pdf") || mimeType.equals("application/x-pdf")) {
            return true;
        }
        if (DocumentConversionUtil.isEnabled()) {
            Set extensions = MimeTypesUtil.getExtensions((String)mimeType);
            for (String extension : extensions) {
                Object[] targetExtensions = DocumentConversionUtil.getConversions(extension = extension.substring(1));
                if (Arrays.binarySearch(targetExtensions, "pdf") < 0) continue;
                return true;
            }
        }
        return false;
    }

    public void trigger(FileVersion sourceFileVersion, FileVersion destinationFileVersion) {
        super.trigger(sourceFileVersion, destinationFileVersion);
        this._queueGeneration(sourceFileVersion, destinationFileVersion);
    }

    protected void copyPreviews(FileVersion sourceFileVersion, FileVersion destinationFileVersion) {
        if (!PropsValues.DL_FILE_ENTRY_PREVIEW_ENABLED) {
            return;
        }
        try {
            if (this.hasPreview(sourceFileVersion) && !this.hasPreview(destinationFileVersion)) {
                int count = this.getPreviewFileCount(sourceFileVersion);
                int i2 = 0;
                while (i2 < count) {
                    String previewFilePath = this.getPreviewFilePath(destinationFileVersion, i2 + 1);
                    InputStream is = this.doGetPreviewAsStream(sourceFileVersion, i2 + 1, "png");
                    this.addFileToStore(destinationFileVersion.getCompanyId(), "document_preview/", previewFilePath, is);
                    ++i2;
                }
            }
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
        }
    }

    protected void doExportGeneratedFiles(PortletDataContext portletDataContext, FileEntry fileEntry, Element fileEntryElement) throws Exception {
        this.exportThumbnails(portletDataContext, fileEntry, fileEntryElement, "pdf");
        this.exportPreviews(portletDataContext, fileEntry, fileEntryElement);
    }

    protected void doImportGeneratedFiles(PortletDataContext portletDataContext, FileEntry fileEntry, FileEntry importedFileEntry, Element fileEntryElement) throws Exception {
        this.importThumbnails(portletDataContext, fileEntry, importedFileEntry, fileEntryElement, "pdf");
        this.importPreviews(portletDataContext, fileEntry, importedFileEntry, fileEntryElement);
    }

    protected void exportPreviews(PortletDataContext portletDataContext, FileEntry fileEntry, Element fileEntryElement) throws Exception {
        FileVersion fileVersion = fileEntry.getFileVersion();
        if (!this.isSupported(fileVersion) || !this._hasImages(fileVersion)) {
            return;
        }
        if (!portletDataContext.isPerformDirectBinaryImport()) {
            int previewFileCount = this.getPreviewFileCount(fileVersion);
            fileEntryElement.addAttribute("bin-path-pdf-preview-count", String.valueOf(previewFileCount));
            int i2 = 0;
            while (i2 < previewFileCount) {
                this.exportPreview(portletDataContext, fileEntry, fileEntryElement, "pdf", "png", i2);
                ++i2;
            }
        }
    }

    protected List<Long> getFileVersionIds() {
        return this._fileVersionIds;
    }

    protected String getPreviewType(FileVersion fileVersion) {
        return "png";
    }

    protected String getThumbnailType(FileVersion fileVersion) {
        return "png";
    }

    protected boolean hasPreview(FileVersion fileVersion) throws Exception {
        return this.hasPreview(fileVersion, null);
    }

    protected boolean hasPreview(FileVersion fileVersion, String type) throws Exception {
        String previewFilePath = this.getPreviewFilePath(fileVersion, 1);
        return DLStoreUtil.hasFile((long)fileVersion.getCompanyId(), (long)0L, (String)previewFilePath);
    }

    protected void importPreviews(PortletDataContext portletDataContext, FileEntry fileEntry, FileEntry importedFileEntry, Element fileEntryElement) throws Exception {
        int previewFileCount = GetterUtil.getInteger((String)fileEntryElement.attributeValue("bin-path-pdf-preview-count"));
        int i2 = 0;
        while (i2 < previewFileCount) {
            this.importPreview(portletDataContext, fileEntry, importedFileEntry, fileEntryElement, "pdf", "png", i2);
            ++i2;
        }
    }

    private void _generateImages(FileVersion fileVersion, File file) throws Exception {
        if (GhostscriptUtil.isEnabled()) {
            if (!this._ghostscriptInitialized) {
                GhostscriptUtil.reset();
                this._ghostscriptInitialized = true;
            }
            this._generateImagesGS(fileVersion, file);
        } else {
            this._generateImagesPB(fileVersion, file);
        }
    }

    /*
     * Exception decompiling
     */
    private void _generateImages(FileVersion sourceFileVersion, FileVersion destinationFileVersion) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK], 5[CATCHBLOCK]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void _generateImages(FileVersion fileVersion, InputStream inputStream) throws Exception {
        if (GhostscriptUtil.isEnabled()) {
            this._generateImagesGS(fileVersion, inputStream);
        } else {
            this._generateImagesPB(fileVersion, inputStream);
        }
    }

    private void _generateImagesGS(FileVersion fileVersion, File file) throws Exception {
        StopWatch stopWatch;
        if (this._isGeneratePreview(fileVersion)) {
            stopWatch = null;
            if (_log.isInfoEnabled()) {
                stopWatch = new StopWatch();
                stopWatch.start();
            }
            this._generateImagesGS(fileVersion, file, false);
            if (_log.isInfoEnabled()) {
                int previewFileCount = this.getPreviewFileCount(fileVersion);
                _log.info((Object)("Ghostscript generated " + previewFileCount + " preview pages for " + fileVersion.getTitle() + " in " + stopWatch));
            }
        }
        if (this._isGenerateThumbnail(fileVersion)) {
            stopWatch = null;
            if (_log.isInfoEnabled()) {
                stopWatch = new StopWatch();
                stopWatch.start();
            }
            this._generateImagesGS(fileVersion, file, true);
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Ghostscript generated a thumbnail for " + fileVersion.getTitle() + " in " + stopWatch));
            }
        }
    }

    private void _generateImagesGS(FileVersion fileVersion, File file, boolean thumbnail) throws Exception {
        String tempFileId = DLUtil.getTempFileId((long)fileVersion.getFileEntryId(), (String)fileVersion.getVersion());
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add("-sDEVICE=png16m");
        if (thumbnail) {
            arguments.add("-sOutputFile=" + this.getThumbnailTempFilePath(tempFileId));
            arguments.add("-dFirstPage=1");
            arguments.add("-dLastPage=1");
        } else {
            arguments.add("-sOutputFile=" + this.getPreviewTempFilePath(tempFileId, -1));
        }
        arguments.add("-dPDFFitPage");
        arguments.add("-dTextAlphaBits=4");
        arguments.add("-dGraphicsAlphaBits=4");
        arguments.add("-r" + PropsValues.DL_FILE_ENTRY_PREVIEW_DOCUMENT_DPI);
        if (PropsValues.DL_FILE_ENTRY_PREVIEW_DOCUMENT_MAX_WIDTH != 0) {
            arguments.add("-dDEVICEWIDTH" + PropsValues.DL_FILE_ENTRY_PREVIEW_DOCUMENT_MAX_WIDTH);
        }
        if (PropsValues.DL_FILE_ENTRY_PREVIEW_DOCUMENT_MAX_HEIGHT != 0) {
            arguments.add("-dDEVICEHEIGHT" + PropsValues.DL_FILE_ENTRY_PREVIEW_DOCUMENT_MAX_HEIGHT);
        }
        arguments.add(file.getPath());
        Future future = GhostscriptUtil.execute(arguments);
        String processIdentity = String.valueOf(fileVersion.getFileVersionId());
        this.futures.put(processIdentity, future);
        future.get();
        if (thumbnail) {
            File thumbnailTempFile = this.getThumbnailTempFile(tempFileId);
            try {
                this.storeThumbnailImages(fileVersion, thumbnailTempFile);
            }
            finally {
                FileUtil.delete((File)thumbnailTempFile);
            }
        }
        int total = this.getPreviewTempFileCount(fileVersion);
        int i2 = 0;
        while (i2 < total) {
            File previewTempFile = this.getPreviewTempFile(tempFileId, i2 + 2);
            try {
                this.addFileToStore(fileVersion.getCompanyId(), "document_preview/", this.getPreviewFilePath(fileVersion, i2 + 1), previewTempFile);
            }
            finally {
                FileUtil.delete((File)previewTempFile);
            }
            ++i2;
        }
    }

    private void _generateImagesGS(FileVersion fileVersion, InputStream inputStream) throws Exception {
        File file = null;
        try {
            file = FileUtil.createTempFile((InputStream)inputStream);
            this._generateImagesGS(fileVersion, file);
        }
        finally {
            FileUtil.delete((File)file);
        }
    }

    private void _generateImagesPB(FileVersion fileVersion, File file) throws Exception {
        this._generateImagesPB(fileVersion, new FileInputStream(file));
    }

    private void _generateImagesPB(FileVersion fileVersion, InputStream inputStream) throws Exception {
        boolean generatePreview = this._isGeneratePreview(fileVersion);
        boolean generateThumbnail = this._isGenerateThumbnail(fileVersion);
        PDDocument pdDocument = null;
        try {
            pdDocument = PDDocument.load((InputStream)inputStream);
            PDDocumentCatalog pdDocumentCatalog = pdDocument.getDocumentCatalog();
            List pdPages = pdDocumentCatalog.getAllPages();
            int i2 = 0;
            while (i2 < pdPages.size()) {
                PDPage pdPage = (PDPage)pdPages.get(i2);
                if (generateThumbnail && i2 == 0) {
                    this._generateImagesPB(fileVersion, pdPage, i2);
                    if (_log.isInfoEnabled()) {
                        _log.info((Object)("PDFBox generated a thumbnail for " + fileVersion.getFileVersionId()));
                    }
                }
                if (!generatePreview) break;
                this._generateImagesPB(fileVersion, pdPage, i2 + 1);
                ++i2;
            }
            if (_log.isInfoEnabled() && generatePreview) {
                _log.info((Object)("PDFBox generated " + this.getPreviewFileCount(fileVersion) + " preview pages for " + fileVersion.getFileVersionId()));
            }
        }
        finally {
            if (pdDocument != null) {
                pdDocument.close();
            }
        }
    }

    private void _generateImagesPB(FileVersion fileVersion, PDPage pdPage, int index) throws Exception {
        RenderedImage renderedImage = pdPage.convertToImage(1, PropsValues.DL_FILE_ENTRY_PREVIEW_DOCUMENT_DPI);
        renderedImage = PropsValues.DL_FILE_ENTRY_PREVIEW_DOCUMENT_MAX_HEIGHT != 0 ? ImageToolUtil.scale((RenderedImage)renderedImage, (int)PropsValues.DL_FILE_ENTRY_PREVIEW_DOCUMENT_MAX_WIDTH, (int)PropsValues.DL_FILE_ENTRY_PREVIEW_DOCUMENT_MAX_HEIGHT) : ImageToolUtil.scale((RenderedImage)renderedImage, (int)PropsValues.DL_FILE_ENTRY_PREVIEW_DOCUMENT_MAX_WIDTH);
        if (index == 0) {
            this.storeThumbnailImages(fileVersion, renderedImage);
        } else {
            File tempFile = null;
            try {
                String tempFileId = DLUtil.getTempFileId((long)fileVersion.getFileEntryId(), (String)fileVersion.getVersion());
                tempFile = this.getPreviewTempFile(tempFileId, index);
                tempFile.createNewFile();
                ImageIO.write(renderedImage, "png", new FileOutputStream(tempFile));
                this.addFileToStore(fileVersion.getCompanyId(), "document_preview/", this.getPreviewFilePath(fileVersion, index), tempFile);
            }
            catch (Throwable throwable) {
                FileUtil.delete(tempFile);
                throw throwable;
            }
            FileUtil.delete((File)tempFile);
        }
    }

    private boolean _hasImages(FileVersion fileVersion) throws Exception {
        if (PropsValues.DL_FILE_ENTRY_PREVIEW_ENABLED && !this.hasPreview(fileVersion)) {
            return false;
        }
        return this.hasThumbnails(fileVersion);
    }

    private boolean _isGeneratePreview(FileVersion fileVersion) throws Exception {
        return PropsValues.DL_FILE_ENTRY_PREVIEW_ENABLED && !this.hasPreview(fileVersion);
    }

    private boolean _isGenerateThumbnail(FileVersion fileVersion) throws Exception {
        return PropsValues.DL_FILE_ENTRY_THUMBNAIL_ENABLED && !this.hasThumbnail(fileVersion, 0);
    }

    private void _queueGeneration(FileVersion sourceFileVersion, FileVersion destinationFileVersion) {
        if (this._fileVersionIds.contains(destinationFileVersion.getFileVersionId())) {
            return;
        }
        boolean generateImages = false;
        String extension = destinationFileVersion.getExtension();
        if (extension.equals("pdf")) {
            generateImages = true;
        } else if (DocumentConversionUtil.isEnabled()) {
            String[] conversions;
            String[] stringArray = conversions = DocumentConversionUtil.getConversions(extension);
            int n = conversions.length;
            int n2 = 0;
            while (n2 < n) {
                String conversion = stringArray[n2];
                if (conversion.equals("pdf")) {
                    generateImages = true;
                    break;
                }
                ++n2;
            }
        }
        if (generateImages) {
            this._fileVersionIds.add(destinationFileVersion.getFileVersionId());
            this.sendGenerationMessage("liferay/document_library_pdf_processor", PropsValues.DL_FILE_ENTRY_PROCESSORS_TRIGGER_SYNCHRONOUSLY, sourceFileVersion, destinationFileVersion);
        }
    }
}

