/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.util;

import com.liferay.portal.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.security.pacl.DoPrivileged;
import com.liferay.portal.kernel.util.InstanceFactory;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.repository.liferayrepository.model.LiferayFileVersion;
import com.liferay.portal.util.ClassLoaderUtil;
import com.liferay.portlet.documentlibrary.model.DLFileEntry;
import com.liferay.portlet.documentlibrary.util.AudioProcessor;
import com.liferay.portlet.documentlibrary.util.DLProcessor;
import com.liferay.portlet.documentlibrary.util.DLProcessorRegistry;
import com.liferay.portlet.documentlibrary.util.DLProcessorThreadLocal;
import com.liferay.portlet.documentlibrary.util.ImageProcessor;
import com.liferay.portlet.documentlibrary.util.PDFProcessor;
import com.liferay.portlet.documentlibrary.util.RawMetadataProcessor;
import com.liferay.portlet.documentlibrary.util.VideoProcessor;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@DoPrivileged
public class DLProcessorRegistryImpl
implements DLProcessorRegistry {
    private static final String[] _DL_FILE_ENTRY_PROCESSORS = PropsUtil.getArray((String)"dl.file.entry.processors");
    private static Log _log = LogFactoryUtil.getLog(DLProcessorRegistryImpl.class);
    private Map<String, DLProcessor> _dlProcessors = new ConcurrentHashMap<String, DLProcessor>();

    public void afterPropertiesSet() throws Exception {
        ClassLoader classLoader = ClassLoaderUtil.getPortalClassLoader();
        String[] stringArray = _DL_FILE_ENTRY_PROCESSORS;
        int n = _DL_FILE_ENTRY_PROCESSORS.length;
        int n2 = 0;
        while (n2 < n) {
            String dlProcessorClassName = stringArray[n2];
            DLProcessor dlProcessor = (DLProcessor)InstanceFactory.newInstance((ClassLoader)classLoader, (String)dlProcessorClassName);
            dlProcessor.afterPropertiesSet();
            this.register(dlProcessor);
            ++n2;
        }
    }

    public void cleanUp(FileEntry fileEntry) {
        if (!DLProcessorThreadLocal.isEnabled()) {
            return;
        }
        for (DLProcessor dlProcessor : this._dlProcessors.values()) {
            if (!dlProcessor.isSupported(fileEntry.getMimeType())) continue;
            dlProcessor.cleanUp(fileEntry);
        }
    }

    public void cleanUp(FileVersion fileVersion) {
        if (!DLProcessorThreadLocal.isEnabled()) {
            return;
        }
        for (DLProcessor dlProcessor : this._dlProcessors.values()) {
            if (!dlProcessor.isSupported(fileVersion)) continue;
            dlProcessor.cleanUp(fileVersion);
        }
    }

    public void exportGeneratedFiles(PortletDataContext portletDataContext, FileEntry fileEntry, Element fileEntryElement) throws Exception {
        if (fileEntry == null || fileEntry.getSize() == 0L) {
            return;
        }
        FileVersion latestFileVersion = this._getLatestFileVersion(fileEntry, true);
        if (latestFileVersion == null) {
            return;
        }
        for (DLProcessor dlProcessor : this._dlProcessors.values()) {
            if (!dlProcessor.isSupported(latestFileVersion)) continue;
            dlProcessor.exportGeneratedFiles(portletDataContext, fileEntry, fileEntryElement);
        }
    }

    public DLProcessor getDLProcessor(String dlProcessorType) {
        return this._dlProcessors.get(dlProcessorType);
    }

    public void importGeneratedFiles(PortletDataContext portletDataContext, FileEntry fileEntry, FileEntry importedFileEntry, Element fileEntryElement) throws Exception {
        if (importedFileEntry == null || importedFileEntry.getSize() == 0L) {
            return;
        }
        FileVersion fileVersion = importedFileEntry.getFileVersion();
        if (fileVersion == null) {
            return;
        }
        for (DLProcessor dlProcessor : this._dlProcessors.values()) {
            if (!dlProcessor.isSupported(fileVersion)) continue;
            dlProcessor.importGeneratedFiles(portletDataContext, fileEntry, importedFileEntry, fileEntryElement);
        }
    }

    public void register(DLProcessor dlProcessor) {
        String type = this._getType(dlProcessor);
        this._dlProcessors.put(type, dlProcessor);
    }

    public void trigger(FileEntry fileEntry, FileVersion fileVersion) {
        this.trigger(fileEntry, fileVersion, false);
    }

    public void trigger(FileEntry fileEntry, FileVersion fileVersion, boolean trusted) {
        if (!DLProcessorThreadLocal.isEnabled()) {
            return;
        }
        if (fileEntry == null || fileEntry.getSize() == 0L) {
            return;
        }
        FileVersion latestFileVersion = this._getLatestFileVersion(fileEntry, trusted);
        if (latestFileVersion == null) {
            return;
        }
        for (DLProcessor dlProcessor : this._dlProcessors.values()) {
            if (!dlProcessor.isSupported(latestFileVersion)) continue;
            dlProcessor.trigger(fileVersion, latestFileVersion);
        }
    }

    public void unregister(DLProcessor dlProcessor) {
        String type = this._getType(dlProcessor);
        this._dlProcessors.remove(type);
    }

    private FileVersion _getLatestFileVersion(FileEntry fileEntry, boolean trusted) {
        FileVersion latestFileVersion = null;
        try {
            if (fileEntry.getModel() instanceof DLFileEntry) {
                DLFileEntry dlFileEntry = (DLFileEntry)fileEntry.getModel();
                latestFileVersion = new LiferayFileVersion(dlFileEntry.getLatestFileVersion(trusted));
            } else {
                latestFileVersion = fileEntry.getLatestFileVersion();
            }
            return latestFileVersion;
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
            return null;
        }
    }

    private String _getType(DLProcessor dlProcessor) {
        if (dlProcessor instanceof AudioProcessor) {
            return "AudioProcessor";
        }
        if (dlProcessor instanceof ImageProcessor) {
            return "ImageProcessor";
        }
        if (dlProcessor instanceof PDFProcessor) {
            return "PDFProcessor";
        }
        if (dlProcessor instanceof RawMetadataProcessor) {
            return "RawMetadataProcessor";
        }
        if (dlProcessor instanceof VideoProcessor) {
            return "VideoProcessor";
        }
        return null;
    }
}

