/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.trash;

import com.liferay.portal.InvalidRepositoryException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.repository.Repository;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.trash.TrashRenderer;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.ContainerModel;
import com.liferay.portal.repository.liferayrepository.LiferayRepository;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.service.RepositoryServiceUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.documentlibrary.asset.DLFolderAssetRenderer;
import com.liferay.portlet.documentlibrary.model.DLFolder;
import com.liferay.portlet.documentlibrary.service.DLAppHelperLocalServiceUtil;
import com.liferay.portlet.documentlibrary.service.DLAppLocalServiceUtil;
import com.liferay.portlet.documentlibrary.service.DLFolderLocalServiceUtil;
import com.liferay.portlet.documentlibrary.service.permission.DLFolderPermission;
import com.liferay.portlet.documentlibrary.trash.DLBaseTrashHandler;
import com.liferay.portlet.documentlibrary.util.DLUtil;
import com.liferay.portlet.trash.DuplicateEntryException;
import com.liferay.portlet.trash.model.TrashEntry;
import javax.portlet.PortletRequest;

public class DLFolderTrashHandler
extends DLBaseTrashHandler {
    public void checkDuplicateTrashEntry(TrashEntry trashEntry, long containerModelId, String newName) throws PortalException, SystemException {
        DLFolder duplicateDLFolder;
        DLFolder dlFolder = this.getDLFolder(trashEntry.getClassPK());
        if (containerModelId == -1L) {
            containerModelId = dlFolder.getParentFolderId();
        }
        String originalTitle = trashEntry.getTypeSettingsProperty("title");
        if (Validator.isNotNull((String)newName)) {
            originalTitle = newName;
        }
        if ((duplicateDLFolder = DLFolderLocalServiceUtil.fetchFolder((long)dlFolder.getGroupId(), (long)dlFolder.getParentFolderId(), (String)originalTitle)) != null) {
            DuplicateEntryException dee = new DuplicateEntryException();
            dee.setDuplicateEntryId(duplicateDLFolder.getFolderId());
            dee.setOldName(duplicateDLFolder.getName());
            dee.setTrashEntryId(trashEntry.getEntryId());
            throw dee;
        }
    }

    public void deleteTrashEntry(long classPK) throws PortalException, SystemException {
        DLFolderLocalServiceUtil.deleteFolder((long)classPK, (boolean)false);
    }

    public String getClassName() {
        return DLFolder.class.getName();
    }

    public String getDeleteMessage() {
        return "found-in-deleted-folder-x";
    }

    public ContainerModel getParentContainerModel(long classPK) throws PortalException, SystemException {
        DLFolder dlFolder = this.getDLFolder(classPK);
        long parentFolderId = dlFolder.getParentFolderId();
        if (parentFolderId <= 0L) {
            return null;
        }
        return this.getContainerModel(parentFolderId);
    }

    public String getRestoreLink(PortletRequest portletRequest, long classPK) throws PortalException, SystemException {
        DLFolder dlFolder = this.getDLFolder(classPK);
        return DLUtil.getDLControlPanelLink((PortletRequest)portletRequest, (long)dlFolder.getParentFolderId());
    }

    public String getRestoreMessage(PortletRequest portletRequest, long classPK) throws PortalException, SystemException {
        DLFolder dlFolder = this.getDLFolder(classPK);
        return DLUtil.getAbsolutePath((PortletRequest)portletRequest, (long)dlFolder.getParentFolderId());
    }

    public ContainerModel getTrashContainer(long classPK) throws PortalException, SystemException {
        try {
            DLFolder dlFolder = this.getDLFolder(classPK);
            return dlFolder.getTrashContainer();
        }
        catch (InvalidRepositoryException invalidRepositoryException) {
            return null;
        }
    }

    public TrashRenderer getTrashRenderer(long classPK) throws PortalException, SystemException {
        Folder folder = DLAppLocalServiceUtil.getFolder((long)classPK);
        return new DLFolderAssetRenderer(folder);
    }

    public boolean hasTrashPermission(PermissionChecker permissionChecker, long groupId, long classPK, String trashActionId) throws PortalException, SystemException {
        if (trashActionId.equals("MOVE")) {
            return DLFolderPermission.contains(permissionChecker, groupId, classPK, "ADD_FOLDER");
        }
        return super.hasTrashPermission(permissionChecker, groupId, classPK, trashActionId);
    }

    public boolean isContainerModel() {
        return true;
    }

    public boolean isInTrash(long classPK) throws PortalException, SystemException {
        try {
            DLFolder dlFolder = this.getDLFolder(classPK);
            return dlFolder.isInTrash();
        }
        catch (InvalidRepositoryException invalidRepositoryException) {
            return false;
        }
    }

    public boolean isInTrashContainer(long classPK) throws PortalException, SystemException {
        try {
            DLFolder dlFolder = this.getDLFolder(classPK);
            return dlFolder.isInTrashContainer();
        }
        catch (InvalidRepositoryException invalidRepositoryException) {
            return false;
        }
    }

    public boolean isRestorable(long classPK) throws PortalException, SystemException {
        try {
            DLFolder dlFolder = this.getDLFolder(classPK);
            return !dlFolder.isInTrashContainer();
        }
        catch (InvalidRepositoryException invalidRepositoryException) {
            return false;
        }
    }

    public void moveEntry(long userId, long classPK, long containerModelId, ServiceContext serviceContext) throws PortalException, SystemException {
        DLFolderLocalServiceUtil.moveFolder((long)userId, (long)classPK, (long)containerModelId, (ServiceContext)serviceContext);
    }

    public void moveTrashEntry(long userId, long classPK, long containerModelId, ServiceContext serviceContext) throws PortalException, SystemException {
        Repository repository = this.getRepository(classPK);
        DLAppHelperLocalServiceUtil.moveFolderFromTrash((long)userId, (Folder)repository.getFolder(classPK), (long)containerModelId, (ServiceContext)serviceContext);
    }

    public void restoreTrashEntry(long userId, long classPK) throws PortalException, SystemException {
        Repository repository = this.getRepository(classPK);
        DLAppHelperLocalServiceUtil.restoreFolderFromTrash((long)userId, (Folder)repository.getFolder(classPK));
    }

    public void updateTitle(long classPK, String name) throws PortalException, SystemException {
        DLFolder dlFolder = this.getDLFolder(classPK);
        dlFolder.setName(name);
        DLFolderLocalServiceUtil.updateDLFolder((DLFolder)dlFolder);
    }

    @Override
    protected Repository getRepository(long classPK) throws PortalException, SystemException {
        Repository repository = RepositoryServiceUtil.getRepositoryImpl((long)classPK, (long)0L, (long)0L);
        if (!(repository instanceof LiferayRepository)) {
            throw new InvalidRepositoryException("Repository " + repository.getRepositoryId() + " does not support trash operations");
        }
        return repository;
    }

    protected boolean hasPermission(PermissionChecker permissionChecker, long classPK, String actionId) throws PortalException, SystemException {
        DLFolder dlFolder = this.getDLFolder(classPK);
        if (dlFolder.isInHiddenFolder() && actionId.equals("VIEW")) {
            return false;
        }
        return DLFolderPermission.contains(permissionChecker, dlFolder, actionId);
    }
}

