/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.social;

import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.asset.AssetRendererFactoryRegistryUtil;
import com.liferay.portlet.asset.model.AssetRenderer;
import com.liferay.portlet.asset.model.AssetRendererFactory;
import com.liferay.portlet.documentlibrary.model.DLFileEntry;
import com.liferay.portlet.documentlibrary.model.DLFileVersion;
import com.liferay.portlet.documentlibrary.service.DLAppLocalServiceUtil;
import com.liferay.portlet.documentlibrary.service.permission.DLFileEntryPermission;
import com.liferay.portlet.social.model.BaseSocialActivityInterpreter;
import com.liferay.portlet.social.model.SocialActivity;
import com.liferay.portlet.trash.util.TrashUtil;

public class DLFileEntryActivityInterpreter
extends BaseSocialActivityInterpreter {
    private static final String[] _CLASS_NAMES = new String[]{DLFileEntry.class.getName()};

    public String[] getClassNames() {
        return _CLASS_NAMES;
    }

    protected String getBody(SocialActivity activity, ServiceContext serviceContext) throws Exception {
        FileEntry fileEntry = DLAppLocalServiceUtil.getFileEntry((long)activity.getClassPK());
        if (TrashUtil.isInTrash((String)DLFileEntry.class.getName(), (long)fileEntry.getFileEntryId())) {
            return "";
        }
        StringBundler sb = new StringBundler(3);
        AssetRendererFactory assetRendererFactory = AssetRendererFactoryRegistryUtil.getAssetRendererFactoryByClassName((String)DLFileEntry.class.getName());
        AssetRenderer assetRenderer = assetRendererFactory.getAssetRenderer(fileEntry.getFileEntryId());
        String fileEntryLink = assetRenderer.getURLDownload(serviceContext.getThemeDisplay());
        sb.append(this.wrapLink(fileEntryLink, "download-file", serviceContext));
        sb.append(" ");
        String folderLink = this.getFolderLink(fileEntry, serviceContext);
        sb.append(this.wrapLink(folderLink, "go-to-folder", serviceContext));
        return sb.toString();
    }

    protected String getEntryTitle(SocialActivity activity, ServiceContext serviceContext) throws Exception {
        DLFileEntry dlFileEntry;
        DLFileVersion dlFileVersion;
        FileEntry fileEntry = DLAppLocalServiceUtil.getFileEntry((long)activity.getClassPK());
        if (fileEntry.getModel() instanceof DLFileEntry && (dlFileVersion = (dlFileEntry = (DLFileEntry)fileEntry.getModel()).getFileVersion()).isInTrash()) {
            return TrashUtil.getOriginalTitle((String)fileEntry.getTitle());
        }
        return fileEntry.getTitle();
    }

    protected String getFolderLink(FileEntry fileEntry, ServiceContext serviceContext) {
        StringBundler sb = new StringBundler(6);
        sb.append(serviceContext.getPortalURL());
        sb.append(serviceContext.getPathMain());
        sb.append("/document_library/find_folder?groupId=");
        sb.append(fileEntry.getRepositoryId());
        sb.append("&folderId=");
        sb.append(fileEntry.getFolderId());
        return sb.toString();
    }

    protected String getPath(SocialActivity activity, ServiceContext serviceContext) {
        return "/document_library/find_file_entry?fileEntryId=" + activity.getClassPK();
    }

    protected String getTitlePattern(String groupName, SocialActivity activity) {
        int activityType = activity.getType();
        if (activityType == 1) {
            if (Validator.isNull((String)groupName)) {
                return "activity-document-library-file-add-file";
            }
            return "activity-document-library-file-add-file-in";
        }
        if (activityType == 2) {
            if (Validator.isNull((String)groupName)) {
                return "activity-document-library-file-update-file";
            }
            return "activity-document-library-file-update-file-in";
        }
        if (activityType == 10007) {
            if (Validator.isNull((String)groupName)) {
                return "activity-document-library-file-move-to-trash";
            }
            return "activity-document-library-file-move-to-trash-in";
        }
        if (activityType == 10008) {
            if (Validator.isNull((String)groupName)) {
                return "activity-document-library-file-restore-from-trash";
            }
            return "activity-document-library-file-restore-from-trash-in";
        }
        return null;
    }

    protected boolean hasPermissions(PermissionChecker permissionChecker, SocialActivity activity, String actionId, ServiceContext serviceContext) throws Exception {
        return DLFileEntryPermission.contains(permissionChecker, activity.getClassPK(), actionId);
    }
}

