/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.service.persistence;

import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryDefinition;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.SQLQuery;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.Type;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.security.permission.InlineSQLHelperUtil;
import com.liferay.portal.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portlet.documentlibrary.model.DLFileEntry;
import com.liferay.portlet.documentlibrary.model.DLFileShortcut;
import com.liferay.portlet.documentlibrary.model.DLFolder;
import com.liferay.portlet.documentlibrary.model.impl.DLFolderImpl;
import com.liferay.portlet.documentlibrary.service.persistence.DLFileEntryUtil;
import com.liferay.portlet.documentlibrary.service.persistence.DLFileShortcutUtil;
import com.liferay.portlet.documentlibrary.service.persistence.DLFolderFinder;
import com.liferay.portlet.documentlibrary.service.persistence.DLFolderUtil;
import com.liferay.util.dao.orm.CustomSQLUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class DLFolderFinderImpl
extends BasePersistenceImpl<DLFolder>
implements DLFolderFinder {
    public static final String COUNT_F_BY_G_M_F = String.valueOf(DLFolderFinder.class.getName()) + ".countF_ByG_M_F";
    public static final String COUNT_FE_BY_G_F = String.valueOf(DLFolderFinder.class.getName()) + ".countFE_ByG_F";
    public static final String COUNT_FS_BY_G_F_A = String.valueOf(DLFolderFinder.class.getName()) + ".countFS_ByG_F_A";
    public static final String FIND_F_BY_NO_ASSETS = String.valueOf(DLFolderFinder.class.getName()) + ".findF_ByNoAssets";
    public static final String FIND_F_BY_G_M_F = String.valueOf(DLFolderFinder.class.getName()) + ".findF_ByG_M_F";
    public static final String FIND_FE_BY_G_F = String.valueOf(DLFolderFinder.class.getName()) + ".findFE_ByG_F";
    public static final String FIND_FS_BY_G_F_A = String.valueOf(DLFolderFinder.class.getName()) + ".findFS_ByG_F_A";
    public static final String JOIN_FE_BY_DL_FILE_VERSION = String.valueOf(DLFolderFinder.class.getName()) + ".joinFE_ByDLFileVersion";
    public static final String JOIN_FS_BY_DL_FILE_ENTRY = String.valueOf(DLFolderFinder.class.getName()) + ".joinFS_ByDLFileEntry";

    public int countF_FE_FS_ByG_F_M_M(long groupId, long folderId, String[] mimeTypes, boolean includeMountFolders, QueryDefinition queryDefinition) throws SystemException {
        return this.doCountF_FE_FS_ByG_F_M_M(groupId, folderId, mimeTypes, includeMountFolders, queryDefinition, false);
    }

    public int countFE_ByG_F(long groupId, long folderId, QueryDefinition queryDefinition) throws SystemException {
        return this.doCountFE_ByG_F(groupId, folderId, queryDefinition, false);
    }

    public int countFE_FS_ByG_F(long groupId, long folderId, QueryDefinition queryDefinition) throws SystemException {
        return this.doCountFE_FS_ByG_F_M(groupId, folderId, null, queryDefinition, false);
    }

    public int filterCountF_FE_FS_ByG_F_M_M(long groupId, long folderId, String[] mimeTypes, boolean includeMountFolders, QueryDefinition queryDefinition) throws SystemException {
        return this.doCountF_FE_FS_ByG_F_M_M(groupId, folderId, mimeTypes, includeMountFolders, queryDefinition, true);
    }

    public int filterCountFE_ByG_F(long groupId, long folderId, QueryDefinition queryDefinition) throws SystemException {
        return this.doCountFE_ByG_F(groupId, folderId, queryDefinition, true);
    }

    public int filterCountFE_FS_ByG_F(long groupId, long folderId, QueryDefinition queryDefinition) throws SystemException {
        return this.doCountFE_FS_ByG_F_M(groupId, folderId, null, queryDefinition, true);
    }

    public int filterCountFE_FS_ByG_F_M(long groupId, long folderId, String[] mimeTypes, QueryDefinition queryDefinition) throws SystemException {
        return this.doCountFE_FS_ByG_F_M(groupId, folderId, mimeTypes, queryDefinition, true);
    }

    public List<Object> filterFindF_FE_FS_ByG_F_M_M(long groupId, long folderId, String[] mimeTypes, boolean includeMountFolders, QueryDefinition queryDefinition) throws SystemException {
        return this.doFindF_FE_FS_ByG_F_M_M(groupId, folderId, mimeTypes, includeMountFolders, queryDefinition, true);
    }

    public List<Object> filterFindFE_FS_ByG_F(long groupId, long folderId, QueryDefinition queryDefinition) throws SystemException {
        return this.doFindFE_FS_ByG_F(groupId, folderId, queryDefinition, true);
    }

    public List<DLFolder> findF_ByNoAssets() throws SystemException {
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_F_BY_NO_ASSETS);
            SQLQuery q = session.createSQLQuery(sql);
            q.addEntity("DLFolder", DLFolderImpl.class);
            List list = q.list(true);
            return list;
        }
        catch (Exception e2) {
            throw new SystemException((Throwable)e2);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<Object> findF_FE_FS_ByG_F_M_M(long groupId, long folderId, String[] mimeTypes, boolean includeMountFolders, QueryDefinition queryDefinition) throws SystemException {
        return this.doFindF_FE_FS_ByG_F_M_M(groupId, folderId, mimeTypes, includeMountFolders, queryDefinition, false);
    }

    public List<Object> findFE_FS_ByG_F(long groupId, long folderId, QueryDefinition queryDefinition) throws SystemException {
        return this.doFindFE_FS_ByG_F(groupId, folderId, queryDefinition, false);
    }

    protected int doCountF_FE_FS_ByG_F_M_M(long groupId, long folderId, String[] mimeTypes, boolean includeMountFolders, QueryDefinition queryDefinition, boolean inlineSQLHelper) throws SystemException {
        Session session = null;
        try {
            session = this.openSession();
            StringBundler sb = new StringBundler(7);
            sb.append("(");
            String sql = CustomSQLUtil.get((String)COUNT_F_BY_G_M_F, (QueryDefinition)queryDefinition, (String)"DLFolder");
            if (inlineSQLHelper) {
                sql = InlineSQLHelperUtil.replacePermissionCheck((String)sql, (String)DLFolder.class.getName(), (String)"DLFolder.folderId", (long)groupId);
            }
            sb.append(sql);
            sb.append(") UNION ALL (");
            sb.append(this.getFileVersionsSQL(COUNT_FE_BY_G_F, groupId, mimeTypes, queryDefinition, inlineSQLHelper));
            sb.append(") UNION ALL (");
            sb.append(this.getFileShortcutsSQL(COUNT_FS_BY_G_F_A, groupId, mimeTypes, queryDefinition, inlineSQLHelper));
            sb.append(")");
            sql = sb.toString();
            sql = this.updateSQL(sql, folderId, includeMountFolders);
            SQLQuery q = session.createSQLQuery(sql);
            q.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(groupId);
            if (!includeMountFolders) {
                qPos.add(false);
            }
            qPos.add(queryDefinition.getStatus());
            qPos.add(folderId);
            qPos.add(groupId);
            qPos.add(queryDefinition.getStatus());
            qPos.add(folderId);
            if (mimeTypes != null) {
                qPos.add(mimeTypes);
            }
            qPos.add(groupId);
            qPos.add(true);
            qPos.add(queryDefinition.getStatus());
            qPos.add(folderId);
            if (mimeTypes != null) {
                qPos.add(mimeTypes);
            }
            int count = 0;
            Iterator itr = q.iterate();
            while (itr.hasNext()) {
                Long l = (Long)itr.next();
                if (l == null) continue;
                count += l.intValue();
            }
            int n = count;
            return n;
        }
        catch (Exception e2) {
            throw new SystemException((Throwable)e2);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected int doCountFE_ByG_F(long groupId, long folderId, QueryDefinition queryDefinition, boolean inlineSQLHelper) throws SystemException {
        Session session = null;
        try {
            Long count;
            session = this.openSession();
            String sql = this.getFileVersionsSQL(COUNT_FE_BY_G_F, groupId, null, queryDefinition, inlineSQLHelper);
            sql = this.updateSQL(sql, folderId, false);
            SQLQuery q = session.createSQLQuery(sql);
            q.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(groupId);
            qPos.add(queryDefinition.getStatus());
            qPos.add(folderId);
            Iterator itr = q.iterate();
            if (itr.hasNext() && (count = (Long)itr.next()) != null) {
                int n = count.intValue();
                return n;
            }
            return 0;
        }
        catch (Exception e2) {
            throw new SystemException((Throwable)e2);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected int doCountFE_FS_ByG_F_M(long groupId, long folderId, String[] mimeTypes, QueryDefinition queryDefinition, boolean inlineSQLHelper) throws SystemException {
        Session session = null;
        try {
            session = this.openSession();
            StringBundler sb = new StringBundler(7);
            sb.append("(");
            String sql = this.getFileVersionsSQL(COUNT_FE_BY_G_F, groupId, mimeTypes, queryDefinition, inlineSQLHelper);
            sb.append(sql);
            sb.append(") UNION ALL (");
            sb.append(this.getFileShortcutsSQL(COUNT_FS_BY_G_F_A, groupId, mimeTypes, queryDefinition, inlineSQLHelper));
            sb.append(")");
            sql = sb.toString();
            sql = this.updateSQL(sql, folderId, false);
            SQLQuery q = session.createSQLQuery(sql);
            q.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(groupId);
            qPos.add(queryDefinition.getStatus());
            qPos.add(folderId);
            if (mimeTypes != null) {
                qPos.add(mimeTypes);
            }
            qPos.add(groupId);
            qPos.add(true);
            qPos.add(queryDefinition.getStatus());
            qPos.add(folderId);
            if (mimeTypes != null) {
                qPos.add(mimeTypes);
            }
            int count = 0;
            Iterator itr = q.iterate();
            while (itr.hasNext()) {
                Long l = (Long)itr.next();
                if (l == null) continue;
                count += l.intValue();
            }
            int n = count;
            return n;
        }
        catch (Exception e2) {
            throw new SystemException((Throwable)e2);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected List<Object> doFindF_FE_FS_ByG_F_M_M(long groupId, long folderId, String[] mimeTypes, boolean includeMountFolders, QueryDefinition queryDefinition, boolean inlineSQLHelper) throws SystemException {
        Session session = null;
        try {
            session = this.openSession();
            StringBundler sb = new StringBundler(7);
            sb.append("SELECT * FROM (");
            String sql = CustomSQLUtil.get((String)FIND_F_BY_G_M_F, (QueryDefinition)queryDefinition, (String)"DLFolder");
            if (inlineSQLHelper) {
                sql = InlineSQLHelperUtil.replacePermissionCheck((String)sql, (String)DLFolder.class.getName(), (String)"DLFolder.folderId", (long)groupId);
            }
            sb.append(sql);
            sb.append(" UNION ALL ");
            sql = this.getFileEntriesSQL(FIND_FE_BY_G_F, groupId, mimeTypes, queryDefinition, inlineSQLHelper);
            sb.append(sql);
            sb.append(" UNION ALL ");
            sql = this.getFileShortcutsSQL(FIND_FS_BY_G_F_A, groupId, mimeTypes, queryDefinition, inlineSQLHelper);
            sb.append(sql);
            sb.append(") TEMP_TABLE ORDER BY modelFolder DESC, title ASC");
            sql = sb.toString();
            sql = this.updateSQL(sql, folderId, includeMountFolders);
            sql = CustomSQLUtil.replaceOrderBy((String)sql, (OrderByComparator)queryDefinition.getOrderByComparator());
            SQLQuery q = session.createSQLQuery(sql);
            q.addScalar("modelFolderId", Type.LONG);
            q.addScalar("name", Type.STRING);
            q.addScalar("title", Type.STRING);
            q.addScalar("fileShortcutId", Type.LONG);
            q.addScalar("modelFolder", Type.LONG);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(groupId);
            if (!includeMountFolders) {
                qPos.add(false);
            }
            qPos.add(queryDefinition.getStatus());
            qPos.add(folderId);
            qPos.add(groupId);
            qPos.add(queryDefinition.getStatus());
            qPos.add(folderId);
            if (mimeTypes != null) {
                qPos.add(mimeTypes);
            }
            qPos.add(groupId);
            qPos.add(true);
            qPos.add(queryDefinition.getStatus());
            qPos.add(folderId);
            if (mimeTypes != null) {
                qPos.add(mimeTypes);
            }
            ArrayList<Object> models = new ArrayList<Object>();
            Iterator itr = QueryUtil.iterate((Query)q, (Dialect)this.getDialect(), (int)queryDefinition.getStart(), (int)queryDefinition.getEnd());
            while (itr.hasNext()) {
                Object[] array = (Object[])itr.next();
                long curFolderId = (Long)array[0];
                String name = (String)array[1];
                long fileShortcutId = (Long)array[3];
                long modelFolder = (Long)array[4];
                Object obj = null;
                obj = modelFolder == 1L ? DLFolderUtil.findByPrimaryKey((long)curFolderId) : (fileShortcutId > 0L ? DLFileShortcutUtil.findByPrimaryKey((long)fileShortcutId) : DLFileEntryUtil.findByG_F_N((long)groupId, (long)curFolderId, (String)name));
                models.add(obj);
            }
            ArrayList<Object> arrayList = models;
            return arrayList;
        }
        catch (Exception e2) {
            throw new SystemException((Throwable)e2);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected List<Object> doFindFE_FS_ByG_F(long groupId, long folderId, QueryDefinition queryDefinition, boolean inlineSQLHelper) throws SystemException {
        Session session = null;
        try {
            session = this.openSession();
            StringBundler sb = new StringBundler(5);
            sb.append("SELECT * FROM (");
            String sql = this.getFileEntriesSQL(FIND_FE_BY_G_F, groupId, null, queryDefinition, inlineSQLHelper);
            sb.append(sql);
            sb.append(" UNION ALL ");
            sql = this.getFileShortcutsSQL(FIND_FS_BY_G_F_A, groupId, null, queryDefinition, inlineSQLHelper);
            sb.append(sql);
            sb.append(") TEMP_TABLE ORDER BY modelFolder DESC, title ASC");
            sql = sb.toString();
            sql = this.updateSQL(sql, folderId, false);
            SQLQuery q = session.createSQLQuery(sql);
            q.addScalar("modelFolderId", Type.LONG);
            q.addScalar("name", Type.STRING);
            q.addScalar("title", Type.STRING);
            q.addScalar("fileShortcutId", Type.LONG);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(groupId);
            qPos.add(queryDefinition.getStatus());
            qPos.add(folderId);
            qPos.add(groupId);
            qPos.add(true);
            qPos.add(queryDefinition.getStatus());
            qPos.add(folderId);
            ArrayList<Object> models = new ArrayList<Object>();
            Iterator itr = QueryUtil.iterate((Query)q, (Dialect)this.getDialect(), (int)queryDefinition.getStart(), (int)queryDefinition.getEnd());
            while (itr.hasNext()) {
                Object[] array = (Object[])itr.next();
                long folderId2 = (Long)array[0];
                String name = (String)array[1];
                long fileShortcutId = (Long)array[3];
                Object obj = null;
                obj = fileShortcutId > 0L ? DLFileShortcutUtil.findByPrimaryKey((long)fileShortcutId) : DLFileEntryUtil.findByG_F_N((long)groupId, (long)folderId2, (String)name);
                models.add(obj);
            }
            ArrayList<Object> arrayList = models;
            return arrayList;
        }
        catch (Exception e2) {
            throw new SystemException((Throwable)e2);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected String getFileEntriesSQL(String id, long groupId, String[] mimeTypes, QueryDefinition queryDefinition, boolean inlineSQLHelper) {
        String sql = CustomSQLUtil.get((String)id, (QueryDefinition)queryDefinition, (String)"DLFileVersion");
        if (inlineSQLHelper) {
            sql = InlineSQLHelperUtil.replacePermissionCheck((String)sql, (String)DLFileEntry.class.getName(), (String)"DLFileEntry.fileEntryId", (long)groupId);
        }
        sql = queryDefinition.getStatus() == -1 ? StringUtil.replace((String)sql, (String)"[$JOIN$]", (String)"") : StringUtil.replace((String)sql, (String)"[$JOIN$]", (String)CustomSQLUtil.get((String)JOIN_FE_BY_DL_FILE_VERSION));
        if (mimeTypes != null && mimeTypes.length > 0) {
            StringBundler sb = new StringBundler(5);
            sb.append(sql);
            sb.append(" AND ");
            sb.append("(");
            sb.append(this.getMimeTypes(mimeTypes, "DLFileEntry"));
            sb.append(")");
            sql = sb.toString();
        }
        return sql;
    }

    protected String getFileShortcutsSQL(String id, long groupId, String[] mimeTypes, QueryDefinition queryDefinition, boolean inlineSQLHelper) {
        String sql = CustomSQLUtil.get((String)id, (QueryDefinition)queryDefinition, (String)"DLFileShortcut");
        if (inlineSQLHelper) {
            sql = InlineSQLHelperUtil.replacePermissionCheck((String)sql, (String)DLFileShortcut.class.getName(), (String)"DLFileShortcut.fileShortcutId", (long)groupId);
        }
        if (mimeTypes != null && mimeTypes.length > 0) {
            StringBundler sb = new StringBundler(5);
            sb.append(StringUtil.replace((String)sql, (String)"[$JOIN$]", (String)CustomSQLUtil.get((String)JOIN_FS_BY_DL_FILE_ENTRY)));
            sb.append(" AND ");
            sb.append("(");
            sb.append(this.getMimeTypes(mimeTypes, "DLFileEntry"));
            sb.append(")");
            sql = sb.toString();
        } else {
            sql = StringUtil.replace((String)sql, (String)"[$JOIN$]", (String)"");
        }
        return sql;
    }

    protected String getFileVersionsSQL(String id, long groupId, String[] mimeTypes, QueryDefinition queryDefinition, boolean inlineSQLHelper) {
        String sql = CustomSQLUtil.get((String)id, (QueryDefinition)queryDefinition, (String)"DLFileVersion");
        if (inlineSQLHelper) {
            sql = InlineSQLHelperUtil.replacePermissionCheck((String)sql, (String)DLFileEntry.class.getName(), (String)"DLFileVersion.fileEntryId", (long)groupId);
        }
        if (mimeTypes != null && mimeTypes.length > 0) {
            StringBundler sb = new StringBundler(5);
            sb.append(sql);
            sb.append(" AND ");
            sb.append("(");
            sb.append(this.getMimeTypes(mimeTypes, "DLFileVersion"));
            sb.append(")");
            sql = sb.toString();
        }
        return sql;
    }

    protected String getFolderId(long folderId, String tableName) {
        StringBundler sb = new StringBundler(4);
        sb.append(tableName);
        sb.append(".");
        if (tableName.equals("DLFolder")) {
            sb.append("parentFolderId");
        } else {
            sb.append("folderId");
        }
        sb.append("= ? ");
        return sb.toString();
    }

    protected String getMimeTypes(String[] mimeTypes, String tableName) {
        if (mimeTypes.length == 0) {
            return "";
        }
        StringBundler sb = new StringBundler(mimeTypes.length * 2 - 1);
        int i2 = 0;
        while (i2 < mimeTypes.length) {
            sb.append(tableName);
            sb.append(".mimeType = ?");
            if (i2 + 1 != mimeTypes.length) {
                sb.append(" OR ");
            }
            ++i2;
        }
        return sb.toString();
    }

    protected String updateSQL(String sql, long folderId, boolean includeMountFolders) {
        sql = StringUtil.replace((String)sql, (String[])new String[]{"[$FILE_ENTRY_FOLDER_ID$]", "[$FILE_SHORTCUT_FOLDER_ID$]", "[$FILE_VERSION_FOLDER_ID$]", "[$FOLDER_PARENT_FOLDER_ID$]"}, (String[])new String[]{this.getFolderId(folderId, "DLFileEntry"), this.getFolderId(folderId, "DLFileShortcut"), this.getFolderId(folderId, "DLFileVersion"), this.getFolderId(folderId, "DLFolder")});
        if (includeMountFolders) {
            sql = StringUtil.replace((String)sql, (String)"(DLFolder.mountPoint = ?) AND", (String)"");
        }
        return sql;
    }
}

