/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.service.persistence;

import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryDefinition;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.SQLQuery;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.Type;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.security.permission.InlineSQLHelperUtil;
import com.liferay.portal.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portlet.documentlibrary.NoSuchFileEntryException;
import com.liferay.portlet.documentlibrary.model.DLFileEntry;
import com.liferay.portlet.documentlibrary.model.impl.DLFileEntryImpl;
import com.liferay.portlet.documentlibrary.service.persistence.DLFileEntryFinder;
import com.liferay.portlet.documentlibrary.service.persistence.DLFolderFinderImpl;
import com.liferay.util.dao.orm.CustomSQLUtil;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class DLFileEntryFinderImpl
extends BasePersistenceImpl<DLFileEntry>
implements DLFileEntryFinder {
    public static final String COUNT_BY_EXTRA_SETTINGS = String.valueOf(DLFileEntryFinder.class.getName()) + ".countByExtraSettings";
    public static final String COUNT_BY_G_F = String.valueOf(DLFileEntryFinder.class.getName()) + ".countByG_F";
    public static final String COUNT_BY_G_U_F = String.valueOf(DLFileEntryFinder.class.getName()) + ".countByG_U_F";
    public static final String FIND_BY_ANY_IMAGE_ID = String.valueOf(DLFileEntryFinder.class.getName()) + ".findByAnyImageId";
    public static final String FIND_BY_EXTRA_SETTINGS = String.valueOf(DLFileEntryFinder.class.getName()) + ".findByExtraSettings";
    public static final String FIND_BY_DDM_STRUCTURE_IDS = String.valueOf(DLFileEntryFinder.class.getName()) + ".findByDDMStructureIds";
    public static final String FIND_BY_MISVERSIONED = String.valueOf(DLFileEntryFinder.class.getName()) + ".findByMisversioned";
    public static final String FIND_BY_NO_ASSETS = String.valueOf(DLFileEntryFinder.class.getName()) + ".findByNoAssets";
    public static final String FIND_BY_ORPHANED_FILE_ENTRIES = String.valueOf(DLFileEntryFinder.class.getName()) + ".findByOrphanedFileEntries";
    public static final String FIND_BY_G_F = String.valueOf(DLFileEntryFinder.class.getName()) + ".findByG_F";
    public static final String FIND_BY_G_U_F = String.valueOf(DLFileEntryFinder.class.getName()) + ".findByG_U_F";

    public int countByExtraSettings() throws SystemException {
        Session session = null;
        try {
            Long count;
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)COUNT_BY_EXTRA_SETTINGS);
            SQLQuery q = session.createSQLQuery(sql);
            q.addScalar("COUNT_VALUE", Type.LONG);
            Iterator itr = q.iterate();
            if (itr.hasNext() && (count = (Long)itr.next()) != null) {
                int n = count.intValue();
                return n;
            }
            return 0;
        }
        catch (Exception e2) {
            throw new SystemException((Throwable)e2);
        }
        finally {
            this.closeSession(session);
        }
    }

    public int countByG_F(long groupId, List<Long> folderIds, QueryDefinition queryDefinition) throws SystemException {
        return this.doCountByG_U_F_M(groupId, 0L, folderIds, null, queryDefinition, false);
    }

    public int countByG_U_F_M(long groupId, long userId, List<Long> folderIds, String[] mimeTypes, QueryDefinition queryDefinition) throws SystemException {
        return this.doCountByG_U_F_M(groupId, userId, folderIds, mimeTypes, queryDefinition, false);
    }

    public DLFileEntry fetchByAnyImageId(long imageId) throws SystemException {
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_BY_ANY_IMAGE_ID);
            SQLQuery q = session.createSQLQuery(sql);
            q.addEntity("DLFileEntry", DLFileEntryImpl.class);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(imageId);
            qPos.add(imageId);
            qPos.add(imageId);
            qPos.add(imageId);
            List dlFileEntries = q.list();
            if (!dlFileEntries.isEmpty()) {
                DLFileEntry dLFileEntry = (DLFileEntry)dlFileEntries.get(0);
                return dLFileEntry;
            }
            return null;
        }
        catch (Exception e2) {
            throw new SystemException((Throwable)e2);
        }
        finally {
            this.closeSession(session);
        }
    }

    public int filterCountByG_F(long groupId, List<Long> folderIds, QueryDefinition queryDefinition) throws SystemException {
        return this.doCountByG_U_F_M(groupId, 0L, folderIds, null, queryDefinition, true);
    }

    public List<DLFileEntry> filterFindByG_F(long groupId, List<Long> folderIds, QueryDefinition queryDefinition) throws SystemException {
        return this.doFindByG_U_F_M(groupId, 0L, folderIds, null, queryDefinition, true);
    }

    public DLFileEntry findByAnyImageId(long imageId) throws NoSuchFileEntryException, SystemException {
        DLFileEntry dlFileEntry = this.fetchByAnyImageId(imageId);
        if (dlFileEntry != null) {
            return dlFileEntry;
        }
        throw new NoSuchFileEntryException("No DLFileEntry exists with the imageId " + imageId);
    }

    public List<DLFileEntry> findByDDMStructureIds(long[] ddmStructureIds, int start, int end) throws SystemException {
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_BY_DDM_STRUCTURE_IDS);
            if (ddmStructureIds == null || ddmStructureIds.length <= 0) {
                List<DLFileEntry> list = Collections.emptyList();
                return list;
            }
            sql = StringUtil.replace((String)sql, (String)"[$DDM_STRUCTURE_ID$]", (String)this.getDDMStructureIds(ddmStructureIds));
            SQLQuery q = session.createSQLQuery(sql);
            q.addEntity("DLFileEntry", DLFileEntryImpl.class);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(ddmStructureIds);
            List list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
            return list;
        }
        catch (Exception e2) {
            throw new SystemException((Throwable)e2);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<DLFileEntry> findByExtraSettings(int start, int end) throws SystemException {
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_BY_EXTRA_SETTINGS);
            SQLQuery q = session.createSQLQuery(sql);
            q.addEntity("DLFileEntry", DLFileEntryImpl.class);
            List list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
            return list;
        }
        catch (Exception e2) {
            throw new SystemException((Throwable)e2);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<DLFileEntry> findByMisversioned() throws SystemException {
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_BY_MISVERSIONED);
            SQLQuery q = session.createSQLQuery(sql);
            q.addEntity("DLFileEntry", DLFileEntryImpl.class);
            List list = q.list(true);
            return list;
        }
        catch (Exception e2) {
            throw new SystemException((Throwable)e2);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<DLFileEntry> findByNoAssets() throws SystemException {
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_BY_NO_ASSETS);
            SQLQuery q = session.createSQLQuery(sql);
            q.addEntity("DLFileEntry", DLFileEntryImpl.class);
            List list = q.list(true);
            return list;
        }
        catch (Exception e2) {
            throw new SystemException((Throwable)e2);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<DLFileEntry> findByOrphanedFileEntries() throws SystemException {
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_BY_ORPHANED_FILE_ENTRIES);
            SQLQuery q = session.createSQLQuery(sql);
            q.addEntity("DLFileEntry", DLFileEntryImpl.class);
            List list = q.list(true);
            return list;
        }
        catch (Exception e2) {
            throw new SystemException((Throwable)e2);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<DLFileEntry> findByG_F(long groupId, List<Long> folderIds, QueryDefinition queryDefinition) throws SystemException {
        return this.doFindByG_U_F_M(groupId, 0L, folderIds, null, queryDefinition, false);
    }

    public List<DLFileEntry> findByG_U_F_M(long groupId, long userId, List<Long> folderIds, String[] mimeTypes, QueryDefinition queryDefinition) throws SystemException {
        return this.doFindByG_U_F_M(groupId, userId, folderIds, mimeTypes, queryDefinition, false);
    }

    protected int doCountByG_U_F_M(long groupId, long userId, List<Long> folderIds, String[] mimeTypes, QueryDefinition queryDefinition, boolean inlineSQLHelper) throws SystemException {
        Session session = null;
        try {
            Long count;
            Iterator itr;
            session = this.openSession();
            String id = null;
            id = userId <= 0L ? COUNT_BY_G_F : COUNT_BY_G_U_F;
            String sql = this.getFileEntriesSQL(id, groupId, folderIds, mimeTypes, queryDefinition, inlineSQLHelper);
            SQLQuery q = session.createSQLQuery(sql);
            q.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(groupId);
            if (userId > 0L) {
                qPos.add(userId);
            }
            qPos.add(queryDefinition.getStatus());
            for (Long folderId : folderIds) {
                qPos.add(folderId);
            }
            if (mimeTypes != null) {
                qPos.add(mimeTypes);
            }
            if ((itr = q.iterate()).hasNext() && (count = (Long)itr.next()) != null) {
                int n = count.intValue();
                return n;
            }
            return 0;
        }
        catch (Exception e2) {
            throw new SystemException((Throwable)e2);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected List<DLFileEntry> doFindByG_U_F_M(long groupId, long userId, List<Long> folderIds, String[] mimeTypes, QueryDefinition queryDefinition, boolean inlineSQLHelper) throws SystemException {
        Session session = null;
        try {
            session = this.openSession();
            String id = null;
            id = userId <= 0L ? FIND_BY_G_F : FIND_BY_G_U_F;
            String sql = this.getFileEntriesSQL(id, groupId, folderIds, mimeTypes, queryDefinition, inlineSQLHelper);
            sql = CustomSQLUtil.replaceOrderBy((String)sql, (OrderByComparator)queryDefinition.getOrderByComparator());
            SQLQuery q = session.createSQLQuery(sql);
            q.addEntity("DLFileEntry", DLFileEntryImpl.class);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(groupId);
            if (userId > 0L) {
                qPos.add(userId);
            }
            qPos.add(queryDefinition.getStatus());
            for (Long folderId : folderIds) {
                qPos.add(folderId);
            }
            if (mimeTypes != null) {
                qPos.add(mimeTypes);
            }
            List list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)queryDefinition.getStart(), (int)queryDefinition.getEnd());
            return list;
        }
        catch (Exception e2) {
            throw new SystemException((Throwable)e2);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected String getDDMStructureIds(long[] ddmStructureIds) {
        StringBundler sb = new StringBundler(ddmStructureIds.length * 2 - 1 + 2);
        sb.append("(");
        int i2 = 0;
        while (i2 < ddmStructureIds.length) {
            sb.append("DLFileEntryTypes_DDMStructures.structureId = ?");
            if (i2 + 1 != ddmStructureIds.length) {
                sb.append(" OR ");
            }
            ++i2;
        }
        sb.append(")");
        return sb.toString();
    }

    protected String getFileEntriesSQL(String id, long groupId, List<Long> folderIds, String[] mimeTypes, QueryDefinition queryDefinition, boolean inlineSQLHelper) {
        String tableName = "DLFileVersion";
        String sql = CustomSQLUtil.get((String)id, (QueryDefinition)queryDefinition, (String)tableName);
        if (queryDefinition.getStatus() == -1) {
            sql = StringUtil.replace((String)sql, (String)"[$JOIN$]", (String)"");
            tableName = "DLFileEntry";
        } else {
            sql = StringUtil.replace((String)sql, (String)"[$JOIN$]", (String)CustomSQLUtil.get((String)DLFolderFinderImpl.JOIN_FE_BY_DL_FILE_VERSION));
        }
        if (inlineSQLHelper && InlineSQLHelperUtil.isEnabled()) {
            sql = InlineSQLHelperUtil.replacePermissionCheck((String)sql, (String)DLFileEntry.class.getName(), (String)"DLFileEntry.fileEntryId", (long)groupId);
        }
        StringBundler sb = new StringBundler(7);
        if (!folderIds.isEmpty()) {
            sb.append("(");
            sb.append(this.getFolderIds(folderIds, tableName));
            sb.append(")");
        }
        if (mimeTypes != null && mimeTypes.length > 0) {
            sb.append(" AND ");
            sb.append("(");
            sb.append(this.getMimeTypes(mimeTypes, tableName));
            sb.append(")");
        }
        return StringUtil.replace((String)sql, (String)"[$FOLDER_ID$]", (String)sb.toString());
    }

    protected String getFolderIds(List<Long> folderIds, String tableName) {
        if (folderIds.isEmpty()) {
            return "";
        }
        StringBundler sb = new StringBundler(folderIds.size() * 3 + 1);
        sb.append("(");
        int i2 = 0;
        while (i2 < folderIds.size()) {
            sb.append(tableName);
            sb.append(".folderId = ? ");
            if (i2 + 1 != folderIds.size()) {
                sb.append(" OR ");
            }
            ++i2;
        }
        sb.append(")");
        return sb.toString();
    }

    protected String getMimeTypes(String[] mimeTypes, String tableName) {
        if (mimeTypes.length == 0) {
            return "";
        }
        StringBundler sb = new StringBundler(mimeTypes.length * 2 - 1);
        int i2 = 0;
        while (i2 < mimeTypes.length) {
            sb.append(tableName);
            sb.append(".mimeType = ?");
            if (i2 + 1 != mimeTypes.length) {
                sb.append(" OR ");
            }
            ++i2;
        }
        return sb.toString();
    }
}

