/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.service.impl;

import com.liferay.portal.ExpiredLockException;
import com.liferay.portal.InvalidLockException;
import com.liferay.portal.NoSuchLockException;
import com.liferay.portal.NoSuchModelException;
import com.liferay.portal.kernel.dao.orm.QueryDefinition;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.image.ImageBag;
import com.liferay.portal.kernel.image.ImageToolUtil;
import com.liferay.portal.kernel.increment.BufferedIncrement;
import com.liferay.portal.kernel.increment.NumberIncrement;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.util.Accessor;
import com.liferay.portal.kernel.util.DigesterUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.ObjectValuePair;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StreamUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.workflow.WorkflowHandlerRegistryUtil;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.Image;
import com.liferay.portal.model.Lock;
import com.liferay.portal.model.ModelHintsUtil;
import com.liferay.portal.model.Repository;
import com.liferay.portal.model.User;
import com.liferay.portal.repository.liferayrepository.model.LiferayFileEntry;
import com.liferay.portal.repository.liferayrepository.model.LiferayFileVersion;
import com.liferay.portal.security.auth.PrincipalThreadLocal;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PrefsPropsUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.asset.model.AssetEntry;
import com.liferay.portlet.asset.model.AssetLink;
import com.liferay.portlet.documentlibrary.DuplicateFileException;
import com.liferay.portlet.documentlibrary.DuplicateFolderNameException;
import com.liferay.portlet.documentlibrary.FileExtensionException;
import com.liferay.portlet.documentlibrary.FileNameException;
import com.liferay.portlet.documentlibrary.ImageSizeException;
import com.liferay.portlet.documentlibrary.InvalidFileEntryTypeException;
import com.liferay.portlet.documentlibrary.InvalidFileVersionException;
import com.liferay.portlet.documentlibrary.NoSuchFileEntryException;
import com.liferay.portlet.documentlibrary.NoSuchFileVersionException;
import com.liferay.portlet.documentlibrary.model.DLFileEntry;
import com.liferay.portlet.documentlibrary.model.DLFileEntryConstants;
import com.liferay.portlet.documentlibrary.model.DLFileEntryMetadata;
import com.liferay.portlet.documentlibrary.model.DLFileEntryType;
import com.liferay.portlet.documentlibrary.model.DLFileVersion;
import com.liferay.portlet.documentlibrary.model.DLFolder;
import com.liferay.portlet.documentlibrary.model.DLFolderConstants;
import com.liferay.portlet.documentlibrary.model.impl.DLFileEntryImpl;
import com.liferay.portlet.documentlibrary.service.base.DLFileEntryLocalServiceBaseImpl;
import com.liferay.portlet.documentlibrary.store.DLStoreUtil;
import com.liferay.portlet.documentlibrary.util.DLAppUtil;
import com.liferay.portlet.documentlibrary.util.DLUtil;
import com.liferay.portlet.documentlibrary.util.comparator.RepositoryModelModifiedDateComparator;
import com.liferay.portlet.dynamicdatamapping.model.DDMStructure;
import com.liferay.portlet.dynamicdatamapping.storage.Fields;
import com.liferay.portlet.dynamicdatamapping.storage.StorageEngineUtil;
import com.liferay.portlet.expando.NoSuchRowException;
import com.liferay.portlet.expando.NoSuchTableException;
import com.liferay.portlet.expando.model.ExpandoBridge;
import com.liferay.portlet.expando.model.ExpandoColumnConstants;
import com.liferay.portlet.expando.model.ExpandoRow;
import com.liferay.portlet.expando.model.ExpandoTable;
import com.liferay.portlet.expando.util.ExpandoBridgeFactoryUtil;
import com.liferay.portlet.trash.model.TrashVersion;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DLFileEntryLocalServiceImpl
extends DLFileEntryLocalServiceBaseImpl {
    private static final int _DELETE_INTERVAL = 100;
    private static Log _log = LogFactoryUtil.getLog(DLFileEntryLocalServiceImpl.class);

    public DLFileEntry addFileEntry(long userId, long groupId, long repositoryId, long folderId, String sourceFileName, String mimeType, String title, String description, String changeLog, long fileEntryTypeId, Map<String, Fields> fieldsMap, File file, InputStream is, long size, ServiceContext serviceContext) throws PortalException, SystemException {
        if (Validator.isNull((String)title)) {
            if (size == 0L) {
                throw new FileNameException();
            }
            title = sourceFileName;
        }
        User user = this.userPersistence.findByPrimaryKey(userId);
        folderId = this.dlFolderLocalService.getFolderId(user.getCompanyId(), folderId);
        String name = String.valueOf(this.counterLocalService.increment(DLFileEntry.class.getName()));
        String extension = DLAppUtil.getExtension(title, sourceFileName);
        if (fileEntryTypeId == -1L) {
            fileEntryTypeId = this.dlFileEntryTypeLocalService.getDefaultFileEntryTypeId(folderId);
        }
        Date now = new Date();
        this.validateFileEntryTypeId(PortalUtil.getSiteAndCompanyGroupIds((long)groupId), folderId, fileEntryTypeId);
        this.validateFile(groupId, folderId, 0L, title, extension, sourceFileName, file, is);
        long fileEntryId = this.counterLocalService.increment();
        DLFileEntry dlFileEntry = this.dlFileEntryPersistence.create(fileEntryId);
        dlFileEntry.setUuid(serviceContext.getUuid());
        dlFileEntry.setGroupId(groupId);
        dlFileEntry.setCompanyId(user.getCompanyId());
        dlFileEntry.setUserId(user.getUserId());
        dlFileEntry.setUserName(user.getFullName());
        dlFileEntry.setVersionUserId(user.getUserId());
        dlFileEntry.setVersionUserName(user.getFullName());
        dlFileEntry.setCreateDate(serviceContext.getCreateDate(now));
        dlFileEntry.setModifiedDate(serviceContext.getModifiedDate(now));
        DLFolder repositoryDLFolder = null;
        if (repositoryId != groupId) {
            Repository repository = this.repositoryLocalService.getRepository(repositoryId);
            repositoryDLFolder = this.dlFolderPersistence.findByPrimaryKey(repository.getDlFolderId());
        }
        if (repositoryDLFolder != null && repositoryDLFolder.isHidden()) {
            long classNameId = PortalUtil.getClassNameId((String)((String)((Object)serviceContext.getAttribute("className"))));
            long classPK = ParamUtil.getLong((ServiceContext)serviceContext, (String)"classPK");
            if (Validator.isNotNull((Long)classNameId) && Validator.isNotNull((Long)classPK)) {
                dlFileEntry.setClassNameId(classNameId);
                dlFileEntry.setClassPK(classPK);
            }
        }
        dlFileEntry.setRepositoryId(repositoryId);
        dlFileEntry.setFolderId(folderId);
        dlFileEntry.setName(name);
        dlFileEntry.setExtension(extension);
        dlFileEntry.setMimeType(mimeType);
        dlFileEntry.setTitle(title);
        dlFileEntry.setDescription(description);
        dlFileEntry.setFileEntryTypeId(fileEntryTypeId);
        dlFileEntry.setVersion("1.0");
        dlFileEntry.setSize(size);
        dlFileEntry.setReadCount(0);
        this.dlFileEntryPersistence.update((BaseModel)dlFileEntry);
        this.addFileVersion(user, dlFileEntry, serviceContext.getModifiedDate(now), extension, mimeType, title, description, null, "", fileEntryTypeId, fieldsMap, "1.0", size, 2, serviceContext);
        if (folderId != 0L) {
            DLFolder dlFolder = this.dlFolderPersistence.findByPrimaryKey(dlFileEntry.getFolderId());
            dlFolder.setLastPostDate(dlFileEntry.getModifiedDate());
            this.dlFolderPersistence.update((BaseModel)dlFolder);
        }
        if (file != null) {
            DLStoreUtil.addFile((long)user.getCompanyId(), (long)dlFileEntry.getDataRepositoryId(), (String)name, (boolean)false, (File)file);
        } else {
            DLStoreUtil.addFile((long)user.getCompanyId(), (long)dlFileEntry.getDataRepositoryId(), (String)name, (boolean)false, (InputStream)is);
        }
        return dlFileEntry;
    }

    public DLFileVersion cancelCheckOut(long userId, long fileEntryId) throws PortalException, SystemException {
        if (!this.isFileEntryCheckedOut(fileEntryId)) {
            return null;
        }
        DLFileEntry dlFileEntry = this.dlFileEntryPersistence.findByPrimaryKey(fileEntryId);
        DLFileVersion dlFileVersion = this.dlFileVersionLocalService.getLatestFileVersion(fileEntryId, false);
        this.removeFileVersion(dlFileEntry, dlFileVersion);
        if (dlFileEntry.getFolderId() != 0L) {
            DLFolder dlFolder = this.dlFolderPersistence.findByPrimaryKey(dlFileEntry.getFolderId());
            dlFolder.setLastPostDate(new Date());
            this.dlFolderPersistence.update((BaseModel)dlFolder);
        }
        return dlFileVersion;
    }

    public void checkInFileEntry(long userId, long fileEntryId, boolean majorVersion, String changeLog, ServiceContext serviceContext) throws PortalException, SystemException {
        DLFileVersion latestDLFileVersion;
        DLFileVersion lastDLFileVersion;
        if (!this.isFileEntryCheckedOut(fileEntryId)) {
            return;
        }
        User user = this.userPersistence.findByPrimaryKey(userId);
        DLFileEntry dlFileEntry = this.dlFileEntryPersistence.findByPrimaryKey(fileEntryId);
        boolean webDAVCheckInMode = GetterUtil.getBoolean((Object)serviceContext.getAttribute("webDAVCheckInMode"));
        boolean manualCheckInRequired = dlFileEntry.getManualCheckInRequired();
        if (!webDAVCheckInMode && manualCheckInRequired) {
            dlFileEntry.setManualCheckInRequired(false);
            this.dlFileEntryPersistence.update((BaseModel)dlFileEntry);
        }
        if (this.isKeepFileVersionLabel(dlFileEntry, lastDLFileVersion = this.dlFileVersionLocalService.getFileVersion(dlFileEntry.getFileEntryId(), dlFileEntry.getVersion()), latestDLFileVersion = this.dlFileVersionLocalService.getLatestFileVersion(fileEntryId, false), serviceContext.getWorkflowAction())) {
            if (lastDLFileVersion.getSize() != latestDLFileVersion.getSize()) {
                lastDLFileVersion.setExtension(latestDLFileVersion.getExtension());
                lastDLFileVersion.setMimeType(latestDLFileVersion.getMimeType());
                lastDLFileVersion.setSize(latestDLFileVersion.getSize());
                this.dlFileVersionPersistence.update((BaseModel)lastDLFileVersion);
                try {
                    DLStoreUtil.deleteFile((long)user.getCompanyId(), (long)dlFileEntry.getDataRepositoryId(), (String)dlFileEntry.getName(), (String)lastDLFileVersion.getVersion());
                }
                catch (NoSuchModelException noSuchModelException) {}
                DLStoreUtil.copyFileVersion((long)user.getCompanyId(), (long)dlFileEntry.getDataRepositoryId(), (String)dlFileEntry.getName(), (String)"PWC", (String)lastDLFileVersion.getVersion());
            }
            this.removeFileVersion(dlFileEntry, latestDLFileVersion);
            latestDLFileVersion = lastDLFileVersion;
        } else {
            String version = this.getNextVersion(dlFileEntry, majorVersion, serviceContext.getWorkflowAction());
            latestDLFileVersion.setVersion(version);
            latestDLFileVersion.setChangeLog(changeLog);
            this.dlFileVersionPersistence.update((BaseModel)latestDLFileVersion);
            DLStoreUtil.updateFileVersion((long)user.getCompanyId(), (long)dlFileEntry.getDataRepositoryId(), (String)dlFileEntry.getName(), (String)"PWC", (String)version);
        }
        if (dlFileEntry.getFolderId() != 0L) {
            DLFolder dlFolder = this.dlFolderPersistence.findByPrimaryKey(dlFileEntry.getFolderId());
            dlFolder.setLastPostDate(dlFileEntry.getModifiedDate());
            this.dlFolderPersistence.update((BaseModel)dlFolder);
        }
        if (serviceContext.getWorkflowAction() == 1) {
            this.startWorkflowInstance(userId, serviceContext, latestDLFileVersion, "update");
        }
        this.unlockFileEntry(fileEntryId);
    }

    public void checkInFileEntry(long userId, long fileEntryId, String lockUuid) throws PortalException, SystemException {
        this.checkInFileEntry(userId, fileEntryId, lockUuid, new ServiceContext());
    }

    public void checkInFileEntry(long userId, long fileEntryId, String lockUuid, ServiceContext serviceContext) throws PortalException, SystemException {
        block4: {
            if (Validator.isNotNull((String)lockUuid)) {
                try {
                    Lock lock = this.lockLocalService.getLock(DLFileEntry.class.getName(), fileEntryId);
                    if (!lock.getUuid().equals(lockUuid)) {
                        throw new InvalidLockException("UUIDs do not match");
                    }
                }
                catch (PortalException pe) {
                    if (pe instanceof ExpiredLockException || pe instanceof NoSuchLockException) break block4;
                    throw pe;
                }
            }
        }
        this.checkInFileEntry(userId, fileEntryId, false, "", serviceContext);
    }

    public DLFileEntry checkOutFileEntry(long userId, long fileEntryId) throws PortalException, SystemException {
        return this.checkOutFileEntry(userId, fileEntryId, new ServiceContext());
    }

    public DLFileEntry checkOutFileEntry(long userId, long fileEntryId, ServiceContext serviceContext) throws PortalException, SystemException {
        return this.checkOutFileEntry(userId, fileEntryId, "", DLFileEntryImpl.LOCK_EXPIRATION_TIME, serviceContext);
    }

    public DLFileEntry checkOutFileEntry(long userId, long fileEntryId, String owner, long expirationTime) throws PortalException, SystemException {
        return this.checkOutFileEntry(userId, fileEntryId, owner, expirationTime, new ServiceContext());
    }

    public DLFileEntry checkOutFileEntry(long userId, long fileEntryId, String owner, long expirationTime, ServiceContext serviceContext) throws PortalException, SystemException {
        DLFileEntry dlFileEntry = this.dlFileEntryPersistence.findByPrimaryKey(fileEntryId);
        boolean hasLock = this.hasFileEntryLock(userId, fileEntryId);
        if (!hasLock) {
            if (expirationTime <= 0L || expirationTime > DLFileEntryImpl.LOCK_EXPIRATION_TIME) {
                expirationTime = DLFileEntryImpl.LOCK_EXPIRATION_TIME;
            }
            this.lockLocalService.lock(userId, DLFileEntry.class.getName(), fileEntryId, owner, false, expirationTime);
        }
        User user = this.userPersistence.findByPrimaryKey(userId);
        serviceContext.setCompanyId(user.getCompanyId());
        DLFileVersion dlFileVersion = this.dlFileVersionLocalService.getLatestFileVersion(fileEntryId, false);
        long dlFileVersionId = dlFileVersion.getFileVersionId();
        Map expandoBridgeAttributes = serviceContext.getExpandoBridgeAttributes();
        if (expandoBridgeAttributes.isEmpty()) {
            ExpandoBridge expandoBridge = ExpandoBridgeFactoryUtil.getExpandoBridge((long)serviceContext.getCompanyId(), (String)DLFileEntry.class.getName(), (long)dlFileVersionId);
            serviceContext.setExpandoBridgeAttributes(expandoBridge.getAttributes());
        }
        serviceContext.setUserId(userId);
        boolean manualCheckinRequired = GetterUtil.getBoolean((Object)serviceContext.getAttribute("manualCheckInRequired"));
        dlFileEntry.setManualCheckInRequired(manualCheckinRequired);
        this.dlFileEntryPersistence.update((BaseModel)dlFileEntry);
        String version = dlFileVersion.getVersion();
        if (!version.equals("PWC")) {
            long existingDLFileVersionId = ParamUtil.getLong((ServiceContext)serviceContext, (String)"existingDLFileVersionId");
            if (existingDLFileVersionId > 0L) {
                DLFileVersion existingDLFileVersion = this.dlFileVersionPersistence.findByPrimaryKey(existingDLFileVersionId);
                dlFileVersion = this.updateFileVersion(user, existingDLFileVersion, null, existingDLFileVersion.getExtension(), existingDLFileVersion.getMimeType(), existingDLFileVersion.getTitle(), existingDLFileVersion.getDescription(), existingDLFileVersion.getChangeLog(), existingDLFileVersion.getExtraSettings(), existingDLFileVersion.getFileEntryTypeId(), null, "PWC", existingDLFileVersion.getSize(), 2, new Date(), serviceContext);
            } else {
                long oldDLFileVersionId = dlFileVersion.getFileVersionId();
                dlFileVersion = this.addFileVersion(user, dlFileEntry, new Date(), dlFileVersion.getExtension(), dlFileVersion.getMimeType(), dlFileVersion.getTitle(), dlFileVersion.getDescription(), dlFileVersion.getChangeLog(), dlFileVersion.getExtraSettings(), dlFileVersion.getFileEntryTypeId(), null, "PWC", dlFileVersion.getSize(), 2, serviceContext);
                this.copyExpandoRowModifiedDate(dlFileEntry.getCompanyId(), oldDLFileVersionId, dlFileVersion.getFileVersionId());
            }
            try {
                DLStoreUtil.deleteFile((long)dlFileEntry.getCompanyId(), (long)dlFileEntry.getDataRepositoryId(), (String)dlFileEntry.getName(), (String)"PWC");
            }
            catch (NoSuchModelException noSuchModelException) {}
            DLStoreUtil.copyFileVersion((long)user.getCompanyId(), (long)dlFileEntry.getDataRepositoryId(), (String)dlFileEntry.getName(), (String)version, (String)"PWC");
            this.copyFileEntryMetadata(dlFileEntry.getCompanyId(), dlFileVersion.getFileEntryTypeId(), fileEntryId, dlFileVersionId, dlFileVersion.getFileVersionId(), serviceContext);
        }
        if (dlFileEntry.getFolderId() != 0L) {
            DLFolder dlFolder = this.dlFolderPersistence.findByPrimaryKey(dlFileEntry.getFolderId());
            dlFolder.setLastPostDate(dlFileVersion.getModifiedDate());
            this.dlFolderPersistence.update((BaseModel)dlFolder);
        }
        return dlFileEntry;
    }

    public void convertExtraSettings(String[] keys) throws PortalException, SystemException {
        int count = this.dlFileEntryFinder.countByExtraSettings();
        int pages = count / 10000;
        int i2 = 0;
        while (i2 <= pages) {
            int start = i2 * 10000;
            int end = start + 10000;
            List dlFileEntries = this.dlFileEntryFinder.findByExtraSettings(start, end);
            for (DLFileEntry dlFileEntry : dlFileEntries) {
                this.convertExtraSettings(dlFileEntry, keys);
            }
            ++i2;
        }
    }

    public void copyFileEntryMetadata(long companyId, long fileEntryTypeId, long fileEntryId, long fromFileVersionId, long toFileVersionId, ServiceContext serviceContext) throws PortalException, SystemException {
        HashMap<String, Fields> fieldsMap = new HashMap<String, Fields>();
        List ddmStructures = null;
        if (fileEntryTypeId > 0L) {
            DLFileEntryType dlFileEntryType = this.dlFileEntryTypeLocalService.getFileEntryType(fileEntryTypeId);
            ddmStructures = dlFileEntryType.getDDMStructures();
        } else {
            long classNameId = PortalUtil.getClassNameId(DLFileEntryMetadata.class);
            ddmStructures = this.ddmStructureLocalService.getClassStructures(companyId, classNameId);
        }
        this.copyFileEntryMetadata(companyId, fileEntryTypeId, fileEntryId, fromFileVersionId, toFileVersionId, serviceContext, fieldsMap, ddmStructures);
    }

    public void deleteFileEntries(long groupId, long folderId) throws PortalException, SystemException {
        this.deleteFileEntries(groupId, folderId, true);
    }

    public void deleteFileEntries(long groupId, long folderId, boolean includeTrashedEntries) throws PortalException, SystemException {
        int count = this.dlFileEntryPersistence.countByG_F(groupId, folderId);
        int pages = count / 100;
        int i2 = 0;
        while (i2 <= pages) {
            int start = i2 * 100;
            int end = start + 100;
            List dlFileEntries = this.dlFileEntryPersistence.findByG_F(groupId, folderId, start, end);
            for (DLFileEntry dlFileEntry : dlFileEntries) {
                DLFileVersion dlFileVersion = dlFileEntry.getLatestFileVersion(true);
                if (!includeTrashedEntries && dlFileVersion.isInTrash()) continue;
                this.dlAppHelperLocalService.deleteFileEntry((FileEntry)new LiferayFileEntry(dlFileEntry));
                this.dlFileEntryLocalService.deleteFileEntry(dlFileEntry);
            }
            ++i2;
        }
    }

    @Indexable(type=IndexableType.DELETE)
    public DLFileEntry deleteFileEntry(DLFileEntry dlFileEntry) throws PortalException, SystemException {
        block3: {
            this.dlFileEntryPersistence.remove((BaseModel)dlFileEntry);
            this.resourceLocalService.deleteResource(dlFileEntry.getCompanyId(), DLFileEntry.class.getName(), 4, dlFileEntry.getFileEntryId());
            this.webDAVPropsLocalService.deleteWebDAVProps(DLFileEntry.class.getName(), dlFileEntry.getFileEntryId());
            this.dlFileEntryMetadataLocalService.deleteFileEntryMetadata(dlFileEntry.getFileEntryId());
            List dlFileVersions = this.dlFileVersionPersistence.findByFileEntryId(dlFileEntry.getFileEntryId());
            for (DLFileVersion dlFileVersion : dlFileVersions) {
                this.dlFileVersionPersistence.remove((BaseModel)dlFileVersion);
                this.expandoValueLocalService.deleteValues(DLFileEntry.class.getName(), dlFileVersion.getFileVersionId());
                this.workflowInstanceLinkLocalService.deleteWorkflowInstanceLinks(dlFileEntry.getCompanyId(), dlFileEntry.getGroupId(), DLFileEntry.class.getName(), dlFileVersion.getFileVersionId());
            }
            this.expandoValueLocalService.deleteValues(DLFileEntry.class.getName(), dlFileEntry.getFileEntryId());
            this.unlockFileEntry(dlFileEntry.getFileEntryId());
            try {
                DLStoreUtil.deleteFile((long)dlFileEntry.getCompanyId(), (long)dlFileEntry.getDataRepositoryId(), (String)dlFileEntry.getName());
            }
            catch (Exception e2) {
                if (!_log.isWarnEnabled()) break block3;
                _log.warn((Object)e2, (Throwable)e2);
            }
        }
        return dlFileEntry;
    }

    @Indexable(type=IndexableType.DELETE)
    public DLFileEntry deleteFileEntry(long fileEntryId) throws PortalException, SystemException {
        DLFileEntry dlFileEntry = this.getFileEntry(fileEntryId);
        return this.deleteFileEntry(dlFileEntry);
    }

    @Indexable(type=IndexableType.DELETE)
    public DLFileEntry deleteFileEntry(long userId, long fileEntryId) throws PortalException, SystemException {
        if (!this.hasFileEntryLock(userId, fileEntryId)) {
            this.lockFileEntry(userId, fileEntryId);
        }
        try {
            DLFileEntry dLFileEntry = this.deleteFileEntry(fileEntryId);
            return dLFileEntry;
        }
        finally {
            this.unlockFileEntry(fileEntryId);
        }
    }

    @Indexable(type=IndexableType.REINDEX)
    public DLFileEntry deleteFileVersion(long userId, long fileEntryId, String version) throws PortalException, SystemException {
        if (Validator.isNull((String)version) || version.equals("PWC")) {
            throw new InvalidFileVersionException();
        }
        if (!this.hasFileEntryLock(userId, fileEntryId)) {
            this.lockFileEntry(userId, fileEntryId);
        }
        boolean latestVersion = false;
        DLFileEntry dlFileEntry = null;
        try {
            DLFileVersion dlFileVersion = this.dlFileVersionPersistence.findByF_V(fileEntryId, version);
            if (!dlFileVersion.isApproved()) {
                throw new InvalidFileVersionException("Cannot delete an unapproved file version");
            }
            int count = this.dlFileVersionPersistence.countByF_S(fileEntryId, 0);
            if (count <= 1) {
                throw new InvalidFileVersionException("Cannot delete the only approved file version");
            }
            this.dlFileVersionPersistence.remove((BaseModel)dlFileVersion);
            this.expandoValueLocalService.deleteValues(DLFileEntry.class.getName(), dlFileVersion.getFileVersionId());
            dlFileEntry = this.dlFileEntryPersistence.findByPrimaryKey(fileEntryId);
            latestVersion = version.equals(dlFileEntry.getVersion());
            if (latestVersion) {
                try {
                    DLFileVersion dlLatestFileVersion = this.dlFileVersionLocalService.getLatestFileVersion(dlFileEntry.getFileEntryId(), true);
                    dlFileEntry.setVersionUserId(dlLatestFileVersion.getUserId());
                    dlFileEntry.setVersionUserName(dlLatestFileVersion.getUserName());
                    dlFileEntry.setModifiedDate(dlLatestFileVersion.getCreateDate());
                    dlFileEntry.setExtension(dlLatestFileVersion.getExtension());
                    dlFileEntry.setMimeType(dlLatestFileVersion.getMimeType());
                    dlFileEntry.setTitle(dlLatestFileVersion.getTitle());
                    dlFileEntry.setDescription(dlLatestFileVersion.getDescription());
                    dlFileEntry.setExtraSettings(dlLatestFileVersion.getExtraSettings());
                    dlFileEntry.setFileEntryTypeId(dlLatestFileVersion.getFileEntryTypeId());
                    dlFileEntry.setVersion(dlLatestFileVersion.getVersion());
                    dlFileEntry.setSize(dlLatestFileVersion.getSize());
                    dlFileEntry = (DLFileEntry)this.dlFileEntryPersistence.update((BaseModel)dlFileEntry);
                }
                catch (NoSuchFileVersionException noSuchFileVersionException) {}
            }
            try {
                DLStoreUtil.deleteFile((long)dlFileEntry.getCompanyId(), (long)dlFileEntry.getDataRepositoryId(), (String)dlFileEntry.getName(), (String)version);
            }
            catch (NoSuchModelException noSuchModelException) {}
        }
        finally {
            this.unlockFileEntry(fileEntryId);
        }
        if (latestVersion) {
            return dlFileEntry;
        }
        return null;
    }

    public DLFileEntry fetchFileEntry(long groupId, long folderId, String title) throws SystemException {
        return this.dlFileEntryPersistence.fetchByG_F_T(groupId, folderId, title);
    }

    public DLFileEntry fetchFileEntryByAnyImageId(long imageId) throws SystemException {
        return this.dlFileEntryFinder.fetchByAnyImageId(imageId);
    }

    public DLFileEntry fetchFileEntryByName(long groupId, long folderId, String name) throws SystemException {
        return this.dlFileEntryPersistence.fetchByG_F_N(groupId, folderId, name);
    }

    public List<DLFileEntry> getDDMStructureFileEntries(long[] ddmStructureIds) throws SystemException {
        return this.dlFileEntryFinder.findByDDMStructureIds(ddmStructureIds, -1, -1);
    }

    public List<DLFileEntry> getExtraSettingsFileEntries(int start, int end) throws SystemException {
        return this.dlFileEntryFinder.findByExtraSettings(start, end);
    }

    public File getFile(long userId, long fileEntryId, String version, boolean incrementCounter) throws PortalException, SystemException {
        return this.getFile(userId, fileEntryId, version, incrementCounter, 1);
    }

    public File getFile(long userId, long fileEntryId, String version, boolean incrementCounter, int increment) throws PortalException, SystemException {
        DLFileEntry dlFileEntry = this.dlFileEntryPersistence.findByPrimaryKey(fileEntryId);
        if (incrementCounter) {
            this.dlFileEntryLocalService.incrementViewCounter(dlFileEntry, increment);
        }
        this.dlAppHelperLocalService.getFileAsStream(userId, (FileEntry)new LiferayFileEntry(dlFileEntry), incrementCounter);
        return DLStoreUtil.getFile((long)dlFileEntry.getCompanyId(), (long)dlFileEntry.getDataRepositoryId(), (String)dlFileEntry.getName(), (String)version);
    }

    public InputStream getFileAsStream(long userId, long fileEntryId, String version) throws PortalException, SystemException {
        return this.getFileAsStream(userId, fileEntryId, version, true, 1);
    }

    public InputStream getFileAsStream(long userId, long fileEntryId, String version, boolean incrementCounter) throws PortalException, SystemException {
        return this.getFileAsStream(userId, fileEntryId, version, incrementCounter, 1);
    }

    public InputStream getFileAsStream(long userId, long fileEntryId, String version, boolean incrementCounter, int increment) throws PortalException, SystemException {
        DLFileEntry dlFileEntry = this.dlFileEntryPersistence.findByPrimaryKey(fileEntryId);
        if (incrementCounter) {
            this.dlFileEntryLocalService.incrementViewCounter(dlFileEntry, increment);
        }
        this.dlAppHelperLocalService.getFileAsStream(userId, (FileEntry)new LiferayFileEntry(dlFileEntry), incrementCounter);
        return DLStoreUtil.getFileAsStream((long)dlFileEntry.getCompanyId(), (long)dlFileEntry.getDataRepositoryId(), (String)dlFileEntry.getName(), (String)version);
    }

    public List<DLFileEntry> getFileEntries(int start, int end) throws SystemException {
        return this.dlFileEntryPersistence.findAll(start, end);
    }

    public List<DLFileEntry> getFileEntries(long groupId, long folderId) throws SystemException {
        return this.dlFileEntryPersistence.findByG_F(groupId, folderId);
    }

    public List<DLFileEntry> getFileEntries(long groupId, long folderId, int status, int start, int end, OrderByComparator obc) throws SystemException {
        ArrayList<Long> folderIds = new ArrayList<Long>();
        folderIds.add(folderId);
        QueryDefinition queryDefinition = new QueryDefinition(status, false, start, end, obc);
        return this.dlFileEntryFinder.findByG_F(groupId, folderIds, queryDefinition);
    }

    public List<DLFileEntry> getFileEntries(long groupId, long folderId, int start, int end, OrderByComparator obc) throws SystemException {
        return this.dlFileEntryPersistence.findByG_F(groupId, folderId, start, end, obc);
    }

    public List<DLFileEntry> getFileEntries(long folderId, String name) throws SystemException {
        return this.dlFileEntryPersistence.findByF_N(folderId, name);
    }

    public int getFileEntriesCount() throws SystemException {
        return this.dlFileEntryPersistence.countAll();
    }

    public int getFileEntriesCount(long groupId, long folderId) throws SystemException {
        return this.dlFileEntryPersistence.countByG_F(groupId, folderId);
    }

    public int getFileEntriesCount(long groupId, long folderId, int status) throws SystemException {
        ArrayList<Long> folderIds = new ArrayList<Long>();
        folderIds.add(folderId);
        return this.dlFileEntryFinder.countByG_F(groupId, folderIds, new QueryDefinition(status));
    }

    public DLFileEntry getFileEntry(long fileEntryId) throws PortalException, SystemException {
        return this.dlFileEntryPersistence.findByPrimaryKey(fileEntryId);
    }

    public DLFileEntry getFileEntry(long groupId, long folderId, String title) throws PortalException, SystemException {
        DLFileEntry dlFileEntry = this.dlFileEntryPersistence.fetchByG_F_T(groupId, folderId, title);
        if (dlFileEntry != null) {
            return dlFileEntry;
        }
        List dlFileVersions = this.dlFileVersionPersistence.findByG_F_T_V(groupId, folderId, title, "PWC");
        long userId = PrincipalThreadLocal.getUserId();
        for (DLFileVersion dlFileVersion : dlFileVersions) {
            if (!this.hasFileEntryLock(userId, dlFileVersion.getFileEntryId())) continue;
            return dlFileVersion.getFileEntry();
        }
        StringBundler sb = new StringBundler(8);
        sb.append("No DLFileEntry exists with the key {");
        sb.append("groupId=");
        sb.append(groupId);
        sb.append(", folderId=");
        sb.append(folderId);
        sb.append(", title=");
        sb.append(title);
        sb.append("}");
        throw new NoSuchFileEntryException(sb.toString());
    }

    public DLFileEntry getFileEntryByName(long groupId, long folderId, String name) throws PortalException, SystemException {
        return this.dlFileEntryPersistence.findByG_F_N(groupId, folderId, name);
    }

    public DLFileEntry getFileEntryByUuidAndGroupId(String uuid, long groupId) throws PortalException, SystemException {
        return this.dlFileEntryPersistence.findByUUID_G(uuid, groupId);
    }

    public List<DLFileEntry> getGroupFileEntries(long groupId, int start, int end) throws SystemException {
        return this.getGroupFileEntries(groupId, start, end, (OrderByComparator)new RepositoryModelModifiedDateComparator());
    }

    public List<DLFileEntry> getGroupFileEntries(long groupId, int start, int end, OrderByComparator obc) throws SystemException {
        return this.dlFileEntryPersistence.findByGroupId(groupId, start, end, obc);
    }

    public List<DLFileEntry> getGroupFileEntries(long groupId, long userId, int start, int end) throws SystemException {
        return this.getGroupFileEntries(groupId, userId, start, end, (OrderByComparator)new RepositoryModelModifiedDateComparator());
    }

    public List<DLFileEntry> getGroupFileEntries(long groupId, long userId, int start, int end, OrderByComparator obc) throws SystemException {
        if (userId <= 0L) {
            return this.dlFileEntryPersistence.findByGroupId(groupId, start, end, obc);
        }
        return this.dlFileEntryPersistence.findByG_U(groupId, userId, start, end, obc);
    }

    public int getGroupFileEntriesCount(long groupId) throws SystemException {
        return this.dlFileEntryPersistence.countByGroupId(groupId);
    }

    public int getGroupFileEntriesCount(long groupId, long userId) throws SystemException {
        if (userId <= 0L) {
            return this.dlFileEntryPersistence.countByGroupId(groupId);
        }
        return this.dlFileEntryPersistence.countByG_U(groupId, userId);
    }

    public List<DLFileEntry> getMisversionedFileEntries() throws SystemException {
        return this.dlFileEntryFinder.findByMisversioned();
    }

    public List<DLFileEntry> getNoAssetFileEntries() throws SystemException {
        return this.dlFileEntryFinder.findByNoAssets();
    }

    public List<DLFileEntry> getOrphanedFileEntries() throws SystemException {
        return this.dlFileEntryFinder.findByOrphanedFileEntries();
    }

    public boolean hasExtraSettings() throws SystemException {
        return this.dlFileEntryFinder.countByExtraSettings() > 0;
    }

    public boolean hasFileEntryLock(long userId, long fileEntryId) throws PortalException, SystemException {
        DLFileEntry dlFileEntry = this.getFileEntry(fileEntryId);
        long folderId = dlFileEntry.getFolderId();
        boolean hasLock = this.lockLocalService.hasLock(userId, DLFileEntry.class.getName(), fileEntryId);
        if (!hasLock && folderId != 0L) {
            hasLock = this.dlFolderService.hasInheritableLock(folderId);
        }
        return hasLock;
    }

    @BufferedIncrement(configuration="DLFileEntry", incrementClass=NumberIncrement.class)
    public void incrementViewCounter(DLFileEntry dlFileEntry, int increment) throws SystemException {
        dlFileEntry.setReadCount(dlFileEntry.getReadCount() + increment);
        this.dlFileEntryPersistence.update((BaseModel)dlFileEntry);
    }

    public boolean isFileEntryCheckedOut(long fileEntryId) throws PortalException, SystemException {
        DLFileVersion dlFileVersion = this.dlFileVersionLocalService.getLatestFileVersion(fileEntryId, false);
        String version = dlFileVersion.getVersion();
        return version.equals("PWC");
    }

    public Lock lockFileEntry(long userId, long fileEntryId) throws PortalException, SystemException {
        if (this.hasFileEntryLock(userId, fileEntryId)) {
            return this.lockLocalService.getLock(DLFileEntry.class.getName(), fileEntryId);
        }
        return this.lockLocalService.lock(userId, DLFileEntry.class.getName(), fileEntryId, null, false, DLFileEntryImpl.LOCK_EXPIRATION_TIME);
    }

    @Indexable(type=IndexableType.REINDEX)
    public DLFileEntry moveFileEntry(long userId, long fileEntryId, long newFolderId, ServiceContext serviceContext) throws PortalException, SystemException {
        if (!this.hasFileEntryLock(userId, fileEntryId)) {
            this.lockFileEntry(userId, fileEntryId);
        }
        try {
            DLFileEntry dlFileEntry = this.moveFileEntryImpl(userId, fileEntryId, newFolderId, serviceContext);
            this.dlAppHelperLocalService.moveFileEntry((FileEntry)new LiferayFileEntry(dlFileEntry));
            DLFileEntry dLFileEntry = this.dlFileEntryTypeLocalService.updateFileEntryFileEntryType(dlFileEntry, serviceContext);
            return dLFileEntry;
        }
        finally {
            if (!this.isFileEntryCheckedOut(fileEntryId)) {
                this.unlockFileEntry(fileEntryId);
            }
        }
    }

    public void revertFileEntry(long userId, long fileEntryId, String version, ServiceContext serviceContext) throws PortalException, SystemException {
        if (Validator.isNull((String)version) || version.equals("PWC")) {
            throw new InvalidFileVersionException();
        }
        DLFileVersion dlFileVersion = this.dlFileVersionLocalService.getFileVersion(fileEntryId, version);
        if (!dlFileVersion.isApproved()) {
            throw new InvalidFileVersionException("Cannot revert from an unapproved file version");
        }
        DLFileVersion latestDLFileVersion = this.dlFileVersionLocalService.getLatestFileVersion(fileEntryId, false);
        if (version.equals(latestDLFileVersion.getVersion())) {
            throw new InvalidFileVersionException("Cannot revert from the latest file version");
        }
        String sourceFileName = dlFileVersion.getTitle();
        String extension = dlFileVersion.getExtension();
        String mimeType = dlFileVersion.getMimeType();
        String title = dlFileVersion.getTitle();
        String description = dlFileVersion.getDescription();
        String changeLog = "Reverted to " + version;
        boolean majorVersion = true;
        String extraSettings = dlFileVersion.getExtraSettings();
        long fileEntryTypeId = dlFileVersion.getFileEntryTypeId();
        Map<String, Fields> fieldsMap = null;
        InputStream is = this.getFileAsStream(userId, fileEntryId, version);
        long size = dlFileVersion.getSize();
        DLFileEntry dlFileEntry = this.updateFileEntry(userId, fileEntryId, sourceFileName, extension, mimeType, title, description, changeLog, majorVersion, extraSettings, fileEntryTypeId, fieldsMap, null, is, size, serviceContext);
        DLFileVersion newDlFileVersion = this.dlFileVersionLocalService.getFileVersion(fileEntryId, dlFileEntry.getVersion());
        this.copyFileEntryMetadata(dlFileVersion.getCompanyId(), dlFileVersion.getFileEntryTypeId(), fileEntryId, newDlFileVersion.getFileVersionId(), dlFileVersion.getFileVersionId(), serviceContext);
    }

    public void unlockFileEntry(long fileEntryId) throws SystemException {
        this.lockLocalService.unlock(DLFileEntry.class.getName(), fileEntryId);
    }

    public DLFileEntry updateFileEntry(long userId, long fileEntryId, String sourceFileName, String mimeType, String title, String description, String changeLog, boolean majorVersion, long fileEntryTypeId, Map<String, Fields> fieldsMap, File file, InputStream is, long size, ServiceContext serviceContext) throws PortalException, SystemException {
        DLFileEntry dlFileEntry = this.dlFileEntryPersistence.findByPrimaryKey(fileEntryId);
        String extension = DLAppUtil.getExtension(title, sourceFileName);
        String extraSettings = "";
        if (fileEntryTypeId == -1L) {
            fileEntryTypeId = dlFileEntry.getFileEntryTypeId();
        }
        this.validateFileEntryTypeId(PortalUtil.getSiteAndCompanyGroupIds((long)dlFileEntry.getGroupId()), dlFileEntry.getFolderId(), fileEntryTypeId);
        return this.updateFileEntry(userId, fileEntryId, sourceFileName, extension, mimeType, title, description, changeLog, majorVersion, extraSettings, fileEntryTypeId, fieldsMap, file, is, size, serviceContext);
    }

    public void updateSmallImage(long smallImageId, long largeImageId) throws PortalException, SystemException {
        try {
            RenderedImage renderedImage = null;
            Image largeImage = this.imageLocalService.getImage(largeImageId);
            byte[] bytes = largeImage.getTextObj();
            String contentType = largeImage.getType();
            if (bytes != null) {
                ImageBag imageBag = ImageToolUtil.read((byte[])bytes);
                renderedImage = imageBag.getRenderedImage();
            }
            if (renderedImage != null) {
                int height = PrefsPropsUtil.getInteger("dl.file.entry.thumbnail.max.height");
                int width = PrefsPropsUtil.getInteger("dl.file.entry.thumbnail.max.width");
                RenderedImage thumbnailRenderedImage = ImageToolUtil.scale((RenderedImage)renderedImage, (int)height, (int)width);
                this.imageLocalService.updateImage(smallImageId, ImageToolUtil.getBytes((RenderedImage)thumbnailRenderedImage, (String)contentType));
            }
        }
        catch (IOException ioe) {
            throw new ImageSizeException((Throwable)ioe);
        }
    }

    public DLFileEntry updateStatus(long userId, long fileVersionId, int status, Map<String, Serializable> workflowContext, ServiceContext serviceContext) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        DLFileVersion dlFileVersion = this.dlFileVersionPersistence.findByPrimaryKey(fileVersionId);
        int oldStatus = dlFileVersion.getStatus();
        int oldDLFileVersionStatus = -1;
        List<Object> dlFileVersionStatusOVPs = new ArrayList();
        List dlFileVersions = (List)((Object)workflowContext.get("dlFileVersions"));
        if (dlFileVersions != null && !dlFileVersions.isEmpty()) {
            DLFileVersion oldDLFileVersion = (DLFileVersion)dlFileVersions.get(0);
            oldDLFileVersionStatus = oldDLFileVersion.getStatus();
            dlFileVersionStatusOVPs = this.getDlFileVersionStatuses(dlFileVersions);
        }
        dlFileVersion.setStatus(status);
        dlFileVersion.setStatusByUserId(user.getUserId());
        dlFileVersion.setStatusByUserName(user.getFullName());
        dlFileVersion.setStatusDate(new Date());
        this.dlFileVersionPersistence.update((BaseModel)dlFileVersion);
        DLFileEntry dlFileEntry = this.dlFileEntryPersistence.findByPrimaryKey(dlFileVersion.getFileEntryId());
        if (status == 0) {
            if (DLUtil.compareVersions((String)dlFileEntry.getVersion(), (String)dlFileVersion.getVersion()) <= 0) {
                dlFileEntry.setExtension(dlFileVersion.getExtension());
                dlFileEntry.setMimeType(dlFileVersion.getMimeType());
                dlFileEntry.setTitle(dlFileVersion.getTitle());
                dlFileEntry.setDescription(dlFileVersion.getDescription());
                dlFileEntry.setExtraSettings(dlFileVersion.getExtraSettings());
                dlFileEntry.setFileEntryTypeId(dlFileVersion.getFileEntryTypeId());
                dlFileEntry.setVersion(dlFileVersion.getVersion());
                dlFileEntry.setVersionUserId(dlFileVersion.getUserId());
                dlFileEntry.setVersionUserName(dlFileVersion.getUserName());
                dlFileEntry.setModifiedDate(dlFileVersion.getCreateDate());
                dlFileEntry.setSize(dlFileVersion.getSize());
                this.dlFileEntryPersistence.update((BaseModel)dlFileEntry);
            }
        } else {
            if (status != 8 && dlFileEntry.getVersion().equals(dlFileVersion.getVersion())) {
                String newVersion = "1.0";
                List approvedFileVersions = this.dlFileVersionPersistence.findByF_S(dlFileEntry.getFileEntryId(), 0);
                if (!approvedFileVersions.isEmpty()) {
                    newVersion = ((DLFileVersion)approvedFileVersions.get(0)).getVersion();
                }
                dlFileEntry.setVersion(newVersion);
                this.dlFileEntryPersistence.update((BaseModel)dlFileEntry);
            }
            if (dlFileVersion.getVersion().equals("1.0")) {
                Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(DLFileEntry.class);
                indexer.delete((Object)dlFileEntry);
            }
        }
        if (oldStatus == 8) {
            List trashVersions = (List)((Object)workflowContext.get("trashVersions"));
            for (TrashVersion trashVersion : trashVersions) {
                DLFileVersion trashDLFileVersion = this.dlFileVersionPersistence.findByPrimaryKey(trashVersion.getClassPK());
                trashDLFileVersion.setStatus(trashVersion.getStatus());
                this.dlFileVersionPersistence.update((BaseModel)trashDLFileVersion);
            }
            this.trashEntryLocalService.deleteEntry(DLFileEntryConstants.getClassName(), dlFileEntry.getFileEntryId());
            Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(DLFileEntry.class);
            indexer.delete((Object)dlFileEntry);
        } else if (status == 8) {
            for (DLFileVersion curDLFileVersion : dlFileVersions) {
                curDLFileVersion.setStatus(8);
                this.dlFileVersionPersistence.update((BaseModel)curDLFileVersion);
            }
            UnicodeProperties typeSettingsProperties = new UnicodeProperties();
            typeSettingsProperties.put("title", dlFileEntry.getTitle());
            this.trashEntryLocalService.addTrashEntry(userId, dlFileEntry.getGroupId(), DLFileEntryConstants.getClassName(), dlFileEntry.getFileEntryId(), oldDLFileVersionStatus, dlFileVersionStatusOVPs, typeSettingsProperties);
        }
        this.dlAppHelperLocalService.updateStatus(userId, (FileEntry)new LiferayFileEntry(dlFileEntry), (FileVersion)new LiferayFileVersion(dlFileVersion), oldStatus, status, workflowContext, serviceContext);
        if (!(status != 0 && status != 8 && oldStatus != 8 || serviceContext != null && !serviceContext.isIndexingEnabled())) {
            this.reindex(dlFileEntry);
        }
        return dlFileEntry;
    }

    public boolean verifyFileEntryCheckOut(long fileEntryId, String lockUuid) throws PortalException, SystemException {
        return this.verifyFileEntryLock(fileEntryId, lockUuid) && this.isFileEntryCheckedOut(fileEntryId);
    }

    public boolean verifyFileEntryLock(long fileEntryId, String lockUuid) throws PortalException, SystemException {
        boolean lockVerified = false;
        try {
            Lock lock = this.lockLocalService.getLock(DLFileEntry.class.getName(), fileEntryId);
            if (lock.getUuid().equals(lockUuid)) {
                lockVerified = true;
            }
        }
        catch (PortalException pe) {
            if (pe instanceof ExpiredLockException || pe instanceof NoSuchLockException) {
                DLFileEntry dlFileEntry = this.dlFileEntryLocalService.getFileEntry(fileEntryId);
                lockVerified = this.dlFolderService.verifyInheritableLock(dlFileEntry.getFolderId(), lockUuid);
            }
            throw pe;
        }
        return lockVerified;
    }

    protected DLFileVersion addFileVersion(User user, DLFileEntry dlFileEntry, Date modifiedDate, String extension, String mimeType, String title, String description, String changeLog, String extraSettings, long fileEntryTypeId, Map<String, Fields> fieldsMap, String version, long size, int status, ServiceContext serviceContext) throws PortalException, SystemException {
        long fileVersionId = this.counterLocalService.increment();
        DLFileVersion dlFileVersion = this.dlFileVersionPersistence.create(fileVersionId);
        String uuid = ParamUtil.getString((ServiceContext)serviceContext, (String)"fileVersionUuid", (String)serviceContext.getUuid());
        dlFileVersion.setUuid(uuid);
        dlFileVersion.setGroupId(dlFileEntry.getGroupId());
        dlFileVersion.setCompanyId(dlFileEntry.getCompanyId());
        long versionUserId = dlFileEntry.getVersionUserId();
        if (versionUserId <= 0L) {
            versionUserId = dlFileEntry.getUserId();
        }
        dlFileVersion.setUserId(versionUserId);
        String versionUserName = GetterUtil.getString((String)dlFileEntry.getVersionUserName(), (String)dlFileEntry.getUserName());
        dlFileVersion.setUserName(versionUserName);
        dlFileVersion.setCreateDate(modifiedDate);
        dlFileVersion.setModifiedDate(modifiedDate);
        dlFileVersion.setRepositoryId(dlFileEntry.getRepositoryId());
        dlFileVersion.setFolderId(dlFileEntry.getFolderId());
        dlFileVersion.setFileEntryId(dlFileEntry.getFileEntryId());
        dlFileVersion.setExtension(extension);
        dlFileVersion.setMimeType(mimeType);
        dlFileVersion.setTitle(title);
        dlFileVersion.setDescription(description);
        dlFileVersion.setChangeLog(changeLog);
        dlFileVersion.setExtraSettings(extraSettings);
        dlFileVersion.setFileEntryTypeId(fileEntryTypeId);
        dlFileVersion.setVersion(version);
        dlFileVersion.setSize(size);
        dlFileVersion.setStatus(status);
        dlFileVersion.setStatusByUserId(user.getUserId());
        dlFileVersion.setStatusByUserName(user.getFullName());
        dlFileVersion.setStatusDate(dlFileEntry.getModifiedDate());
        dlFileVersion.setExpandoBridgeAttributes(serviceContext);
        this.dlFileVersionPersistence.update((BaseModel)dlFileVersion);
        if (fileEntryTypeId > 0L && fieldsMap != null) {
            this.dlFileEntryMetadataLocalService.updateFileEntryMetadata(fileEntryTypeId, dlFileEntry.getFileEntryId(), fileVersionId, fieldsMap, serviceContext);
        }
        return dlFileVersion;
    }

    protected void convertExtraSettings(DLFileEntry dlFileEntry, DLFileVersion dlFileVersion, String[] keys) throws PortalException, SystemException {
        UnicodeProperties extraSettingsProperties = dlFileVersion.getExtraSettingsProperties();
        ExpandoBridge expandoBridge = dlFileVersion.getExpandoBridge();
        this.convertExtraSettings(extraSettingsProperties, expandoBridge, keys);
        dlFileVersion.setExtraSettingsProperties(extraSettingsProperties);
        this.dlFileVersionPersistence.update((BaseModel)dlFileVersion);
        int status = dlFileVersion.getStatus();
        if (status == 0 && DLUtil.compareVersions((String)dlFileEntry.getVersion(), (String)dlFileVersion.getVersion()) <= 0) {
            this.reindex(dlFileEntry);
        }
    }

    protected void convertExtraSettings(DLFileEntry dlFileEntry, String[] keys) throws PortalException, SystemException {
        UnicodeProperties extraSettingsProperties = dlFileEntry.getExtraSettingsProperties();
        ExpandoBridge expandoBridge = dlFileEntry.getExpandoBridge();
        this.convertExtraSettings(extraSettingsProperties, expandoBridge, keys);
        dlFileEntry.setExtraSettingsProperties(extraSettingsProperties);
        this.dlFileEntryPersistence.update((BaseModel)dlFileEntry);
        List dlFileVersions = this.dlFileVersionLocalService.getFileVersions(dlFileEntry.getFileEntryId(), -1);
        for (DLFileVersion dlFileVersion : dlFileVersions) {
            this.convertExtraSettings(dlFileEntry, dlFileVersion, keys);
        }
    }

    protected void convertExtraSettings(UnicodeProperties extraSettingsProperties, ExpandoBridge expandoBridge, String[] keys) {
        String[] stringArray = keys;
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            String value = extraSettingsProperties.remove((Object)key);
            if (!Validator.isNull((String)value)) {
                int type = expandoBridge.getAttributeType(key);
                Serializable serializable = ExpandoColumnConstants.getSerializable((int)type, (String)value);
                expandoBridge.setAttribute(key, serializable);
            }
            ++n2;
        }
    }

    protected void copyExpandoRowModifiedDate(long companyId, long sourceFileVersionId, long destinationFileVersionId) throws PortalException, SystemException {
        ExpandoTable expandoTable = null;
        try {
            expandoTable = this.expandoTableLocalService.getDefaultTable(companyId, DLFileEntry.class.getName());
        }
        catch (NoSuchTableException noSuchTableException) {
            return;
        }
        Date sourceModifiedDate = null;
        try {
            ExpandoRow sourceExpandoRow = this.expandoRowLocalService.getRow(expandoTable.getTableId(), sourceFileVersionId);
            sourceModifiedDate = sourceExpandoRow.getModifiedDate();
        }
        catch (NoSuchRowException noSuchRowException) {
            return;
        }
        try {
            ExpandoRow destinationExpandoRow = this.expandoRowLocalService.getRow(expandoTable.getTableId(), destinationFileVersionId);
            destinationExpandoRow.setModifiedDate(sourceModifiedDate);
            this.expandoRowLocalService.updateExpandoRow(destinationExpandoRow);
        }
        catch (NoSuchRowException noSuchRowException) {}
    }

    protected void copyFileEntryMetadata(long companyId, long fileEntryTypeId, long fileEntryId, long fromFileVersionId, long toFileVersionId, ServiceContext serviceContext, Map<String, Fields> fieldsMap, List<DDMStructure> ddmStructures) throws PortalException, SystemException {
        for (DDMStructure ddmStructure : ddmStructures) {
            DLFileEntryMetadata dlFileEntryMetadata = this.dlFileEntryMetadataLocalService.fetchFileEntryMetadata(ddmStructure.getStructureId(), fromFileVersionId);
            if (dlFileEntryMetadata == null) continue;
            Fields fields = StorageEngineUtil.getFields((long)dlFileEntryMetadata.getDDMStorageId());
            fieldsMap.put(ddmStructure.getStructureKey(), fields);
        }
        if (!fieldsMap.isEmpty()) {
            this.dlFileEntryMetadataLocalService.updateFileEntryMetadata(companyId, ddmStructures, fileEntryTypeId, fileEntryId, toFileVersionId, fieldsMap, serviceContext);
        }
    }

    protected List<ObjectValuePair<Long, Integer>> getDlFileVersionStatuses(List<DLFileVersion> dlFileVersions) {
        ArrayList<ObjectValuePair<Long, Integer>> dlFileVersionStatusOVPs = new ArrayList<ObjectValuePair<Long, Integer>>(dlFileVersions.size());
        for (DLFileVersion dlFileVersion : dlFileVersions) {
            int status = dlFileVersion.getStatus();
            if (status == 1) {
                status = 2;
            }
            ObjectValuePair dlFileVersionStatusOVP = new ObjectValuePair((Object)dlFileVersion.getFileVersionId(), (Object)status);
            dlFileVersionStatusOVPs.add((ObjectValuePair<Long, Integer>)dlFileVersionStatusOVP);
        }
        return dlFileVersionStatusOVPs;
    }

    protected String getNextVersion(DLFileEntry dlFileEntry, boolean majorVersion, int workflowAction) throws PortalException, SystemException {
        String version = dlFileEntry.getVersion();
        try {
            DLFileVersion dlFileVersion = this.dlFileVersionLocalService.getLatestFileVersion(dlFileEntry.getFileEntryId(), true);
            version = dlFileVersion.getVersion();
        }
        catch (NoSuchFileVersionException noSuchFileVersionException) {}
        if (workflowAction == 2) {
            majorVersion = false;
        }
        int[] versionParts = StringUtil.split((String)version, (String)".", (int)0);
        if (majorVersion) {
            versionParts[0] = versionParts[0] + 1;
            versionParts[1] = 0;
        } else {
            versionParts[1] = versionParts[1] + 1;
        }
        return String.valueOf(versionParts[0]) + "." + versionParts[1];
    }

    protected boolean isKeepFileVersionLabel(DLFileEntry dlFileEntry, DLFileVersion lastDLFileVersion, DLFileVersion latestDLFileVersion, int workflowAction) throws PortalException, SystemException {
        if (workflowAction == 2) {
            return false;
        }
        if (PropsValues.DL_FILE_ENTRY_VERSION_POLICY != 1) {
            return false;
        }
        if (lastDLFileVersion.getFolderId() == latestDLFileVersion.getFolderId() && Validator.equals((Object)lastDLFileVersion.getTitle(), (Object)latestDLFileVersion.getTitle()) && Validator.equals((Object)lastDLFileVersion.getDescription(), (Object)latestDLFileVersion.getDescription()) && lastDLFileVersion.getFileEntryTypeId() == latestDLFileVersion.getFileEntryTypeId()) {
            String latestChecksum;
            InputStream latestInputStream;
            InputStream lastInputStream;
            block25: {
                AssetEntry lastAssetEntry = this.assetEntryLocalService.getEntry(DLFileEntryConstants.getClassName(), dlFileEntry.getFileEntryId());
                AssetEntry latestAssetEntry = this.assetEntryLocalService.getEntry(DLFileEntryConstants.getClassName(), latestDLFileVersion.getFileVersionId());
                if (!Validator.equalsSorted((long[])lastAssetEntry.getCategoryIds(), (long[])latestAssetEntry.getCategoryIds())) {
                    return false;
                }
                if (!Validator.equalsSorted((Object[])lastAssetEntry.getTagNames(), (Object[])latestAssetEntry.getTagNames())) {
                    return false;
                }
                List lastAssetLinks = this.assetLinkLocalService.getDirectLinks(lastAssetEntry.getEntryId(), 0);
                List latestAssetLinks = this.assetLinkLocalService.getDirectLinks(latestAssetEntry.getEntryId(), 0);
                if (!Validator.equalsSorted((long[])StringUtil.split((String)ListUtil.toString((List)lastAssetLinks, (Accessor)AssetLink.ENTRY_ID2_ACCESSOR), (long)0L), (long[])StringUtil.split((String)ListUtil.toString((List)latestAssetLinks, (Accessor)AssetLink.ENTRY_ID2_ACCESSOR), (long)0L))) {
                    return false;
                }
                ExpandoTable expandoTable = null;
                try {
                    expandoTable = this.expandoTableLocalService.getDefaultTable(lastDLFileVersion.getCompanyId(), DLFileEntry.class.getName());
                }
                catch (NoSuchTableException noSuchTableException) {}
                if (expandoTable != null) {
                    Date lastModifiedDate = null;
                    try {
                        ExpandoRow lastExpandoRow = this.expandoRowLocalService.getRow(expandoTable.getTableId(), lastDLFileVersion.getPrimaryKey());
                        lastModifiedDate = lastExpandoRow.getModifiedDate();
                    }
                    catch (NoSuchRowException noSuchRowException) {}
                    Date latestModifiedDate = null;
                    try {
                        ExpandoRow latestExpandoRow = this.expandoRowLocalService.getRow(expandoTable.getTableId(), latestDLFileVersion.getPrimaryKey());
                        latestModifiedDate = latestExpandoRow.getModifiedDate();
                    }
                    catch (NoSuchRowException noSuchRowException) {}
                    if (!Validator.equals(lastModifiedDate, latestModifiedDate)) {
                        return false;
                    }
                }
                List lastFileEntryMetadatas = this.dlFileEntryMetadataLocalService.getFileVersionFileEntryMetadatas(lastDLFileVersion.getFileVersionId());
                List latestFileEntryMetadatas = this.dlFileEntryMetadataLocalService.getFileVersionFileEntryMetadatas(latestDLFileVersion.getFileVersionId());
                for (DLFileEntryMetadata lastFileEntryMetadata : lastFileEntryMetadatas) {
                    Fields lastFields = StorageEngineUtil.getFields((long)lastFileEntryMetadata.getDDMStorageId());
                    boolean found = false;
                    for (DLFileEntryMetadata latestEntryMetadata : latestFileEntryMetadatas) {
                        Fields latestFields = StorageEngineUtil.getFields((long)latestEntryMetadata.getDDMStorageId());
                        if (!lastFields.equals((Object)latestFields)) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    return false;
                }
                long lastSize = lastDLFileVersion.getSize();
                long latestSize = latestDLFileVersion.getSize();
                if (lastSize == 0L && (latestSize == 0L || latestSize > 0L)) {
                    return true;
                }
                if (lastSize != latestSize) {
                    return false;
                }
                lastInputStream = null;
                latestInputStream = null;
                String lastChecksum = lastDLFileVersion.getChecksum();
                if (Validator.isNull((String)lastChecksum)) {
                    lastInputStream = DLStoreUtil.getFileAsStream((long)dlFileEntry.getCompanyId(), (long)dlFileEntry.getDataRepositoryId(), (String)dlFileEntry.getName(), (String)lastDLFileVersion.getVersion());
                    lastChecksum = DigesterUtil.digestBase64((InputStream)lastInputStream);
                    lastDLFileVersion.setChecksum(lastChecksum);
                    this.dlFileVersionPersistence.update((BaseModel)lastDLFileVersion);
                }
                if (!lastChecksum.equals(latestChecksum = DigesterUtil.digestBase64((InputStream)(latestInputStream = DLStoreUtil.getFileAsStream((long)dlFileEntry.getCompanyId(), (long)dlFileEntry.getDataRepositoryId(), (String)dlFileEntry.getName(), (String)latestDLFileVersion.getVersion()))))) break block25;
                StreamUtil.cleanUp((InputStream)lastInputStream);
                StreamUtil.cleanUp((InputStream)latestInputStream);
                return true;
            }
            try {
                try {
                    latestDLFileVersion.setChecksum(latestChecksum);
                    this.dlFileVersionPersistence.update((BaseModel)latestDLFileVersion);
                }
                catch (Exception e2) {
                    if (_log.isWarnEnabled()) {
                        _log.warn((Object)e2, (Throwable)e2);
                    }
                    StreamUtil.cleanUp(lastInputStream);
                    StreamUtil.cleanUp(latestInputStream);
                }
            }
            catch (Throwable throwable) {
                StreamUtil.cleanUp(lastInputStream);
                StreamUtil.cleanUp(latestInputStream);
                throw throwable;
            }
            StreamUtil.cleanUp((InputStream)lastInputStream);
            StreamUtil.cleanUp((InputStream)latestInputStream);
        }
        return false;
    }

    protected DLFileEntry moveFileEntryImpl(long userId, long fileEntryId, long newFolderId, ServiceContext serviceContext) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        DLFileEntry dlFileEntry = this.dlFileEntryPersistence.findByPrimaryKey(fileEntryId);
        long oldDataRepositoryId = dlFileEntry.getDataRepositoryId();
        this.validateFile(dlFileEntry.getGroupId(), newFolderId, dlFileEntry.getFileEntryId(), dlFileEntry.getTitle(), dlFileEntry.getExtension());
        if (DLStoreUtil.hasFile((long)user.getCompanyId(), (long)DLFolderConstants.getDataRepositoryId((long)dlFileEntry.getGroupId(), (long)newFolderId), (String)dlFileEntry.getName(), (String)"")) {
            throw new DuplicateFileException(dlFileEntry.getName());
        }
        dlFileEntry.setModifiedDate(serviceContext.getModifiedDate(null));
        dlFileEntry.setFolderId(newFolderId);
        this.dlFileEntryPersistence.update((BaseModel)dlFileEntry);
        List dlFileVersions = this.dlFileVersionPersistence.findByFileEntryId(fileEntryId);
        for (DLFileVersion dlFileVersion : dlFileVersions) {
            dlFileVersion.setFolderId(newFolderId);
            this.dlFileVersionPersistence.update((BaseModel)dlFileVersion);
        }
        if (newFolderId != 0L) {
            DLFolder dlFolder = this.dlFolderPersistence.findByPrimaryKey(newFolderId);
            dlFolder.setModifiedDate(serviceContext.getModifiedDate(null));
            this.dlFolderPersistence.update((BaseModel)dlFolder);
        }
        DLStoreUtil.updateFile((long)user.getCompanyId(), (long)oldDataRepositoryId, (long)dlFileEntry.getDataRepositoryId(), (String)dlFileEntry.getName());
        return dlFileEntry;
    }

    protected void reindex(DLFileEntry dlFileEntry) throws SearchException {
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(DLFileEntry.class);
        indexer.reindex((Object)dlFileEntry);
    }

    protected void removeFileVersion(DLFileEntry dlFileEntry, DLFileVersion dlFileVersion) throws PortalException, SystemException {
        this.dlFileVersionPersistence.remove((BaseModel)dlFileVersion);
        this.expandoValueLocalService.deleteValues(DLFileEntry.class.getName(), dlFileVersion.getFileVersionId());
        this.dlFileEntryMetadataLocalService.deleteFileVersionFileEntryMetadata(dlFileVersion.getFileVersionId());
        try {
            DLStoreUtil.deleteFile((long)dlFileEntry.getCompanyId(), (long)dlFileEntry.getDataRepositoryId(), (String)dlFileEntry.getName(), (String)"PWC");
        }
        catch (NoSuchModelException noSuchModelException) {}
        this.unlockFileEntry(dlFileEntry.getFileEntryId());
    }

    protected void startWorkflowInstance(long userId, ServiceContext serviceContext, DLFileVersion dlFileVersion, String syncEventType) throws PortalException, SystemException {
        HashMap<String, String> workflowContext = new HashMap<String, String>();
        workflowContext.put("event", syncEventType);
        WorkflowHandlerRegistryUtil.startWorkflowInstance((long)dlFileVersion.getCompanyId(), (long)dlFileVersion.getGroupId(), (long)userId, (String)DLFileEntry.class.getName(), (long)dlFileVersion.getFileVersionId(), (Object)dlFileVersion, (ServiceContext)serviceContext, workflowContext);
    }

    protected DLFileEntry updateFileEntry(long userId, long fileEntryId, String sourceFileName, String extension, String mimeType, String title, String description, String changeLog, boolean majorVersion, String extraSettings, long fileEntryTypeId, Map<String, Fields> fieldsMap, File file, InputStream is, long size, ServiceContext serviceContext) throws PortalException, SystemException {
        boolean autoCheckIn;
        User user = this.userPersistence.findByPrimaryKey(userId);
        DLFileEntry dlFileEntry = this.dlFileEntryPersistence.findByPrimaryKey(fileEntryId);
        boolean checkedOut = dlFileEntry.isCheckedOut();
        DLFileVersion dlFileVersion = this.dlFileVersionLocalService.getLatestFileVersion(fileEntryId, !checkedOut);
        boolean bl = autoCheckIn = !checkedOut && dlFileVersion.isApproved();
        if (autoCheckIn) {
            dlFileEntry = this.checkOutFileEntry(userId, fileEntryId, serviceContext);
        } else if (!checkedOut) {
            this.lockFileEntry(userId, fileEntryId);
        }
        if (!this.hasFileEntryLock(userId, fileEntryId)) {
            this.lockFileEntry(userId, fileEntryId);
        }
        if (checkedOut || autoCheckIn) {
            dlFileVersion = this.dlFileVersionLocalService.getLatestFileVersion(fileEntryId, false);
        }
        try {
            try {
                if (Validator.isNull((String)extension)) {
                    extension = dlFileEntry.getExtension();
                }
                if (Validator.isNull((String)mimeType)) {
                    mimeType = dlFileEntry.getMimeType();
                }
                if (Validator.isNull((String)title) && Validator.isNull((String)(title = sourceFileName))) {
                    title = dlFileEntry.getTitle();
                }
                Date now = new Date();
                this.validateFile(dlFileEntry.getGroupId(), dlFileEntry.getFolderId(), dlFileEntry.getFileEntryId(), title, extension, sourceFileName, file, is);
                String version = dlFileVersion.getVersion();
                if (size == 0L) {
                    size = dlFileVersion.getSize();
                }
                this.updateFileVersion(user, dlFileVersion, sourceFileName, extension, mimeType, title, description, changeLog, extraSettings, fileEntryTypeId, fieldsMap, version, size, dlFileVersion.getStatus(), serviceContext.getModifiedDate(now), serviceContext);
                if (dlFileEntry.getFolderId() != 0L) {
                    DLFolder dlFolder = this.dlFolderPersistence.findByPrimaryKey(dlFileEntry.getFolderId());
                    dlFolder.setLastPostDate(serviceContext.getModifiedDate(now));
                    this.dlFolderPersistence.update((BaseModel)dlFolder);
                }
                this.dlAppHelperLocalService.updateAsset(userId, (FileEntry)new LiferayFileEntry(dlFileEntry), (FileVersion)new LiferayFileVersion(dlFileVersion), serviceContext.getAssetCategoryIds(), serviceContext.getAssetTagNames(), serviceContext.getAssetLinkEntryIds());
                if (file != null || is != null) {
                    try {
                        DLStoreUtil.deleteFile((long)user.getCompanyId(), (long)dlFileEntry.getDataRepositoryId(), (String)dlFileEntry.getName(), (String)version);
                    }
                    catch (NoSuchModelException noSuchModelException) {}
                    if (file != null) {
                        DLStoreUtil.updateFile((long)user.getCompanyId(), (long)dlFileEntry.getDataRepositoryId(), (String)dlFileEntry.getName(), (String)dlFileEntry.getExtension(), (boolean)false, (String)version, (String)sourceFileName, (File)file);
                    } else {
                        DLStoreUtil.updateFile((long)user.getCompanyId(), (long)dlFileEntry.getDataRepositoryId(), (String)dlFileEntry.getName(), (String)dlFileEntry.getExtension(), (boolean)false, (String)version, (String)sourceFileName, (InputStream)is);
                    }
                }
                if (autoCheckIn) {
                    this.dlFileEntryService.checkInFileEntry(fileEntryId, majorVersion, changeLog, serviceContext);
                } else if (!checkedOut && serviceContext.getWorkflowAction() == 1) {
                    String syncEvent = "update";
                    if (dlFileVersion.getVersion().equals("1.0")) {
                        syncEvent = "add";
                    }
                    this.startWorkflowInstance(userId, serviceContext, dlFileVersion, syncEvent);
                }
            }
            catch (PortalException pe) {
                if (autoCheckIn) {
                    this.dlFileEntryService.cancelCheckOut(fileEntryId);
                }
                throw pe;
            }
            catch (SystemException se) {
                if (autoCheckIn) {
                    this.dlFileEntryService.cancelCheckOut(fileEntryId);
                }
                throw se;
            }
        }
        finally {
            if (!autoCheckIn && !checkedOut) {
                this.unlockFileEntry(fileEntryId);
            }
        }
        return this.dlFileEntryPersistence.findByPrimaryKey(fileEntryId);
    }

    protected DLFileVersion updateFileVersion(User user, DLFileVersion dlFileVersion, String sourceFileName, String extension, String mimeType, String title, String description, String changeLog, String extraSettings, long fileEntryTypeId, Map<String, Fields> fieldsMap, String version, long size, int status, Date statusDate, ServiceContext serviceContext) throws PortalException, SystemException {
        dlFileVersion.setModifiedDate(statusDate);
        if (Validator.isNotNull((String)sourceFileName)) {
            dlFileVersion.setExtension(extension);
            dlFileVersion.setMimeType(mimeType);
        }
        dlFileVersion.setTitle(title);
        dlFileVersion.setDescription(description);
        dlFileVersion.setChangeLog(changeLog);
        dlFileVersion.setExtraSettings(extraSettings);
        dlFileVersion.setFileEntryTypeId(fileEntryTypeId);
        dlFileVersion.setVersion(version);
        dlFileVersion.setSize(size);
        dlFileVersion.setStatus(status);
        dlFileVersion.setStatusByUserId(user.getUserId());
        dlFileVersion.setStatusByUserName(user.getFullName());
        dlFileVersion.setStatusDate(statusDate);
        dlFileVersion.setExpandoBridgeAttributes(serviceContext);
        dlFileVersion = (DLFileVersion)this.dlFileVersionPersistence.update((BaseModel)dlFileVersion);
        if (fileEntryTypeId > 0L && fieldsMap != null) {
            this.dlFileEntryMetadataLocalService.updateFileEntryMetadata(fileEntryTypeId, dlFileVersion.getFileEntryId(), dlFileVersion.getFileVersionId(), fieldsMap, serviceContext);
        }
        return dlFileVersion;
    }

    protected void validateFile(long groupId, long folderId, long fileEntryId, String title, String extension) throws PortalException, SystemException {
        DLFolder dlFolder = this.dlFolderPersistence.fetchByG_P_N(groupId, folderId, title);
        if (dlFolder != null) {
            throw new DuplicateFolderNameException(title);
        }
        DLFileEntry dlFileEntry = this.dlFileEntryPersistence.fetchByG_F_T(groupId, folderId, title);
        if (dlFileEntry != null && dlFileEntry.getFileEntryId() != fileEntryId) {
            throw new DuplicateFileException(title);
        }
        String periodAndExtension = "." + extension;
        if (!title.endsWith(periodAndExtension) && (dlFileEntry = this.dlFileEntryPersistence.fetchByG_F_T(groupId, folderId, title = String.valueOf(title) + periodAndExtension)) != null && dlFileEntry.getFileEntryId() != fileEntryId) {
            throw new DuplicateFileException(title);
        }
    }

    protected void validateFile(long groupId, long folderId, long fileEntryId, String title, String extension, String sourceFileName, File file, InputStream is) throws PortalException, SystemException {
        if (Validator.isNotNull((String)sourceFileName)) {
            if (file != null) {
                DLStoreUtil.validate((String)sourceFileName, (String)extension, (String)sourceFileName, (boolean)true, (File)file);
            } else {
                DLStoreUtil.validate((String)sourceFileName, (String)extension, (String)sourceFileName, (boolean)true, (InputStream)is);
            }
        }
        this.validateFileExtension(extension);
        this.validateFileName(title);
        DLStoreUtil.validate((String)title, (boolean)false);
        this.validateFile(groupId, folderId, fileEntryId, title, extension);
    }

    protected void validateFileEntryTypeId(long[] groupIds, long folderId, long fileEntryTypeId) throws PortalException, SystemException {
        List dlFileEntryTypes = this.dlFileEntryTypeLocalService.getFolderFileEntryTypes(groupIds, folderId, true);
        for (DLFileEntryType dlFileEntryType : dlFileEntryTypes) {
            if (dlFileEntryType.getFileEntryTypeId() != fileEntryTypeId) continue;
            return;
        }
        throw new InvalidFileEntryTypeException("Invalid file entry type " + fileEntryTypeId + " for folder " + folderId);
    }

    protected void validateFileExtension(String extension) throws PortalException {
        if (Validator.isNotNull((String)extension)) {
            int maxLength = ModelHintsUtil.getMaxLength((String)DLFileEntry.class.getName(), (String)"extension");
            if (extension.length() > maxLength) {
                throw new FileExtensionException();
            }
        }
    }

    protected void validateFileName(String fileName) throws PortalException {
        if (fileName.contains("/")) {
            throw new FileNameException(fileName);
        }
    }
}

