/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.model.impl;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.model.Repository;
import com.liferay.portal.repository.liferayrepository.model.LiferayFolder;
import com.liferay.portal.service.RepositoryLocalServiceUtil;
import com.liferay.portlet.documentlibrary.NoSuchFolderException;
import com.liferay.portlet.documentlibrary.model.DLFolder;
import com.liferay.portlet.documentlibrary.model.impl.DLFileShortcutBaseImpl;
import com.liferay.portlet.documentlibrary.model.impl.DLFolderImpl;
import com.liferay.portlet.documentlibrary.service.DLAppLocalServiceUtil;
import com.liferay.portlet.documentlibrary.service.DLFolderLocalServiceUtil;

public class DLFileShortcutImpl
extends DLFileShortcutBaseImpl {
    private static Log _log = LogFactoryUtil.getLog(DLFileShortcutImpl.class);

    public Folder getFolder() {
        LiferayFolder folder = new LiferayFolder(new DLFolderImpl());
        if (this.getFolderId() > 0L) {
            try {
                folder = DLAppLocalServiceUtil.getFolder((long)this.getFolderId());
            }
            catch (NoSuchFolderException nsfe) {
                try {
                    if (!this.isInTrash()) {
                        _log.error((Object)nsfe, (Throwable)nsfe);
                    }
                }
                catch (Exception e2) {
                    _log.error((Object)e2, (Throwable)e2);
                }
            }
            catch (Exception e3) {
                _log.error((Object)e3, (Throwable)e3);
            }
        }
        return folder;
    }

    public String getToTitle() {
        String toTitle = null;
        try {
            FileEntry fileEntry = DLAppLocalServiceUtil.getFileEntry((long)this.getToFileEntryId());
            toTitle = fileEntry.getTitle();
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
        }
        return toTitle;
    }

    public DLFolder getTrashContainer() {
        Folder folder = this.getFolder();
        DLFolder dlFolder = (DLFolder)folder.getModel();
        if (dlFolder.isInTrash()) {
            return dlFolder;
        }
        return dlFolder.getTrashContainer();
    }

    public boolean isInHiddenFolder() {
        try {
            long repositoryId = this.getRepositoryId();
            Repository repository = RepositoryLocalServiceUtil.getRepository((long)repositoryId);
            long dlFolderId = repository.getDlFolderId();
            DLFolder dlFolder = DLFolderLocalServiceUtil.getFolder((long)dlFolderId);
            return dlFolder.isHidden();
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean isInTrashContainer() {
        return this.getTrashContainer() != null;
    }
}

