/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.model.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.model.Lock;
import com.liferay.portal.model.Repository;
import com.liferay.portal.service.LockLocalServiceUtil;
import com.liferay.portal.service.RepositoryLocalServiceUtil;
import com.liferay.portlet.documentlibrary.NoSuchFolderException;
import com.liferay.portlet.documentlibrary.model.DLFileEntry;
import com.liferay.portlet.documentlibrary.model.DLFileEntryMetadata;
import com.liferay.portlet.documentlibrary.model.DLFileEntryType;
import com.liferay.portlet.documentlibrary.model.DLFileVersion;
import com.liferay.portlet.documentlibrary.model.DLFolder;
import com.liferay.portlet.documentlibrary.model.DLFolderConstants;
import com.liferay.portlet.documentlibrary.model.impl.DLFileEntryBaseImpl;
import com.liferay.portlet.documentlibrary.model.impl.DLFolderImpl;
import com.liferay.portlet.documentlibrary.service.DLFileEntryMetadataLocalServiceUtil;
import com.liferay.portlet.documentlibrary.service.DLFileEntryServiceUtil;
import com.liferay.portlet.documentlibrary.service.DLFileEntryTypeLocalServiceUtil;
import com.liferay.portlet.documentlibrary.service.DLFileVersionLocalServiceUtil;
import com.liferay.portlet.documentlibrary.service.DLFileVersionServiceUtil;
import com.liferay.portlet.documentlibrary.service.DLFolderLocalServiceUtil;
import com.liferay.portlet.documentlibrary.util.DLUtil;
import com.liferay.portlet.dynamicdatamapping.model.DDMStructure;
import com.liferay.portlet.dynamicdatamapping.storage.Fields;
import com.liferay.portlet.dynamicdatamapping.storage.StorageEngineUtil;
import com.liferay.portlet.expando.model.ExpandoBridge;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DLFileEntryImpl
extends DLFileEntryBaseImpl {
    private static Log _log = LogFactoryUtil.getLog(DLFileEntryImpl.class);
    private UnicodeProperties _extraSettingsProperties;

    public InputStream getContentStream() throws PortalException, SystemException {
        return this.getContentStream(this.getVersion());
    }

    public InputStream getContentStream(String version) throws PortalException, SystemException {
        return DLFileEntryServiceUtil.getFileAsStream((long)this.getFileEntryId(), (String)version);
    }

    public long getDataRepositoryId() {
        return DLFolderConstants.getDataRepositoryId((long)this.getGroupId(), (long)this.getFolderId());
    }

    @Override
    public ExpandoBridge getExpandoBridge() {
        try {
            DLFileVersion dlFileVersion = this.getFileVersion();
            return dlFileVersion.getExpandoBridge();
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
            return null;
        }
    }

    @Override
    public String getExtraSettings() {
        if (this._extraSettingsProperties == null) {
            return super.getExtraSettings();
        }
        return this._extraSettingsProperties.toString();
    }

    public UnicodeProperties getExtraSettingsProperties() {
        if (this._extraSettingsProperties == null) {
            this._extraSettingsProperties = new UnicodeProperties(true);
            try {
                this._extraSettingsProperties.load(super.getExtraSettings());
            }
            catch (IOException ioe) {
                _log.error((Object)ioe, (Throwable)ioe);
            }
        }
        return this._extraSettingsProperties;
    }

    public Map<String, Fields> getFieldsMap(long fileVersionId) throws PortalException, SystemException {
        HashMap<String, Fields> fieldsMap = new HashMap<String, Fields>();
        DLFileVersion dlFileVersion = DLFileVersionLocalServiceUtil.getFileVersion((long)fileVersionId);
        long fileEntryTypeId = dlFileVersion.getFileEntryTypeId();
        if (fileEntryTypeId <= 0L) {
            return fieldsMap;
        }
        DLFileEntryType dlFileEntryType = DLFileEntryTypeLocalServiceUtil.getFileEntryType((long)fileEntryTypeId);
        List ddmStructures = dlFileEntryType.getDDMStructures();
        for (DDMStructure ddmStructure : ddmStructures) {
            DLFileEntryMetadata dlFileEntryMetadata = DLFileEntryMetadataLocalServiceUtil.getFileEntryMetadata((long)ddmStructure.getStructureId(), (long)fileVersionId);
            Fields fields = StorageEngineUtil.getFields((long)dlFileEntryMetadata.getDDMStorageId());
            fieldsMap.put(ddmStructure.getStructureKey(), fields);
        }
        return fieldsMap;
    }

    public DLFileVersion getFileVersion() throws PortalException, SystemException {
        return this.getFileVersion(this.getVersion());
    }

    public DLFileVersion getFileVersion(String version) throws PortalException, SystemException {
        return DLFileVersionLocalServiceUtil.getFileVersion((long)this.getFileEntryId(), (String)version);
    }

    public List<DLFileVersion> getFileVersions(int status) throws SystemException {
        return DLFileVersionLocalServiceUtil.getFileVersions((long)this.getFileEntryId(), (int)status);
    }

    public int getFileVersionsCount(int status) throws SystemException {
        return DLFileVersionLocalServiceUtil.getFileVersionsCount((long)this.getFileEntryId(), (int)status);
    }

    public DLFolder getFolder() {
        DLFolderImpl dlFolder = new DLFolderImpl();
        if (this.getFolderId() <= 0L) {
            return dlFolder;
        }
        try {
            dlFolder = DLFolderLocalServiceUtil.getFolder((long)this.getFolderId());
        }
        catch (NoSuchFolderException nsfe) {
            try {
                DLFileVersion dlFileVersion = this.getLatestFileVersion(true);
                if (!dlFileVersion.isInTrash()) {
                    _log.error((Object)nsfe, (Throwable)nsfe);
                }
            }
            catch (Exception e2) {
                _log.error((Object)e2, (Throwable)e2);
            }
        }
        catch (Exception e3) {
            _log.error((Object)e3, (Throwable)e3);
        }
        return dlFolder;
    }

    public String getIcon() {
        return DLUtil.getFileIcon((String)this.getExtension());
    }

    public DLFileVersion getLatestFileVersion(boolean trusted) throws PortalException, SystemException {
        if (trusted) {
            return DLFileVersionLocalServiceUtil.getLatestFileVersion((long)this.getFileEntryId(), (boolean)false);
        }
        return DLFileVersionServiceUtil.getLatestFileVersion((long)this.getFileEntryId());
    }

    public Lock getLock() {
        try {
            return LockLocalServiceUtil.getLock((String)DLFileEntry.class.getName(), (long)this.getFileEntryId());
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getLuceneProperties() {
        UnicodeProperties extraSettingsProps = this.getExtraSettingsProperties();
        StringBundler sb = new StringBundler(extraSettingsProps.entrySet().size() + 4);
        sb.append(FileUtil.stripExtension((String)this.getTitle()));
        sb.append(" ");
        sb.append(this.getDescription());
        sb.append(" ");
        for (Map.Entry entry : extraSettingsProps.entrySet()) {
            String value = GetterUtil.getString((String)((String)entry.getValue()));
            sb.append(value);
        }
        return sb.toString();
    }

    public DLFolder getTrashContainer() {
        DLFolder dlFolder = this.getFolder();
        if (dlFolder.isInTrash()) {
            return dlFolder;
        }
        return dlFolder.getTrashContainer();
    }

    public boolean hasLock() {
        try {
            return DLFileEntryServiceUtil.hasFileEntryLock((long)this.getFileEntryId());
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean isCheckedOut() {
        try {
            return DLFileEntryServiceUtil.isFileEntryCheckedOut((long)this.getFileEntryId());
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean isInHiddenFolder() {
        try {
            long repositoryId = this.getRepositoryId();
            Repository repository = RepositoryLocalServiceUtil.getRepository((long)repositoryId);
            long dlFolderId = repository.getDlFolderId();
            DLFolder dlFolder = DLFolderLocalServiceUtil.getFolder((long)dlFolderId);
            return dlFolder.isHidden();
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean isInTrashContainer() {
        return this.getTrashContainer() != null;
    }

    @Override
    public void setExtraSettings(String extraSettings) {
        this._extraSettingsProperties = null;
        super.setExtraSettings(extraSettings);
    }

    public void setExtraSettingsProperties(UnicodeProperties extraSettingsProperties) {
        this._extraSettingsProperties = extraSettingsProperties;
        super.setExtraSettings(this._extraSettingsProperties.toString());
    }
}

