/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.lar;

import com.liferay.portal.kernel.lar.BaseStagedModelDataHandler;
import com.liferay.portal.kernel.lar.ExportImportPathUtil;
import com.liferay.portal.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.model.ClassedModel;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Repository;
import com.liferay.portal.model.StagedModel;
import com.liferay.portal.repository.liferayrepository.LiferayRepository;
import com.liferay.portal.repository.liferayrepository.model.LiferayFolder;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.persistence.RepositoryUtil;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.documentlibrary.lar.FolderUtil;
import com.liferay.portlet.documentlibrary.model.DLFileEntryType;
import com.liferay.portlet.documentlibrary.model.DLFolder;
import com.liferay.portlet.documentlibrary.service.DLAppLocalServiceUtil;
import com.liferay.portlet.documentlibrary.service.DLFileEntryTypeLocalServiceUtil;
import com.liferay.portlet.documentlibrary.service.DLFolderLocalServiceUtil;
import com.liferay.portlet.documentlibrary.service.persistence.DLFileEntryTypeUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class FolderStagedModelDataHandler
extends BaseStagedModelDataHandler<Folder> {
    public static final String[] CLASS_NAMES = new String[]{DLFolder.class.getName(), Folder.class.getName(), LiferayFolder.class.getName()};

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    public String getDisplayName(Folder folder) {
        return folder.getName();
    }

    public String getManifestSummaryKey(StagedModel stagedModel) {
        return Folder.class.getName();
    }

    protected void doExportStagedModel(PortletDataContext portletDataContext, Folder folder) throws Exception {
        Element folderElement = portletDataContext.getExportDataElement((ClassedModel)folder, Folder.class);
        String folderPath = ExportImportPathUtil.getModelPath((long)folder.getGroupId(), (String)Folder.class.getName(), (long)folder.getFolderId());
        Repository repository = null;
        if (folder.isMountPoint() || !folder.isDefaultRepository()) {
            repository = RepositoryUtil.findByPrimaryKey((long)folder.getRepositoryId());
            StagedModelDataHandlerUtil.exportStagedModel((PortletDataContext)portletDataContext, (StagedModel)repository);
            portletDataContext.addReferenceElement((StagedModel)folder, folderElement, (ClassedModel)repository, "strong", false);
            portletDataContext.addClassedModel(folderElement, folderPath, (ClassedModel)folder, "document_library");
        }
        long liferayRepositoryClassNameId = PortalUtil.getClassNameId((String)LiferayRepository.class.getName());
        if (repository != null && repository.getClassNameId() != liferayRepositoryClassNameId || folder.isMountPoint()) {
            return;
        }
        if (folder.getParentFolderId() != 0L) {
            StagedModelDataHandlerUtil.exportStagedModel((PortletDataContext)portletDataContext, (StagedModel)folder.getParentFolder());
        }
        this.exportFolderFileEntryTypes(portletDataContext, folder, folderElement);
        portletDataContext.addClassedModel(folderElement, folderPath, (ClassedModel)folder, "document_library");
    }

    protected void doImportStagedModel(PortletDataContext portletDataContext, Folder folder) throws Exception {
        long userId = portletDataContext.getUserId(folder.getUserUuid());
        String path = ExportImportPathUtil.getModelPath((PortletDataContext)portletDataContext, (String)Folder.class.getName(), (long)folder.getFolderId());
        Element folderElement = portletDataContext.getImportDataElement(Folder.class.getSimpleName(), "path", path);
        List referenceDataElements = portletDataContext.getReferenceDataElements(folderElement, Repository.class);
        Iterator iterator = referenceDataElements.iterator();
        if (iterator.hasNext()) {
            Element referenceDataElement = (Element)iterator.next();
            String referencePath = referenceDataElement.attributeValue("path");
            StagedModel referenceStagedModel = (StagedModel)portletDataContext.getZipEntryAsObject(referencePath);
            StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)portletDataContext, (StagedModel)referenceStagedModel);
            return;
        }
        if (folder.getParentFolderId() != 0L) {
            String parentFolderPath = ExportImportPathUtil.getModelPath((PortletDataContext)portletDataContext, (String)Folder.class.getName(), (long)folder.getParentFolderId());
            Folder parentFolder = (Folder)portletDataContext.getZipEntryAsObject(parentFolderPath);
            StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)portletDataContext, (StagedModel)parentFolder);
        }
        Map folderIds = portletDataContext.getNewPrimaryKeysMap(Folder.class);
        long parentFolderId = MapUtil.getLong((Map)folderIds, (long)folder.getParentFolderId(), (long)folder.getParentFolderId());
        ServiceContext serviceContext = portletDataContext.createServiceContext((StagedModel)folder, "document_library");
        serviceContext.setUserId(userId);
        Folder importedFolder = null;
        if (portletDataContext.isDataStrategyMirror()) {
            Folder existingFolder = FolderUtil.fetchByUUID_R(folder.getUuid(), portletDataContext.getScopeGroupId());
            if (existingFolder == null) {
                String name = this.getFolderName(null, portletDataContext.getScopeGroupId(), parentFolderId, folder.getName(), 2);
                serviceContext.setUuid(folder.getUuid());
                importedFolder = DLAppLocalServiceUtil.addFolder((long)userId, (long)portletDataContext.getScopeGroupId(), (long)parentFolderId, (String)name, (String)folder.getDescription(), (ServiceContext)serviceContext);
            } else {
                String name = this.getFolderName(folder.getUuid(), portletDataContext.getScopeGroupId(), parentFolderId, folder.getName(), 2);
                importedFolder = DLAppLocalServiceUtil.updateFolder((long)existingFolder.getFolderId(), (long)parentFolderId, (String)name, (String)folder.getDescription(), (ServiceContext)serviceContext);
            }
        } else {
            String name = this.getFolderName(null, portletDataContext.getScopeGroupId(), parentFolderId, folder.getName(), 2);
            importedFolder = DLAppLocalServiceUtil.addFolder((long)userId, (long)portletDataContext.getScopeGroupId(), (long)parentFolderId, (String)name, (String)folder.getDescription(), (ServiceContext)serviceContext);
        }
        this.importFolderFileEntryTypes(portletDataContext, folderElement, folder, serviceContext);
        portletDataContext.importClassedModel((ClassedModel)folder, (ClassedModel)importedFolder, "document_library");
        folderIds.put(folder.getFolderId(), importedFolder.getFolderId());
    }

    protected void exportFolderFileEntryTypes(PortletDataContext portletDataContext, Folder folder, Element folderElement) throws Exception {
        List dlFileEntryTypes = DLFileEntryTypeLocalServiceUtil.getFolderFileEntryTypes((long[])new long[]{portletDataContext.getScopeGroupId()}, (long)folder.getFolderId(), (boolean)false);
        long defaultFileEntryTypeId = DLFileEntryTypeLocalServiceUtil.getDefaultFileEntryTypeId((long)folder.getFolderId());
        String defaultFileEntryTypeUuid = "";
        for (DLFileEntryType dlFileEntryType : dlFileEntryTypes) {
            if (dlFileEntryType.getFileEntryTypeId() == 0L) {
                folderElement.addAttribute("basic-document", "true");
                continue;
            }
            if (defaultFileEntryTypeId == dlFileEntryType.getFileEntryTypeId()) {
                defaultFileEntryTypeUuid = dlFileEntryType.getUuid();
            }
            if (!dlFileEntryType.isExportable()) continue;
            StagedModelDataHandlerUtil.exportStagedModel((PortletDataContext)portletDataContext, (StagedModel)dlFileEntryType);
            portletDataContext.addReferenceElement((StagedModel)folder, folderElement, (ClassedModel)dlFileEntryType, "strong", false);
        }
        folderElement.addAttribute("defaultFileEntryTypeUuid", defaultFileEntryTypeUuid);
    }

    protected String getFolderName(String uuid, long groupId, long parentFolderId, String name, int count) throws Exception {
        Folder folder = FolderUtil.fetchByR_P_N(groupId, parentFolderId, name);
        if (folder == null) {
            return name;
        }
        if (Validator.isNotNull((String)uuid) && uuid.equals(folder.getUuid())) {
            return name;
        }
        name = StringUtil.appendParentheticalSuffix((String)name, (int)count);
        return this.getFolderName(uuid, groupId, parentFolderId, name, ++count);
    }

    protected void importFolderFileEntryTypes(PortletDataContext portletDataContext, Element folderElement, Folder folder, ServiceContext serviceContext) throws Exception {
        ArrayList<Long> fileEntryTypeIds = new ArrayList<Long>();
        String defaultFileEntryTypeUuid = GetterUtil.getString((String)folderElement.attributeValue("defaultFileEntryTypeUuid"));
        long defaultFileEntryTypeId = 0L;
        List referenceDataElements = portletDataContext.getReferenceDataElements(folderElement, DLFileEntryType.class);
        for (Element referenceDataElement : referenceDataElements) {
            String referencePath = referenceDataElement.attributeValue("path");
            DLFileEntryType referenceDLFileEntryType = (DLFileEntryType)portletDataContext.getZipEntryAsObject(referencePath);
            String fileEntryTypeUuid = referenceDLFileEntryType.getUuid();
            DLFileEntryType dlFileEntryType = DLFileEntryTypeUtil.fetchByUUID_G((String)fileEntryTypeUuid, (long)portletDataContext.getScopeGroupId());
            if (dlFileEntryType == null) {
                Group companyGroup = GroupLocalServiceUtil.getCompanyGroup((long)portletDataContext.getCompanyId());
                dlFileEntryType = DLFileEntryTypeUtil.fetchByUUID_G((String)fileEntryTypeUuid, (long)companyGroup.getGroupId());
            }
            if (dlFileEntryType == null) continue;
            fileEntryTypeIds.add(dlFileEntryType.getFileEntryTypeId());
            if (!defaultFileEntryTypeUuid.equals(dlFileEntryType.getUuid())) continue;
            defaultFileEntryTypeId = dlFileEntryType.getFileEntryTypeId();
        }
        if (GetterUtil.getBoolean((String)folderElement.attributeValue("basic-document"))) {
            DLFileEntryType dlFileEntryType = DLFileEntryTypeLocalServiceUtil.fetchDLFileEntryType((long)0L);
            fileEntryTypeIds.add(dlFileEntryType.getFileEntryTypeId());
        }
        if (!fileEntryTypeIds.isEmpty()) {
            DLFolder dlFolder = (DLFolder)folder.getModel();
            dlFolder.setDefaultFileEntryTypeId(defaultFileEntryTypeId);
            dlFolder.setOverrideFileEntryTypes(true);
            DLFolderLocalServiceUtil.updateDLFolder((DLFolder)dlFolder);
            DLFileEntryTypeLocalServiceUtil.updateFolderFileEntryTypes((DLFolder)dlFolder, fileEntryTypeIds, (long)defaultFileEntryTypeId, (ServiceContext)serviceContext);
        }
    }
}

