/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.lar;

import com.liferay.portal.kernel.lar.BaseStagedModelDataHandler;
import com.liferay.portal.kernel.lar.ExportImportPathUtil;
import com.liferay.portal.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.lar.PortletDataException;
import com.liferay.portal.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.model.ClassedModel;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Repository;
import com.liferay.portal.model.StagedModel;
import com.liferay.portal.repository.liferayrepository.LiferayRepository;
import com.liferay.portal.repository.liferayrepository.model.LiferayFileEntry;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.persistence.RepositoryUtil;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.documentlibrary.DuplicateFileException;
import com.liferay.portlet.documentlibrary.NoSuchFileException;
import com.liferay.portlet.documentlibrary.lar.FileEntryUtil;
import com.liferay.portlet.documentlibrary.model.DLFileEntry;
import com.liferay.portlet.documentlibrary.model.DLFileEntryMetadata;
import com.liferay.portlet.documentlibrary.model.DLFileEntryType;
import com.liferay.portlet.documentlibrary.service.DLAppLocalServiceUtil;
import com.liferay.portlet.documentlibrary.service.DLAppServiceUtil;
import com.liferay.portlet.documentlibrary.service.DLFileEntryMetadataLocalServiceUtil;
import com.liferay.portlet.documentlibrary.service.DLFileEntryTypeLocalServiceUtil;
import com.liferay.portlet.documentlibrary.service.DLFileVersionLocalServiceUtil;
import com.liferay.portlet.documentlibrary.service.persistence.DLFileEntryTypeUtil;
import com.liferay.portlet.documentlibrary.service.persistence.DLFileEntryUtil;
import com.liferay.portlet.documentlibrary.util.DLProcessorRegistryUtil;
import com.liferay.portlet.documentlibrary.util.DLProcessorThreadLocal;
import com.liferay.portlet.documentlibrary.util.DLUtil;
import com.liferay.portlet.dynamicdatamapping.model.DDMStructure;
import com.liferay.portlet.dynamicdatamapping.storage.Fields;
import com.liferay.portlet.dynamicdatamapping.storage.StorageEngineUtil;
import com.liferay.util.PwdGenerator;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.List;
import java.util.Map;

public class FileEntryStagedModelDataHandler
extends BaseStagedModelDataHandler<FileEntry> {
    public static final String[] CLASS_NAMES = new String[]{DLFileEntry.class.getName(), FileEntry.class.getName(), LiferayFileEntry.class.getName()};
    private static Log _log = LogFactoryUtil.getLog(FileEntryStagedModelDataHandler.class);

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    public String getDisplayName(FileEntry fileEntry) {
        return fileEntry.getTitle();
    }

    public String getManifestSummaryKey(StagedModel stagedModel) {
        return FileEntry.class.getName();
    }

    public void importStagedModel(PortletDataContext portletDataContext, FileEntry fileEntry) throws PortletDataException {
        boolean dlProcessorEnabled = DLProcessorThreadLocal.isEnabled();
        try {
            DLProcessorThreadLocal.setEnabled((boolean)false);
            super.importStagedModel(portletDataContext, (StagedModel)fileEntry);
        }
        finally {
            DLProcessorThreadLocal.setEnabled((boolean)dlProcessorEnabled);
        }
    }

    protected void doExportStagedModel(PortletDataContext portletDataContext, FileEntry fileEntry) throws Exception {
        FileVersion fileVersion;
        Element fileEntryElement = portletDataContext.getExportDataElement((ClassedModel)fileEntry, FileEntry.class);
        String fileEntryPath = ExportImportPathUtil.getModelPath((long)fileEntry.getGroupId(), (String)FileEntry.class.getName(), (long)fileEntry.getFileEntryId());
        if (!fileEntry.isDefaultRepository()) {
            Repository repository = RepositoryUtil.findByPrimaryKey((long)fileEntry.getRepositoryId());
            StagedModelDataHandlerUtil.exportStagedModel((PortletDataContext)portletDataContext, (StagedModel)repository);
            portletDataContext.addReferenceElement((StagedModel)fileEntry, fileEntryElement, (ClassedModel)repository, "strong", false);
            portletDataContext.addClassedModel(fileEntryElement, fileEntryPath, (ClassedModel)fileEntry, "document_library");
            long liferayRepositoryClassNameId = PortalUtil.getClassNameId((String)LiferayRepository.class.getName());
            if (repository.getClassNameId() != liferayRepositoryClassNameId) {
                return;
            }
        }
        if (!(fileVersion = fileEntry.getFileVersion()).isApproved() && !fileVersion.isInTrash()) {
            return;
        }
        if (fileEntry.getFolderId() != 0L) {
            StagedModelDataHandlerUtil.exportStagedModel((PortletDataContext)portletDataContext, (StagedModel)fileEntry.getFolder());
        }
        LiferayFileEntry liferayFileEntry = (LiferayFileEntry)fileEntry;
        liferayFileEntry.setCachedFileVersion(fileVersion);
        if (!portletDataContext.isPerformDirectBinaryImport()) {
            InputStream is = null;
            try {
                is = FileEntryUtil.getContentStream(fileEntry);
            }
            catch (NoSuchFileException noSuchFileException) {}
            if (is == null) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)("No file found for file entry " + fileEntry.getFileEntryId()));
                }
                fileEntryElement.detach();
                return;
            }
            try {
                String binPath = ExportImportPathUtil.getModelPath((StagedModel)fileEntry, (String)fileEntry.getVersion());
                portletDataContext.addZipEntry(binPath, is);
                fileEntryElement.addAttribute("bin-path", binPath);
            }
            finally {
                try {
                    is.close();
                }
                catch (IOException ioe) {
                    _log.error((Object)ioe, (Throwable)ioe);
                }
            }
        }
        if (portletDataContext.getBooleanParameter("document_library", "previews-and-thumbnails")) {
            DLProcessorRegistryUtil.exportGeneratedFiles((PortletDataContext)portletDataContext, (FileEntry)fileEntry, (Element)fileEntryElement);
        }
        this.exportMetaData(portletDataContext, fileEntryElement, fileEntry);
        portletDataContext.addClassedModel(fileEntryElement, fileEntryPath, (ClassedModel)fileEntry, "document_library");
    }

    /*
     * Unable to fully structure code
     */
    protected void doImportStagedModel(PortletDataContext portletDataContext, FileEntry fileEntry) throws Exception {
        userId = portletDataContext.getUserId(fileEntry.getUserUuid());
        path = ExportImportPathUtil.getModelPath((PortletDataContext)portletDataContext, (String)FileEntry.class.getName(), (long)fileEntry.getFileEntryId());
        fileEntryElement = portletDataContext.getImportDataElement(FileEntry.class.getSimpleName(), "path", path);
        referenceDataElements = portletDataContext.getReferenceDataElements(fileEntryElement, Repository.class);
        for (Element referenceDataElement : referenceDataElements) {
            referencePath = referenceDataElement.attributeValue("path");
            referenceStagedModel = (StagedModel)portletDataContext.getZipEntryAsObject(referencePath);
            StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)portletDataContext, (StagedModel)referenceStagedModel);
        }
        if (fileEntry.getFolderId() != 0L) {
            folderPath = ExportImportPathUtil.getModelPath((PortletDataContext)portletDataContext, (String)Folder.class.getName(), (long)fileEntry.getFolderId());
            folder = (Folder)portletDataContext.getZipEntryAsObject(folderPath);
            StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)portletDataContext, (StagedModel)folder);
        }
        folderIds = portletDataContext.getNewPrimaryKeysMap(Folder.class);
        folderId = MapUtil.getLong((Map)folderIds, (long)fileEntry.getFolderId(), (long)fileEntry.getFolderId());
        assetCategoryIds = portletDataContext.getAssetCategoryIds(DLFileEntry.class, fileEntry.getFileEntryId());
        assetTagNames = portletDataContext.getAssetTagNames(DLFileEntry.class, fileEntry.getFileEntryId());
        serviceContext = portletDataContext.createServiceContext((StagedModel)fileEntry, "document_library");
        serviceContext.setAttribute("sourceFileName", (Serializable)("A." + fileEntry.getExtension()));
        serviceContext.setUserId(userId);
        binPath = fileEntryElement.attributeValue("bin-path");
        is = null;
        if (Validator.isNull((String)binPath) && portletDataContext.isPerformDirectBinaryImport()) {
            try {
                is = FileEntryUtil.getContentStream(fileEntry);
            }
            catch (NoSuchFileException v0) {}
        } else {
            is = portletDataContext.getZipEntryAsInputStream(binPath);
        }
        if (is == null) {
            if (FileEntryStagedModelDataHandler._log.isWarnEnabled()) {
                FileEntryStagedModelDataHandler._log.warn((Object)("No file found for file entry " + fileEntry.getFileEntryId()));
            }
            return;
        }
        this.importMetaData(portletDataContext, fileEntryElement, serviceContext);
        importedFileEntry = null;
        titleWithExtension = DLUtil.getTitleWithExtension((FileEntry)fileEntry);
        extension = fileEntry.getExtension();
        dotExtension = "." + extension;
        if (portletDataContext.isDataStrategyMirror()) {
            existingFileEntry = FileEntryUtil.fetchByUUID_R(fileEntry.getUuid(), portletDataContext.getScopeGroupId());
            fileVersion = fileEntry.getFileVersion();
            if (existingFileEntry == null) {
                fileEntryTitle = fileEntry.getTitle();
                existingTitleFileEntry = FileEntryUtil.fetchByR_F_T(portletDataContext.getScopeGroupId(), folderId, fileEntryTitle);
                if (existingTitleFileEntry != null) {
                    if (fileEntry.getGroupId() == portletDataContext.getSourceGroupId() && portletDataContext.isDataStrategyMirrorWithOverwriting()) {
                        DLAppLocalServiceUtil.deleteFileEntry((long)existingTitleFileEntry.getFileEntryId());
                    } else {
                        titleHasExtension = false;
                        if (fileEntryTitle.endsWith(dotExtension)) {
                            fileEntryTitle = FileUtil.stripExtension((String)fileEntryTitle);
                            titleHasExtension = true;
                        }
                        i = 1;
                        while (true) {
                            fileEntryTitle = String.valueOf(fileEntryTitle) + " " + i;
                            titleWithExtension = String.valueOf(fileEntryTitle) + dotExtension;
                            existingTitleFileEntry = FileEntryUtil.fetchByR_F_T(portletDataContext.getScopeGroupId(), folderId, titleWithExtension);
                            if (existingTitleFileEntry == null) {
                                if (!titleHasExtension) break;
                                fileEntryTitle = String.valueOf(fileEntryTitle) + dotExtension;
                                break;
                            }
                            ++i;
                        }
                    }
                }
                serviceContext.setAttribute("fileVersionUuid", (Serializable)fileVersion.getUuid());
                serviceContext.setUuid(fileEntry.getUuid());
                importedFileEntry = DLAppLocalServiceUtil.addFileEntry((long)userId, (long)portletDataContext.getScopeGroupId(), (long)folderId, (String)titleWithExtension, (String)fileEntry.getMimeType(), (String)fileEntryTitle, (String)fileEntry.getDescription(), null, (InputStream)is, (long)fileEntry.getSize(), (ServiceContext)serviceContext);
                if (fileVersion.isInTrash()) {
                    importedFileEntry = DLAppServiceUtil.moveFileEntryToTrash((long)importedFileEntry.getFileEntryId());
                }
            } else {
                latestExistingFileVersion = existingFileEntry.getLatestFileVersion();
                indexEnabled = serviceContext.isIndexingEnabled();
                try {
                    serviceContext.setIndexingEnabled(false);
                    if (!fileVersion.getUuid().equals(latestExistingFileVersion.getUuid())) {
                        alreadyExistingFileVersion = DLFileVersionLocalServiceUtil.getFileVersionByUuidAndGroupId((String)fileVersion.getUuid(), (long)existingFileEntry.getGroupId());
                        if (alreadyExistingFileVersion != null) {
                            serviceContext.setAttribute("existingDLFileVersionId", (Serializable)Long.valueOf(alreadyExistingFileVersion.getFileVersionId()));
                        }
                        serviceContext.setUuid(fileVersion.getUuid());
                        importedFileEntry = DLAppLocalServiceUtil.updateFileEntry((long)userId, (long)existingFileEntry.getFileEntryId(), (String)fileEntry.getTitle(), (String)fileEntry.getMimeType(), (String)fileEntry.getTitle(), (String)fileEntry.getDescription(), null, (boolean)false, (InputStream)is, (long)fileEntry.getSize(), (ServiceContext)serviceContext);
                    } else {
                        DLAppLocalServiceUtil.updateAsset((long)userId, (FileEntry)existingFileEntry, (FileVersion)latestExistingFileVersion, (long[])assetCategoryIds, (String[])assetTagNames, null);
                        importedFileEntry = existingFileEntry;
                    }
                    if (importedFileEntry.getFolderId() != folderId) {
                        importedFileEntry = DLAppLocalServiceUtil.moveFileEntry((long)userId, (long)importedFileEntry.getFileEntryId(), (long)folderId, (ServiceContext)serviceContext);
                    }
                    if (!(importedFileEntry instanceof LiferayFileEntry)) ** GOTO lbl105
                    liferayFileEntry = (LiferayFileEntry)importedFileEntry;
                    indexer = IndexerRegistryUtil.getIndexer(DLFileEntry.class);
                    indexer.reindex(liferayFileEntry.getModel());
                }
                finally {
                    serviceContext.setIndexingEnabled(indexEnabled);
                }
            }
        } else {
            try {
                importedFileEntry = DLAppLocalServiceUtil.addFileEntry((long)userId, (long)portletDataContext.getScopeGroupId(), (long)folderId, (String)titleWithExtension, (String)fileEntry.getMimeType(), (String)fileEntry.getTitle(), (String)fileEntry.getDescription(), null, (InputStream)is, (long)fileEntry.getSize(), (ServiceContext)serviceContext);
            }
            catch (DuplicateFileException v1) {
                title = fileEntry.getTitle();
                titleParts = title.split("\\.", 2);
                title = String.valueOf(titleParts[0]) + PwdGenerator.getPassword();
                if (titleParts.length > 1) {
                    title = String.valueOf(title) + "." + titleParts[1];
                }
                if (!title.endsWith(dotExtension)) {
                    title = String.valueOf(title) + dotExtension;
                }
                importedFileEntry = DLAppLocalServiceUtil.addFileEntry((long)userId, (long)portletDataContext.getScopeGroupId(), (long)folderId, (String)title, (String)fileEntry.getMimeType(), (String)title, (String)fileEntry.getDescription(), null, (InputStream)is, (long)fileEntry.getSize(), (ServiceContext)serviceContext);
            }
        }
lbl105:
        // 5 sources

        if (portletDataContext.getBooleanParameter("document_library", "previews-and-thumbnails")) {
            DLProcessorRegistryUtil.importGeneratedFiles((PortletDataContext)portletDataContext, (FileEntry)fileEntry, (FileEntry)importedFileEntry, (Element)fileEntryElement);
        }
        portletDataContext.importClassedModel((ClassedModel)fileEntry, (ClassedModel)importedFileEntry, "document_library");
        fileEntryIds = portletDataContext.getNewPrimaryKeysMap(FileEntry.class);
        fileEntryIds.put(fileEntry.getFileEntryId(), importedFileEntry.getFileEntryId());
    }

    protected void exportMetaData(PortletDataContext portletDataContext, Element fileEntryElement, FileEntry fileEntry) throws Exception {
        LiferayFileEntry liferayFileEntry = (LiferayFileEntry)fileEntry;
        DLFileEntry dlFileEntry = liferayFileEntry.getDLFileEntry();
        long fileEntryTypeId = dlFileEntry.getFileEntryTypeId();
        DLFileEntryType dlFileEntryType = DLFileEntryTypeLocalServiceUtil.fetchFileEntryType((long)fileEntryTypeId);
        if (dlFileEntryType == null || !dlFileEntryType.isExportable()) {
            return;
        }
        StagedModelDataHandlerUtil.exportStagedModel((PortletDataContext)portletDataContext, (StagedModel)dlFileEntryType);
        List ddmStructures = dlFileEntryType.getDDMStructures();
        for (DDMStructure ddmStructure : ddmStructures) {
            Element structureFields = fileEntryElement.addElement("structure-fields");
            String path = ExportImportPathUtil.getModelPath((StagedModel)ddmStructure, (String)String.valueOf(ddmStructure.getStructureId()));
            structureFields.addAttribute("path", path);
            structureFields.addAttribute("structureUuid", ddmStructure.getUuid());
            FileVersion fileVersion = fileEntry.getFileVersion();
            DLFileEntryMetadata dlFileEntryMetadata = DLFileEntryMetadataLocalServiceUtil.getFileEntryMetadata((long)ddmStructure.getStructureId(), (long)fileVersion.getFileVersionId());
            Fields fields = StorageEngineUtil.getFields((long)dlFileEntryMetadata.getDDMStorageId());
            portletDataContext.addZipEntry(path, (Object)fields);
        }
    }

    protected void importMetaData(PortletDataContext portletDataContext, Element fileEntryElement, ServiceContext serviceContext) throws Exception {
        Group group;
        String fileEntryTypeUuid = fileEntryElement.attributeValue("fileEntryTypeUuid");
        if (Validator.isNull((String)fileEntryTypeUuid)) {
            return;
        }
        DLFileEntryType dlFileEntryType = DLFileEntryTypeUtil.fetchByUUID_G((String)fileEntryTypeUuid, (long)portletDataContext.getScopeGroupId());
        if (dlFileEntryType == null && (dlFileEntryType = DLFileEntryTypeUtil.fetchByUUID_G((String)fileEntryTypeUuid, (long)(group = GroupLocalServiceUtil.getCompanyGroup((long)portletDataContext.getCompanyId())).getGroupId())) == null) {
            serviceContext.setAttribute("fileEntryTypeId", (Serializable)Integer.valueOf(-1));
            return;
        }
        serviceContext.setAttribute("fileEntryTypeId", (Serializable)Long.valueOf(dlFileEntryType.getFileEntryTypeId()));
        List ddmStructures = dlFileEntryType.getDDMStructures();
        for (DDMStructure ddmStructure : ddmStructures) {
            Element structureFieldsElement = (Element)fileEntryElement.selectSingleNode("structure-fields[@structureUuid='".concat(ddmStructure.getUuid()).concat("']"));
            if (structureFieldsElement == null) continue;
            String path = structureFieldsElement.attributeValue("path");
            Fields fields = (Fields)portletDataContext.getZipEntryAsObject(path);
            serviceContext.setAttribute(String.valueOf(Fields.class.getName()) + ddmStructure.getStructureId(), (Serializable)fields);
        }
    }

    protected boolean validateMissingReference(String uuid, long companyId, long groupId) {
        try {
            DLFileEntry dlFileEntry = DLFileEntryUtil.fetchByUUID_G((String)uuid, (long)groupId);
            return dlFileEntry != null;
        }
        catch (Exception exception) {
            return false;
        }
    }
}

