/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.lar;

import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.lar.BasePortletDataHandler;
import com.liferay.portal.kernel.lar.ExportImportPathUtil;
import com.liferay.portal.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.lar.PortletDataHandlerBoolean;
import com.liferay.portal.kernel.lar.PortletDataHandlerControl;
import com.liferay.portal.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.StagedModel;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.documentlibrary.model.DLFileEntry;
import com.liferay.portlet.documentlibrary.model.DLFileEntryType;
import com.liferay.portlet.documentlibrary.model.DLFileRank;
import com.liferay.portlet.documentlibrary.model.DLFileShortcut;
import com.liferay.portlet.documentlibrary.model.DLFolder;
import com.liferay.portlet.documentlibrary.service.DLAppLocalServiceUtil;
import com.liferay.portlet.documentlibrary.service.persistence.DLFileEntryExportActionableDynamicQuery;
import com.liferay.portlet.documentlibrary.service.persistence.DLFileEntryTypeExportActionableDynamicQuery;
import com.liferay.portlet.documentlibrary.service.persistence.DLFileShortcutExportActionableDynamicQuery;
import com.liferay.portlet.documentlibrary.service.persistence.DLFolderExportActionableDynamicQuery;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.portlet.PortletPreferences;

public class DLPortletDataHandler
extends BasePortletDataHandler {
    public static final String NAMESPACE = "document_library";

    public DLPortletDataHandler() {
        this.setDeletionSystemEventClassNames(new String[]{DLFileEntry.class.getName(), DLFileRank.class.getName(), DLFileShortcut.class.getName(), DLFolder.class.getName()});
        this.setDataLocalized(true);
        this.setDataPortletPreferences(new String[]{"rootFolderId"});
        this.setExportControls(new PortletDataHandlerControl[]{new PortletDataHandlerBoolean(NAMESPACE, "documents", true, false, null, FileEntry.class.getName()), new PortletDataHandlerBoolean(NAMESPACE, "shortcuts", true, false, null, DLFileShortcut.class.getName()), new PortletDataHandlerBoolean(NAMESPACE, "previews-and-thumbnails")});
        this.setPublishToLiveByDefault(PropsValues.DL_PUBLISH_TO_LIVE_BY_DEFAULT);
    }

    protected PortletPreferences doDeleteData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences) throws Exception {
        if (portletDataContext.addPrimaryKey(DLPortletDataHandler.class, "deleteData")) {
            return portletPreferences;
        }
        DLAppLocalServiceUtil.deleteAll((long)portletDataContext.getScopeGroupId());
        return portletPreferences;
    }

    protected String doExportData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences) throws Exception {
        portletDataContext.addPermissions("com.liferay.portlet.documentlibrary", portletDataContext.getScopeGroupId());
        Element rootElement = this.addExportDataRootElement(portletDataContext);
        rootElement.addAttribute("group-id", String.valueOf(portletDataContext.getScopeGroupId()));
        long rootFolderId = GetterUtil.getLong((String)portletPreferences.getValue("rootFolderId", null));
        if (rootFolderId != 0L) {
            rootElement.addAttribute("root-folder-id", String.valueOf(rootFolderId));
        }
        if (portletDataContext.getBooleanParameter(NAMESPACE, "documents")) {
            ActionableDynamicQuery fileEntryTypeActionableDynamicQuery = this.getDLFileEntryTypeActionableDynamicQuery(portletDataContext);
            fileEntryTypeActionableDynamicQuery.performActions();
            ActionableDynamicQuery folderActionableDynamicQuery = this.getFolderActionableDynamicQuery(portletDataContext);
            folderActionableDynamicQuery.performActions();
            ActionableDynamicQuery fileEntryActionableDynamicQuery = this.getFileEntryActionableDynamicQuery(portletDataContext);
            fileEntryActionableDynamicQuery.performActions();
        }
        if (portletDataContext.getBooleanParameter(NAMESPACE, "shortcuts")) {
            ActionableDynamicQuery fileShortcutActionableDynamicQuery = this.getDLFileShortcutActionableDynamicQuery(portletDataContext);
            fileShortcutActionableDynamicQuery.performActions();
        }
        return this.getExportDataRootElementString(rootElement);
    }

    protected PortletPreferences doImportData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences, String data) throws Exception {
        Element rootElement;
        long rootFolderId;
        portletDataContext.importPermissions("com.liferay.portlet.documentlibrary", portletDataContext.getSourceGroupId(), portletDataContext.getScopeGroupId());
        Element fileEntryTypesElement = portletDataContext.getImportDataGroupElement(DLFileEntryType.class);
        List fileEntryTypeElements = fileEntryTypesElement.elements();
        for (Element fileEntryTypeElement : fileEntryTypeElements) {
            StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)portletDataContext, (Element)fileEntryTypeElement);
        }
        if (portletDataContext.getBooleanParameter(NAMESPACE, "documents")) {
            Element foldersElement = portletDataContext.getImportDataGroupElement(Folder.class);
            List folderElements = foldersElement.elements();
            for (Element folderElement : folderElements) {
                StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)portletDataContext, (Element)folderElement);
            }
            Element fileEntriesElement = portletDataContext.getImportDataGroupElement(FileEntry.class);
            List fileEntryElements = fileEntriesElement.elements();
            Iterator iterator = fileEntryElements.iterator();
            while (iterator.hasNext()) {
                Element fileEntryElement = (Element)iterator.next();
                StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)portletDataContext, (Element)fileEntryElement);
            }
        }
        if (portletDataContext.getBooleanParameter(NAMESPACE, "shortcuts")) {
            Element fileShortcutsElement = portletDataContext.getImportDataGroupElement(DLFileShortcut.class);
            List fileShortcutElements = fileShortcutsElement.elements();
            for (Element fileShortcutElement : fileShortcutElements) {
                StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)portletDataContext, (Element)fileShortcutElement);
            }
        }
        if ((rootFolderId = GetterUtil.getLong((String)(rootElement = portletDataContext.getImportDataRootElement()).attributeValue("root-folder-id"))) > 0L) {
            String rootFolderPath = ExportImportPathUtil.getModelPath((PortletDataContext)portletDataContext, (String)Folder.class.getName(), (long)rootFolderId);
            Folder folder = (Folder)portletDataContext.getZipEntryAsObject(rootFolderPath);
            StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)portletDataContext, (StagedModel)folder);
            Map folderIds = portletDataContext.getNewPrimaryKeysMap(Folder.class);
            rootFolderId = MapUtil.getLong((Map)folderIds, (long)rootFolderId, (long)rootFolderId);
            portletPreferences.setValue("rootFolderId", String.valueOf(rootFolderId));
        }
        return portletPreferences;
    }

    protected void doPrepareManifestSummary(PortletDataContext portletDataContext) throws Exception {
        ActionableDynamicQuery dlFileShortcutActionableDynamicQuery = this.getDLFileShortcutActionableDynamicQuery(portletDataContext);
        dlFileShortcutActionableDynamicQuery.performCount();
        ActionableDynamicQuery fileEntryActionableDynamicQuery = this.getFileEntryActionableDynamicQuery(portletDataContext);
        fileEntryActionableDynamicQuery.performCount();
        ActionableDynamicQuery folderActionableDynamicQuery = this.getFolderActionableDynamicQuery(portletDataContext);
        folderActionableDynamicQuery.performCount();
    }

    protected ActionableDynamicQuery getDLFileEntryTypeActionableDynamicQuery(final PortletDataContext portletDataContext) throws Exception {
        final Group companyGroup = GroupLocalServiceUtil.getCompanyGroup((long)portletDataContext.getCompanyId());
        return new DLFileEntryTypeExportActionableDynamicQuery(portletDataContext){

            protected void addCriteria(DynamicQuery dynamicQuery) {
                super.addCriteria(dynamicQuery);
                Property property = PropertyFactoryUtil.forName((String)"groupId");
                dynamicQuery.add(property.in((Object[])new Long[]{portletDataContext.getScopeGroupId(), companyGroup.getGroupId()}));
            }

            protected void performAction(Object object) throws PortalException {
                DLFileEntryType dlFileEntryType = (DLFileEntryType)object;
                if (dlFileEntryType.isExportable()) {
                    StagedModelDataHandlerUtil.exportStagedModel((PortletDataContext)portletDataContext, (StagedModel)dlFileEntryType);
                }
            }
        };
    }

    protected ActionableDynamicQuery getDLFileShortcutActionableDynamicQuery(PortletDataContext portletDataContext) throws Exception {
        return new DLFileShortcutExportActionableDynamicQuery(portletDataContext){

            protected void addCriteria(DynamicQuery dynamicQuery) {
                super.addCriteria(dynamicQuery);
                Property property = PropertyFactoryUtil.forName((String)"active");
                dynamicQuery.add(property.eq((Object)Boolean.TRUE));
            }
        };
    }

    protected ActionableDynamicQuery getFileEntryActionableDynamicQuery(final PortletDataContext portletDataContext) throws Exception {
        return new DLFileEntryExportActionableDynamicQuery(portletDataContext){

            protected String getManifestSummaryKey() {
                return FileEntry.class.getName();
            }

            protected void performAction(Object object) throws PortalException, SystemException {
                DLFileEntry dlFileEntry = (DLFileEntry)object;
                FileEntry fileEntry = DLAppLocalServiceUtil.getFileEntry((long)dlFileEntry.getFileEntryId());
                StagedModelDataHandlerUtil.exportStagedModel((PortletDataContext)portletDataContext, (StagedModel)fileEntry);
            }
        };
    }

    protected ActionableDynamicQuery getFolderActionableDynamicQuery(final PortletDataContext portletDataContext) throws Exception {
        return new DLFolderExportActionableDynamicQuery(portletDataContext){

            protected String getManifestSummaryKey() {
                return Folder.class.getName();
            }

            protected void performAction(Object object) throws PortalException, SystemException {
                DLFolder dlFolder = (DLFolder)object;
                Folder folder = DLAppLocalServiceUtil.getFolder((long)dlFolder.getFolderId());
                StagedModelDataHandlerUtil.exportStagedModel((PortletDataContext)portletDataContext, (StagedModel)folder);
            }
        };
    }
}

