/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.lar;

import com.liferay.portal.kernel.lar.BaseStagedModelDataHandler;
import com.liferay.portal.kernel.lar.ExportImportPathUtil;
import com.liferay.portal.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.model.ClassedModel;
import com.liferay.portal.model.StagedModel;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.documentlibrary.lar.FileEntryUtil;
import com.liferay.portlet.documentlibrary.lar.FolderUtil;
import com.liferay.portlet.documentlibrary.model.DLFileShortcut;
import com.liferay.portlet.documentlibrary.service.DLAppLocalServiceUtil;
import com.liferay.portlet.documentlibrary.service.persistence.DLFileShortcutUtil;
import java.util.Map;

public class DLFileShortcutStagedModelDataHandler
extends BaseStagedModelDataHandler<DLFileShortcut> {
    public static final String[] CLASS_NAMES = new String[]{DLFileShortcut.class.getName()};
    private static Log _log = LogFactoryUtil.getLog(DLFileShortcutStagedModelDataHandler.class);

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    public String getDisplayName(DLFileShortcut shortcut) {
        return shortcut.getToTitle();
    }

    protected void doExportStagedModel(PortletDataContext portletDataContext, DLFileShortcut fileShortcut) throws Exception {
        if (fileShortcut.getFolderId() != 0L) {
            StagedModelDataHandlerUtil.exportStagedModel((PortletDataContext)portletDataContext, (StagedModel)fileShortcut.getFolder());
        }
        FileEntry fileEntry = DLAppLocalServiceUtil.getFileEntry((long)fileShortcut.getToFileEntryId());
        StagedModelDataHandlerUtil.exportStagedModel((PortletDataContext)portletDataContext, (StagedModel)fileEntry);
        Element fileShortcutElement = portletDataContext.getExportDataElement((ClassedModel)fileShortcut);
        fileShortcutElement.addAttribute("file-entry-uuid", fileEntry.getUuid());
        portletDataContext.addClassedModel(fileShortcutElement, ExportImportPathUtil.getModelPath((StagedModel)fileShortcut), (ClassedModel)fileShortcut, "document_library");
    }

    protected void doImportStagedModel(PortletDataContext portletDataContext, DLFileShortcut fileShortcut) throws Exception {
        long userId = portletDataContext.getUserId(fileShortcut.getUserUuid());
        if (fileShortcut.getFolderId() != 0L) {
            String folderPath = ExportImportPathUtil.getModelPath((PortletDataContext)portletDataContext, (String)Folder.class.getName(), (long)fileShortcut.getFolderId());
            Folder folder = (Folder)portletDataContext.getZipEntryAsObject(folderPath);
            StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)portletDataContext, (StagedModel)folder);
        }
        Map folderIds = portletDataContext.getNewPrimaryKeysMap(Folder.class);
        long folderId = MapUtil.getLong((Map)folderIds, (long)fileShortcut.getFolderId(), (long)fileShortcut.getFolderId());
        long groupId = portletDataContext.getScopeGroupId();
        if (folderId != 0L) {
            Folder folder = FolderUtil.findByPrimaryKey(folderId);
            groupId = folder.getRepositoryId();
        }
        String fileEntryPath = ExportImportPathUtil.getModelPath((PortletDataContext)portletDataContext, (String)FileEntry.class.getName(), (long)fileShortcut.getToFileEntryId());
        FileEntry fileEntry = (FileEntry)portletDataContext.getZipEntryAsObject(fileEntryPath);
        StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)portletDataContext, (StagedModel)fileEntry);
        Element fileShortcutElement = portletDataContext.getImportDataStagedModelElement((StagedModel)fileShortcut);
        String fileEntryUuid = fileShortcutElement.attributeValue("file-entry-uuid");
        FileEntry importedFileEntry = FileEntryUtil.fetchByUUID_R(fileEntryUuid, groupId);
        if (importedFileEntry == null) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Unable to fetch file entry {uuid=" + fileEntryUuid + ", groupId=" + groupId + "}"));
            }
            return;
        }
        ServiceContext serviceContext = portletDataContext.createServiceContext((StagedModel)fileShortcut, "document_library");
        DLFileShortcut importedFileShortcut = null;
        if (portletDataContext.isDataStrategyMirror()) {
            DLFileShortcut existingFileShortcut = DLFileShortcutUtil.fetchByUUID_G((String)fileShortcut.getUuid(), (long)portletDataContext.getScopeGroupId());
            if (existingFileShortcut == null) {
                serviceContext.setUuid(fileShortcut.getUuid());
                importedFileShortcut = DLAppLocalServiceUtil.addFileShortcut((long)userId, (long)groupId, (long)folderId, (long)importedFileEntry.getFileEntryId(), (ServiceContext)serviceContext);
            } else {
                importedFileShortcut = DLAppLocalServiceUtil.updateFileShortcut((long)userId, (long)existingFileShortcut.getFileShortcutId(), (long)folderId, (long)importedFileEntry.getFileEntryId(), (ServiceContext)serviceContext);
            }
        } else {
            importedFileShortcut = DLAppLocalServiceUtil.addFileShortcut((long)userId, (long)groupId, (long)folderId, (long)importedFileEntry.getFileEntryId(), (ServiceContext)serviceContext);
        }
        portletDataContext.importClassedModel((ClassedModel)fileShortcut, (ClassedModel)importedFileShortcut, "document_library");
    }
}

