/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.lar;

import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.lar.DataLevel;
import com.liferay.portal.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.model.RepositoryEntry;
import com.liferay.portal.model.StagedModel;
import com.liferay.portlet.documentlibrary.lar.DLPortletDataHandler;
import com.liferay.portlet.documentlibrary.model.DLFileEntry;
import com.liferay.portlet.documentlibrary.model.DLFileEntryType;
import com.liferay.portlet.documentlibrary.model.DLFileShortcut;
import com.liferay.portlet.documentlibrary.model.DLFolder;
import com.liferay.portlet.documentlibrary.service.DLAppLocalServiceUtil;
import com.liferay.portlet.documentlibrary.service.DLFolderLocalServiceUtil;
import com.liferay.portlet.documentlibrary.service.persistence.DLFileEntryActionableDynamicQuery;
import com.liferay.portlet.documentlibrary.service.persistence.DLFolderActionableDynamicQuery;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.portlet.PortletPreferences;

public class DLDisplayPortletDataHandler
extends DLPortletDataHandler {
    public DLDisplayPortletDataHandler() {
        this.setDataLevel(DataLevel.PORTLET_INSTANCE);
    }

    @Override
    protected PortletPreferences doDeleteData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences) throws Exception {
        if (portletPreferences == null) {
            return portletPreferences;
        }
        portletPreferences.setValue("enable-comment-ratings", "");
        portletPreferences.setValue("fileEntriesPerPage", "");
        portletPreferences.setValue("fileEntryColumns", "");
        portletPreferences.setValue("folderColumns", "");
        portletPreferences.setValue("foldersPerPage", "");
        portletPreferences.setValue("rootFolderId", "");
        portletPreferences.setValue("showFoldersSearch", "");
        portletPreferences.setValue("showSubfolders", "");
        return portletPreferences;
    }

    @Override
    protected String doExportData(final PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences) throws Exception {
        portletDataContext.addPermissions("com.liferay.portlet.documentlibrary", portletDataContext.getScopeGroupId());
        Element rootElement = this.addExportDataRootElement(portletDataContext);
        rootElement.addAttribute("group-id", String.valueOf(portletDataContext.getScopeGroupId()));
        long rootFolderId = GetterUtil.getLong((String)portletPreferences.getValue("rootFolderId", null));
        if (rootFolderId == 0L) {
            DLFolderActionableDynamicQuery folderActionableDynamicQuery = new DLFolderActionableDynamicQuery(){

                protected void addCriteria(DynamicQuery dynamicQuery) {
                    portletDataContext.addDateRangeCriteria(dynamicQuery, "modifiedDate");
                }

                protected void performAction(Object object) throws PortalException, SystemException {
                    DLFolder dlFolder = (DLFolder)object;
                    Folder folder = DLAppLocalServiceUtil.getFolder((long)dlFolder.getFolderId());
                    StagedModelDataHandlerUtil.exportStagedModel((PortletDataContext)portletDataContext, (StagedModel)folder);
                }
            };
            folderActionableDynamicQuery.setGroupId(portletDataContext.getScopeGroupId());
            folderActionableDynamicQuery.performActions();
            DLFileEntryActionableDynamicQuery fileEntryActionableDynamicQuery = new DLFileEntryActionableDynamicQuery(){

                protected void addCriteria(DynamicQuery dynamicQuery) {
                    portletDataContext.addDateRangeCriteria(dynamicQuery, "modifiedDate");
                }

                protected void performAction(Object object) throws PortalException, SystemException {
                    DLFileEntry dlFileEntry = (DLFileEntry)object;
                    FileEntry fileEntry = DLAppLocalServiceUtil.getFileEntry((long)dlFileEntry.getFileEntryId());
                    StagedModelDataHandlerUtil.exportStagedModel((PortletDataContext)portletDataContext, (StagedModel)fileEntry);
                }
            };
            fileEntryActionableDynamicQuery.setGroupId(portletDataContext.getScopeGroupId());
            fileEntryActionableDynamicQuery.performActions();
            return this.getExportDataRootElementString(rootElement);
        }
        Folder rootFolder = DLAppLocalServiceUtil.getFolder((long)rootFolderId);
        rootElement.addAttribute("root-folder-id", String.valueOf(rootFolder.getFolderId()));
        rootElement.addAttribute("default-repository", String.valueOf(rootFolder.isDefaultRepository()));
        final ArrayList<Long> folderIds = new ArrayList<Long>();
        DLFolderLocalServiceUtil.getSubfolderIds(folderIds, (long)portletDataContext.getScopeGroupId(), (long)rootFolderId);
        folderIds.add(rootFolderId);
        Iterator iterator = folderIds.iterator();
        while (iterator.hasNext()) {
            long folderId = (Long)iterator.next();
            Folder folder = DLAppLocalServiceUtil.getFolder((long)folderId);
            StagedModelDataHandlerUtil.exportStagedModel((PortletDataContext)portletDataContext, (StagedModel)folder);
        }
        DLFileEntryActionableDynamicQuery fileEntryActionableDynamicQuery = new DLFileEntryActionableDynamicQuery(){

            protected void addCriteria(DynamicQuery dynamicQuery) {
                portletDataContext.addDateRangeCriteria(dynamicQuery, "modifiedDate");
                Property property = PropertyFactoryUtil.forName((String)"folderId");
                Object[] folderIdsArray = folderIds.toArray(new Long[folderIds.size()]);
                dynamicQuery.add(property.in(folderIdsArray));
            }

            protected void performAction(Object object) throws PortalException, SystemException {
                DLFileEntry dlFileEntry = (DLFileEntry)object;
                FileEntry fileEntry = DLAppLocalServiceUtil.getFileEntry((long)dlFileEntry.getFileEntryId());
                StagedModelDataHandlerUtil.exportStagedModel((PortletDataContext)portletDataContext, (StagedModel)fileEntry);
            }
        };
        fileEntryActionableDynamicQuery.setGroupId(portletDataContext.getScopeGroupId());
        fileEntryActionableDynamicQuery.performActions();
        return this.getExportDataRootElementString(rootElement);
    }

    @Override
    protected PortletPreferences doImportData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences, String data) throws Exception {
        portletDataContext.importPermissions("com.liferay.portlet.documentlibrary", portletDataContext.getSourceGroupId(), portletDataContext.getScopeGroupId());
        Element fileEntryTypesElement = portletDataContext.getImportDataGroupElement(DLFileEntryType.class);
        List fileEntryTypeElements = fileEntryTypesElement.elements();
        for (Element fileEntryTypeElement : fileEntryTypeElements) {
            StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)portletDataContext, (Element)fileEntryTypeElement);
        }
        Element foldersElement = portletDataContext.getImportDataGroupElement(Folder.class);
        List folderElements = foldersElement.elements();
        for (Element folderElement : folderElements) {
            StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)portletDataContext, (Element)folderElement);
        }
        Element fileEntriesElement = portletDataContext.getImportDataGroupElement(FileEntry.class);
        List fileEntryElements = fileEntriesElement.elements();
        for (Element fileEntryElement : fileEntryElements) {
            StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)portletDataContext, (Element)fileEntryElement);
        }
        if (portletDataContext.getBooleanParameter("document_library", "shortcuts")) {
            Element fileShortcutsElement = portletDataContext.getImportDataGroupElement(DLFileShortcut.class);
            List fileShortcutElements = fileShortcutsElement.elements();
            for (Element fileShortcutElement : fileShortcutElements) {
                StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)portletDataContext, (Element)fileShortcutElement);
            }
        }
        Element rootElement = portletDataContext.getImportDataRootElement();
        long rootFolderId = GetterUtil.getLong((String)rootElement.attributeValue("root-folder-id"));
        boolean defaultRepository = GetterUtil.getBoolean((String)rootElement.attributeValue("default-repository"), (boolean)true);
        if (rootFolderId <= 0L) {
            return portletPreferences;
        }
        Map folderIds = null;
        folderIds = defaultRepository ? portletDataContext.getNewPrimaryKeysMap(Folder.class) : portletDataContext.getNewPrimaryKeysMap(RepositoryEntry.class);
        rootFolderId = MapUtil.getLong((Map)folderIds, (long)rootFolderId, (long)rootFolderId);
        portletPreferences.setValue("rootFolderId", String.valueOf(rootFolderId));
        return portletPreferences;
    }
}

