/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.antivirus;

import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portlet.documentlibrary.antivirus.AntivirusScannerException;
import com.liferay.portlet.documentlibrary.antivirus.BaseFileAntivirusScanner;
import java.io.File;
import java.io.IOException;

public class ClamAntivirusScannerImpl
extends BaseFileAntivirusScanner {
    public void scan(File file) throws AntivirusScannerException, SystemException {
        ProcessBuilder processBuilder = new ProcessBuilder("clamscan", "--stdout", "--no-summary", file.getAbsolutePath());
        processBuilder.redirectErrorStream(true);
        Process process = null;
        try {
            try {
                process = processBuilder.start();
                process.waitFor();
                int exitValue = process.exitValue();
                if (exitValue == 1) {
                    throw new AntivirusScannerException("Virus detected in " + file.getAbsolutePath());
                }
                if (exitValue >= 2) {
                    throw new AntivirusScannerException("Unable to scan file due to inability to execute antivirus process");
                }
            }
            catch (IOException ioe) {
                throw new SystemException("Unable to scan file", (Throwable)ioe);
            }
            catch (InterruptedException ie) {
                throw new SystemException("Unable to scan file", (Throwable)ie);
            }
        }
        finally {
            if (process != null) {
                process.destroy();
            }
        }
    }
}

