/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.action;

import com.liferay.portal.kernel.portlet.DefaultConfigurationAction;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portlet.documentlibrary.NoSuchFolderException;
import com.liferay.portlet.documentlibrary.service.DLAppLocalServiceUtil;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;

public class ConfigurationActionImpl
extends DefaultConfigurationAction {
    public void processAction(PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        String tabs2 = ParamUtil.getString((PortletRequest)actionRequest, (String)"tabs2");
        if (Validator.isNotNull((String)cmd)) {
            if (tabs2.equals("display-settings")) {
                this.validateRootFolder(actionRequest);
            } else if (tabs2.equals("document-added-email")) {
                this.validateEmailFileEntryAdded(actionRequest);
            } else if (tabs2.equals("document-updated-email")) {
                this.validateEmailFileEntryUpdated(actionRequest);
            } else if (tabs2.equals("email-from")) {
                this.validateEmailFrom(actionRequest);
            }
        }
        super.processAction(portletConfig, actionRequest, actionResponse);
    }

    protected void validateEmailFileEntryAdded(ActionRequest actionRequest) throws Exception {
        String emailFileEntryAddedSubject = this.getLocalizedParameter((PortletRequest)actionRequest, "emailFileEntryAddedSubject");
        String emailFileEntryAddedBody = this.getLocalizedParameter((PortletRequest)actionRequest, "emailFileEntryAddedBody");
        if (Validator.isNull((String)emailFileEntryAddedSubject)) {
            SessionErrors.add((PortletRequest)actionRequest, (String)"emailFileEntryAddedSubject");
        } else if (Validator.isNull((String)emailFileEntryAddedBody)) {
            SessionErrors.add((PortletRequest)actionRequest, (String)"emailFileEntryAddedBody");
        }
    }

    protected void validateEmailFileEntryUpdated(ActionRequest actionRequest) throws Exception {
        String emailFileEntryUpdatedSubject = this.getLocalizedParameter((PortletRequest)actionRequest, "emailFileEntryUpdatedSubject");
        String emailFileEntryUpdatedBody = this.getLocalizedParameter((PortletRequest)actionRequest, "emailFileEntryUpdatedBody");
        if (Validator.isNull((String)emailFileEntryUpdatedSubject)) {
            SessionErrors.add((PortletRequest)actionRequest, (String)"emailFileEntryUpdatedSubject");
        } else if (Validator.isNull((String)emailFileEntryUpdatedBody)) {
            SessionErrors.add((PortletRequest)actionRequest, (String)"emailFileEntryUpdatedBody");
        }
    }

    protected void validateEmailFrom(ActionRequest actionRequest) throws Exception {
        String emailFromName = this.getParameter((PortletRequest)actionRequest, "emailFromName");
        String emailFromAddress = this.getParameter((PortletRequest)actionRequest, "emailFromAddress");
        if (Validator.isNull((String)emailFromName)) {
            SessionErrors.add((PortletRequest)actionRequest, (String)"emailFromName");
        } else if (!Validator.isEmailAddress((String)emailFromAddress) && !Validator.isVariableTerm((String)emailFromAddress)) {
            SessionErrors.add((PortletRequest)actionRequest, (String)"emailFromAddress");
        }
    }

    protected void validateRootFolder(ActionRequest actionRequest) throws Exception {
        long rootFolderId = GetterUtil.getLong((String)this.getParameter((PortletRequest)actionRequest, "rootFolderId"));
        if (rootFolderId != 0L) {
            try {
                DLAppLocalServiceUtil.getFolder((long)rootFolderId);
            }
            catch (NoSuchFolderException noSuchFolderException) {
                SessionErrors.add((PortletRequest)actionRequest, (String)"rootFolderIdInvalid");
            }
        }
    }
}

