/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.action;

import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Repository;
import com.liferay.portal.service.RepositoryServiceUtil;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.documentlibrary.NoSuchFileEntryException;
import com.liferay.portlet.documentlibrary.NoSuchFolderException;
import com.liferay.portlet.documentlibrary.model.DLFileShortcut;
import com.liferay.portlet.documentlibrary.model.DLFolder;
import com.liferay.portlet.documentlibrary.service.DLAppServiceUtil;
import com.liferay.portlet.documentlibrary.service.permission.DLPermission;
import com.liferay.portlet.documentlibrary.util.RawMetadataProcessorUtil;
import java.util.ArrayList;
import javax.portlet.PortletRequest;
import javax.servlet.http.HttpServletRequest;

public class ActionUtil {
    public static void getFileEntries(HttpServletRequest request) throws Exception {
        long[] fileEntryIds;
        ArrayList<FileEntry> fileEntries = new ArrayList<FileEntry>();
        long[] lArray = fileEntryIds = StringUtil.split((String)ParamUtil.getString((HttpServletRequest)request, (String)"fileEntryIds"), (long)0L);
        int n = fileEntryIds.length;
        int n2 = 0;
        while (n2 < n) {
            long fileEntryId = lArray[n2];
            try {
                FileEntry fileEntry = DLAppServiceUtil.getFileEntry((long)fileEntryId);
                fileEntries.add(fileEntry);
            }
            catch (NoSuchFileEntryException noSuchFileEntryException) {}
            ++n2;
        }
        request.setAttribute("DOCUMENT_LIBRARY_FILE_ENTRIES", fileEntries);
    }

    public static void getFileEntries(PortletRequest portletRequest) throws Exception {
        HttpServletRequest request = PortalUtil.getHttpServletRequest((PortletRequest)portletRequest);
        ActionUtil.getFileEntries(request);
    }

    public static void getFileEntry(HttpServletRequest request) throws Exception {
        long fileEntryId = ParamUtil.getLong((HttpServletRequest)request, (String)"fileEntryId");
        FileEntry fileEntry = null;
        if (fileEntryId > 0L) {
            fileEntry = DLAppServiceUtil.getFileEntry((long)fileEntryId);
        }
        request.setAttribute("DOCUMENT_LIBRARY_FILE_ENTRY", (Object)fileEntry);
        String version = ParamUtil.getString((HttpServletRequest)request, (String)"version");
        if (fileEntry == null) {
            return;
        }
        FileVersion fileVersion = null;
        if (Validator.isNotNull((String)version)) {
            fileVersion = fileEntry.getFileVersion(version);
            request.setAttribute("DOCUMENT_LIBRARY_FILE_VERSION", (Object)fileVersion);
        } else {
            fileVersion = fileEntry.getFileVersion();
        }
        RawMetadataProcessorUtil.generateMetadata((FileVersion)fileVersion);
        String cmd = ParamUtil.getString((HttpServletRequest)request, (String)"cmd");
        if ((fileVersion.isInTrash() || fileVersion.isInTrashContainer()) && !cmd.equals("move_from_trash")) {
            throw new NoSuchFileEntryException();
        }
    }

    public static void getFileEntry(PortletRequest portletRequest) throws Exception {
        HttpServletRequest request = PortalUtil.getHttpServletRequest((PortletRequest)portletRequest);
        ActionUtil.getFileEntry(request);
    }

    public static void getFileShortcut(HttpServletRequest request) throws Exception {
        long fileShortcutId = ParamUtil.getLong((HttpServletRequest)request, (String)"fileShortcutId");
        DLFileShortcut fileShortcut = null;
        if (fileShortcutId > 0L) {
            fileShortcut = DLAppServiceUtil.getFileShortcut((long)fileShortcutId);
        }
        request.setAttribute("DOCUMENT_LIBRARY_FILE_SHORTCUT", (Object)fileShortcut);
    }

    public static void getFileShortcut(PortletRequest portletRequest) throws Exception {
        HttpServletRequest request = PortalUtil.getHttpServletRequest((PortletRequest)portletRequest);
        ActionUtil.getFileShortcut(request);
    }

    public static void getFileShortcuts(HttpServletRequest request) throws Exception {
        long[] fileShortcutIds = StringUtil.split((String)ParamUtil.getString((HttpServletRequest)request, (String)"fileShortcutIds"), (long)0L);
        ArrayList<DLFileShortcut> fileShortcuts = new ArrayList<DLFileShortcut>();
        long[] lArray = fileShortcutIds;
        int n = fileShortcutIds.length;
        int n2 = 0;
        while (n2 < n) {
            long fileShortcutId = lArray[n2];
            if (fileShortcutId > 0L) {
                fileShortcuts.add(DLAppServiceUtil.getFileShortcut((long)fileShortcutId));
            }
            ++n2;
        }
        request.setAttribute("DOCUMENT_LIBRARY_FILE_SHORTCUTS", fileShortcuts);
    }

    public static void getFileShortcuts(PortletRequest portletRequest) throws Exception {
        HttpServletRequest request = PortalUtil.getHttpServletRequest((PortletRequest)portletRequest);
        ActionUtil.getFileShortcuts(request);
    }

    public static void getFolder(HttpServletRequest request) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long folderId = ParamUtil.getLong((HttpServletRequest)request, (String)"folderId");
        Folder folder = null;
        if (folderId > 0L && folderId != 0L) {
            DLFolder dlFolder;
            folder = DLAppServiceUtil.getFolder((long)folderId);
            if (folder.getModel() instanceof DLFolder && ((dlFolder = (DLFolder)folder.getModel()).isInTrash() || dlFolder.isInTrashContainer())) {
                throw new NoSuchFolderException();
            }
        } else {
            DLPermission.check(themeDisplay.getPermissionChecker(), themeDisplay.getScopeGroupId(), "VIEW");
        }
        request.setAttribute("DOCUMENT_LIBRARY_FOLDER", (Object)folder);
    }

    public static void getFolder(PortletRequest portletRequest) throws Exception {
        HttpServletRequest request = PortalUtil.getHttpServletRequest((PortletRequest)portletRequest);
        ActionUtil.getFolder(request);
    }

    public static void getFolders(HttpServletRequest request) throws Exception {
        long[] folderIds = StringUtil.split((String)ParamUtil.getString((HttpServletRequest)request, (String)"folderIds"), (long)0L);
        ArrayList<Folder> folders = new ArrayList<Folder>();
        long[] lArray = folderIds;
        int n = folderIds.length;
        int n2 = 0;
        while (n2 < n) {
            long folderId = lArray[n2];
            try {
                Folder folder = DLAppServiceUtil.getFolder((long)folderId);
                folders.add(folder);
            }
            catch (NoSuchFolderException noSuchFolderException) {}
            ++n2;
        }
        request.setAttribute("DOCUMENT_LIBRARY_FOLDERS", folders);
    }

    public static void getFolders(PortletRequest portletRequest) throws Exception {
        HttpServletRequest request = PortalUtil.getHttpServletRequest((PortletRequest)portletRequest);
        ActionUtil.getFolders(request);
    }

    public static void getRepository(HttpServletRequest request) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long repositoryId = ParamUtil.getLong((HttpServletRequest)request, (String)"repositoryId");
        Repository repository = null;
        if (repositoryId > 0L) {
            repository = RepositoryServiceUtil.getRepository((long)repositoryId);
        } else {
            DLPermission.check(themeDisplay.getPermissionChecker(), themeDisplay.getScopeGroupId(), "VIEW");
        }
        request.setAttribute("DOCUMENT_LIBRARY_REPOSITORY", (Object)repository);
    }

    public static void getRepository(PortletRequest portletRequest) throws Exception {
        HttpServletRequest request = PortalUtil.getHttpServletRequest((PortletRequest)portletRequest);
        ActionUtil.getRepository(request);
    }
}

