/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.calendar.social;

import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.calendar.model.CalEvent;
import com.liferay.portlet.calendar.service.CalEventLocalServiceUtil;
import com.liferay.portlet.calendar.service.permission.CalEventPermission;
import com.liferay.portlet.social.model.BaseSocialActivityInterpreter;
import com.liferay.portlet.social.model.SocialActivity;

public class CalendarActivityInterpreter
extends BaseSocialActivityInterpreter {
    private static final String[] _CLASS_NAMES = new String[]{CalEvent.class.getName()};

    public String[] getClassNames() {
        return _CLASS_NAMES;
    }

    protected String getEntryTitle(SocialActivity activity, ServiceContext serviceContext) throws Exception {
        CalEvent event = CalEventLocalServiceUtil.getEvent((long)activity.getClassPK());
        return event.getTitle();
    }

    protected String getPath(SocialActivity activity, ServiceContext serviceContext) {
        StringBundler sb = new StringBundler(4);
        sb.append("/calendar/find_event?redirect=");
        sb.append(HtmlUtil.escapeURL((String)serviceContext.getCurrentURL()));
        sb.append("&eventId=");
        sb.append(activity.getClassPK());
        return sb.toString();
    }

    protected String getTitlePattern(String groupName, SocialActivity activity) {
        int activityType = activity.getType();
        if (activityType == 1) {
            if (Validator.isNull((String)groupName)) {
                return "activity-calendar-event-add-event";
            }
            return "activity-calendar-event-add-event-in";
        }
        if (activityType == 2) {
            if (Validator.isNull((String)groupName)) {
                return "activity-calendar-event-update-event";
            }
            return "activity-calendar-event-update-event-in";
        }
        return "";
    }

    protected boolean hasPermissions(PermissionChecker permissionChecker, SocialActivity activity, String actionId, ServiceContext serviceContext) throws Exception {
        return CalEventPermission.contains(permissionChecker, activity.getClassPK(), actionId);
    }
}

