/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.bookmarks.util;

import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.search.BaseIndexer;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.BooleanQueryFactoryUtil;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchEngineUtil;
import com.liferay.portal.kernel.search.Summary;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.Group;
import com.liferay.portal.service.persistence.GroupActionableDynamicQuery;
import com.liferay.portlet.bookmarks.model.BookmarksEntry;
import com.liferay.portlet.bookmarks.model.BookmarksFolder;
import com.liferay.portlet.bookmarks.service.BookmarksEntryLocalServiceUtil;
import com.liferay.portlet.bookmarks.service.BookmarksFolderServiceUtil;
import com.liferay.portlet.bookmarks.service.persistence.BookmarksEntryActionableDynamicQuery;
import com.liferay.portlet.bookmarks.service.persistence.BookmarksFolderActionableDynamicQuery;
import java.util.ArrayList;
import java.util.Locale;
import javax.portlet.PortletURL;

public class BookmarksEntryIndexer
extends BaseIndexer {
    public static final String[] CLASS_NAMES = new String[]{BookmarksEntry.class.getName()};
    public static final String PORTLET_ID = "28";

    public BookmarksEntryIndexer() {
        this.setPermissionAware(true);
    }

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    public String getPortletId() {
        return PORTLET_ID;
    }

    public void postProcessContextQuery(BooleanQuery contextQuery, SearchContext searchContext) throws Exception {
        long[] folderIds;
        int status = GetterUtil.getInteger((Object)searchContext.getAttribute("status"), (int)0);
        if (status != -1) {
            contextQuery.addRequiredTerm("status", status);
        }
        if ((folderIds = searchContext.getFolderIds()) != null && folderIds.length > 0 && folderIds[0] != 0L) {
            BooleanQuery folderIdsQuery = BooleanQueryFactoryUtil.create((SearchContext)searchContext);
            long[] lArray = folderIds;
            int n = folderIds.length;
            int n2 = 0;
            while (n2 < n) {
                block5: {
                    long folderId = lArray[n2];
                    try {
                        BookmarksFolderServiceUtil.getFolder((long)folderId);
                    }
                    catch (Exception exception) {
                        break block5;
                    }
                    folderIdsQuery.addTerm("folderId", folderId);
                }
                ++n2;
            }
            contextQuery.add((Query)folderIdsQuery, BooleanClauseOccur.MUST);
        }
    }

    protected void doDelete(Object obj) throws Exception {
        BookmarksEntry entry = (BookmarksEntry)obj;
        this.deleteDocument(entry.getCompanyId(), entry.getEntryId());
    }

    protected Document doGetDocument(Object obj) throws Exception {
        BookmarksEntry entry = (BookmarksEntry)obj;
        Document document = this.getBaseModelDocument(PORTLET_ID, (BaseModel)entry);
        document.addText("description", entry.getDescription());
        document.addKeyword("folderId", entry.getFolderId());
        document.addText("title", entry.getName());
        document.addText("url", entry.getUrl());
        if (!entry.isInTrash() && entry.isInTrashContainer()) {
            BookmarksFolder folder = entry.getTrashContainer();
            this.addTrashFields(document, BookmarksFolder.class.getName(), folder.getFolderId(), null, null, "bookmark");
            document.addKeyword("rootEntryClassName", BookmarksFolder.class.getName());
            document.addKeyword("rootEntryClassPK", folder.getFolderId());
            document.addKeyword("status", 8);
        }
        return document;
    }

    protected Summary doGetSummary(Document document, Locale locale, String snippet, PortletURL portletURL) {
        String entryId = document.get("entryClassPK");
        portletURL.setParameter("struts_action", "/bookmarks/view_entry");
        portletURL.setParameter("entryId", entryId);
        Summary summary = this.createSummary(document, "title", "url");
        summary.setPortletURL(portletURL);
        return summary;
    }

    protected void doReindex(Object obj) throws Exception {
        BookmarksEntry entry = (BookmarksEntry)obj;
        Document document = this.getDocument(entry);
        SearchEngineUtil.updateDocument((String)this.getSearchEngineId(), (long)entry.getCompanyId(), (Document)document);
    }

    protected void doReindex(String className, long classPK) throws Exception {
        BookmarksEntry entry = BookmarksEntryLocalServiceUtil.getEntry((long)classPK);
        this.doReindex(entry);
    }

    protected void doReindex(String[] ids) throws Exception {
        long companyId = GetterUtil.getLong((String)ids[0]);
        this.reindexFolders(companyId);
        this.reindexRoot(companyId);
    }

    protected String getPortletId(SearchContext searchContext) {
        return PORTLET_ID;
    }

    protected void reindexEntries(long companyId, long groupId, final long folderId) throws PortalException, SystemException {
        final ArrayList documents = new ArrayList();
        BookmarksEntryActionableDynamicQuery actionableDynamicQuery = new BookmarksEntryActionableDynamicQuery(){

            protected void addCriteria(DynamicQuery dynamicQuery) {
                Property folderIdProperty = PropertyFactoryUtil.forName((String)"folderId");
                dynamicQuery.add(folderIdProperty.eq((Object)folderId));
                Property statusProperty = PropertyFactoryUtil.forName((String)"status");
                Object[] statuses = new Integer[]{0, 8};
                dynamicQuery.add(statusProperty.in(statuses));
            }

            protected void performAction(Object object) throws PortalException {
                BookmarksEntry entry = (BookmarksEntry)object;
                Document document = BookmarksEntryIndexer.this.getDocument(entry);
                documents.add(document);
            }
        };
        actionableDynamicQuery.setGroupId(groupId);
        actionableDynamicQuery.performActions();
        SearchEngineUtil.updateDocuments((String)this.getSearchEngineId(), (long)companyId, documents);
    }

    protected void reindexFolders(final long companyId) throws PortalException, SystemException {
        BookmarksFolderActionableDynamicQuery actionableDynamicQuery = new BookmarksFolderActionableDynamicQuery(){

            protected void performAction(Object object) throws PortalException, SystemException {
                BookmarksFolder folder = (BookmarksFolder)object;
                long groupId = folder.getGroupId();
                long folderId = folder.getFolderId();
                BookmarksEntryIndexer.this.reindexEntries(companyId, groupId, folderId);
            }
        };
        actionableDynamicQuery.setCompanyId(companyId);
        actionableDynamicQuery.performActions();
    }

    protected void reindexRoot(final long companyId) throws PortalException, SystemException {
        GroupActionableDynamicQuery actionableDynamicQuery = new GroupActionableDynamicQuery(){

            protected void performAction(Object object) throws PortalException, SystemException {
                Group group = (Group)object;
                long groupId = group.getGroupId();
                long folderId = 0L;
                BookmarksEntryIndexer.this.reindexEntries(companyId, groupId, folderId);
            }
        };
        actionableDynamicQuery.setCompanyId(companyId);
        actionableDynamicQuery.performActions();
    }
}

