/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.bookmarks.trash;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.model.ContainerModel;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.bookmarks.model.BookmarksEntry;
import com.liferay.portlet.bookmarks.model.BookmarksFolder;
import com.liferay.portlet.bookmarks.service.BookmarksEntryLocalServiceUtil;
import com.liferay.portlet.bookmarks.service.permission.BookmarksEntryPermission;
import com.liferay.portlet.bookmarks.trash.BookmarksBaseTrashHandler;
import com.liferay.portlet.bookmarks.util.BookmarksUtil;
import javax.portlet.PortletRequest;

public class BookmarksEntryTrashHandler
extends BookmarksBaseTrashHandler {
    public void deleteTrashEntry(long classPK) throws PortalException, SystemException {
        BookmarksEntryLocalServiceUtil.deleteEntry((long)classPK);
    }

    public String getClassName() {
        return BookmarksEntry.class.getName();
    }

    public ContainerModel getParentContainerModel(long classPK) throws PortalException, SystemException {
        BookmarksEntry entry = BookmarksEntryLocalServiceUtil.getEntry((long)classPK);
        long parentFolderId = entry.getFolderId();
        if (parentFolderId <= 0L) {
            return null;
        }
        return this.getContainerModel(parentFolderId);
    }

    public String getRestoreLink(PortletRequest portletRequest, long classPK) throws PortalException, SystemException {
        BookmarksEntry entry = BookmarksEntryLocalServiceUtil.getEntry((long)classPK);
        return BookmarksUtil.getControlPanelLink(portletRequest, entry.getFolderId());
    }

    public String getRestoreMessage(PortletRequest portletRequest, long classPK) throws PortalException, SystemException {
        BookmarksEntry entry = BookmarksEntryLocalServiceUtil.getEntry((long)classPK);
        return BookmarksUtil.getAbsolutePath(portletRequest, entry.getFolderId());
    }

    public ContainerModel getTrashContainer(long classPK) throws PortalException, SystemException {
        BookmarksEntry entry = BookmarksEntryLocalServiceUtil.getEntry((long)classPK);
        return entry.getTrashContainer();
    }

    public boolean hasTrashPermission(PermissionChecker permissionChecker, long groupId, long classPK, String trashActionId) throws PortalException, SystemException {
        if (trashActionId.equals("MOVE")) {
            return true;
        }
        return super.hasTrashPermission(permissionChecker, groupId, classPK, trashActionId);
    }

    public boolean isInTrash(long classPK) throws PortalException, SystemException {
        BookmarksEntry entry = BookmarksEntryLocalServiceUtil.getEntry((long)classPK);
        return entry.isInTrash();
    }

    public boolean isInTrashContainer(long classPK) throws PortalException, SystemException {
        BookmarksEntry entry = BookmarksEntryLocalServiceUtil.getEntry((long)classPK);
        return entry.isInTrashContainer();
    }

    public boolean isRestorable(long classPK) throws PortalException, SystemException {
        BookmarksEntry entry = BookmarksEntryLocalServiceUtil.getEntry((long)classPK);
        return !entry.isInTrashContainer();
    }

    public void moveEntry(long userId, long classPK, long containerModelId, ServiceContext serviceContext) throws PortalException, SystemException {
        BookmarksEntryLocalServiceUtil.moveEntry((long)classPK, (long)containerModelId);
    }

    public void moveTrashEntry(long userId, long classPK, long containerId, ServiceContext serviceContext) throws PortalException, SystemException {
        BookmarksEntryLocalServiceUtil.moveEntryFromTrash((long)userId, (long)classPK, (long)containerId);
    }

    public void restoreTrashEntry(long userId, long classPK) throws PortalException, SystemException {
        BookmarksEntryLocalServiceUtil.restoreEntryFromTrash((long)userId, (long)classPK);
    }

    @Override
    protected BookmarksFolder getBookmarksFolder(long classPK) throws PortalException, SystemException {
        BookmarksEntry entry = BookmarksEntryLocalServiceUtil.getEntry((long)classPK);
        return entry.getFolder();
    }

    protected boolean hasPermission(PermissionChecker permissionChecker, long classPK, String actionId) throws PortalException, SystemException {
        BookmarksEntry entry = BookmarksEntryLocalServiceUtil.getEntry((long)classPK);
        return BookmarksEntryPermission.contains(permissionChecker, entry, actionId);
    }
}

