/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.bookmarks.service.impl;

import com.liferay.portal.kernel.dao.orm.QueryDefinition;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.bookmarks.model.BookmarksFolder;
import com.liferay.portlet.bookmarks.service.base.BookmarksFolderServiceBaseImpl;
import com.liferay.portlet.bookmarks.service.permission.BookmarksFolderPermission;
import java.util.ArrayList;
import java.util.List;

public class BookmarksFolderServiceImpl
extends BookmarksFolderServiceBaseImpl {
    public BookmarksFolder addFolder(long parentFolderId, String name, String description, ServiceContext serviceContext) throws PortalException, SystemException {
        BookmarksFolderPermission.check(this.getPermissionChecker(), serviceContext.getScopeGroupId(), parentFolderId, "ADD_FOLDER");
        return this.bookmarksFolderLocalService.addFolder(this.getUserId(), parentFolderId, name, description, serviceContext);
    }

    public void deleteFolder(long folderId) throws PortalException, SystemException {
        BookmarksFolder folder = this.bookmarksFolderLocalService.getFolder(folderId);
        BookmarksFolderPermission.check(this.getPermissionChecker(), folder, "DELETE");
        this.bookmarksFolderLocalService.deleteFolder(folderId);
    }

    public void deleteFolder(long folderId, boolean includeTrashedEntries) throws PortalException, SystemException {
        BookmarksFolder folder = this.bookmarksFolderLocalService.getFolder(folderId);
        BookmarksFolderPermission.check(this.getPermissionChecker(), folder, "DELETE");
        this.bookmarksFolderLocalService.deleteFolder(folderId, includeTrashedEntries);
    }

    public BookmarksFolder getFolder(long folderId) throws PortalException, SystemException {
        BookmarksFolder folder = this.bookmarksFolderLocalService.getFolder(folderId);
        BookmarksFolderPermission.check(this.getPermissionChecker(), folder, "VIEW");
        return folder;
    }

    public List<Long> getFolderIds(long groupId, long folderId) throws PortalException, SystemException {
        BookmarksFolderPermission.check(this.getPermissionChecker(), groupId, folderId, "VIEW");
        List<Long> folderIds = this.getSubfolderIds(groupId, folderId, true);
        folderIds.add(0, folderId);
        return folderIds;
    }

    public List<BookmarksFolder> getFolders(long groupId) throws SystemException {
        return this.bookmarksFolderPersistence.filterFindByGroupId(groupId);
    }

    public List<BookmarksFolder> getFolders(long groupId, long parentFolderId) throws SystemException {
        return this.bookmarksFolderPersistence.filterFindByG_P_S(groupId, parentFolderId, 0);
    }

    public List<BookmarksFolder> getFolders(long groupId, long parentFolderId, int start, int end) throws SystemException {
        return this.getFolders(groupId, parentFolderId, 0, start, end);
    }

    public List<BookmarksFolder> getFolders(long groupId, long parentFolderId, int status, int start, int end) throws SystemException {
        if (status == -1) {
            return this.bookmarksFolderPersistence.filterFindByG_P(groupId, parentFolderId, start, end);
        }
        return this.bookmarksFolderPersistence.filterFindByG_P_S(groupId, parentFolderId, status, start, end);
    }

    public List<Object> getFoldersAndEntries(long groupId, long folderId) throws SystemException {
        return this.getFoldersAndEntries(groupId, folderId, -1);
    }

    public List<Object> getFoldersAndEntries(long groupId, long folderId, int status) throws SystemException {
        QueryDefinition queryDefinition = new QueryDefinition(status);
        return this.bookmarksFolderFinder.filterFindBF_E_ByG_F(groupId, folderId, queryDefinition);
    }

    public List<Object> getFoldersAndEntries(long groupId, long folderId, int status, int start, int end) throws SystemException {
        QueryDefinition queryDefinition = new QueryDefinition(status, start, end, null);
        return this.bookmarksFolderFinder.filterFindBF_E_ByG_F(groupId, folderId, queryDefinition);
    }

    public int getFoldersAndEntriesCount(long groupId, long folderId) throws SystemException {
        return this.getFoldersAndEntriesCount(groupId, folderId, -1);
    }

    public int getFoldersAndEntriesCount(long groupId, long folderId, int status) throws SystemException {
        QueryDefinition queryDefinition = new QueryDefinition(status);
        return this.bookmarksFolderFinder.filterCountF_E_ByG_F(groupId, folderId, queryDefinition);
    }

    public int getFoldersCount(long groupId, long parentFolderId) throws SystemException {
        return this.getFoldersCount(groupId, parentFolderId, 0);
    }

    public int getFoldersCount(long groupId, long parentFolderId, int status) throws SystemException {
        if (status == -1) {
            return this.bookmarksFolderPersistence.filterCountByG_P(groupId, parentFolderId);
        }
        return this.bookmarksFolderPersistence.filterCountByG_P_S(groupId, parentFolderId, status);
    }

    public void getSubfolderIds(List<Long> folderIds, long groupId, long folderId) throws SystemException {
        List folders = this.bookmarksFolderPersistence.filterFindByG_P_S(groupId, folderId, 0);
        for (BookmarksFolder folder : folders) {
            if (folder.isInTrashContainer()) continue;
            folderIds.add(folder.getFolderId());
            this.getSubfolderIds(folderIds, folder.getGroupId(), folder.getFolderId());
        }
    }

    public List<Long> getSubfolderIds(long groupId, long folderId, boolean recurse) throws SystemException {
        ArrayList<Long> folderIds = new ArrayList<Long>();
        this.getSubfolderIds(folderIds, groupId, folderId);
        return folderIds;
    }

    public BookmarksFolder moveFolder(long folderId, long parentFolderId) throws PortalException, SystemException {
        BookmarksFolder folder = this.bookmarksFolderLocalService.getFolder(folderId);
        BookmarksFolderPermission.check(this.getPermissionChecker(), folder, "UPDATE");
        return this.bookmarksFolderLocalService.moveFolder(folderId, parentFolderId);
    }

    public BookmarksFolder moveFolderFromTrash(long folderId, long parentFolderId) throws PortalException, SystemException {
        BookmarksFolder folder = this.bookmarksFolderLocalService.getFolder(folderId);
        BookmarksFolderPermission.check(this.getPermissionChecker(), folder, "UPDATE");
        return this.bookmarksFolderLocalService.moveFolderFromTrash(this.getUserId(), folderId, parentFolderId);
    }

    public void moveFolderToTrash(long folderId) throws PortalException, SystemException {
        BookmarksFolder folder = this.bookmarksFolderLocalService.getFolder(folderId);
        BookmarksFolderPermission.check(this.getPermissionChecker(), folder, "DELETE");
        this.bookmarksFolderLocalService.moveFolderToTrash(this.getUserId(), folderId);
    }

    public void restoreFolderFromTrash(long folderId) throws PortalException, SystemException {
        BookmarksFolder folder = this.bookmarksFolderLocalService.getFolder(folderId);
        BookmarksFolderPermission.check(this.getPermissionChecker(), folder, "UPDATE");
        this.bookmarksFolderLocalService.restoreFolderFromTrash(this.getUserId(), folderId);
    }

    public void subscribeFolder(long groupId, long folderId) throws PortalException, SystemException {
        BookmarksFolderPermission.check(this.getPermissionChecker(), groupId, folderId, "SUBSCRIBE");
        this.bookmarksFolderLocalService.subscribeFolder(this.getUserId(), groupId, folderId);
    }

    public void unsubscribeFolder(long groupId, long folderId) throws PortalException, SystemException {
        BookmarksFolderPermission.check(this.getPermissionChecker(), groupId, folderId, "SUBSCRIBE");
        this.bookmarksFolderLocalService.unsubscribeFolder(this.getUserId(), groupId, folderId);
    }

    public BookmarksFolder updateFolder(long folderId, long parentFolderId, String name, String description, boolean mergeWithParentFolder, ServiceContext serviceContext) throws PortalException, SystemException {
        BookmarksFolder folder = this.bookmarksFolderLocalService.getFolder(folderId);
        BookmarksFolderPermission.check(this.getPermissionChecker(), folder, "UPDATE");
        return this.bookmarksFolderLocalService.updateFolder(this.getUserId(), folderId, parentFolderId, name, description, mergeWithParentFolder, serviceContext);
    }
}

