/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.bookmarks.service.impl;

import com.liferay.portal.kernel.dao.orm.QueryDefinition;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.AuditedModel;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.User;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.asset.model.AssetEntry;
import com.liferay.portlet.bookmarks.FolderNameException;
import com.liferay.portlet.bookmarks.model.BookmarksEntry;
import com.liferay.portlet.bookmarks.model.BookmarksFolder;
import com.liferay.portlet.bookmarks.service.base.BookmarksFolderLocalServiceBaseImpl;
import com.liferay.portlet.trash.model.TrashEntry;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class BookmarksFolderLocalServiceImpl
extends BookmarksFolderLocalServiceBaseImpl {
    public BookmarksFolder addFolder(long userId, long parentFolderId, String name, String description, ServiceContext serviceContext) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        long groupId = serviceContext.getScopeGroupId();
        parentFolderId = this.getParentFolderId(groupId, parentFolderId);
        Date now = new Date();
        this.validate(name);
        long folderId = this.counterLocalService.increment();
        BookmarksFolder folder = this.bookmarksFolderPersistence.create(folderId);
        folder.setUuid(serviceContext.getUuid());
        folder.setGroupId(groupId);
        folder.setCompanyId(user.getCompanyId());
        folder.setUserId(user.getUserId());
        folder.setUserName(user.getFullName());
        folder.setCreateDate(serviceContext.getCreateDate(now));
        folder.setModifiedDate(serviceContext.getModifiedDate(now));
        folder.setParentFolderId(parentFolderId);
        folder.setName(name);
        folder.setDescription(description);
        folder.setExpandoBridgeAttributes(serviceContext);
        this.bookmarksFolderPersistence.update((BaseModel)folder);
        this.resourceLocalService.addModelResources((AuditedModel)folder, serviceContext);
        this.updateAsset(userId, folder, serviceContext.getAssetCategoryIds(), serviceContext.getAssetTagNames(), serviceContext.getAssetLinkEntryIds());
        return folder;
    }

    @Indexable(type=IndexableType.DELETE)
    public BookmarksFolder deleteFolder(BookmarksFolder folder) throws PortalException, SystemException {
        return this.deleteFolder(folder, true);
    }

    @Indexable(type=IndexableType.DELETE)
    public BookmarksFolder deleteFolder(BookmarksFolder folder, boolean includeTrashedEntries) throws PortalException, SystemException {
        List folders = this.bookmarksFolderPersistence.findByG_P_S(folder.getGroupId(), folder.getFolderId(), -1);
        for (BookmarksFolder curFolder : folders) {
            if (!includeTrashedEntries && curFolder.isInTrash()) continue;
            this.deleteFolder(curFolder);
        }
        this.bookmarksFolderPersistence.remove((BaseModel)folder);
        this.resourceLocalService.deleteResource((AuditedModel)folder, 4);
        this.bookmarksEntryLocalService.deleteEntries(folder.getGroupId(), folder.getFolderId(), includeTrashedEntries);
        this.assetEntryLocalService.deleteEntry(BookmarksFolder.class.getName(), folder.getFolderId());
        this.expandoValueLocalService.deleteValues(BookmarksFolder.class.getName(), folder.getFolderId());
        this.subscriptionLocalService.deleteSubscriptions(folder.getCompanyId(), BookmarksFolder.class.getName(), folder.getFolderId());
        this.trashEntryLocalService.deleteEntry(BookmarksFolder.class.getName(), folder.getFolderId());
        return folder;
    }

    @Indexable(type=IndexableType.DELETE)
    public BookmarksFolder deleteFolder(long folderId) throws PortalException, SystemException {
        BookmarksFolder folder = this.bookmarksFolderPersistence.findByPrimaryKey(folderId);
        return this.deleteFolder(folder);
    }

    @Indexable(type=IndexableType.DELETE)
    public BookmarksFolder deleteFolder(long folderId, boolean includeTrashedEntries) throws PortalException, SystemException {
        BookmarksFolder folder = this.bookmarksFolderLocalService.getFolder(folderId);
        return this.deleteFolder(folder, includeTrashedEntries);
    }

    public void deleteFolders(long groupId) throws PortalException, SystemException {
        List folders = this.bookmarksFolderPersistence.findByG_P(groupId, 0L);
        for (BookmarksFolder folder : folders) {
            this.bookmarksFolderLocalService.deleteFolder(folder);
        }
    }

    public List<BookmarksFolder> getCompanyFolders(long companyId, int start, int end) throws SystemException {
        return this.bookmarksFolderPersistence.findByCompanyId(companyId, start, end);
    }

    public int getCompanyFoldersCount(long companyId) throws SystemException {
        return this.bookmarksFolderPersistence.countByCompanyId(companyId);
    }

    public BookmarksFolder getFolder(long folderId) throws PortalException, SystemException {
        return this.bookmarksFolderPersistence.findByPrimaryKey(folderId);
    }

    public List<BookmarksFolder> getFolders(long groupId) throws SystemException {
        return this.bookmarksFolderPersistence.findByGroupId(groupId);
    }

    public List<BookmarksFolder> getFolders(long groupId, long parentFolderId) throws SystemException {
        return this.bookmarksFolderPersistence.findByG_P(groupId, parentFolderId);
    }

    public List<BookmarksFolder> getFolders(long groupId, long parentFolderId, int start, int end) throws SystemException {
        return this.getFolders(groupId, parentFolderId, 0, start, end);
    }

    public List<BookmarksFolder> getFolders(long groupId, long parentFolderId, int status, int start, int end) throws SystemException {
        return this.bookmarksFolderPersistence.findByG_P_S(groupId, parentFolderId, status, start, end);
    }

    public List<Object> getFoldersAndEntries(long groupId, long folderId) throws SystemException {
        return this.getFoldersAndEntries(groupId, folderId, -1);
    }

    public List<Object> getFoldersAndEntries(long groupId, long folderId, int status) throws SystemException {
        QueryDefinition queryDefinition = new QueryDefinition(status);
        return this.bookmarksFolderFinder.findF_E_ByG_F(groupId, folderId, queryDefinition);
    }

    public List<Object> getFoldersAndEntries(long groupId, long folderId, int status, int start, int end) throws SystemException {
        QueryDefinition queryDefinition = new QueryDefinition(status, start, end, null);
        return this.bookmarksFolderFinder.findF_E_ByG_F(groupId, folderId, queryDefinition);
    }

    public int getFoldersAndEntriesCount(long groupId, long folderId, int status) throws SystemException {
        QueryDefinition queryDefinition = new QueryDefinition(status);
        return this.bookmarksFolderFinder.countF_E_ByG_F(groupId, folderId, queryDefinition);
    }

    public int getFoldersCount(long groupId, long parentFolderId) throws SystemException {
        return this.getFoldersCount(groupId, parentFolderId, 0);
    }

    public int getFoldersCount(long groupId, long parentFolderId, int status) throws SystemException {
        return this.bookmarksFolderPersistence.countByG_P_S(groupId, parentFolderId, status);
    }

    public List<BookmarksFolder> getNoAssetFolders() throws SystemException {
        return this.bookmarksFolderFinder.findByNoAssets();
    }

    public void getSubfolderIds(List<Long> folderIds, long groupId, long folderId) throws SystemException {
        List folders = this.bookmarksFolderPersistence.findByG_P(groupId, folderId);
        for (BookmarksFolder folder : folders) {
            folderIds.add(folder.getFolderId());
            this.getSubfolderIds(folderIds, folder.getGroupId(), folder.getFolderId());
        }
    }

    @Indexable(type=IndexableType.REINDEX)
    public BookmarksFolder moveFolder(long folderId, long parentFolderId) throws PortalException, SystemException {
        BookmarksFolder folder = this.bookmarksFolderPersistence.findByPrimaryKey(folderId);
        folder.setParentFolderId(parentFolderId);
        this.bookmarksFolderPersistence.update((BaseModel)folder);
        return folder;
    }

    public BookmarksFolder moveFolderFromTrash(long userId, long folderId, long parentFolderId) throws PortalException, SystemException {
        BookmarksFolder folder = this.bookmarksFolderPersistence.findByPrimaryKey(folderId);
        if (folder.isInTrash()) {
            this.restoreFolderFromTrash(userId, folderId);
        } else {
            this.updateStatus(userId, folder, 0);
        }
        return this.bookmarksFolderLocalService.moveFolder(folderId, parentFolderId);
    }

    @Indexable(type=IndexableType.REINDEX)
    public void moveFolderToTrash(long userId, long folderId) throws PortalException, SystemException {
        BookmarksFolder folder = this.bookmarksFolderPersistence.findByPrimaryKey(folderId);
        this.updateStatus(userId, folder, 8);
        this.socialActivityCounterLocalService.enableActivityCounters(BookmarksFolder.class.getName(), folder.getFolderId());
        this.socialActivityLocalService.addActivity(userId, folder.getGroupId(), BookmarksFolder.class.getName(), folder.getFolderId(), 10007, "", 0L);
    }

    @Indexable(type=IndexableType.REINDEX)
    public void restoreFolderFromTrash(long userId, long folderId) throws PortalException, SystemException {
        BookmarksFolder folder = this.bookmarksFolderPersistence.findByPrimaryKey(folderId);
        TrashEntry trashEntry = this.trashEntryLocalService.getEntry(BookmarksFolder.class.getName(), folderId);
        this.updateStatus(userId, folder, trashEntry.getStatus());
        this.socialActivityCounterLocalService.enableActivityCounters(BookmarksFolder.class.getName(), folder.getFolderId());
        this.socialActivityLocalService.addActivity(userId, folder.getGroupId(), BookmarksFolder.class.getName(), folder.getFolderId(), 10008, "", 0L);
    }

    public void subscribeFolder(long userId, long groupId, long folderId) throws PortalException, SystemException {
        if (folderId == 0L) {
            folderId = groupId;
        }
        this.subscriptionLocalService.addSubscription(userId, groupId, BookmarksFolder.class.getName(), folderId);
    }

    public void unsubscribeFolder(long userId, long groupId, long folderId) throws PortalException, SystemException {
        if (folderId == 0L) {
            folderId = groupId;
        }
        this.subscriptionLocalService.deleteSubscription(userId, BookmarksFolder.class.getName(), folderId);
    }

    public void updateAsset(long userId, BookmarksFolder folder, long[] assetCategoryIds, String[] assetTagNames, long[] assetLinkEntryIds) throws PortalException, SystemException {
        AssetEntry assetEntry = this.assetEntryLocalService.updateEntry(userId, folder.getGroupId(), folder.getCreateDate(), folder.getModifiedDate(), BookmarksFolder.class.getName(), folder.getFolderId(), folder.getUuid(), 0L, assetCategoryIds, assetTagNames, true, null, null, null, "text/plain", folder.getName(), folder.getDescription(), null, null, null, 0, 0, null, false);
        this.assetLinkLocalService.updateLinks(userId, assetEntry.getEntryId(), assetLinkEntryIds, 0);
    }

    @Indexable(type=IndexableType.REINDEX)
    public BookmarksFolder updateFolder(long userId, long folderId, long parentFolderId, String name, String description, boolean mergeWithParentFolder, ServiceContext serviceContext) throws PortalException, SystemException {
        BookmarksFolder folder = this.bookmarksFolderPersistence.findByPrimaryKey(folderId);
        parentFolderId = this.getParentFolderId(folder, parentFolderId);
        if (mergeWithParentFolder && folderId != parentFolderId) {
            this.mergeFolders(folder, parentFolderId);
            return folder;
        }
        this.validate(name);
        folder.setModifiedDate(serviceContext.getModifiedDate(null));
        folder.setParentFolderId(parentFolderId);
        folder.setName(name);
        folder.setDescription(description);
        folder.setExpandoBridgeAttributes(serviceContext);
        this.bookmarksFolderPersistence.update((BaseModel)folder);
        this.updateAsset(userId, folder, serviceContext.getAssetCategoryIds(), serviceContext.getAssetTagNames(), serviceContext.getAssetLinkEntryIds());
        return folder;
    }

    public BookmarksFolder updateStatus(long userId, BookmarksFolder folder, int status) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        int oldStatus = folder.getStatus();
        folder.setStatus(status);
        folder.setStatusByUserId(userId);
        folder.setStatusByUserName(user.getFullName());
        folder.setStatusDate(new Date());
        this.bookmarksFolderPersistence.update((BaseModel)folder);
        List foldersAndEntries = this.bookmarksFolderLocalService.getFoldersAndEntries(folder.getGroupId(), folder.getFolderId());
        this.updateDependentStatus(foldersAndEntries, status);
        if (status == 0) {
            this.assetEntryLocalService.updateVisible(BookmarksFolder.class.getName(), folder.getFolderId(), true);
            this.socialActivityCounterLocalService.enableActivityCounters(BookmarksFolder.class.getName(), folder.getFolderId());
        } else if (status == 8) {
            this.assetEntryLocalService.updateVisible(BookmarksFolder.class.getName(), folder.getFolderId(), false);
            this.socialActivityCounterLocalService.disableActivityCounters(BookmarksFolder.class.getName(), folder.getFolderId());
        }
        if (oldStatus == 8) {
            this.trashEntryLocalService.deleteEntry(BookmarksFolder.class.getName(), folder.getFolderId());
        } else if (status == 8) {
            this.trashEntryLocalService.addTrashEntry(userId, folder.getGroupId(), BookmarksFolder.class.getName(), folder.getFolderId(), oldStatus, null, null);
        }
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(BookmarksFolder.class);
        indexer.reindex((Object)folder);
        return folder;
    }

    protected long getParentFolderId(BookmarksFolder folder, long parentFolderId) throws SystemException {
        if (parentFolderId == 0L) {
            return parentFolderId;
        }
        if (folder.getFolderId() == parentFolderId) {
            return folder.getParentFolderId();
        }
        BookmarksFolder parentFolder = this.bookmarksFolderPersistence.fetchByPrimaryKey(parentFolderId);
        if (parentFolder == null || folder.getGroupId() != parentFolder.getGroupId()) {
            return folder.getParentFolderId();
        }
        ArrayList<Long> subfolderIds = new ArrayList<Long>();
        this.getSubfolderIds(subfolderIds, folder.getGroupId(), folder.getFolderId());
        if (subfolderIds.contains(parentFolderId)) {
            return folder.getParentFolderId();
        }
        return parentFolderId;
    }

    protected long getParentFolderId(long groupId, long parentFolderId) throws SystemException {
        BookmarksFolder parentFolder;
        if (parentFolderId != 0L && ((parentFolder = this.bookmarksFolderPersistence.fetchByPrimaryKey(parentFolderId)) == null || groupId != parentFolder.getGroupId())) {
            parentFolderId = 0L;
        }
        return parentFolderId;
    }

    protected void mergeFolders(BookmarksFolder fromFolder, long toFolderId) throws PortalException, SystemException {
        List folders = this.bookmarksFolderPersistence.findByG_P(fromFolder.getGroupId(), fromFolder.getFolderId());
        for (BookmarksFolder folder : folders) {
            this.mergeFolders(folder, toFolderId);
        }
        List entries = this.bookmarksEntryPersistence.findByG_F(fromFolder.getGroupId(), fromFolder.getFolderId());
        for (BookmarksEntry entry : entries) {
            entry.setFolderId(toFolderId);
            this.bookmarksEntryPersistence.update((BaseModel)entry);
            Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(BookmarksEntry.class);
            indexer.reindex((Object)entry);
        }
        this.bookmarksFolderLocalService.deleteFolder(fromFolder);
    }

    protected void updateDependentStatus(List<Object> foldersAndEntries, int status) throws PortalException, SystemException {
        for (Object object : foldersAndEntries) {
            BookmarksFolder folder;
            if (object instanceof BookmarksEntry) {
                BookmarksEntry entry = (BookmarksEntry)object;
                if (status == 8) {
                    this.assetEntryLocalService.updateVisible(BookmarksEntry.class.getName(), entry.getEntryId(), false);
                    this.socialActivityCounterLocalService.disableActivityCounters(BookmarksEntry.class.getName(), entry.getEntryId());
                    if (entry.getStatus() == 1) {
                        entry.setStatus(2);
                        this.bookmarksEntryPersistence.update((BaseModel)entry);
                    }
                } else {
                    if (entry.getStatus() == 0) {
                        this.assetEntryLocalService.updateVisible(BookmarksEntry.class.getName(), entry.getEntryId(), true);
                    }
                    this.socialActivityCounterLocalService.enableActivityCounters(BookmarksEntry.class.getName(), entry.getEntryId());
                }
                Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(BookmarksEntry.class);
                indexer.reindex((Object)entry);
                continue;
            }
            if (!(object instanceof BookmarksFolder) || (folder = (BookmarksFolder)object).isInTrash()) continue;
            List<Object> curFoldersAndEntries = this.getFoldersAndEntries(folder.getGroupId(), folder.getFolderId());
            this.updateDependentStatus(curFoldersAndEntries, status);
            if (status == 8) {
                this.assetEntryLocalService.updateVisible(BookmarksFolder.class.getName(), folder.getFolderId(), false);
                this.socialActivityCounterLocalService.disableActivityCounters(BookmarksFolder.class.getName(), folder.getFolderId());
            } else {
                this.assetEntryLocalService.updateVisible(BookmarksFolder.class.getName(), folder.getFolderId(), true);
                this.socialActivityCounterLocalService.enableActivityCounters(BookmarksFolder.class.getName(), folder.getFolderId());
            }
            Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(BookmarksFolder.class);
            indexer.reindex((Object)folder);
        }
    }

    protected void validate(String name) throws PortalException {
        if (Validator.isNull((String)name) || name.contains("\\\\") || name.contains("//")) {
            throw new FolderNameException();
        }
    }
}

