/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.bookmarks.service.http;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.MethodHandler;
import com.liferay.portal.kernel.util.MethodKey;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.security.auth.HttpPrincipal;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.http.TunnelUtil;
import com.liferay.portlet.bookmarks.model.BookmarksEntry;
import com.liferay.portlet.bookmarks.service.BookmarksEntryServiceUtil;
import java.util.List;

public class BookmarksEntryServiceHttp {
    private static Log _log = LogFactoryUtil.getLog(BookmarksEntryServiceHttp.class);
    private static final Class<?>[] _addEntryParameterTypes0 = new Class[]{Long.TYPE, Long.TYPE, String.class, String.class, String.class, ServiceContext.class};
    private static final Class<?>[] _deleteEntryParameterTypes1 = new Class[]{Long.TYPE};
    private static final Class<?>[] _getEntriesParameterTypes2 = new Class[]{Long.TYPE, Long.TYPE, Integer.TYPE, Integer.TYPE};
    private static final Class<?>[] _getEntriesParameterTypes3 = new Class[]{Long.TYPE, Long.TYPE, Integer.TYPE, Integer.TYPE, OrderByComparator.class};
    private static final Class<?>[] _getEntriesCountParameterTypes4 = new Class[]{Long.TYPE, Long.TYPE};
    private static final Class<?>[] _getEntryParameterTypes5 = new Class[]{Long.TYPE};
    private static final Class<?>[] _getFoldersEntriesCountParameterTypes6 = new Class[]{Long.TYPE, List.class};
    private static final Class<?>[] _getGroupEntriesParameterTypes7 = new Class[]{Long.TYPE, Integer.TYPE, Integer.TYPE};
    private static final Class<?>[] _getGroupEntriesParameterTypes8 = new Class[]{Long.TYPE, Long.TYPE, Integer.TYPE, Integer.TYPE};
    private static final Class<?>[] _getGroupEntriesParameterTypes9 = new Class[]{Long.TYPE, Long.TYPE, Long.TYPE, Integer.TYPE, Integer.TYPE};
    private static final Class<?>[] _getGroupEntriesCountParameterTypes10 = new Class[]{Long.TYPE};
    private static final Class<?>[] _getGroupEntriesCountParameterTypes11 = new Class[]{Long.TYPE, Long.TYPE};
    private static final Class<?>[] _getGroupEntriesCountParameterTypes12 = new Class[]{Long.TYPE, Long.TYPE, Long.TYPE};
    private static final Class<?>[] _moveEntryParameterTypes13 = new Class[]{Long.TYPE, Long.TYPE};
    private static final Class<?>[] _moveEntryFromTrashParameterTypes14 = new Class[]{Long.TYPE, Long.TYPE};
    private static final Class<?>[] _moveEntryToTrashParameterTypes15 = new Class[]{Long.TYPE};
    private static final Class<?>[] _openEntryParameterTypes16 = new Class[]{BookmarksEntry.class};
    private static final Class<?>[] _openEntryParameterTypes17 = new Class[]{Long.TYPE};
    private static final Class<?>[] _restoreEntryFromTrashParameterTypes18 = new Class[]{Long.TYPE};
    private static final Class<?>[] _subscribeEntryParameterTypes19 = new Class[]{Long.TYPE};
    private static final Class<?>[] _unsubscribeEntryParameterTypes20 = new Class[]{Long.TYPE};
    private static final Class<?>[] _updateEntryParameterTypes21 = new Class[]{Long.TYPE, Long.TYPE, Long.TYPE, String.class, String.class, String.class, ServiceContext.class};

    public static BookmarksEntry addEntry(HttpPrincipal httpPrincipal, long groupId, long folderId, String name, String url, String description, ServiceContext serviceContext) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(BookmarksEntryServiceUtil.class, "addEntry", (Class[])_addEntryParameterTypes0);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, folderId, name, url, description, serviceContext});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e2) {
                if (e2 instanceof PortalException) {
                    throw (PortalException)((Object)e2);
                }
                if (e2 instanceof SystemException) {
                    throw (SystemException)((Object)e2);
                }
                throw new SystemException((Throwable)e2);
            }
            return (BookmarksEntry)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void deleteEntry(HttpPrincipal httpPrincipal, long entryId) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(BookmarksEntryServiceUtil.class, "deleteEntry", (Class[])_deleteEntryParameterTypes1);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{entryId});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e2) {
                if (e2 instanceof PortalException) {
                    throw (PortalException)((Object)e2);
                }
                if (e2 instanceof SystemException) {
                    throw (SystemException)((Object)e2);
                }
                throw new SystemException((Throwable)e2);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static List<BookmarksEntry> getEntries(HttpPrincipal httpPrincipal, long groupId, long folderId, int start, int end) throws SystemException {
        try {
            MethodKey methodKey = new MethodKey(BookmarksEntryServiceUtil.class, "getEntries", (Class[])_getEntriesParameterTypes2);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, folderId, start, end});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e2) {
                if (e2 instanceof SystemException) {
                    throw (SystemException)((Object)e2);
                }
                throw new SystemException((Throwable)e2);
            }
            return (List)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static List<BookmarksEntry> getEntries(HttpPrincipal httpPrincipal, long groupId, long folderId, int start, int end, OrderByComparator orderByComparator) throws SystemException {
        try {
            MethodKey methodKey = new MethodKey(BookmarksEntryServiceUtil.class, "getEntries", (Class[])_getEntriesParameterTypes3);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, folderId, start, end, orderByComparator});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e2) {
                if (e2 instanceof SystemException) {
                    throw (SystemException)((Object)e2);
                }
                throw new SystemException((Throwable)e2);
            }
            return (List)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static int getEntriesCount(HttpPrincipal httpPrincipal, long groupId, long folderId) throws SystemException {
        try {
            MethodKey methodKey = new MethodKey(BookmarksEntryServiceUtil.class, "getEntriesCount", (Class[])_getEntriesCountParameterTypes4);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, folderId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e2) {
                if (e2 instanceof SystemException) {
                    throw (SystemException)((Object)e2);
                }
                throw new SystemException((Throwable)e2);
            }
            return (Integer)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static BookmarksEntry getEntry(HttpPrincipal httpPrincipal, long entryId) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(BookmarksEntryServiceUtil.class, "getEntry", (Class[])_getEntryParameterTypes5);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{entryId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e2) {
                if (e2 instanceof PortalException) {
                    throw (PortalException)((Object)e2);
                }
                if (e2 instanceof SystemException) {
                    throw (SystemException)((Object)e2);
                }
                throw new SystemException((Throwable)e2);
            }
            return (BookmarksEntry)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static int getFoldersEntriesCount(HttpPrincipal httpPrincipal, long groupId, List<Long> folderIds) throws SystemException {
        try {
            MethodKey methodKey = new MethodKey(BookmarksEntryServiceUtil.class, "getFoldersEntriesCount", (Class[])_getFoldersEntriesCountParameterTypes6);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, folderIds});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e2) {
                if (e2 instanceof SystemException) {
                    throw (SystemException)((Object)e2);
                }
                throw new SystemException((Throwable)e2);
            }
            return (Integer)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static List<BookmarksEntry> getGroupEntries(HttpPrincipal httpPrincipal, long groupId, int start, int end) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(BookmarksEntryServiceUtil.class, "getGroupEntries", (Class[])_getGroupEntriesParameterTypes7);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, start, end});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e2) {
                if (e2 instanceof PortalException) {
                    throw (PortalException)((Object)e2);
                }
                if (e2 instanceof SystemException) {
                    throw (SystemException)((Object)e2);
                }
                throw new SystemException((Throwable)e2);
            }
            return (List)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static List<BookmarksEntry> getGroupEntries(HttpPrincipal httpPrincipal, long groupId, long userId, int start, int end) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(BookmarksEntryServiceUtil.class, "getGroupEntries", (Class[])_getGroupEntriesParameterTypes8);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, userId, start, end});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e2) {
                if (e2 instanceof PortalException) {
                    throw (PortalException)((Object)e2);
                }
                if (e2 instanceof SystemException) {
                    throw (SystemException)((Object)e2);
                }
                throw new SystemException((Throwable)e2);
            }
            return (List)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static List<BookmarksEntry> getGroupEntries(HttpPrincipal httpPrincipal, long groupId, long userId, long rootFolderId, int start, int end) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(BookmarksEntryServiceUtil.class, "getGroupEntries", (Class[])_getGroupEntriesParameterTypes9);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, userId, rootFolderId, start, end});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e2) {
                if (e2 instanceof PortalException) {
                    throw (PortalException)((Object)e2);
                }
                if (e2 instanceof SystemException) {
                    throw (SystemException)((Object)e2);
                }
                throw new SystemException((Throwable)e2);
            }
            return (List)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static int getGroupEntriesCount(HttpPrincipal httpPrincipal, long groupId) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(BookmarksEntryServiceUtil.class, "getGroupEntriesCount", (Class[])_getGroupEntriesCountParameterTypes10);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e2) {
                if (e2 instanceof PortalException) {
                    throw (PortalException)((Object)e2);
                }
                if (e2 instanceof SystemException) {
                    throw (SystemException)((Object)e2);
                }
                throw new SystemException((Throwable)e2);
            }
            return (Integer)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static int getGroupEntriesCount(HttpPrincipal httpPrincipal, long groupId, long userId) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(BookmarksEntryServiceUtil.class, "getGroupEntriesCount", (Class[])_getGroupEntriesCountParameterTypes11);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, userId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e2) {
                if (e2 instanceof PortalException) {
                    throw (PortalException)((Object)e2);
                }
                if (e2 instanceof SystemException) {
                    throw (SystemException)((Object)e2);
                }
                throw new SystemException((Throwable)e2);
            }
            return (Integer)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static int getGroupEntriesCount(HttpPrincipal httpPrincipal, long groupId, long userId, long rootFolderId) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(BookmarksEntryServiceUtil.class, "getGroupEntriesCount", (Class[])_getGroupEntriesCountParameterTypes12);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, userId, rootFolderId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e2) {
                if (e2 instanceof PortalException) {
                    throw (PortalException)((Object)e2);
                }
                if (e2 instanceof SystemException) {
                    throw (SystemException)((Object)e2);
                }
                throw new SystemException((Throwable)e2);
            }
            return (Integer)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static BookmarksEntry moveEntry(HttpPrincipal httpPrincipal, long entryId, long parentFolderId) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(BookmarksEntryServiceUtil.class, "moveEntry", (Class[])_moveEntryParameterTypes13);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{entryId, parentFolderId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e2) {
                if (e2 instanceof PortalException) {
                    throw (PortalException)((Object)e2);
                }
                if (e2 instanceof SystemException) {
                    throw (SystemException)((Object)e2);
                }
                throw new SystemException((Throwable)e2);
            }
            return (BookmarksEntry)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static BookmarksEntry moveEntryFromTrash(HttpPrincipal httpPrincipal, long entryId, long parentFolderId) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(BookmarksEntryServiceUtil.class, "moveEntryFromTrash", (Class[])_moveEntryFromTrashParameterTypes14);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{entryId, parentFolderId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e2) {
                if (e2 instanceof PortalException) {
                    throw (PortalException)((Object)e2);
                }
                if (e2 instanceof SystemException) {
                    throw (SystemException)((Object)e2);
                }
                throw new SystemException((Throwable)e2);
            }
            return (BookmarksEntry)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void moveEntryToTrash(HttpPrincipal httpPrincipal, long entryId) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(BookmarksEntryServiceUtil.class, "moveEntryToTrash", (Class[])_moveEntryToTrashParameterTypes15);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{entryId});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e2) {
                if (e2 instanceof PortalException) {
                    throw (PortalException)((Object)e2);
                }
                if (e2 instanceof SystemException) {
                    throw (SystemException)((Object)e2);
                }
                throw new SystemException((Throwable)e2);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static BookmarksEntry openEntry(HttpPrincipal httpPrincipal, BookmarksEntry entry) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(BookmarksEntryServiceUtil.class, "openEntry", (Class[])_openEntryParameterTypes16);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{entry});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e2) {
                if (e2 instanceof PortalException) {
                    throw (PortalException)((Object)e2);
                }
                if (e2 instanceof SystemException) {
                    throw (SystemException)((Object)e2);
                }
                throw new SystemException((Throwable)e2);
            }
            return (BookmarksEntry)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static BookmarksEntry openEntry(HttpPrincipal httpPrincipal, long entryId) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(BookmarksEntryServiceUtil.class, "openEntry", (Class[])_openEntryParameterTypes17);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{entryId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e2) {
                if (e2 instanceof PortalException) {
                    throw (PortalException)((Object)e2);
                }
                if (e2 instanceof SystemException) {
                    throw (SystemException)((Object)e2);
                }
                throw new SystemException((Throwable)e2);
            }
            return (BookmarksEntry)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void restoreEntryFromTrash(HttpPrincipal httpPrincipal, long entryId) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(BookmarksEntryServiceUtil.class, "restoreEntryFromTrash", (Class[])_restoreEntryFromTrashParameterTypes18);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{entryId});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e2) {
                if (e2 instanceof PortalException) {
                    throw (PortalException)((Object)e2);
                }
                if (e2 instanceof SystemException) {
                    throw (SystemException)((Object)e2);
                }
                throw new SystemException((Throwable)e2);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void subscribeEntry(HttpPrincipal httpPrincipal, long entryId) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(BookmarksEntryServiceUtil.class, "subscribeEntry", (Class[])_subscribeEntryParameterTypes19);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{entryId});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e2) {
                if (e2 instanceof PortalException) {
                    throw (PortalException)((Object)e2);
                }
                if (e2 instanceof SystemException) {
                    throw (SystemException)((Object)e2);
                }
                throw new SystemException((Throwable)e2);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void unsubscribeEntry(HttpPrincipal httpPrincipal, long entryId) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(BookmarksEntryServiceUtil.class, "unsubscribeEntry", (Class[])_unsubscribeEntryParameterTypes20);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{entryId});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e2) {
                if (e2 instanceof PortalException) {
                    throw (PortalException)((Object)e2);
                }
                if (e2 instanceof SystemException) {
                    throw (SystemException)((Object)e2);
                }
                throw new SystemException((Throwable)e2);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static BookmarksEntry updateEntry(HttpPrincipal httpPrincipal, long entryId, long groupId, long folderId, String name, String url, String description, ServiceContext serviceContext) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(BookmarksEntryServiceUtil.class, "updateEntry", (Class[])_updateEntryParameterTypes21);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{entryId, groupId, folderId, name, url, description, serviceContext});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e2) {
                if (e2 instanceof PortalException) {
                    throw (PortalException)((Object)e2);
                }
                if (e2 instanceof SystemException) {
                    throw (SystemException)((Object)e2);
                }
                throw new SystemException((Throwable)e2);
            }
            return (BookmarksEntry)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }
}

