/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.bookmarks.lar;

import com.liferay.portal.kernel.lar.BaseStagedModelDataHandler;
import com.liferay.portal.kernel.lar.ExportImportPathUtil;
import com.liferay.portal.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.model.ClassedModel;
import com.liferay.portal.model.StagedModel;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.bookmarks.model.BookmarksFolder;
import com.liferay.portlet.bookmarks.service.BookmarksFolderLocalServiceUtil;
import com.liferay.portlet.bookmarks.service.persistence.BookmarksFolderUtil;
import java.util.Map;

public class BookmarksFolderStagedModelDataHandler
extends BaseStagedModelDataHandler<BookmarksFolder> {
    public static final String[] CLASS_NAMES = new String[]{BookmarksFolder.class.getName()};

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    public String getDisplayName(BookmarksFolder folder) {
        return folder.getName();
    }

    protected void doExportStagedModel(PortletDataContext portletDataContext, BookmarksFolder folder) throws Exception {
        if (folder.getParentFolderId() != 0L) {
            this.exportStagedModel(portletDataContext, (StagedModel)folder.getParentFolder());
        }
        Element folderElement = portletDataContext.getExportDataElement((ClassedModel)folder);
        portletDataContext.addClassedModel(folderElement, ExportImportPathUtil.getModelPath((StagedModel)folder), (ClassedModel)folder, "bookmarks");
    }

    protected void doImportStagedModel(PortletDataContext portletDataContext, BookmarksFolder folder) throws Exception {
        long userId = portletDataContext.getUserId(folder.getUserUuid());
        if (folder.getParentFolderId() != 0L) {
            String parentFolderPath = ExportImportPathUtil.getModelPath((PortletDataContext)portletDataContext, (String)BookmarksFolder.class.getName(), (long)folder.getParentFolderId());
            BookmarksFolder parentFolder = (BookmarksFolder)portletDataContext.getZipEntryAsObject(parentFolderPath);
            this.importStagedModel(portletDataContext, (StagedModel)parentFolder);
        }
        Map folderIds = portletDataContext.getNewPrimaryKeysMap(BookmarksFolder.class);
        long parentFolderId = MapUtil.getLong((Map)folderIds, (long)folder.getParentFolderId(), (long)folder.getParentFolderId());
        ServiceContext serviceContext = portletDataContext.createServiceContext((StagedModel)folder, "bookmarks");
        BookmarksFolder importedFolder = null;
        if (portletDataContext.isDataStrategyMirror()) {
            BookmarksFolder existingFolder = BookmarksFolderUtil.fetchByUUID_G((String)folder.getUuid(), (long)portletDataContext.getScopeGroupId());
            if (existingFolder == null) {
                serviceContext.setUuid(folder.getUuid());
                importedFolder = BookmarksFolderLocalServiceUtil.addFolder((long)userId, (long)parentFolderId, (String)folder.getName(), (String)folder.getDescription(), (ServiceContext)serviceContext);
            } else {
                importedFolder = BookmarksFolderLocalServiceUtil.updateFolder((long)userId, (long)existingFolder.getFolderId(), (long)parentFolderId, (String)folder.getName(), (String)folder.getDescription(), (boolean)false, (ServiceContext)serviceContext);
            }
        } else {
            importedFolder = BookmarksFolderLocalServiceUtil.addFolder((long)userId, (long)parentFolderId, (String)folder.getName(), (String)folder.getDescription(), (ServiceContext)serviceContext);
        }
        portletDataContext.importClassedModel((ClassedModel)folder, (ClassedModel)importedFolder, "bookmarks");
    }
}

