/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.bookmarks.lar;

import com.liferay.portal.kernel.lar.BaseStagedModelDataHandler;
import com.liferay.portal.kernel.lar.ExportImportPathUtil;
import com.liferay.portal.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.model.ClassedModel;
import com.liferay.portal.model.StagedModel;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.bookmarks.model.BookmarksEntry;
import com.liferay.portlet.bookmarks.model.BookmarksFolder;
import com.liferay.portlet.bookmarks.service.BookmarksEntryLocalServiceUtil;
import com.liferay.portlet.bookmarks.service.persistence.BookmarksEntryUtil;
import java.util.Map;

public class BookmarksEntryStagedModelDataHandler
extends BaseStagedModelDataHandler<BookmarksEntry> {
    public static final String[] CLASS_NAMES = new String[]{BookmarksEntry.class.getName()};

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    public String getDisplayName(BookmarksEntry entry) {
        return entry.getName();
    }

    protected void doExportStagedModel(PortletDataContext portletDataContext, BookmarksEntry entry) throws Exception {
        if (entry.getFolderId() != 0L) {
            StagedModelDataHandlerUtil.exportStagedModel((PortletDataContext)portletDataContext, (StagedModel)entry.getFolder());
        }
        Element entryElement = portletDataContext.getExportDataElement((ClassedModel)entry);
        portletDataContext.addClassedModel(entryElement, ExportImportPathUtil.getModelPath((StagedModel)entry), (ClassedModel)entry, "bookmarks");
    }

    protected void doImportStagedModel(PortletDataContext portletDataContext, BookmarksEntry entry) throws Exception {
        long userId = portletDataContext.getUserId(entry.getUserUuid());
        if (entry.getFolderId() != 0L) {
            String parentFolderPath = ExportImportPathUtil.getModelPath((PortletDataContext)portletDataContext, (String)BookmarksFolder.class.getName(), (long)entry.getFolderId());
            BookmarksFolder parentFolder = (BookmarksFolder)portletDataContext.getZipEntryAsObject(parentFolderPath);
            StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)portletDataContext, (StagedModel)parentFolder);
        }
        Map folderIds = portletDataContext.getNewPrimaryKeysMap(BookmarksFolder.class);
        long folderId = MapUtil.getLong((Map)folderIds, (long)entry.getFolderId(), (long)entry.getFolderId());
        ServiceContext serviceContext = portletDataContext.createServiceContext((StagedModel)entry, "bookmarks");
        BookmarksEntry importedEntry = null;
        if (portletDataContext.isDataStrategyMirror()) {
            BookmarksEntry existingEntry = BookmarksEntryUtil.fetchByUUID_G((String)entry.getUuid(), (long)portletDataContext.getScopeGroupId());
            if (existingEntry == null) {
                serviceContext.setUuid(entry.getUuid());
                importedEntry = BookmarksEntryLocalServiceUtil.addEntry((long)userId, (long)portletDataContext.getScopeGroupId(), (long)folderId, (String)entry.getName(), (String)entry.getUrl(), (String)entry.getDescription(), (ServiceContext)serviceContext);
            } else {
                importedEntry = BookmarksEntryLocalServiceUtil.updateEntry((long)userId, (long)existingEntry.getEntryId(), (long)portletDataContext.getScopeGroupId(), (long)folderId, (String)entry.getName(), (String)entry.getUrl(), (String)entry.getDescription(), (ServiceContext)serviceContext);
            }
        } else {
            importedEntry = BookmarksEntryLocalServiceUtil.addEntry((long)userId, (long)portletDataContext.getScopeGroupId(), (long)folderId, (String)entry.getName(), (String)entry.getUrl(), (String)entry.getDescription(), (ServiceContext)serviceContext);
        }
        portletDataContext.importClassedModel((ClassedModel)entry, (ClassedModel)importedEntry, "bookmarks");
    }
}

