/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.bookmarks.asset;

import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.trash.TrashRenderer;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portlet.asset.model.AssetRendererFactory;
import com.liferay.portlet.asset.model.BaseAssetRenderer;
import com.liferay.portlet.bookmarks.model.BookmarksFolder;
import com.liferay.portlet.bookmarks.service.BookmarksEntryServiceUtil;
import com.liferay.portlet.bookmarks.service.BookmarksFolderServiceUtil;
import com.liferay.portlet.trash.util.TrashUtil;
import java.util.Date;
import java.util.Locale;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.WindowState;

public class BookmarksFolderAssetRenderer
extends BaseAssetRenderer
implements TrashRenderer {
    public static final String TYPE = "bookmarks_folder";
    private BookmarksFolder _folder;

    public BookmarksFolderAssetRenderer(BookmarksFolder folder) {
        this._folder = folder;
    }

    public String getClassName() {
        return BookmarksFolder.class.getName();
    }

    public long getClassPK() {
        return this._folder.getFolderId();
    }

    public Date getDisplayDate() {
        return this._folder.getModifiedDate();
    }

    public long getGroupId() {
        return this._folder.getGroupId();
    }

    public String getIconPath(ThemeDisplay themeDisplay) {
        try {
            if (BookmarksFolderServiceUtil.getFoldersAndEntriesCount((long)this._folder.getGroupId(), (long)this._folder.getFolderId(), (int)0) > 0) {
                return String.valueOf(themeDisplay.getPathThemeImages()) + "/common/folder_full_document.png";
            }
        }
        catch (Exception exception) {}
        return String.valueOf(themeDisplay.getPathThemeImages()) + "/common/folder_empty.png";
    }

    public String getPortletId() {
        AssetRendererFactory assetRendererFactory = this.getAssetRendererFactory();
        return assetRendererFactory.getPortletId();
    }

    public String getSummary(Locale locale) {
        return HtmlUtil.stripHtml((String)this._folder.getDescription());
    }

    public String getThumbnailPath(PortletRequest portletRequest) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        int entriesCount = BookmarksEntryServiceUtil.getEntriesCount((long)this._folder.getGroupId(), (long)this._folder.getFolderId());
        int foldersCount = BookmarksFolderServiceUtil.getFoldersCount((long)this._folder.getGroupId(), (long)this._folder.getFolderId());
        if (entriesCount > 0 || foldersCount > 0) {
            return String.valueOf(themeDisplay.getPathThemeImages()) + "/file_system/large/folder_full_bookmark.png";
        }
        return String.valueOf(themeDisplay.getPathThemeImages()) + "/file_system/large/folder_empty_bookmark.png";
    }

    public String getTitle(Locale locale) {
        return TrashUtil.getOriginalTitle((String)this._folder.getName());
    }

    public String getType() {
        return TYPE;
    }

    public PortletURL getURLEdit(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse) throws Exception {
        LiferayPortletURL portletURL = liferayPortletResponse.createLiferayPortletURL(this.getControlPanelPlid(liferayPortletRequest), "28", "RENDER_PHASE");
        portletURL.setParameter("struts_action", "/bookmarks/edit_folder");
        portletURL.setParameter("folderId", String.valueOf(this._folder.getFolderId()));
        return portletURL;
    }

    public PortletURL getURLView(LiferayPortletResponse liferayPortletResponse, WindowState windowState) throws Exception {
        LiferayPortletURL portletURL = liferayPortletResponse.createLiferayPortletURL("28", "RENDER_PHASE");
        portletURL.setParameter("struts_action", "/bookmarks/view");
        portletURL.setParameter("folderId", String.valueOf(this._folder.getFolderId()));
        portletURL.setWindowState(windowState);
        return portletURL;
    }

    public String getURLViewInContext(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse, String noSuchEntryRedirect) {
        return this.getURLViewInContext(liferayPortletRequest, noSuchEntryRedirect, "/bookmarks/find_folder", "folderId", this._folder.getFolderId());
    }

    public long getUserId() {
        return this._folder.getUserId();
    }

    public String getUserName() {
        return this._folder.getUserName();
    }

    public String getUuid() {
        return this._folder.getUuid();
    }

    public String render(RenderRequest renderRequest, RenderResponse renderResponse, String template) throws Exception {
        if (template.equals("full_content")) {
            renderRequest.setAttribute("BOOKMARKS_FOLDER", (Object)this._folder);
            return "/html/portlet/bookmarks/asset/folder_" + template + ".jsp";
        }
        return null;
    }
}

