/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.bookmarks.action;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.portlet.LiferayPortletConfig;
import com.liferay.portal.kernel.portlet.LiferayWindowState;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.servlet.SessionMessages;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextFactory;
import com.liferay.portal.struts.PortletAction;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.asset.AssetCategoryException;
import com.liferay.portlet.asset.AssetTagException;
import com.liferay.portlet.assetpublisher.util.AssetPublisherUtil;
import com.liferay.portlet.bookmarks.EntryURLException;
import com.liferay.portlet.bookmarks.NoSuchEntryException;
import com.liferay.portlet.bookmarks.NoSuchFolderException;
import com.liferay.portlet.bookmarks.action.ActionUtil;
import com.liferay.portlet.bookmarks.model.BookmarksEntry;
import com.liferay.portlet.bookmarks.service.BookmarksEntryServiceUtil;
import com.liferay.portlet.bookmarks.service.BookmarksFolderServiceUtil;
import java.util.HashMap;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.WindowState;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class EditEntryAction
extends PortletAction {
    @Override
    public void processAction(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        try {
            BookmarksEntry entry = null;
            if (cmd.equals("add") || cmd.equals("update")) {
                entry = this.updateEntry(actionRequest);
            } else if (cmd.equals("delete")) {
                this.deleteEntry((LiferayPortletConfig)portletConfig, actionRequest, false);
            } else if (cmd.equals("move_to_trash")) {
                this.deleteEntry((LiferayPortletConfig)portletConfig, actionRequest, true);
            } else if (cmd.equals("restore")) {
                this.restoreEntryFromTrash(actionRequest);
            } else if (cmd.equals("subscribe")) {
                this.subscribeEntry(actionRequest);
            } else if (cmd.equals("unsubscribe")) {
                this.unsubscribeEntry(actionRequest);
            }
            WindowState windowState = actionRequest.getWindowState();
            if (!windowState.equals((Object)LiferayWindowState.POP_UP)) {
                this.sendRedirect(actionRequest, actionResponse);
            } else {
                String redirect = PortalUtil.escapeRedirect((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"redirect"));
                if (Validator.isNotNull((String)redirect)) {
                    if (cmd.equals("add") && entry != null) {
                        redirect = HttpUtil.addParameter((String)redirect, (String)"className", (String)BookmarksEntry.class.getName());
                        redirect = HttpUtil.addParameter((String)redirect, (String)"classPK", (long)entry.getEntryId());
                    }
                    actionResponse.sendRedirect(redirect);
                }
            }
        }
        catch (Exception e2) {
            if (e2 instanceof NoSuchEntryException || e2 instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)actionRequest, e2.getClass());
                this.setForward((PortletRequest)actionRequest, "portlet.bookmarks.error");
            }
            if (e2 instanceof EntryURLException || e2 instanceof NoSuchFolderException) {
                SessionErrors.add((PortletRequest)actionRequest, e2.getClass());
            }
            if (e2 instanceof AssetCategoryException || e2 instanceof AssetTagException) {
                SessionErrors.add((PortletRequest)actionRequest, e2.getClass(), (Object)e2);
            }
            throw e2;
        }
    }

    @Override
    public ActionForward render(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        try {
            ActionUtil.getEntry((PortletRequest)renderRequest);
        }
        catch (Exception e2) {
            if (e2 instanceof NoSuchEntryException || e2 instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)renderRequest, e2.getClass());
                return mapping.findForward("portlet.bookmarks.error");
            }
            throw e2;
        }
        return mapping.findForward(this.getForward((PortletRequest)renderRequest, "portlet.bookmarks.edit_entry"));
    }

    protected void deleteEntry(LiferayPortletConfig liferayPortletConfig, ActionRequest actionRequest, boolean moveToTrash) throws Exception {
        long[] deleteEntryIds = null;
        long entryId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"entryId");
        deleteEntryIds = entryId > 0L ? new long[]{entryId} : StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"deleteEntryIds"), (long)0L);
        long[] lArray = deleteEntryIds;
        int n = deleteEntryIds.length;
        int n2 = 0;
        while (n2 < n) {
            long deleteEntryId = lArray[n2];
            if (moveToTrash) {
                BookmarksEntryServiceUtil.moveEntryToTrash((long)deleteEntryId);
            } else {
                BookmarksEntryServiceUtil.deleteEntry((long)deleteEntryId);
            }
            ++n2;
        }
        if (moveToTrash && deleteEntryIds.length > 0) {
            HashMap<String, String[]> data = new HashMap<String, String[]>();
            data.put("restoreEntryIds", ArrayUtil.toStringArray((long[])deleteEntryIds));
            SessionMessages.add((PortletRequest)actionRequest, (String)(String.valueOf(liferayPortletConfig.getPortletId()) + ".deleteSuccessData"), data);
            SessionMessages.add((PortletRequest)actionRequest, (String)(String.valueOf(liferayPortletConfig.getPortletId()) + ".hideDefaultSuccessMessage"));
        }
    }

    protected void restoreEntryFromTrash(ActionRequest actionRequest) throws PortalException, SystemException {
        long[] restoreEntryIds;
        long[] restoreFolderIds;
        long[] lArray = restoreFolderIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"restoreFolderIds"), (long)0L);
        int n = restoreFolderIds.length;
        int n2 = 0;
        while (n2 < n) {
            long restoreFolderId = lArray[n2];
            BookmarksFolderServiceUtil.restoreFolderFromTrash((long)restoreFolderId);
            ++n2;
        }
        long[] lArray2 = restoreEntryIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"restoreEntryIds"), (long)0L);
        int n3 = restoreEntryIds.length;
        n = 0;
        while (n < n3) {
            long restoreEntryId = lArray2[n];
            BookmarksEntryServiceUtil.restoreEntryFromTrash((long)restoreEntryId);
            ++n;
        }
    }

    protected void subscribeEntry(ActionRequest actionRequest) throws Exception {
        long entryId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"entryId");
        BookmarksEntryServiceUtil.subscribeEntry((long)entryId);
    }

    protected void unsubscribeEntry(ActionRequest actionRequest) throws Exception {
        long entryId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"entryId");
        BookmarksEntryServiceUtil.unsubscribeEntry((long)entryId);
    }

    protected BookmarksEntry updateEntry(ActionRequest actionRequest) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long entryId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"entryId");
        long groupId = themeDisplay.getScopeGroupId();
        long folderId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"folderId");
        String name = ParamUtil.getString((PortletRequest)actionRequest, (String)"name");
        String url = ParamUtil.getString((PortletRequest)actionRequest, (String)"url");
        String description = ParamUtil.getString((PortletRequest)actionRequest, (String)"description");
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)BookmarksEntry.class.getName(), (PortletRequest)actionRequest);
        BookmarksEntry entry = null;
        if (entryId <= 0L) {
            entry = BookmarksEntryServiceUtil.addEntry((long)groupId, (long)folderId, (String)name, (String)url, (String)description, (ServiceContext)serviceContext);
            AssetPublisherUtil.addAndStoreSelection((PortletRequest)actionRequest, (String)BookmarksEntry.class.getName(), (long)entry.getEntryId(), (int)-1);
        } else {
            entry = BookmarksEntryServiceUtil.updateEntry((long)entryId, (long)groupId, (long)folderId, (String)name, (String)url, (String)description, (ServiceContext)serviceContext);
        }
        AssetPublisherUtil.addRecentFolderId((PortletRequest)actionRequest, (String)BookmarksEntry.class.getName(), (long)folderId);
        return entry;
    }
}

