/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.blogs.util;

import com.liferay.ibm.icu.util.Calendar;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.Http;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.ReleaseInfo;
import com.liferay.portal.kernel.util.Tuple;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xmlrpc.Response;
import com.liferay.portal.kernel.xmlrpc.XmlRpcException;
import com.liferay.portal.kernel.xmlrpc.XmlRpcUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portal.xml.StAXReaderUtil;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import net.htmlparser.jericho.Source;
import net.htmlparser.jericho.StartTag;

public class LinkbackProducerUtil {
    private static final boolean _HTTP_HEADER_VERSION_VERBOSITY_DEFAULT = PropsValues.HTTP_HEADER_VERSION_VERBOSITY.equalsIgnoreCase(ReleaseInfo.getName());
    private static final boolean _HTTP_HEADER_VERSION_VERBOSITY_PARTIAL = PropsValues.HTTP_HEADER_VERSION_VERBOSITY.equalsIgnoreCase("partial");
    private static Log _log = LogFactoryUtil.getLog(LinkbackProducerUtil.class);
    private static List<Tuple> _pingbackQueue = Collections.synchronizedList(new ArrayList());

    public static void sendPingback(String sourceUri, String targetUri) throws Exception {
        _pingbackQueue.add(new Tuple(new Object[]{new Date(), sourceUri, targetUri}));
    }

    public static synchronized void sendQueuedPingbacks() throws XmlRpcException {
        Calendar cal = Calendar.getInstance();
        cal.add(12, -1);
        Date expiration = cal.getTime();
        while (!_pingbackQueue.isEmpty()) {
            Tuple tuple = _pingbackQueue.get(0);
            Date time = (Date)tuple.getObject(0);
            if (!time.before(expiration)) break;
            _pingbackQueue.remove(0);
            String sourceUri = (String)tuple.getObject(1);
            String targetUri = (String)tuple.getObject(2);
            String serverUri = LinkbackProducerUtil._discoverPingbackServer(targetUri);
            if (Validator.isNull((String)serverUri)) continue;
            if (_log.isInfoEnabled()) {
                _log.info((Object)("XML-RPC pingback " + serverUri + ", source " + sourceUri + ", target " + targetUri));
            }
            Response response = XmlRpcUtil.executeMethod((String)serverUri, (String)"pingback.ping", (Object[])new Object[]{sourceUri, targetUri});
            if (!_log.isInfoEnabled()) continue;
            _log.info((Object)response.toString());
        }
    }

    public static boolean sendTrackback(String trackback, Map<String, String> parts) throws Exception {
        XMLStreamReader xmlStreamReader;
        String error;
        block18: {
            String name;
            block19: {
                block20: {
                    if (_log.isInfoEnabled()) {
                        _log.info((Object)("Pinging trackback " + trackback));
                    }
                    Http.Options options = new Http.Options();
                    if (!_HTTP_HEADER_VERSION_VERBOSITY_DEFAULT) {
                        if (_HTTP_HEADER_VERSION_VERBOSITY_PARTIAL) {
                            options.addHeader("User-Agent", ReleaseInfo.getName());
                        } else {
                            options.addHeader("User-Agent", ReleaseInfo.getServerInfo());
                        }
                    }
                    options.setLocation(trackback);
                    options.setParts(parts);
                    options.setPost(true);
                    String xml = HttpUtil.URLtoString((Http.Options)options);
                    if (_log.isDebugEnabled()) {
                        _log.debug((Object)xml);
                    }
                    error = xml;
                    xmlStreamReader = null;
                    try {
                        XMLInputFactory xmlInputFactory = StAXReaderUtil.getXMLInputFactory();
                        xmlStreamReader = xmlInputFactory.createXMLStreamReader((Reader)new UnsyncStringReader(xml));
                        xmlStreamReader.nextTag();
                        xmlStreamReader.nextTag();
                        name = xmlStreamReader.getLocalName();
                        if (!name.equals("error")) break block18;
                        int status = GetterUtil.getInteger((String)xmlStreamReader.getElementText(), (int)1);
                        if (status != 0) break block19;
                        if (_log.isInfoEnabled()) {
                            _log.info((Object)"Trackback accepted");
                        }
                        if (xmlStreamReader == null) break block20;
                    }
                    catch (Throwable throwable) {
                        if (xmlStreamReader != null) {
                            try {
                                xmlStreamReader.close();
                            }
                            catch (Exception exception) {}
                        }
                        throw throwable;
                    }
                    try {
                        xmlStreamReader.close();
                    }
                    catch (Exception exception) {}
                }
                return true;
            }
            xmlStreamReader.nextTag();
            name = xmlStreamReader.getLocalName();
            if (name.equals("message")) {
                error = xmlStreamReader.getElementText();
            }
        }
        if (xmlStreamReader != null) {
            try {
                xmlStreamReader.close();
            }
            catch (Exception exception) {}
        }
        _log.error((Object)("Error while pinging trackback at " + trackback + ": " + error));
        return false;
    }

    private static String _discoverPingbackServer(String targetUri) {
        String serverUri = null;
        try {
            Http.Options options = new Http.Options();
            if (!_HTTP_HEADER_VERSION_VERBOSITY_DEFAULT) {
                if (_HTTP_HEADER_VERSION_VERBOSITY_PARTIAL) {
                    options.addHeader("User-Agent", ReleaseInfo.getName());
                } else {
                    options.addHeader("User-Agent", ReleaseInfo.getServerInfo());
                }
            }
            options.setLocation(targetUri);
            options.setHead(true);
            HttpUtil.URLtoByteArray((Http.Options)options);
            Http.Response response = options.getResponse();
            serverUri = response.getHeader("X-Pingback");
        }
        catch (Exception e2) {
            _log.error((Object)("Unable to call HEAD of " + targetUri), (Throwable)e2);
        }
        if (Validator.isNotNull(serverUri)) {
            return serverUri;
        }
        try {
            Source clientSource = new Source((CharSequence)HttpUtil.URLtoString((String)targetUri));
            List startTags = clientSource.getAllStartTags("link");
            for (StartTag startTag : startTags) {
                String rel = startTag.getAttributeValue("rel");
                if (!rel.equalsIgnoreCase("pingback")) continue;
                String href = startTag.getAttributeValue("href");
                serverUri = HtmlUtil.escape((String)href);
                break;
            }
        }
        catch (Exception e3) {
            _log.error((Object)("Unable to call GET of " + targetUri), (Throwable)e3);
        }
        return serverUri;
    }
}

