/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.blogs.util;

import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.util.FriendlyURLNormalizerUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.ModelHintsUtil;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.blogs.model.BlogsEntry;
import com.liferay.portlet.blogs.service.BlogsEntryLocalServiceUtil;
import com.liferay.portlet.messageboards.model.MBMessage;
import com.liferay.portlet.messageboards.service.MBMessageLocalServiceUtil;
import com.liferay.util.ContentUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.portlet.PortletPreferences;

public class BlogsUtil {
    public static final String DISPLAY_STYLE_ABSTRACT = "abstract";
    public static final String DISPLAY_STYLE_FULL_CONTENT = "full-content";
    public static final String DISPLAY_STYLE_TITLE = "title";
    private static final char[] _URL_TITLE_REPLACE_CHARS = new char[]{'.', '/'};
    private static Log _log = LogFactoryUtil.getLog(BlogsUtil.class);

    public static Map<Locale, String> getEmailEntryAddedBodyMap(PortletPreferences preferences) {
        Locale defaultLocale;
        Map map = LocalizationUtil.getLocalizationMap((PortletPreferences)preferences, (String)"emailEntryAddedBody");
        String defaultValue = (String)map.get(defaultLocale = LocaleUtil.getDefault());
        if (Validator.isNotNull((String)defaultValue)) {
            return map;
        }
        map.put(defaultLocale, ContentUtil.get((String)PropsUtil.get("blogs.email.entry.added.body")));
        return map;
    }

    public static boolean getEmailEntryAddedEnabled(PortletPreferences preferences) {
        String emailEntryAddedEnabled = preferences.getValue("emailEntryAddedEnabled", "");
        if (Validator.isNotNull((String)emailEntryAddedEnabled)) {
            return GetterUtil.getBoolean((String)emailEntryAddedEnabled);
        }
        return GetterUtil.getBoolean((String)PropsUtil.get("blogs.email.entry.added.enabled"));
    }

    public static Map<Locale, String> getEmailEntryAddedSubjectMap(PortletPreferences preferences) {
        Locale defaultLocale;
        Map map = LocalizationUtil.getLocalizationMap((PortletPreferences)preferences, (String)"emailEntryAddedSubject");
        String defaultValue = (String)map.get(defaultLocale = LocaleUtil.getDefault());
        if (Validator.isNotNull((String)defaultValue)) {
            return map;
        }
        map.put(defaultLocale, ContentUtil.get((String)PropsUtil.get("blogs.email.entry.added.subject")));
        return map;
    }

    public static Map<Locale, String> getEmailEntryUpdatedBodyMap(PortletPreferences preferences) {
        Locale defaultLocale;
        Map map = LocalizationUtil.getLocalizationMap((PortletPreferences)preferences, (String)"emailEntryUpdatedBody");
        String defaultValue = (String)map.get(defaultLocale = LocaleUtil.getDefault());
        if (Validator.isNotNull((String)defaultValue)) {
            return map;
        }
        map.put(defaultLocale, ContentUtil.get((String)PropsUtil.get("blogs.email.entry.updated.body")));
        return map;
    }

    public static boolean getEmailEntryUpdatedEnabled(PortletPreferences preferences) {
        String emailEntryUpdatedEnabled = preferences.getValue("emailEntryUpdatedEnabled", "");
        if (Validator.isNotNull((String)emailEntryUpdatedEnabled)) {
            return GetterUtil.getBoolean((String)emailEntryUpdatedEnabled);
        }
        return GetterUtil.getBoolean((String)PropsUtil.get("blogs.email.entry.updated.enabled"));
    }

    public static Map<Locale, String> getEmailEntryUpdatedSubjectMap(PortletPreferences preferences) {
        Locale defaultLocale;
        Map map = LocalizationUtil.getLocalizationMap((PortletPreferences)preferences, (String)"emailEntryUpdatedSubject");
        String defaultValue = (String)map.get(defaultLocale = LocaleUtil.getDefault());
        if (Validator.isNotNull((String)defaultValue)) {
            return map;
        }
        map.put(defaultLocale, ContentUtil.get((String)PropsUtil.get("blogs.email.entry.updated.subject")));
        return map;
    }

    public static String getEmailFromAddress(PortletPreferences preferences, long companyId) throws SystemException {
        return PortalUtil.getEmailFromAddress((PortletPreferences)preferences, (long)companyId, (String)PropsValues.BLOGS_EMAIL_FROM_ADDRESS);
    }

    public static String getEmailFromName(PortletPreferences preferences, long companyId) throws SystemException {
        return PortalUtil.getEmailFromName((PortletPreferences)preferences, (long)companyId, (String)PropsValues.BLOGS_EMAIL_FROM_NAME);
    }

    public static List<Object> getEntries(Hits hits) {
        ArrayList<Object> entries = new ArrayList<Object>();
        Document[] documentArray = hits.getDocs();
        int n = documentArray.length;
        int n2 = 0;
        while (n2 < n) {
            block6: {
                Document document = documentArray[n2];
                String entryClassName = GetterUtil.getString((String)document.get("entryClassName"));
                long entryClassPK = GetterUtil.getLong((String)document.get("entryClassPK"));
                try {
                    BlogsEntry obj = null;
                    if (entryClassName.equals(BlogsEntry.class.getName())) {
                        obj = BlogsEntryLocalServiceUtil.getEntry((long)entryClassPK);
                    } else if (entryClassName.equals(MBMessage.class.getName())) {
                        long classPK = GetterUtil.getLong((String)document.get("classPK"));
                        BlogsEntryLocalServiceUtil.getEntry((long)classPK);
                        obj = MBMessageLocalServiceUtil.getMessage((long)entryClassPK);
                    }
                    entries.add(obj);
                }
                catch (Exception exception) {
                    if (!_log.isWarnEnabled()) break block6;
                    _log.warn((Object)("Blogs search index is stale and contains entry {className=" + entryClassName + ", classPK=" + entryClassPK + "}"));
                }
            }
            ++n2;
        }
        return entries;
    }

    public static String getUrlTitle(long entryId, String title) {
        if (title == null) {
            return String.valueOf(entryId);
        }
        title = Validator.isNull((String)(title = title.trim().toLowerCase())) || Validator.isNumber((String)title) || title.equals("rss") ? String.valueOf(entryId) : FriendlyURLNormalizerUtil.normalize((String)title, (char[])_URL_TITLE_REPLACE_CHARS);
        return ModelHintsUtil.trimString((String)BlogsEntry.class.getName(), (String)"urlTitle", (String)title);
    }
}

