/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.blogs.social;

import com.liferay.portal.kernel.util.FastDateFormatFactoryUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.blogs.model.BlogsEntry;
import com.liferay.portlet.blogs.service.BlogsEntryLocalServiceUtil;
import com.liferay.portlet.blogs.service.permission.BlogsEntryPermission;
import com.liferay.portlet.social.model.BaseSocialActivityInterpreter;
import com.liferay.portlet.social.model.SocialActivity;
import java.text.Format;
import java.util.Locale;
import java.util.TimeZone;

public class BlogsActivityInterpreter
extends BaseSocialActivityInterpreter {
    private static final String[] _CLASS_NAMES = new String[]{BlogsEntry.class.getName()};

    public String[] getClassNames() {
        return _CLASS_NAMES;
    }

    protected String getPath(SocialActivity activity, ServiceContext serviceContext) {
        return "/blogs/find_entry?entryId=" + activity.getClassPK();
    }

    protected Object[] getTitleArguments(String groupName, SocialActivity activity, String link, String title, ServiceContext serviceContext) throws Exception {
        String creatorUserName = this.getUserName(activity.getUserId(), serviceContext);
        String receiverUserName = this.getUserName(activity.getReceiverUserId(), serviceContext);
        BlogsEntry entry = BlogsEntryLocalServiceUtil.getEntry((long)activity.getClassPK());
        String displayDate = "";
        if (activity.getType() == 2 && entry.getStatus() == 7) {
            link = null;
            Format dateFormatDate = FastDateFormatFactoryUtil.getSimpleDateFormat((String)"MMMM d", (Locale)serviceContext.getLocale(), (TimeZone)serviceContext.getTimeZone());
            displayDate = dateFormatDate.format(entry.getDisplayDate());
        }
        String displayTitle = this.wrapLink(link, entry.getTitle());
        return new Object[]{groupName, creatorUserName, receiverUserName, displayTitle, displayDate};
    }

    protected String getTitlePattern(String groupName, SocialActivity activity) throws Exception {
        int activityType = activity.getType();
        if (activityType == 1 || activityType == 10005) {
            if (Validator.isNull((String)groupName)) {
                return "activity-blogs-entry-add-comment";
            }
            return "activity-blogs-entry-add-comment-in";
        }
        if (activityType == 2) {
            BlogsEntry entry = BlogsEntryLocalServiceUtil.getEntry((long)activity.getClassPK());
            if (entry.getStatus() == 7) {
                if (Validator.isNull((String)groupName)) {
                    return "activity-blogs-entry-schedule-entry";
                }
                return "activity-blogs-entry-schedule-entry-in";
            }
            if (Validator.isNull((String)groupName)) {
                return "activity-blogs-entry-add-entry";
            }
            return "activity-blogs-entry-add-entry-in";
        }
        if (activityType == 10007) {
            if (Validator.isNull((String)groupName)) {
                return "activity-blogs-entry-move-to-trash";
            }
            return "activity-blogs-entry-move-to-trash-in";
        }
        if (activityType == 10008) {
            if (Validator.isNull((String)groupName)) {
                return "activity-blogs-entry-restore-from-trash";
            }
            return "activity-blogs-entry-restore-from-trash-in";
        }
        if (activityType == 3) {
            if (Validator.isNull((String)groupName)) {
                return "activity-blogs-entry-update-entry";
            }
            return "activity-blogs-entry-update-entry-in";
        }
        return null;
    }

    protected boolean hasPermissions(PermissionChecker permissionChecker, SocialActivity activity, String actionId, ServiceContext serviceContext) throws Exception {
        return BlogsEntryPermission.contains(permissionChecker, activity.getClassPK(), actionId);
    }
}

