/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.blogs.lar;

import com.liferay.portal.kernel.lar.BaseStagedModelDataHandler;
import com.liferay.portal.kernel.lar.ExportImportHelperUtil;
import com.liferay.portal.kernel.lar.ExportImportPathUtil;
import com.liferay.portal.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.util.CalendarFactoryUtil;
import com.liferay.portal.kernel.util.StreamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.model.ClassedModel;
import com.liferay.portal.model.Image;
import com.liferay.portal.model.StagedModel;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.persistence.ImageUtil;
import com.liferay.portlet.blogs.model.BlogsEntry;
import com.liferay.portlet.blogs.service.BlogsEntryLocalServiceUtil;
import com.liferay.portlet.blogs.service.persistence.BlogsEntryUtil;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Calendar;

public class BlogsEntryStagedModelDataHandler
extends BaseStagedModelDataHandler<BlogsEntry> {
    public static final String[] CLASS_NAMES = new String[]{BlogsEntry.class.getName()};

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    public String getDisplayName(BlogsEntry entry) {
        return entry.getTitle();
    }

    protected void doExportStagedModel(PortletDataContext portletDataContext, BlogsEntry entry) throws Exception {
        if (!entry.isApproved() && !entry.isInTrash()) {
            return;
        }
        Element entryElement = portletDataContext.getExportDataElement((ClassedModel)entry);
        if (entry.isSmallImage()) {
            Image smallImage = ImageUtil.fetchByPrimaryKey((long)entry.getSmallImageId());
            if (Validator.isNotNull((String)entry.getSmallImageURL())) {
                String smallImageURL = ExportImportHelperUtil.replaceExportContentReferences((PortletDataContext)portletDataContext, (StagedModel)entry, (Element)entryElement, (String)entry.getSmallImageURL().concat(" "), (boolean)true);
                entry.setSmallImageURL(smallImageURL);
            } else if (smallImage != null) {
                String smallImagePath = ExportImportPathUtil.getModelPath((StagedModel)entry, (String)(String.valueOf(smallImage.getImageId()) + "." + smallImage.getType()));
                entryElement.addAttribute("small-image-path", smallImagePath);
                entry.setSmallImageType(smallImage.getType());
                portletDataContext.addZipEntry(smallImagePath, smallImage.getTextObj());
            }
        }
        String content = ExportImportHelperUtil.replaceExportContentReferences((PortletDataContext)portletDataContext, (StagedModel)entry, (Element)entryElement, (String)entry.getContent(), (boolean)portletDataContext.getBooleanParameter("blogs", "embedded-assets"));
        entry.setContent(content);
        portletDataContext.addClassedModel(entryElement, ExportImportPathUtil.getModelPath((StagedModel)entry), (ClassedModel)entry, "blogs");
    }

    protected void doImportStagedModel(PortletDataContext portletDataContext, BlogsEntry entry) throws Exception {
        long userId = portletDataContext.getUserId(entry.getUserUuid());
        Element entryElement = portletDataContext.getImportDataStagedModelElement((StagedModel)entry);
        String content = ExportImportHelperUtil.replaceImportContentReferences((PortletDataContext)portletDataContext, (Element)entryElement, (String)entry.getContent(), (boolean)portletDataContext.getBooleanParameter("blogs", "embedded-assets"));
        entry.setContent(content);
        Calendar displayDateCal = CalendarFactoryUtil.getCalendar();
        displayDateCal.setTime(entry.getDisplayDate());
        int displayDateMonth = displayDateCal.get(2);
        int displayDateDay = displayDateCal.get(5);
        int displayDateYear = displayDateCal.get(1);
        int displayDateHour = displayDateCal.get(10);
        int displayDateMinute = displayDateCal.get(12);
        if (displayDateCal.get(9) == 1) {
            displayDateHour += 12;
        }
        boolean allowPingbacks = entry.isAllowPingbacks();
        boolean allowTrackbacks = entry.isAllowTrackbacks();
        String[] trackbacks = StringUtil.split((String)entry.getTrackbacks());
        int status = entry.getStatus();
        String smallImageFileName = null;
        InputStream smallImageInputStream = null;
        try {
            if (entry.isSmallImage()) {
                String smallImagePath = entryElement.attributeValue("small-image-path");
                if (Validator.isNotNull((String)entry.getSmallImageURL())) {
                    String smallImageURL = ExportImportHelperUtil.replaceImportContentReferences((PortletDataContext)portletDataContext, (Element)entryElement, (String)entry.getSmallImageURL(), (boolean)true);
                    entry.setSmallImageURL(smallImageURL);
                } else if (Validator.isNotNull((String)smallImagePath)) {
                    smallImageFileName = String.valueOf(entry.getSmallImageId()).concat(".").concat(entry.getSmallImageType());
                    smallImageInputStream = portletDataContext.getZipEntryAsInputStream(smallImagePath);
                }
            }
            ServiceContext serviceContext = portletDataContext.createServiceContext((StagedModel)entry, "blogs");
            if (status != 0 && status != 8) {
                serviceContext.setWorkflowAction(2);
            }
            BlogsEntry importedEntry = null;
            if (portletDataContext.isDataStrategyMirror()) {
                serviceContext.setAttribute("urlTitle", (Serializable)((Object)entry.getUrlTitle()));
                BlogsEntry existingEntry = BlogsEntryUtil.fetchByUUID_G((String)entry.getUuid(), (long)portletDataContext.getScopeGroupId());
                if (existingEntry == null) {
                    serviceContext.setUuid(entry.getUuid());
                    importedEntry = BlogsEntryLocalServiceUtil.addEntry((long)userId, (String)entry.getTitle(), (String)entry.getDescription(), (String)entry.getContent(), (int)displayDateMonth, (int)displayDateDay, (int)displayDateYear, (int)displayDateHour, (int)displayDateMinute, (boolean)allowPingbacks, (boolean)allowTrackbacks, (String[])trackbacks, (boolean)entry.isSmallImage(), (String)entry.getSmallImageURL(), (String)smallImageFileName, (InputStream)smallImageInputStream, (ServiceContext)serviceContext);
                    if (status == 8) {
                        importedEntry = BlogsEntryLocalServiceUtil.moveEntryToTrash((long)userId, (BlogsEntry)importedEntry);
                    }
                } else {
                    importedEntry = BlogsEntryLocalServiceUtil.updateEntry((long)userId, (long)existingEntry.getEntryId(), (String)entry.getTitle(), (String)entry.getDescription(), (String)entry.getContent(), (int)displayDateMonth, (int)displayDateDay, (int)displayDateYear, (int)displayDateHour, (int)displayDateMinute, (boolean)allowPingbacks, (boolean)allowTrackbacks, (String[])trackbacks, (boolean)entry.getSmallImage(), (String)entry.getSmallImageURL(), (String)smallImageFileName, (InputStream)smallImageInputStream, (ServiceContext)serviceContext);
                }
            } else {
                importedEntry = BlogsEntryLocalServiceUtil.addEntry((long)userId, (String)entry.getTitle(), (String)entry.getDescription(), (String)entry.getContent(), (int)displayDateMonth, (int)displayDateDay, (int)displayDateYear, (int)displayDateHour, (int)displayDateMinute, (boolean)allowPingbacks, (boolean)allowTrackbacks, (String[])trackbacks, (boolean)entry.getSmallImage(), (String)entry.getSmallImageURL(), (String)smallImageFileName, (InputStream)smallImageInputStream, (ServiceContext)serviceContext);
            }
            portletDataContext.importClassedModel((ClassedModel)entry, (ClassedModel)importedEntry, "blogs");
        }
        catch (Throwable throwable) {
            StreamUtil.cleanUp(smallImageInputStream);
            throw throwable;
        }
        StreamUtil.cleanUp((InputStream)smallImageInputStream);
    }
}

