/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.assetpublisher.util;

import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.Accessor;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PrefsPropsUtil;
import com.liferay.portal.kernel.util.PrimitiveLongList;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.User;
import com.liferay.portal.security.auth.PrincipalThreadLocal;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import com.liferay.portal.service.PortletPreferencesLocalServiceUtil;
import com.liferay.portal.service.SubscriptionLocalServiceUtil;
import com.liferay.portal.service.permission.GroupPermissionUtil;
import com.liferay.portal.service.permission.PortletPermissionUtil;
import com.liferay.portal.service.persistence.PortletPreferencesActionableDynamicQuery;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portal.util.SubscriptionSender;
import com.liferay.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portlet.asset.AssetRendererFactoryRegistryUtil;
import com.liferay.portlet.asset.model.AssetCategory;
import com.liferay.portlet.asset.model.AssetEntry;
import com.liferay.portlet.asset.model.AssetRendererFactory;
import com.liferay.portlet.asset.service.AssetCategoryLocalServiceUtil;
import com.liferay.portlet.asset.service.AssetEntryLocalServiceUtil;
import com.liferay.portlet.asset.service.AssetEntryServiceUtil;
import com.liferay.portlet.asset.service.AssetTagLocalServiceUtil;
import com.liferay.portlet.asset.service.persistence.AssetEntryQuery;
import com.liferay.portlet.assetpublisher.util.AssetPublisher;
import com.liferay.portlet.assetpublisher.util.AssetPublisherUtil;
import com.liferay.portlet.expando.model.ExpandoBridge;
import com.liferay.portlet.sites.util.SitesUtil;
import com.liferay.util.ContentUtil;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.portlet.PortletException;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class AssetPublisherImpl
implements AssetPublisher {
    private static Log _log = LogFactoryUtil.getLog(AssetPublisherImpl.class);
    private Accessor<AssetEntry, String> _titleAccessor = new Accessor<AssetEntry, String>(){

        public String get(AssetEntry assetEntry) {
            return assetEntry.getTitle(LocaleUtil.getDefault());
        }
    };

    public void addAndStoreSelection(PortletRequest portletRequest, String className, long classPK, int assetEntryOrder) throws Exception {
        String referringPortletResource = ParamUtil.getString((PortletRequest)portletRequest, (String)"referringPortletResource");
        if (Validator.isNull((String)referringPortletResource)) {
            return;
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        Layout layout = LayoutLocalServiceUtil.getLayout((long)themeDisplay.getRefererPlid());
        PortletPreferences portletPreferences = PortletPreferencesFactoryUtil.getPortletSetup((long)themeDisplay.getScopeGroupId(), (Layout)layout, (String)referringPortletResource, null);
        String selectionStyle = portletPreferences.getValue("selectionStyle", "dynamic");
        if (selectionStyle.equals("dynamic")) {
            return;
        }
        AssetEntry assetEntry = AssetEntryLocalServiceUtil.getEntry((String)className, (long)classPK);
        this.addSelection(themeDisplay, portletPreferences, referringPortletResource, assetEntry.getEntryId(), assetEntryOrder, className);
        portletPreferences.store();
    }

    public void addRecentFolderId(PortletRequest portletRequest, String className, long classPK) {
        this._getRecentFolderIds(portletRequest).put(className, classPK);
    }

    public void addSelection(PortletRequest portletRequest, PortletPreferences portletPreferences, String portletId) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long assetEntryId = ParamUtil.getLong((PortletRequest)portletRequest, (String)"assetEntryId");
        int assetEntryOrder = ParamUtil.getInteger((PortletRequest)portletRequest, (String)"assetEntryOrder");
        String assetEntryType = ParamUtil.getString((PortletRequest)portletRequest, (String)"assetEntryType");
        this.addSelection(themeDisplay, portletPreferences, portletId, assetEntryId, assetEntryOrder, assetEntryType);
    }

    public void addSelection(ThemeDisplay themeDisplay, PortletPreferences portletPreferences, String portletId, long assetEntryId, int assetEntryOrder, String assetEntryType) throws Exception {
        long plid;
        String assetEntryXml;
        AssetEntry assetEntry = AssetEntryLocalServiceUtil.getEntry((long)assetEntryId);
        Object[] assetEntryXmls = portletPreferences.getValues("assetEntryXml", new String[0]);
        if (!ArrayUtil.contains((Object[])assetEntryXmls, (Object)(assetEntryXml = this._getAssetEntryXml(assetEntryType, assetEntry.getClassUuid())))) {
            if (assetEntryOrder > -1) {
                assetEntryXmls[assetEntryOrder] = assetEntryXml;
            } else {
                assetEntryXmls = (String[])ArrayUtil.append((Object[])assetEntryXmls, (Object)assetEntryXml);
            }
            portletPreferences.setValues("assetEntryXml", (String[])assetEntryXmls);
        }
        if ((plid = themeDisplay.getRefererPlid()) == 0L) {
            plid = themeDisplay.getPlid();
        }
        ArrayList<AssetEntry> assetEntries = new ArrayList<AssetEntry>();
        assetEntries.add(assetEntry);
        this.notifySubscribers(portletPreferences, plid, portletId, assetEntries);
    }

    public void addUserAttributes(User user, String[] customUserAttributeNames, AssetEntryQuery assetEntryQuery) throws Exception {
        if (user == null || customUserAttributeNames.length == 0) {
            return;
        }
        Group companyGroup = GroupLocalServiceUtil.getCompanyGroup((long)user.getCompanyId());
        long[] allCategoryIds = assetEntryQuery.getAllCategoryIds();
        PrimitiveLongList allCategoryIdsList = new PrimitiveLongList(allCategoryIds.length + customUserAttributeNames.length);
        allCategoryIdsList.addAll(allCategoryIds);
        String[] stringArray = customUserAttributeNames;
        int n = customUserAttributeNames.length;
        int n2 = 0;
        while (n2 < n) {
            String customUserAttributeName = stringArray[n2];
            ExpandoBridge userCustomAttributes = user.getExpandoBridge();
            Serializable userCustomFieldValue = userCustomAttributes.getAttribute(customUserAttributeName);
            if (userCustomFieldValue != null) {
                String userCustomFieldValueString = userCustomFieldValue.toString();
                List assetCategories = AssetCategoryLocalServiceUtil.search((long)companyGroup.getGroupId(), (String)userCustomFieldValueString, (String[])new String[0], (int)-1, (int)-1);
                for (AssetCategory assetCategory : assetCategories) {
                    allCategoryIdsList.add(assetCategory.getCategoryId());
                }
            }
            ++n2;
        }
        assetEntryQuery.setAllCategoryIds(allCategoryIdsList.getArray());
    }

    public void checkAssetEntries() throws Exception {
        PortletPreferencesActionableDynamicQuery actionableDynamicQuery = new PortletPreferencesActionableDynamicQuery(){

            protected void addCriteria(DynamicQuery dynamicQuery) {
                Property property = PropertyFactoryUtil.forName((String)"portletId");
                String portletId = "101_INSTANCE_%";
                dynamicQuery.add(property.like((Object)portletId));
            }

            protected void performAction(Object object) throws PortalException, SystemException {
                com.liferay.portal.model.PortletPreferences portletPreferences = (com.liferay.portal.model.PortletPreferences)object;
                AssetPublisherImpl.this._checkAssetEntries(portletPreferences);
            }
        };
        actionableDynamicQuery.performActions();
    }

    public List<AssetEntry> getAssetEntries(PortletPreferences preferences, Layout layout, long scopeGroupId, int max, boolean checkPermission) throws PortalException, SystemException {
        AssetEntryQuery assetEntryQuery = this.getAssetEntryQuery(preferences, new long[]{scopeGroupId});
        boolean anyAssetType = GetterUtil.getBoolean((String)preferences.getValue("anyAssetType", null), (boolean)true);
        if (!anyAssetType) {
            long[] availableClassNameIds = AssetRendererFactoryRegistryUtil.getClassNameIds((long)layout.getCompanyId());
            long[] classNameIds = this.getClassNameIds(preferences, availableClassNameIds);
            assetEntryQuery.setClassNameIds(classNameIds);
        }
        long[] classTypeIds = GetterUtil.getLongValues((String[])preferences.getValues("classTypeIds", null));
        assetEntryQuery.setClassTypeIds(classTypeIds);
        boolean enablePermissions = GetterUtil.getBoolean((String)preferences.getValue("enablePermissions", null));
        assetEntryQuery.setEnablePermissions(enablePermissions);
        assetEntryQuery.setEnd(max);
        boolean excludeZeroViewCount = GetterUtil.getBoolean((String)preferences.getValue("excludeZeroViewCount", null));
        assetEntryQuery.setExcludeZeroViewCount(excludeZeroViewCount);
        long[] groupIds = this.getGroupIds(preferences, scopeGroupId, layout);
        assetEntryQuery.setGroupIds(groupIds);
        boolean showOnlyLayoutAssets = GetterUtil.getBoolean((String)preferences.getValue("showOnlyLayoutAssets", null));
        if (showOnlyLayoutAssets) {
            assetEntryQuery.setLayout(layout);
        }
        String orderByColumn1 = GetterUtil.getString((String)preferences.getValue("orderByColumn1", "modifiedDate"));
        assetEntryQuery.setOrderByCol1(orderByColumn1);
        String orderByColumn2 = GetterUtil.getString((String)preferences.getValue("orderByColumn2", "title"));
        assetEntryQuery.setOrderByCol2(orderByColumn2);
        String orderByType1 = GetterUtil.getString((String)preferences.getValue("orderByType1", "DESC"));
        assetEntryQuery.setOrderByType1(orderByType1);
        String orderByType2 = GetterUtil.getString((String)preferences.getValue("orderByType2", "ASC"));
        assetEntryQuery.setOrderByType2(orderByType2);
        assetEntryQuery.setStart(0);
        if (checkPermission) {
            return AssetEntryServiceUtil.getEntries((AssetEntryQuery)assetEntryQuery);
        }
        return AssetEntryLocalServiceUtil.getEntries((AssetEntryQuery)assetEntryQuery);
    }

    public AssetEntryQuery getAssetEntryQuery(PortletPreferences portletPreferences, long[] scopeGroupIds) throws PortalException, SystemException {
        String[] queryValues22;
        AssetEntryQuery assetEntryQuery = new AssetEntryQuery();
        long[] allAssetCategoryIds = new long[]{};
        long[] anyAssetCategoryIds = new long[]{};
        long[] notAllAssetCategoryIds = new long[]{};
        long[] notAnyAssetCategoryIds = new long[]{};
        String[] allAssetTagNames = new String[]{};
        String[] anyAssetTagNames = new String[]{};
        String[] notAllAssetTagNames = new String[]{};
        String[] notAnyAssetTagNames = new String[]{};
        int i2 = 0;
        while ((queryValues22 = portletPreferences.getValues("queryValues" + i2, null)) != null && queryValues22.length != 0) {
            boolean queryContains = GetterUtil.getBoolean((String)portletPreferences.getValue("queryContains" + i2, ""));
            boolean queryAndOperator = GetterUtil.getBoolean((String)portletPreferences.getValue("queryAndOperator" + i2, ""));
            String queryName = portletPreferences.getValue("queryName" + i2, "");
            if (Validator.equals((Object)queryName, (Object)"assetCategories")) {
                long[] assetCategoryIds = GetterUtil.getLongValues((String[])queryValues22);
                if (queryContains && queryAndOperator) {
                    allAssetCategoryIds = assetCategoryIds;
                } else if (queryContains && !queryAndOperator) {
                    anyAssetCategoryIds = assetCategoryIds;
                } else if (!queryContains && queryAndOperator) {
                    notAllAssetCategoryIds = assetCategoryIds;
                } else {
                    notAnyAssetCategoryIds = assetCategoryIds;
                }
            } else if (queryContains && queryAndOperator) {
                allAssetTagNames = queryValues22;
            } else if (queryContains && !queryAndOperator) {
                anyAssetTagNames = queryValues22;
            } else if (!queryContains && queryAndOperator) {
                notAllAssetTagNames = queryValues22;
            } else {
                notAnyAssetTagNames = queryValues22;
            }
            ++i2;
        }
        assetEntryQuery.setAllCategoryIds(allAssetCategoryIds);
        String[] stringArray = allAssetTagNames;
        int n = allAssetTagNames.length;
        int queryValues22 = 0;
        while (queryValues22 < n) {
            String assetTagName = stringArray[queryValues22];
            long[] allAssetTagIds = AssetTagLocalServiceUtil.getTagIds((long[])scopeGroupIds, (String)assetTagName);
            assetEntryQuery.addAllTagIdsArray(allAssetTagIds);
            ++queryValues22;
        }
        assetEntryQuery.setAnyCategoryIds(anyAssetCategoryIds);
        long[] anyAssetTagIds = AssetTagLocalServiceUtil.getTagIds((long[])scopeGroupIds, (String[])anyAssetTagNames);
        assetEntryQuery.setAnyTagIds(anyAssetTagIds);
        assetEntryQuery.setNotAllCategoryIds(notAllAssetCategoryIds);
        String[] stringArray2 = notAllAssetTagNames;
        int n2 = notAllAssetTagNames.length;
        n = 0;
        while (n < n2) {
            String assetTagName = stringArray2[n];
            long[] notAllAssetTagIds = AssetTagLocalServiceUtil.getTagIds((long[])scopeGroupIds, (String)assetTagName);
            assetEntryQuery.addNotAllTagIdsArray(notAllAssetTagIds);
            ++n;
        }
        assetEntryQuery.setNotAnyCategoryIds(notAnyAssetCategoryIds);
        long[] notAnyAssetTagIds = AssetTagLocalServiceUtil.getTagIds((long[])scopeGroupIds, (String[])notAnyAssetTagNames);
        assetEntryQuery.setNotAnyTagIds(notAnyAssetTagIds);
        return assetEntryQuery;
    }

    public String[] getAssetTagNames(PortletPreferences portletPreferences, long scopeGroupId) throws Exception {
        String[] queryValues;
        String[] allAssetTagNames = new String[]{};
        int i2 = 0;
        while ((queryValues = portletPreferences.getValues("queryValues" + i2, null)) != null && queryValues.length != 0) {
            boolean queryContains = GetterUtil.getBoolean((String)portletPreferences.getValue("queryContains" + i2, ""));
            boolean queryAndOperator = GetterUtil.getBoolean((String)portletPreferences.getValue("queryAndOperator" + i2, ""));
            String queryName = portletPreferences.getValue("queryName" + i2, "");
            if (!Validator.equals((Object)queryName, (Object)"assetCategories") && queryContains && queryAndOperator) {
                allAssetTagNames = queryValues;
            }
            ++i2;
        }
        return allAssetTagNames;
    }

    public String getClassName(AssetRendererFactory assetRendererFactory) {
        Class<?> clazz = assetRendererFactory.getClass();
        String className = clazz.getName();
        int pos = className.lastIndexOf(".");
        return className.substring(pos + 1);
    }

    public long[] getClassNameIds(PortletPreferences portletPreferences, long[] availableClassNameIds) {
        boolean anyAssetType = GetterUtil.getBoolean((String)portletPreferences.getValue("anyAssetType", Boolean.TRUE.toString()));
        if (anyAssetType) {
            return availableClassNameIds;
        }
        long defaultClassNameId = GetterUtil.getLong((String)portletPreferences.getValue("anyAssetType", null));
        if (defaultClassNameId > 0L) {
            return new long[]{defaultClassNameId};
        }
        long[] classNameIds = GetterUtil.getLongValues((String[])portletPreferences.getValues("classNameIds", null));
        if (classNameIds != null) {
            return classNameIds;
        }
        return availableClassNameIds;
    }

    public Long[] getClassTypeIds(PortletPreferences portletPreferences, String className, Long[] availableClassTypeIds) {
        boolean anyAssetType = GetterUtil.getBoolean((String)portletPreferences.getValue("anyClassType" + className, Boolean.TRUE.toString()));
        if (anyAssetType) {
            return availableClassTypeIds;
        }
        long defaultClassTypeId = GetterUtil.getLong((String)portletPreferences.getValue("anyClassType" + className, null));
        if (defaultClassTypeId > 0L) {
            return new Long[]{defaultClassTypeId};
        }
        Long[] classTypeIds = ArrayUtil.toArray((long[])StringUtil.split((String)portletPreferences.getValue("classTypeIds" + className, null), (long)0L));
        if (classTypeIds != null) {
            return classTypeIds;
        }
        return availableClassTypeIds;
    }

    public Map<Locale, String> getEmailAssetEntryAddedBodyMap(PortletPreferences preferences) {
        Locale defaultLocale;
        Map map = LocalizationUtil.getLocalizationMap((PortletPreferences)preferences, (String)"emailAssetEntryAddedBody");
        String defaultValue = (String)map.get(defaultLocale = LocaleUtil.getDefault());
        if (Validator.isNotNull((String)defaultValue)) {
            return map;
        }
        map.put(defaultLocale, ContentUtil.get((String)PropsUtil.get((String)"asset.publisher.email.asset.entry.added.body")));
        return map;
    }

    public boolean getEmailAssetEntryAddedEnabled(PortletPreferences preferences) {
        String emailAssetEntryAddedEnabled = preferences.getValue("emailAssetEntryAddedEnabled", "");
        if (Validator.isNotNull((String)emailAssetEntryAddedEnabled)) {
            return GetterUtil.getBoolean((String)emailAssetEntryAddedEnabled);
        }
        return PropsValues.ASSET_PUBLISHER_EMAIL_ASSET_ENTRY_ADDED_ENABLED;
    }

    public Map<Locale, String> getEmailAssetEntryAddedSubjectMap(PortletPreferences preferences) {
        Locale defaultLocale;
        Map map = LocalizationUtil.getLocalizationMap((PortletPreferences)preferences, (String)"emailAssetEntryAddedSubject");
        String defaultValue = (String)map.get(defaultLocale = LocaleUtil.getDefault());
        if (Validator.isNotNull((String)defaultValue)) {
            return map;
        }
        map.put(defaultLocale, ContentUtil.get((String)PropsUtil.get((String)"asset.publisher.email.asset.entry.added.subject")));
        return map;
    }

    public String getEmailFromAddress(PortletPreferences preferences, long companyId) throws SystemException {
        return PortalUtil.getEmailFromAddress((PortletPreferences)preferences, (long)companyId, (String)PropsValues.ASSET_PUBLISHER_EMAIL_FROM_ADDRESS);
    }

    public String getEmailFromName(PortletPreferences preferences, long companyId) throws SystemException {
        return PortalUtil.getEmailFromName((PortletPreferences)preferences, (long)companyId, (String)PropsValues.ASSET_PUBLISHER_EMAIL_FROM_NAME);
    }

    public long getGroupIdFromScopeId(String scopeId, long siteGroupId, boolean privateLayout) throws PortalException, SystemException {
        if (scopeId.startsWith("ChildGroup_")) {
            String scopeIdSuffix = scopeId.substring("ChildGroup_".length());
            return GetterUtil.getLong((String)scopeIdSuffix);
        }
        if (scopeId.startsWith("Group_")) {
            String scopeIdSuffix = scopeId.substring("Group_".length());
            if (scopeIdSuffix.equals("default")) {
                return siteGroupId;
            }
            return GetterUtil.getLong((String)scopeIdSuffix);
        }
        if (scopeId.startsWith("LayoutUuid_")) {
            String layoutUuid = scopeId.substring("LayoutUuid_".length());
            Layout scopeIdLayout = LayoutLocalServiceUtil.getLayoutByUuidAndGroupId((String)layoutUuid, (long)siteGroupId, (boolean)privateLayout);
            Group scopeIdGroup = null;
            scopeIdGroup = scopeIdLayout.hasScopeGroup() ? scopeIdLayout.getScopeGroup() : GroupLocalServiceUtil.addGroup((long)PrincipalThreadLocal.getUserId(), (long)0L, (String)Layout.class.getName(), (long)scopeIdLayout.getPlid(), (long)0L, (String)String.valueOf(scopeIdLayout.getPlid()), null, (int)0, null, (boolean)false, (boolean)true, null);
            return scopeIdGroup.getGroupId();
        }
        if (scopeId.startsWith("Layout_")) {
            String scopeIdSuffix = scopeId.substring("Layout_".length());
            long scopeIdLayoutId = GetterUtil.getLong((String)scopeIdSuffix);
            Layout scopeIdLayout = LayoutLocalServiceUtil.getLayout((long)siteGroupId, (boolean)privateLayout, (long)scopeIdLayoutId);
            Group scopeIdGroup = scopeIdLayout.getScopeGroup();
            return scopeIdGroup.getGroupId();
        }
        if (scopeId.startsWith("ParentGroup_")) {
            String scopeIdSuffix = scopeId.substring("ParentGroup_".length());
            return GetterUtil.getLong((String)scopeIdSuffix);
        }
        throw new IllegalArgumentException("Invalid scope ID " + scopeId);
    }

    public long[] getGroupIds(PortletPreferences portletPreferences, long scopeGroupId, Layout layout) {
        String[] scopeIds = portletPreferences.getValues("scopeIds", new String[]{"Group_" + scopeGroupId});
        long[] groupIds = new long[scopeIds.length];
        int i2 = 0;
        String[] stringArray = scopeIds;
        int n = scopeIds.length;
        int n2 = 0;
        while (n2 < n) {
            String scopeId = stringArray[n2];
            try {
                groupIds[i2] = this.getGroupIdFromScopeId(scopeId, scopeGroupId, layout.isPrivateLayout());
                ++i2;
            }
            catch (Exception exception) {}
            ++n2;
        }
        return groupIds;
    }

    public long getRecentFolderId(PortletRequest portletRequest, String className) {
        Long classPK = this._getRecentFolderIds(portletRequest).get(className);
        if (classPK == null) {
            return 0L;
        }
        return classPK;
    }

    public String getScopeId(Group group, long scopeGroupId) throws PortalException, SystemException {
        String key = null;
        if (group.isLayout()) {
            Layout layout = LayoutLocalServiceUtil.getLayout((long)group.getClassPK());
            key = "LayoutUuid_" + layout.getUuid();
        } else {
            Group scopeGroup;
            key = group.isLayoutPrototype() || group.getGroupId() == scopeGroupId ? "Group_default" : ((scopeGroup = GroupLocalServiceUtil.getGroup((long)scopeGroupId)).hasAncestor(group.getGroupId()) ? "ParentGroup_" + group.getGroupId() : (group.hasAncestor(scopeGroup.getGroupId()) ? "ChildGroup_" + group.getGroupId() : "Group_" + group.getGroupId()));
        }
        return key;
    }

    public boolean isScopeIdSelectable(PermissionChecker permissionChecker, String scopeId, long companyGroupId, Layout layout) throws PortalException, SystemException {
        long groupId = this.getGroupIdFromScopeId(scopeId, layout.getGroupId(), layout.isPrivateLayout());
        if (scopeId.startsWith("ChildGroup_")) {
            Group group = GroupLocalServiceUtil.getGroup((long)groupId);
            if (!group.hasAncestor(layout.getGroupId())) {
                return false;
            }
        } else {
            if (scopeId.startsWith("ParentGroup_")) {
                Group siteGroup = layout.getGroup();
                if (!siteGroup.hasAncestor(groupId)) {
                    return false;
                }
                if (SitesUtil.isContentSharingWithChildrenEnabled((Group)siteGroup)) {
                    return true;
                }
                if (!PrefsPropsUtil.getBoolean((long)layout.getCompanyId(), (String)"sites.content.sharing.through.administrators.enabled")) {
                    return false;
                }
                return GroupPermissionUtil.contains((PermissionChecker)permissionChecker, (long)groupId, (String)"UPDATE");
            }
            if (groupId != companyGroupId) {
                return GroupPermissionUtil.contains((PermissionChecker)permissionChecker, (long)groupId, (String)"UPDATE");
            }
        }
        return true;
    }

    public boolean isSubscribed(long companyId, long userId, long plid, String portletId) throws PortalException, SystemException {
        return SubscriptionLocalServiceUtil.isSubscribed((long)companyId, (long)userId, (String)com.liferay.portal.model.PortletPreferences.class.getName(), (long)this._getPortletPreferencesId(plid, portletId));
    }

    public void notifySubscribers(PortletPreferences preferences, long plid, String portletId, List<AssetEntry> assetEntries) throws PortalException, SystemException {
        if (!this.getEmailAssetEntryAddedEnabled(preferences) || assetEntries.isEmpty()) {
            return;
        }
        AssetEntry assetEntry = assetEntries.get(0);
        String fromName = this.getEmailFromName(preferences, assetEntry.getCompanyId());
        String fromAddress = this.getEmailFromAddress(preferences, assetEntry.getCompanyId());
        Map<Locale, String> localizedSubjectMap = this.getEmailAssetEntryAddedSubjectMap(preferences);
        Map<Locale, String> localizedBodyMap = this.getEmailAssetEntryAddedBodyMap(preferences);
        SubscriptionSender subscriptionSender = new SubscriptionSender();
        subscriptionSender.setCompanyId(assetEntry.getCompanyId());
        subscriptionSender.setContextAttributes(new Object[]{"[$ASSET_ENTRIES$]", ListUtil.toString(assetEntries, this._titleAccessor, (String)", ")});
        subscriptionSender.setContextUserPrefix("ASSET_PUBLISHER");
        subscriptionSender.setFrom(fromAddress, fromName);
        subscriptionSender.setHtmlFormat(true);
        subscriptionSender.setLocalizedBodyMap(localizedBodyMap);
        subscriptionSender.setLocalizedSubjectMap(localizedSubjectMap);
        subscriptionSender.setMailId("asset_entry", new Object[]{assetEntry.getEntryId()});
        subscriptionSender.setPortletId("101");
        subscriptionSender.setReplyToAddress(fromAddress);
        subscriptionSender.addPersistedSubscribers(com.liferay.portal.model.PortletPreferences.class.getName(), this._getPortletPreferencesId(plid, portletId));
        subscriptionSender.flushNotificationsAsync();
    }

    public void removeAndStoreSelection(List<String> assetEntryUuids, PortletPreferences portletPreferences) throws Exception {
        if (assetEntryUuids.size() == 0) {
            return;
        }
        Object[] assetEntryXmls = portletPreferences.getValues("assetEntryXml", new String[0]);
        List assetEntryXmlsList = ListUtil.fromArray((Object[])assetEntryXmls);
        Iterator itr = assetEntryXmlsList.iterator();
        while (itr.hasNext()) {
            String assetEntryXml = (String)itr.next();
            Document document = SAXReaderUtil.read((String)assetEntryXml);
            Element rootElement = document.getRootElement();
            String assetEntryUuid = rootElement.elementText("asset-entry-uuid");
            if (!assetEntryUuids.contains(assetEntryUuid)) continue;
            itr.remove();
        }
        portletPreferences.setValues("assetEntryXml", assetEntryXmlsList.toArray(new String[assetEntryXmlsList.size()]));
        portletPreferences.store();
    }

    public void removeRecentFolderId(PortletRequest portletRequest, String className, long classPK) {
        if (this.getRecentFolderId(portletRequest, className) == classPK) {
            this._getRecentFolderIds(portletRequest).remove(className);
        }
    }

    public void subscribe(PermissionChecker permissionChecker, long groupId, long plid, String portletId) throws PortalException, SystemException {
        PortletPermissionUtil.check((PermissionChecker)permissionChecker, (long)plid, (String)portletId, (String)"SUBSCRIBE");
        SubscriptionLocalServiceUtil.addSubscription((long)permissionChecker.getUserId(), (long)groupId, (String)com.liferay.portal.model.PortletPreferences.class.getName(), (long)this._getPortletPreferencesId(plid, portletId));
    }

    public void unsubscribe(PermissionChecker permissionChecker, long plid, String portletId) throws PortalException, SystemException {
        PortletPermissionUtil.check((PermissionChecker)permissionChecker, (long)plid, (String)portletId, (String)"SUBSCRIBE");
        SubscriptionLocalServiceUtil.deleteSubscription((long)permissionChecker.getUserId(), (String)com.liferay.portal.model.PortletPreferences.class.getName(), (long)this._getPortletPreferencesId(plid, portletId));
    }

    private void _checkAssetEntries(com.liferay.portal.model.PortletPreferences portletPreferences) throws PortalException, SystemException {
        Layout layout = LayoutLocalServiceUtil.getLayout((long)portletPreferences.getPlid());
        PortletPreferences preferences = PortletPreferencesFactoryUtil.fromXML((long)layout.getCompanyId(), (long)portletPreferences.getOwnerId(), (int)portletPreferences.getOwnerType(), (long)portletPreferences.getPlid(), (String)portletPreferences.getPortletId(), (String)portletPreferences.getPreferences());
        if (!this.getEmailAssetEntryAddedEnabled(preferences)) {
            return;
        }
        List<AssetEntry> assetEntries = this.getAssetEntries(preferences, layout, layout.getGroupId(), PropsValues.ASSET_PUBLISHER_DYNAMIC_SUBSCRIPTION_LIMIT, false);
        if (assetEntries.isEmpty()) {
            return;
        }
        long[] notifiedAssetEntryIds = GetterUtil.getLongValues((String[])preferences.getValues("notifiedAssetEntryIds", null));
        ArrayList<AssetEntry> newAssetEntries = new ArrayList<AssetEntry>();
        int i2 = 0;
        while (i2 < assetEntries.size()) {
            AssetEntry assetEntry = assetEntries.get(i2);
            if (!ArrayUtil.contains((long[])notifiedAssetEntryIds, (long)assetEntry.getEntryId())) {
                newAssetEntries.add(assetEntry);
            }
            ++i2;
        }
        this.notifySubscribers(preferences, portletPreferences.getPlid(), portletPreferences.getPortletId(), newAssetEntries);
        try {
            preferences.setValues("notifiedAssetEntryIds", StringUtil.split((String)ListUtil.toString(assetEntries, (Accessor)AssetEntry.ENTRY_ID_ACCESSOR)));
            preferences.store();
        }
        catch (IOException ioe) {
            throw new SystemException((Throwable)ioe);
        }
        catch (PortletException pe) {
            throw new SystemException((Throwable)pe);
        }
    }

    private String _getAssetEntryXml(String assetEntryType, String assetEntryUuid) {
        String xml;
        block2: {
            xml = null;
            try {
                Document document = SAXReaderUtil.createDocument((String)"UTF-8");
                Element assetEntryElement = document.addElement("asset-entry");
                Element assetEntryTypeElement = assetEntryElement.addElement("asset-entry-type");
                assetEntryTypeElement.addText(assetEntryType);
                Element assetEntryUuidElement = assetEntryElement.addElement("asset-entry-uuid");
                assetEntryUuidElement.addText(assetEntryUuid);
                xml = document.formattedString("");
            }
            catch (IOException ioe) {
                if (!_log.isWarnEnabled()) break block2;
                _log.warn((Throwable)ioe);
            }
        }
        return xml;
    }

    private long _getPortletPreferencesId(long plid, String portletId) throws PortalException, SystemException {
        com.liferay.portal.model.PortletPreferences portletPreferences = PortletPreferencesLocalServiceUtil.getPortletPreferences((long)0L, (int)3, (long)plid, (String)portletId);
        return portletPreferences.getPortletPreferencesId();
    }

    private Map<String, Long> _getRecentFolderIds(PortletRequest portletRequest) {
        HttpServletRequest request = PortalUtil.getHttpServletRequest((PortletRequest)portletRequest);
        HttpSession session = request.getSession();
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        String key = AssetPublisherUtil.class + "_" + themeDisplay.getScopeGroupId();
        HashMap<String, Long> recentFolderIds = (HashMap<String, Long>)session.getAttribute(key);
        if (recentFolderIds == null) {
            recentFolderIds = new HashMap<String, Long>();
        }
        session.setAttribute(key, recentFolderIds);
        return recentFolderIds;
    }
}

