/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.asset.service.persistence;

import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.SQLQuery;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.Type;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.security.permission.InlineSQLHelperUtil;
import com.liferay.portal.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portlet.asset.NoSuchTagException;
import com.liferay.portlet.asset.model.AssetTag;
import com.liferay.portlet.asset.model.impl.AssetTagImpl;
import com.liferay.portlet.asset.service.persistence.AssetTagFinder;
import com.liferay.util.dao.orm.CustomSQLUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class AssetTagFinderImpl
extends BasePersistenceImpl<AssetTag>
implements AssetTagFinder {
    public static final String COUNT_BY_G_N = String.valueOf(AssetTagFinder.class.getName()) + ".countByG_N";
    public static final String COUNT_BY_G_C_N = String.valueOf(AssetTagFinder.class.getName()) + ".countByG_C_N";
    public static final String COUNT_BY_G_N_P = String.valueOf(AssetTagFinder.class.getName()) + ".countByG_N_P";
    public static final String FIND_BY_G_N = String.valueOf(AssetTagFinder.class.getName()) + ".findByG_N";
    public static final String FIND_BY_G_C_N = String.valueOf(AssetTagFinder.class.getName()) + ".findByG_C_N";
    public static final String FIND_BY_G_N_P = String.valueOf(AssetTagFinder.class.getName()) + ".findByG_N_P";
    public static final String FIND_BY_G_N_S_E = String.valueOf(AssetTagFinder.class.getName()) + ".findByG_N_S_E";

    public int countByG_C_N(long groupId, long classNameId, String name) throws SystemException {
        return this.doCountByG_C_N(groupId, classNameId, name, false);
    }

    public int countByG_N_P(long groupId, String name, String[] tagProperties) throws SystemException {
        return this.doCountByG_N_P(groupId, name, tagProperties, false);
    }

    public int filterCountByG_N(long groupId, String name) throws SystemException {
        return this.doCountByG_N(groupId, name, true);
    }

    public int filterCountByG_C_N(long groupId, long classNameId, String name) throws SystemException {
        return this.doCountByG_C_N(groupId, classNameId, name, true);
    }

    public int filterCountByG_N_P(long groupId, String name, String[] tagProperties) throws SystemException {
        return this.doCountByG_N_P(groupId, name, tagProperties, true);
    }

    public AssetTag filterFindByG_N(long groupId, String name) throws NoSuchTagException, SystemException {
        return this.doFindByG_N(groupId, name, true);
    }

    public List<AssetTag> filterFindByG_C_N(long groupId, long classNameId, String name, int start, int end, OrderByComparator obc) throws SystemException {
        return this.doFindByG_C_N(groupId, classNameId, name, start, end, obc, true);
    }

    public List<AssetTag> filterFindByG_N_P(long[] groupIds, String name, String[] tagProperties, int start, int end, OrderByComparator obc) throws SystemException {
        return this.doFindByG_N_P(groupIds, name, tagProperties, start, end, obc, true);
    }

    public AssetTag findByG_N(long groupId, String name) throws NoSuchTagException, SystemException {
        return this.doFindByG_N(groupId, name, false);
    }

    public List<AssetTag> findByG_C_N(long groupId, long classNameId, String name, int start, int end, OrderByComparator obc) throws SystemException {
        return this.doFindByG_C_N(groupId, classNameId, name, start, end, obc, false);
    }

    public List<AssetTag> findByG_N_P(long[] groupIds, String name, String[] tagProperties, int start, int end, OrderByComparator obc) throws SystemException {
        return this.doFindByG_N_P(groupIds, name, tagProperties, start, end, obc, false);
    }

    public List<AssetTag> findByG_N_S_E(long groupId, String name, int startPeriod, int endPeriod, int periodLength) throws SystemException {
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_BY_G_N_S_E);
            SQLQuery q = session.createSQLQuery(sql);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(groupId);
            qPos.add(name);
            qPos.add(startPeriod);
            qPos.add(endPeriod);
            qPos.add(periodLength);
            qPos.add(endPeriod);
            ArrayList<AssetTag> assetTags = new ArrayList<AssetTag>();
            Iterator itr = q.iterate();
            while (itr.hasNext()) {
                Object[] array = (Object[])itr.next();
                AssetTagImpl assetTag = new AssetTagImpl();
                assetTag.setTagId(GetterUtil.getLong((Object)array[0]));
                assetTag.setName(GetterUtil.getString((Object)array[1]));
                assetTag.setAssetCount(GetterUtil.getInteger((Object)array[2]));
                assetTags.add(assetTag);
            }
            ArrayList<AssetTag> arrayList = assetTags;
            return arrayList;
        }
        catch (Exception e2) {
            throw new SystemException((Throwable)e2);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected int doCountByG_N(long groupId, String name, boolean inlineSQLHelper) throws SystemException {
        Session session = null;
        try {
            Long count;
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)COUNT_BY_G_N);
            if (inlineSQLHelper) {
                sql = InlineSQLHelperUtil.replacePermissionCheck((String)sql, (String)AssetTag.class.getName(), (String)"AssetTag.tagId", (long)groupId);
            }
            SQLQuery q = session.createSQLQuery(sql);
            q.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(groupId);
            qPos.add(name);
            Iterator itr = q.iterate();
            if (itr.hasNext() && (count = (Long)itr.next()) != null) {
                int n = count.intValue();
                return n;
            }
            return 0;
        }
        catch (Exception e2) {
            throw new SystemException((Throwable)e2);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected int doCountByG_C_N(long groupId, long classNameId, String name, boolean inlineSQLHelper) throws SystemException {
        Session session = null;
        try {
            Long count;
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)COUNT_BY_G_C_N);
            if (inlineSQLHelper) {
                sql = InlineSQLHelperUtil.replacePermissionCheck((String)sql, (String)AssetTag.class.getName(), (String)"AssetTag.tagId", (long)groupId);
            }
            SQLQuery q = session.createSQLQuery(sql);
            q.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(groupId);
            qPos.add(classNameId);
            qPos.add(name);
            qPos.add(name);
            Iterator itr = q.iterate();
            if (itr.hasNext() && (count = (Long)itr.next()) != null) {
                int n = count.intValue();
                return n;
            }
            return 0;
        }
        catch (Exception e2) {
            throw new SystemException((Throwable)e2);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected int doCountByG_N_P(long groupId, String name, String[] tagProperties, boolean inlineSQLHelper) throws SystemException {
        Session session = null;
        try {
            Long count;
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)COUNT_BY_G_N_P);
            sql = StringUtil.replace((String)sql, (String)"[$JOIN$]", (String)this.getJoin(tagProperties));
            if (inlineSQLHelper) {
                sql = InlineSQLHelperUtil.replacePermissionCheck((String)sql, (String)AssetTag.class.getName(), (String)"AssetTag.tagId", (long)groupId);
            }
            SQLQuery q = session.createSQLQuery(sql);
            q.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            this.setJoin(qPos, tagProperties);
            qPos.add(groupId);
            qPos.add(name);
            qPos.add(name);
            Iterator itr = q.iterate();
            if (itr.hasNext() && (count = (Long)itr.next()) != null) {
                int n = count.intValue();
                return n;
            }
            return 0;
        }
        catch (Exception e2) {
            throw new SystemException((Throwable)e2);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected AssetTag doFindByG_N(long groupId, String name, boolean inlineSQLHelper) throws NoSuchTagException, SystemException {
        name = name.trim().toLowerCase();
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_BY_G_N);
            if (inlineSQLHelper) {
                sql = InlineSQLHelperUtil.replacePermissionCheck((String)sql, (String)AssetTag.class.getName(), (String)"AssetTag.tagId", (long)groupId);
            }
            SQLQuery q = session.createSQLQuery(sql);
            q.addEntity("AssetTag", AssetTagImpl.class);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(groupId);
            qPos.add(name);
            List tags = q.list();
            if (!tags.isEmpty()) {
                AssetTag assetTag = (AssetTag)tags.get(0);
                return assetTag;
            }
        }
        catch (Exception e2) {
            throw new SystemException((Throwable)e2);
        }
        finally {
            this.closeSession(session);
        }
        StringBundler sb = new StringBundler(6);
        sb.append("No AssetTag exists with the key ");
        sb.append("{groupId=");
        sb.append(groupId);
        sb.append(", name=");
        sb.append(name);
        sb.append("}");
        throw new NoSuchTagException(sb.toString());
    }

    protected List<AssetTag> doFindByG_C_N(long groupId, long classNameId, String name, int start, int end, OrderByComparator obc, boolean inlineSQLHelper) throws SystemException {
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_BY_G_C_N);
            sql = CustomSQLUtil.replaceOrderBy((String)sql, (OrderByComparator)obc);
            if (inlineSQLHelper) {
                sql = InlineSQLHelperUtil.replacePermissionCheck((String)sql, (String)AssetTag.class.getName(), (String)"AssetTag.tagId", (long)groupId);
            }
            SQLQuery q = session.createSQLQuery(sql);
            q.addEntity("AssetTag", AssetTagImpl.class);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(groupId);
            qPos.add(classNameId);
            qPos.add(name);
            qPos.add(name);
            List list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
            return list;
        }
        catch (Exception e2) {
            throw new SystemException((Throwable)e2);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected List<AssetTag> doFindByG_N_P(long[] groupIds, String name, String[] tagProperties, int start, int end, OrderByComparator obc, boolean inlineSQLHelper) throws SystemException {
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_BY_G_N_P);
            sql = StringUtil.replace((String)sql, (String)"[$JOIN$]", (String)this.getJoin(tagProperties));
            sql = StringUtil.replace((String)sql, (String)"[$GROUP_ID$]", (String)this.getGroupIds(groupIds));
            sql = CustomSQLUtil.replaceOrderBy((String)sql, (OrderByComparator)obc);
            if (inlineSQLHelper) {
                sql = InlineSQLHelperUtil.replacePermissionCheck((String)sql, (String)AssetTag.class.getName(), (String)"AssetTag.tagId", (long[])groupIds);
            }
            SQLQuery q = session.createSQLQuery(sql);
            q.addEntity("AssetTag", AssetTagImpl.class);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            this.setJoin(qPos, tagProperties);
            qPos.add(groupIds);
            qPos.add(name);
            qPos.add(name);
            List list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
            return list;
        }
        catch (Exception e2) {
            throw new SystemException((Throwable)e2);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected String getGroupIds(long[] groupIds) {
        if (groupIds.length == 0) {
            return "";
        }
        StringBundler sb = new StringBundler(groupIds.length * 2);
        sb.append("(");
        int i2 = 0;
        while (i2 < groupIds.length) {
            sb.append("groupId = ?");
            if (i2 + 1 < groupIds.length) {
                sb.append(" OR ");
            }
            ++i2;
        }
        sb.append(") AND");
        return sb.toString();
    }

    protected String getJoin(String[] tagProperties) {
        if (tagProperties.length == 0) {
            return "";
        }
        StringBundler sb = new StringBundler(tagProperties.length * 3 + 1);
        sb.append(" INNER JOIN AssetTagProperty ON ");
        sb.append(" (AssetTagProperty.tagId = AssetTag.tagId) AND ");
        int i2 = 0;
        while (i2 < tagProperties.length) {
            sb.append("(AssetTagProperty.key_ = ? AND ");
            sb.append("AssetTagProperty.value = ?) ");
            if (i2 + 1 < tagProperties.length) {
                sb.append(" AND ");
            }
            ++i2;
        }
        return sb.toString();
    }

    protected void setJoin(QueryPos qPos, String[] tagProperties) {
        String[] stringArray = tagProperties;
        int n = tagProperties.length;
        int n2 = 0;
        while (n2 < n) {
            String tagProperty = stringArray[n2];
            String[] tagPropertyParts = StringUtil.split((String)tagProperty, (char)':');
            String key = "";
            if (tagPropertyParts.length > 0) {
                key = GetterUtil.getString((String)tagPropertyParts[0]);
            }
            String value = "";
            if (tagPropertyParts.length > 1) {
                value = GetterUtil.getString((String)tagPropertyParts[1]);
            }
            qPos.add(key);
            qPos.add(value);
            ++n2;
        }
    }
}

