/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.asset.service.permission;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portlet.asset.model.AssetTag;
import com.liferay.portlet.asset.service.AssetTagLocalServiceUtil;

public class AssetTagPermission {
    public static void check(PermissionChecker permissionChecker, AssetTag tag, String actionId) throws PortalException {
        if (!AssetTagPermission.contains(permissionChecker, tag, actionId)) {
            throw new PrincipalException();
        }
    }

    public static void check(PermissionChecker permissionChecker, long tagId, String actionId) throws PortalException, SystemException {
        if (!AssetTagPermission.contains(permissionChecker, tagId, actionId)) {
            throw new PrincipalException();
        }
    }

    public static boolean contains(PermissionChecker permissionChecker, AssetTag tag, String actionId) {
        if (permissionChecker.hasOwnerPermission(tag.getCompanyId(), AssetTag.class.getName(), tag.getTagId(), tag.getUserId(), actionId)) {
            return true;
        }
        return permissionChecker.hasPermission(tag.getGroupId(), AssetTag.class.getName(), tag.getTagId(), actionId);
    }

    public static boolean contains(PermissionChecker permissionChecker, long tagId, String actionId) throws PortalException, SystemException {
        AssetTag tag = AssetTagLocalServiceUtil.getTag((long)tagId);
        return AssetTagPermission.contains(permissionChecker, tag, actionId);
    }
}

