/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.admin.action;

import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.struts.PortletAction;
import com.liferay.portal.theme.ThemeDisplay;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Stroke;
import java.io.OutputStream;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.DialShape;
import org.jfree.chart.plot.MeterInterval;
import org.jfree.chart.plot.MeterPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.data.Range;
import org.jfree.data.general.DefaultValueDataset;
import org.jfree.data.general.ValueDataset;

public class ViewChartAction
extends PortletAction {
    private static final boolean _CHECK_METHOD_ON_PROCESS_ACTION = false;

    @Override
    public void serveResource(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, ResourceRequest resourceRequest, ResourceResponse resourceResponse) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)resourceRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        String type = ParamUtil.getString((PortletRequest)resourceRequest, (String)"type", (String)"max");
        long maxMemory = ParamUtil.getLong((PortletRequest)resourceRequest, (String)"maxMemory");
        long totalMemory = ParamUtil.getLong((PortletRequest)resourceRequest, (String)"totalMemory");
        long usedMemory = ParamUtil.getLong((PortletRequest)resourceRequest, (String)"usedMemory");
        DefaultValueDataset valueDataset = null;
        StringBundler sb = new StringBundler(5);
        sb.append(themeDisplay.translate("used-memory"));
        sb.append(" ");
        sb.append("/");
        sb.append(" ");
        if (type.equals("total")) {
            valueDataset = new DefaultValueDataset((double)(usedMemory * 100L / totalMemory));
            sb.append(themeDisplay.translate("total-memory"));
        } else {
            valueDataset = new DefaultValueDataset((double)(usedMemory * 100L / maxMemory));
            sb.append(themeDisplay.translate("maximum-memory"));
        }
        MeterPlot meterPlot = this.getMeterPlot(themeDisplay, (ValueDataset)valueDataset);
        JFreeChart jFreeChart = this.getJFreeChart(sb.toString(), meterPlot);
        resourceResponse.setContentType("image/jpeg");
        OutputStream outputStream = resourceResponse.getPortletOutputStream();
        ChartUtilities.writeChartAsPNG((OutputStream)outputStream, (JFreeChart)jFreeChart, (int)280, (int)180);
    }

    protected JFreeChart getJFreeChart(String title, MeterPlot meterPlot) {
        JFreeChart jFreeChart = new JFreeChart(title, new Font(null, 0, 13), (Plot)meterPlot, true);
        jFreeChart.removeLegend();
        jFreeChart.setBackgroundPaint((Paint)Color.white);
        return jFreeChart;
    }

    protected MeterPlot getMeterPlot(ThemeDisplay themeDisplay, ValueDataset valueDataset) {
        MeterPlot meterPlot = new MeterPlot(valueDataset);
        meterPlot.addInterval(new MeterInterval(themeDisplay.translate("normal"), new Range(0.0, 75.0), (Paint)Color.lightGray, (Stroke)new BasicStroke(2.0f), (Paint)new Color(0, 255, 0, 64)));
        meterPlot.addInterval(new MeterInterval(themeDisplay.translate("warning"), new Range(75.0, 90.0), (Paint)Color.lightGray, (Stroke)new BasicStroke(2.0f), (Paint)new Color(255, 255, 0, 64)));
        meterPlot.addInterval(new MeterInterval(themeDisplay.translate("critical"), new Range(90.0, 100.0), (Paint)Color.lightGray, (Stroke)new BasicStroke(2.0f), (Paint)new Color(255, 0, 0, 128)));
        meterPlot.setDialBackgroundPaint((Paint)Color.white);
        meterPlot.setDialShape(DialShape.PIE);
        meterPlot.setDialOutlinePaint((Paint)Color.gray);
        meterPlot.setTickLabelFont(new Font(null, 0, 10));
        meterPlot.setTickLabelPaint((Paint)Color.darkGray);
        meterPlot.setTickLabelsVisible(true);
        meterPlot.setTickPaint((Paint)Color.lightGray);
        meterPlot.setTickSize(5.0);
        meterPlot.setMeterAngle(180);
        meterPlot.setNeedlePaint((Paint)Color.darkGray);
        meterPlot.setRange(new Range(0.0, 100.0));
        meterPlot.setValueFont(new Font(null, 0, 10));
        meterPlot.setValuePaint((Paint)Color.black);
        meterPlot.setUnits("%");
        return meterPlot;
    }

    @Override
    protected boolean isCheckMethodOnProcessAction() {
        return false;
    }
}

