/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.admin.action;

import com.liferay.mail.service.MailServiceUtil;
import com.liferay.portal.captcha.CaptchaImpl;
import com.liferay.portal.captcha.recaptcha.ReCaptchaImpl;
import com.liferay.portal.captcha.simplecaptcha.SimpleCaptchaImpl;
import com.liferay.portal.convert.ConvertProcess;
import com.liferay.portal.kernel.cache.CacheRegistryUtil;
import com.liferay.portal.kernel.cache.MultiVMPoolUtil;
import com.liferay.portal.kernel.captcha.CaptchaUtil;
import com.liferay.portal.kernel.cluster.Address;
import com.liferay.portal.kernel.cluster.ClusterExecutorUtil;
import com.liferay.portal.kernel.cluster.ClusterRequest;
import com.liferay.portal.kernel.concurrent.ThreadPoolExecutor;
import com.liferay.portal.kernel.dao.shard.ShardUtil;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.executor.PortalExecutorManagerUtil;
import com.liferay.portal.kernel.image.GhostscriptUtil;
import com.liferay.portal.kernel.image.ImageMagickUtil;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayOutputStream;
import com.liferay.portal.kernel.io.unsync.UnsyncPrintWriter;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.BaseAsyncDestination;
import com.liferay.portal.kernel.messaging.Destination;
import com.liferay.portal.kernel.messaging.MessageBus;
import com.liferay.portal.kernel.messaging.MessageBusUtil;
import com.liferay.portal.kernel.messaging.proxy.MessageValuesThreadLocal;
import com.liferay.portal.kernel.scripting.ScriptingException;
import com.liferay.portal.kernel.scripting.ScriptingUtil;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.SearchEngineUtil;
import com.liferay.portal.kernel.servlet.DirectServletRegistryUtil;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.servlet.SessionMessages;
import com.liferay.portal.kernel.util.InstancePool;
import com.liferay.portal.kernel.util.MethodHandler;
import com.liferay.portal.kernel.util.MethodKey;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.ProgressTracker;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.ThreadUtil;
import com.liferay.portal.kernel.util.UnsyncPrintWriterPool;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.webcache.WebCachePoolUtil;
import com.liferay.portal.kernel.xuggler.XugglerUtil;
import com.liferay.portal.model.Portlet;
import com.liferay.portal.search.lucene.LuceneHelperUtil;
import com.liferay.portal.search.lucene.LuceneIndexer;
import com.liferay.portal.search.lucene.cluster.LuceneClusterUtil;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.security.membershippolicy.OrganizationMembershipPolicy;
import com.liferay.portal.security.membershippolicy.OrganizationMembershipPolicyFactoryUtil;
import com.liferay.portal.security.membershippolicy.RoleMembershipPolicy;
import com.liferay.portal.security.membershippolicy.RoleMembershipPolicyFactoryUtil;
import com.liferay.portal.security.membershippolicy.SiteMembershipPolicy;
import com.liferay.portal.security.membershippolicy.SiteMembershipPolicyFactoryUtil;
import com.liferay.portal.security.membershippolicy.UserGroupMembershipPolicy;
import com.liferay.portal.security.membershippolicy.UserGroupMembershipPolicyFactoryUtil;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.service.PortletLocalServiceUtil;
import com.liferay.portal.service.ServiceComponentLocalServiceUtil;
import com.liferay.portal.struts.PortletAction;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.upload.UploadServletRequestImpl;
import com.liferay.portal.util.MaintenanceUtil;
import com.liferay.portal.util.PortalInstances;
import com.liferay.portal.util.PrefsPropsUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portal.util.ShutdownUtil;
import com.liferay.portlet.ActionResponseImpl;
import com.liferay.portlet.admin.util.CleanUpPermissionsUtil;
import com.liferay.portlet.documentlibrary.util.DLPreviewableProcessor;
import com.liferay.util.log4j.Log4JUtil;
import java.io.File;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletSession;
import javax.portlet.PortletURL;
import javax.portlet.WindowState;
import org.apache.log4j.Level;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;

public class EditServerAction
extends PortletAction {
    private static Log _log = LogFactoryUtil.getLog(EditServerAction.class);
    private static MethodKey _loadIndexesFromClusterMethodKey = new MethodKey(LuceneClusterUtil.class, "loadIndexesFromCluster", new Class[]{long[].class, Address.class});

    @Override
    public void processAction(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        PermissionChecker permissionChecker = themeDisplay.getPermissionChecker();
        if (!permissionChecker.isOmniadmin()) {
            SessionErrors.add((PortletRequest)actionRequest, (String)PrincipalException.class.getName());
            this.setForward((PortletRequest)actionRequest, "portlet.admin.error");
            return;
        }
        PortletPreferences preferences = PrefsPropsUtil.getPreferences();
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        String redirect = null;
        if (cmd.equals("addLogLevel")) {
            this.addLogLevel(actionRequest);
        } else if (cmd.equals("cacheDb")) {
            this.cacheDb();
        } else if (cmd.equals("cacheMulti")) {
            this.cacheMulti();
        } else if (cmd.equals("cacheServlet")) {
            this.cacheServlet();
        } else if (cmd.equals("cacheSingle")) {
            this.cacheSingle();
        } else if (cmd.equals("cleanUpPermissions")) {
            CleanUpPermissionsUtil.cleanUpAddToPagePermissions(actionRequest);
        } else if (cmd.startsWith("convertProcess.")) {
            redirect = this.convertProcess(actionRequest, actionResponse, cmd);
        } else if (cmd.equals("dlPreviews")) {
            DLPreviewableProcessor.deleteFiles();
        } else if (cmd.equals("gc")) {
            this.gc();
        } else {
            if (cmd.equals("installXuggler")) {
                this.installXuggler(actionRequest, actionResponse);
                this.setForward((PortletRequest)actionRequest, "/common/null.jsp");
                return;
            }
            if (cmd.equals("reindex")) {
                this.reindex(actionRequest);
            } else if (cmd.equals("reindexDictionaries")) {
                this.reindexDictionaries(actionRequest);
            } else if (cmd.equals("runScript")) {
                this.runScript(portletConfig, actionRequest, actionResponse);
            } else if (cmd.equals("shutdown")) {
                this.shutdown(actionRequest);
            } else if (cmd.equals("threadDump")) {
                this.threadDump();
            } else if (cmd.equals("updateCaptcha")) {
                this.updateCaptcha(actionRequest, preferences);
            } else if (cmd.equals("updateExternalServices")) {
                this.updateExternalServices(actionRequest, preferences);
            } else if (cmd.equals("updateFileUploads")) {
                this.updateFileUploads(actionRequest, preferences);
            } else if (cmd.equals("updateLogLevels")) {
                this.updateLogLevels(actionRequest);
            } else if (cmd.equals("updateMail")) {
                this.updateMail(actionRequest, preferences);
            } else if (cmd.equals("verifyMembershipPolicies")) {
                this.verifyMembershipPolicies();
            } else if (cmd.equals("verifyPluginTables")) {
                this.verifyPluginTables();
            }
        }
        this.sendRedirect(actionRequest, actionResponse, redirect);
    }

    protected void addLogLevel(ActionRequest actionRequest) throws Exception {
        String loggerName = ParamUtil.getString((PortletRequest)actionRequest, (String)"loggerName");
        String priority = ParamUtil.getString((PortletRequest)actionRequest, (String)"priority");
        Log4JUtil.setLevel((String)loggerName, (String)priority, (boolean)true);
    }

    protected void cacheDb() throws Exception {
        CacheRegistryUtil.clear();
    }

    protected void cacheMulti() throws Exception {
        MultiVMPoolUtil.clear();
    }

    protected void cacheServlet() throws Exception {
        DirectServletRegistryUtil.clearServlets();
    }

    protected void cacheSingle() throws Exception {
        WebCachePoolUtil.clear();
    }

    protected String convertProcess(ActionRequest actionRequest, ActionResponse actionResponse, String cmd) throws Exception {
        String path;
        ActionResponseImpl actionResponseImpl = (ActionResponseImpl)actionResponse;
        PortletSession portletSession = actionRequest.getPortletSession();
        String className = StringUtil.replaceFirst((String)cmd, (String)"convertProcess.", (String)"");
        ConvertProcess convertProcess = (ConvertProcess)InstancePool.get((String)className);
        String[] parameters = convertProcess.getParameterNames();
        if (parameters != null) {
            String[] values = new String[parameters.length];
            int i2 = 0;
            while (i2 < parameters.length) {
                String parameter = String.valueOf(className) + "." + parameters[i2];
                if (parameters[i2].contains("=")) {
                    String[] parameterPair = StringUtil.split((String)parameters[i2], (char)'=');
                    parameter = String.valueOf(className) + "." + parameterPair[0];
                }
                values[i2] = ParamUtil.getString((PortletRequest)actionRequest, (String)parameter);
                ++i2;
            }
            convertProcess.setParameterValues(values);
        }
        if ((path = convertProcess.getPath()) != null) {
            PortletURL portletURL = actionResponseImpl.createRenderURL();
            portletURL.setParameter("struts_action", path);
            portletURL.setWindowState(WindowState.MAXIMIZED);
            return portletURL.toString();
        }
        MaintenanceUtil.maintain(portletSession.getId(), className);
        MessageBusUtil.sendMessage((String)"liferay/convert_process", (Object)className);
        return null;
    }

    protected void gc() throws Exception {
        Runtime.getRuntime().gc();
    }

    protected String getFileExtensions(ActionRequest actionRequest, String name) {
        String value = ParamUtil.getString((PortletRequest)actionRequest, (String)name);
        return value.replace(", .", ",.");
    }

    protected void installXuggler(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        ProgressTracker progressTracker = new ProgressTracker((PortletRequest)actionRequest, "XUGGLER_INSTALL_STATUS");
        progressTracker.addProgress(1, 15, "downloading-xuggler");
        progressTracker.addProgress(2, 70, "copying-xuggler-files");
        progressTracker.initialize();
        String jarName = ParamUtil.getString((PortletRequest)actionRequest, (String)"jarName");
        try {
            XugglerUtil.installNativeLibraries((String)jarName, (ProgressTracker)progressTracker);
            JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
            jsonObject.put("success", Boolean.TRUE.booleanValue());
            this.writeJSON((PortletRequest)actionRequest, actionResponse, (Object)jsonObject);
        }
        catch (Exception e2) {
            JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
            jsonObject.put("exception", e2.getMessage());
            jsonObject.put("success", Boolean.FALSE.booleanValue());
            this.writeJSON((PortletRequest)actionRequest, actionResponse, (Object)jsonObject);
        }
        progressTracker.finish();
    }

    protected void reindex(ActionRequest actionRequest) throws Exception {
        Object object;
        String portletId = ParamUtil.getString((PortletRequest)actionRequest, (String)"portletId");
        long[] companyIds = PortalInstances.getCompanyIds();
        if (LuceneHelperUtil.isLoadIndexFromClusterEnabled()) {
            MessageValuesThreadLocal.setValue((String)"CLUSTER_FORWARD_MESSAGE", (Object)true);
        }
        HashSet<String> usedSearchEngineIds = new HashSet<String>();
        if (Validator.isNull((String)portletId)) {
            object = companyIds;
            int n = companyIds.length;
            int n2 = 0;
            while (n2 < n) {
                long companyId = object[n2];
                try {
                    LuceneIndexer luceneIndexer = new LuceneIndexer(companyId);
                    luceneIndexer.reindex();
                    usedSearchEngineIds.addAll(luceneIndexer.getUsedSearchEngineIds());
                }
                catch (Exception e2) {
                    _log.error((Object)e2, (Throwable)e2);
                }
                ++n2;
            }
        } else {
            long companyId;
            int n;
            int n3;
            long[] lArray;
            Portlet portlet = PortletLocalServiceUtil.getPortletById((long)companyIds[0], (String)portletId);
            if (portlet == null) {
                return;
            }
            List indexers = portlet.getIndexerInstances();
            if (indexers == null) {
                return;
            }
            HashSet<String> searchEngineIds = new HashSet<String>();
            object = indexers.iterator();
            while (object.hasNext()) {
                Indexer indexer = (Indexer)object.next();
                searchEngineIds.add(indexer.getSearchEngineId());
            }
            for (String searchEngineId : searchEngineIds) {
                lArray = companyIds;
                n3 = companyIds.length;
                n = 0;
                while (n < n3) {
                    companyId = lArray[n];
                    SearchEngineUtil.deletePortletDocuments((String)searchEngineId, (long)companyId, (String)portletId);
                    ++n;
                }
            }
            for (Indexer indexer : indexers) {
                lArray = companyIds;
                n3 = companyIds.length;
                n = 0;
                while (n < n3) {
                    block20: {
                        companyId = lArray[n];
                        ShardUtil.pushCompanyService((long)companyId);
                        try {
                            try {
                                indexer.reindex(new String[]{String.valueOf(companyId)});
                                usedSearchEngineIds.add(indexer.getSearchEngineId());
                            }
                            catch (Exception e3) {
                                _log.error((Object)e3, (Throwable)e3);
                                ShardUtil.popCompanyService();
                                break block20;
                            }
                        }
                        catch (Throwable throwable) {
                            ShardUtil.popCompanyService();
                            throw throwable;
                        }
                        ShardUtil.popCompanyService();
                    }
                    ++n;
                }
            }
        }
        if (!LuceneHelperUtil.isLoadIndexFromClusterEnabled()) {
            return;
        }
        HashSet<BaseAsyncDestination> searchWriterDestinations = new HashSet<BaseAsyncDestination>();
        MessageBus messageBus = MessageBusUtil.getMessageBus();
        for (String usedSearchEngineId : usedSearchEngineIds) {
            String searchWriterDestinationName = SearchEngineUtil.getSearchWriterDestinationName((String)usedSearchEngineId);
            Destination destination = messageBus.getDestination(searchWriterDestinationName);
            if (!(destination instanceof BaseAsyncDestination)) continue;
            BaseAsyncDestination baseAsyncDestination = (BaseAsyncDestination)destination;
            searchWriterDestinations.add(baseAsyncDestination);
        }
        this.submitClusterIndexLoadingSyncJob(searchWriterDestinations, companyIds);
    }

    protected void reindexDictionaries(ActionRequest actionRequest) throws Exception {
        long[] companyIds;
        long[] lArray = companyIds = PortalInstances.getCompanyIds();
        int n = companyIds.length;
        int n2 = 0;
        while (n2 < n) {
            long companyId = lArray[n2];
            SearchEngineUtil.indexDictionaries((long)companyId);
            ++n2;
        }
    }

    protected void runScript(PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String language = ParamUtil.getString((PortletRequest)actionRequest, (String)"language");
        String script = ParamUtil.getString((PortletRequest)actionRequest, (String)"script");
        PortletContext portletContext = portletConfig.getPortletContext();
        Map portletObjects = ScriptingUtil.getPortletObjects((PortletConfig)portletConfig, (PortletContext)portletContext, (PortletRequest)actionRequest, (PortletResponse)actionResponse);
        UnsyncByteArrayOutputStream unsyncByteArrayOutputStream = new UnsyncByteArrayOutputStream();
        UnsyncPrintWriter unsyncPrintWriter = UnsyncPrintWriterPool.borrow((OutputStream)unsyncByteArrayOutputStream);
        portletObjects.put("out", unsyncPrintWriter);
        try {
            SessionMessages.add((PortletRequest)actionRequest, (String)"language", (Object)language);
            SessionMessages.add((PortletRequest)actionRequest, (String)"script", (Object)script);
            ScriptingUtil.exec(null, (Map)portletObjects, (String)language, (String)script, (ClassLoader[])new ClassLoader[0]);
            unsyncPrintWriter.flush();
            SessionMessages.add((PortletRequest)actionRequest, (String)"scriptOutput", (Object)unsyncByteArrayOutputStream.toString());
        }
        catch (ScriptingException se) {
            SessionErrors.add((PortletRequest)actionRequest, (String)ScriptingException.class.getName(), (Object)((Object)se));
            _log.error((Object)se.getMessage());
        }
    }

    protected void shutdown(ActionRequest actionRequest) throws Exception {
        if (ShutdownUtil.isInProcess()) {
            ShutdownUtil.cancel();
        } else {
            long minutes = (long)ParamUtil.getInteger((PortletRequest)actionRequest, (String)"minutes") * 60000L;
            if (minutes <= 0L) {
                SessionErrors.add((PortletRequest)actionRequest, (String)"shutdownMinutes");
            } else {
                String message = ParamUtil.getString((PortletRequest)actionRequest, (String)"message");
                ShutdownUtil.shutdown(minutes, message);
            }
        }
    }

    protected void submitClusterIndexLoadingSyncJob(Set<BaseAsyncDestination> baseAsyncDestinations, long[] companyIds) throws Exception {
        if (_log.isInfoEnabled()) {
            StringBundler sb = new StringBundler(baseAsyncDestinations.size() + 1);
            sb.append("[");
            for (BaseAsyncDestination baseAsyncDestination : baseAsyncDestinations) {
                sb.append(baseAsyncDestination.getName());
                sb.append(", ");
            }
            sb.setStringAt("]", sb.index() - 1);
            _log.info((Object)("Synchronizecluster index loading for destinations " + sb.toString()));
        }
        int totalWorkersMaxSize = 0;
        for (BaseAsyncDestination baseAsyncDestination : baseAsyncDestinations) {
            totalWorkersMaxSize += baseAsyncDestination.getWorkersMaxSize();
        }
        if (_log.isInfoEnabled()) {
            _log.info((Object)("There are " + totalWorkersMaxSize + " synchronization threads"));
        }
        CountDownLatch countDownLatch = new CountDownLatch(totalWorkersMaxSize + 1);
        ClusterLoadingSyncJob slaveClusterLoadingSyncJob = new ClusterLoadingSyncJob(companyIds, countDownLatch, false);
        for (BaseAsyncDestination baseAsyncDestination : baseAsyncDestinations) {
            ThreadPoolExecutor threadPoolExecutor = PortalExecutorManagerUtil.getPortalExecutor((String)baseAsyncDestination.getName());
            int i2 = 0;
            while (i2 < baseAsyncDestination.getWorkersMaxSize()) {
                threadPoolExecutor.execute((Runnable)slaveClusterLoadingSyncJob);
                ++i2;
            }
        }
        ClusterLoadingSyncJob masterClusterLoadingSyncJob = new ClusterLoadingSyncJob(companyIds, countDownLatch, true);
        ThreadPoolExecutor threadPoolExecutor = PortalExecutorManagerUtil.getPortalExecutor((String)EditServerAction.class.getName());
        threadPoolExecutor.execute((Runnable)masterClusterLoadingSyncJob);
    }

    protected void threadDump() throws Exception {
        if (_log.isInfoEnabled()) {
            _log.info((Object)ThreadUtil.threadDump());
        } else {
            _log.error((Object)("Thread dumps require the log level to be at least INFO for " + ((Object)((Object)this)).getClass().getName()));
        }
    }

    protected void updateCaptcha(ActionRequest actionRequest, PortletPreferences preferences) throws Exception {
        boolean reCaptchaEnabled = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"reCaptchaEnabled");
        String reCaptchaPrivateKey = ParamUtil.getString((PortletRequest)actionRequest, (String)"reCaptchaPrivateKey");
        String reCaptchaPublicKey = ParamUtil.getString((PortletRequest)actionRequest, (String)"reCaptchaPublicKey");
        SimpleCaptchaImpl captcha = null;
        captcha = reCaptchaEnabled ? new ReCaptchaImpl() : new SimpleCaptchaImpl();
        this.validateCaptcha(actionRequest);
        if (SessionErrors.isEmpty((PortletRequest)actionRequest)) {
            preferences.setValue("captcha.engine.impl", captcha.getClass().getName());
            preferences.setValue("captcha.engine.recaptcha.key.private", reCaptchaPrivateKey);
            preferences.setValue("captcha.engine.recaptcha.key.public", reCaptchaPublicKey);
            preferences.store();
            CaptchaImpl captchaImpl = (CaptchaImpl)CaptchaUtil.getCaptcha();
            captchaImpl.setCaptcha(captcha);
        }
    }

    protected void updateExternalServices(ActionRequest actionRequest, PortletPreferences preferences) throws Exception {
        boolean imageMagickEnabled = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"imageMagickEnabled");
        String imageMagickPath = ParamUtil.getString((PortletRequest)actionRequest, (String)"imageMagickPath");
        boolean openOfficeEnabled = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"openOfficeEnabled");
        int openOfficePort = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"openOfficePort");
        boolean xugglerEnabled = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"xugglerEnabled");
        preferences.setValue("imagemagick.enabled", String.valueOf(imageMagickEnabled));
        preferences.setValue("imagemagick.global.search.path", imageMagickPath);
        preferences.setValue("openoffice.server.enabled", String.valueOf(openOfficeEnabled));
        preferences.setValue("openoffice.server.port", String.valueOf(openOfficePort));
        preferences.setValue("xuggler.enabled", String.valueOf(xugglerEnabled));
        Enumeration enu = actionRequest.getParameterNames();
        while (enu.hasMoreElements()) {
            String name = (String)enu.nextElement();
            if (!name.startsWith("imageMagickLimit")) continue;
            String key = name.substring(16, name.length()).toLowerCase();
            String value = ParamUtil.getString((PortletRequest)actionRequest, (String)name);
            preferences.setValue("imagemagick.resource.limit." + key, value);
        }
        preferences.store();
        GhostscriptUtil.reset();
        ImageMagickUtil.reset();
    }

    protected void updateFileUploads(ActionRequest actionRequest, PortletPreferences preferences) throws Exception {
        long dlFileEntryThumbnailMaxHeight = ParamUtil.getLong((PortletRequest)actionRequest, (String)"dlFileEntryThumbnailMaxHeight");
        long dlFileEntryThumbnailMaxWidth = ParamUtil.getLong((PortletRequest)actionRequest, (String)"dlFileEntryThumbnailMaxWidth");
        String dlFileExtensions = this.getFileExtensions(actionRequest, "dlFileExtensions");
        long dlFileMaxSize = ParamUtil.getLong((PortletRequest)actionRequest, (String)"dlFileMaxSize");
        String journalImageExtensions = this.getFileExtensions(actionRequest, "journalImageExtensions");
        long journalImageSmallMaxSize = ParamUtil.getLong((PortletRequest)actionRequest, (String)"journalImageSmallMaxSize");
        String shoppingImageExtensions = this.getFileExtensions(actionRequest, "shoppingImageExtensions");
        long scImageMaxSize = ParamUtil.getLong((PortletRequest)actionRequest, (String)"scImageMaxSize");
        long scImageThumbnailMaxHeight = ParamUtil.getLong((PortletRequest)actionRequest, (String)"scImageThumbnailMaxHeight");
        long scImageThumbnailMaxWidth = ParamUtil.getLong((PortletRequest)actionRequest, (String)"scImageThumbnailMaxWidth");
        long shoppingImageLargeMaxSize = ParamUtil.getLong((PortletRequest)actionRequest, (String)"shoppingImageLargeMaxSize");
        long shoppingImageMediumMaxSize = ParamUtil.getLong((PortletRequest)actionRequest, (String)"shoppingImageMediumMaxSize");
        long shoppingImageSmallMaxSize = ParamUtil.getLong((PortletRequest)actionRequest, (String)"shoppingImageSmallMaxSize");
        long uploadServletRequestImplMaxSize = ParamUtil.getLong((PortletRequest)actionRequest, (String)"uploadServletRequestImplMaxSize");
        String uploadServletRequestImplTempDir = ParamUtil.getString((PortletRequest)actionRequest, (String)"uploadServletRequestImplTempDir");
        long usersImageMaxSize = ParamUtil.getLong((PortletRequest)actionRequest, (String)"usersImageMaxSize");
        preferences.setValue("dl.file.entry.thumbnail.max.height", String.valueOf(dlFileEntryThumbnailMaxHeight));
        preferences.setValue("dl.file.entry.thumbnail.max.width", String.valueOf(dlFileEntryThumbnailMaxWidth));
        preferences.setValue("dl.file.extensions", dlFileExtensions);
        preferences.setValue("dl.file.max.size", String.valueOf(dlFileMaxSize));
        preferences.setValue("journal.image.extensions", journalImageExtensions);
        preferences.setValue("journal.image.small.max.size", String.valueOf(journalImageSmallMaxSize));
        preferences.setValue("shopping.image.extensions", shoppingImageExtensions);
        preferences.setValue("shopping.image.large.max.size", String.valueOf(shoppingImageLargeMaxSize));
        preferences.setValue("shopping.image.medium.max.size", String.valueOf(shoppingImageMediumMaxSize));
        preferences.setValue("shopping.image.small.max.size", String.valueOf(shoppingImageSmallMaxSize));
        preferences.setValue("sc.image.max.size", String.valueOf(scImageMaxSize));
        preferences.setValue("sc.image.thumbnail.max.height", String.valueOf(scImageThumbnailMaxHeight));
        preferences.setValue("sc.image.thumbnail.max.width", String.valueOf(scImageThumbnailMaxWidth));
        preferences.setValue("com.liferay.portal.upload.UploadServletRequestImpl.max.size", String.valueOf(uploadServletRequestImplMaxSize));
        if (Validator.isNotNull((String)uploadServletRequestImplTempDir)) {
            preferences.setValue("com.liferay.portal.upload.UploadServletRequestImpl.temp.dir", uploadServletRequestImplTempDir);
            UploadServletRequestImpl.setTempDir(new File(uploadServletRequestImplTempDir));
        }
        preferences.setValue("users.image.max.size", String.valueOf(usersImageMaxSize));
        preferences.store();
    }

    protected void updateLogLevels(ActionRequest actionRequest) throws Exception {
        Enumeration enu = actionRequest.getParameterNames();
        while (enu.hasMoreElements()) {
            String name = (String)enu.nextElement();
            if (!name.startsWith("logLevel")) continue;
            String loggerName = name.substring(8);
            String priority = ParamUtil.getString((PortletRequest)actionRequest, (String)name, (String)Level.INFO.toString());
            Log4JUtil.setLevel((String)loggerName, (String)priority, (boolean)true);
        }
    }

    protected void updateMail(ActionRequest actionRequest, PortletPreferences preferences) throws Exception {
        String advancedProperties = ParamUtil.getString((PortletRequest)actionRequest, (String)"advancedProperties");
        String pop3Host = ParamUtil.getString((PortletRequest)actionRequest, (String)"pop3Host");
        String pop3Password = ParamUtil.getString((PortletRequest)actionRequest, (String)"pop3Password");
        int pop3Port = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"pop3Port");
        boolean pop3Secure = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"pop3Secure");
        String pop3User = ParamUtil.getString((PortletRequest)actionRequest, (String)"pop3User");
        String smtpHost = ParamUtil.getString((PortletRequest)actionRequest, (String)"smtpHost");
        String smtpPassword = ParamUtil.getString((PortletRequest)actionRequest, (String)"smtpPassword");
        int smtpPort = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"smtpPort");
        boolean smtpSecure = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"smtpSecure");
        String smtpUser = ParamUtil.getString((PortletRequest)actionRequest, (String)"smtpUser");
        String storeProtocol = "pop3";
        if (pop3Secure) {
            storeProtocol = "pop3s";
        }
        String transportProtocol = "smtp";
        if (smtpSecure) {
            transportProtocol = "smtps";
        }
        preferences.setValue("mail.session.mail", "true");
        preferences.setValue("mail.session.mail.advanced.properties", advancedProperties);
        preferences.setValue("mail.session.mail.pop3.host", pop3Host);
        preferences.setValue("mail.session.mail.pop3.password", pop3Password);
        preferences.setValue("mail.session.mail.pop3.port", String.valueOf(pop3Port));
        preferences.setValue("mail.session.mail.pop3.user", pop3User);
        preferences.setValue("mail.session.mail.smtp.host", smtpHost);
        preferences.setValue("mail.session.mail.smtp.password", smtpPassword);
        preferences.setValue("mail.session.mail.smtp.port", String.valueOf(smtpPort));
        preferences.setValue("mail.session.mail.smtp.user", smtpUser);
        preferences.setValue("mail.session.mail.store.protocol", storeProtocol);
        preferences.setValue("mail.session.mail.transport.protocol", transportProtocol);
        preferences.store();
        MailServiceUtil.clearSession();
    }

    protected void validateCaptcha(ActionRequest actionRequest) throws Exception {
        boolean reCaptchaEnabled = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"reCaptchaEnabled");
        if (!reCaptchaEnabled) {
            return;
        }
        String reCaptchaPrivateKey = ParamUtil.getString((PortletRequest)actionRequest, (String)"reCaptchaPrivateKey");
        String reCaptchaPublicKey = ParamUtil.getString((PortletRequest)actionRequest, (String)"reCaptchaPublicKey");
        if (Validator.isNull((String)reCaptchaPublicKey)) {
            SessionErrors.add((PortletRequest)actionRequest, (String)"reCaptchaPublicKey");
        } else if (Validator.isNull((String)reCaptchaPrivateKey)) {
            SessionErrors.add((PortletRequest)actionRequest, (String)"reCaptchaPrivateKey");
        }
    }

    protected void verifyMembershipPolicies() throws Exception {
        OrganizationMembershipPolicy organizationMembershipPolicy = OrganizationMembershipPolicyFactoryUtil.getOrganizationMembershipPolicy();
        organizationMembershipPolicy.verifyPolicy();
        RoleMembershipPolicy roleMembershipPolicy = RoleMembershipPolicyFactoryUtil.getRoleMembershipPolicy();
        roleMembershipPolicy.verifyPolicy();
        SiteMembershipPolicy siteMembershipPolicy = SiteMembershipPolicyFactoryUtil.getSiteMembershipPolicy();
        siteMembershipPolicy.verifyPolicy();
        UserGroupMembershipPolicy userGroupMembershipPolicy = UserGroupMembershipPolicyFactoryUtil.getUserGroupMembershipPolicy();
        userGroupMembershipPolicy.verifyPolicy();
    }

    protected void verifyPluginTables() throws Exception {
        ServiceComponentLocalServiceUtil.verifyDB();
    }

    private static class ClusterLoadingSyncJob
    implements Runnable {
        private long[] _companyIds;
        private CountDownLatch _countDownLatch;
        private boolean _master;

        public ClusterLoadingSyncJob(long[] companyIds, CountDownLatch countDownLatch, boolean master) {
            this._companyIds = companyIds;
            this._countDownLatch = countDownLatch;
            this._master = master;
        }

        @Override
        public void run() {
            this._countDownLatch.countDown();
            String logPrefix = "";
            if (_log.isInfoEnabled()) {
                Thread currentThread = Thread.currentThread();
                logPrefix = this._master ? "Monitor thread name " + currentThread.getName() + " with thread ID " + currentThread.getId() : "Thread name " + currentThread.getName() + " with thread ID " + currentThread.getId();
            }
            if (!this._master && _log.isInfoEnabled()) {
                _log.info((Object)(String.valueOf(logPrefix) + " synchronized on latch. Waiting for others."));
            }
            try {
                if (this._master) {
                    this._countDownLatch.await();
                } else {
                    boolean result = this._countDownLatch.await(PropsValues.LUCENE_CLUSTER_INDEX_LOADING_SYNC_TIMEOUT, TimeUnit.MILLISECONDS);
                    if (!result) {
                        _log.error((Object)(String.valueOf(logPrefix) + " timed out. You may need to " + "re-trigger a reindex process."));
                    }
                }
            }
            catch (InterruptedException ie) {
                if (this._master) {
                    _log.error((Object)(String.valueOf(logPrefix) + " was interrupted. Skip cluster index " + "loading notification."), (Throwable)ie);
                    return;
                }
                _log.error((Object)(String.valueOf(logPrefix) + " was interrupted. You may need to " + "re-trigger a reindex process."), (Throwable)ie);
            }
            if (this._master) {
                Address localClusterNodeAddress = ClusterExecutorUtil.getLocalClusterNodeAddress();
                ClusterRequest clusterRequest = ClusterRequest.createMulticastRequest((MethodHandler)new MethodHandler(_loadIndexesFromClusterMethodKey, new Object[]{this._companyIds, localClusterNodeAddress}), (boolean)true);
                try {
                    ClusterExecutorUtil.execute((ClusterRequest)clusterRequest);
                }
                catch (SystemException se) {
                    _log.error((Object)"Unable to notify peers to start index loading", (Throwable)se);
                }
                if (_log.isInfoEnabled()) {
                    _log.info((Object)(String.valueOf(logPrefix) + " unlocked latch. Notified peers to " + "start index loading."));
                }
            }
        }
    }
}

