/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.admin.action;

import com.liferay.portal.CompanyMxException;
import com.liferay.portal.CompanyVirtualHostException;
import com.liferay.portal.CompanyWebIdException;
import com.liferay.portal.NoSuchCompanyException;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.model.Company;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.service.CompanyServiceUtil;
import com.liferay.portal.struts.PortletAction;
import com.liferay.portal.util.PortalInstances;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.admin.action.ActionUtil;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.servlet.ServletContext;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class EditInstanceAction
extends PortletAction {
    @Override
    public void processAction(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        try {
            this.updateInstance(actionRequest);
            this.sendRedirect(actionRequest, actionResponse);
        }
        catch (Exception e2) {
            if (e2 instanceof NoSuchCompanyException || e2 instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)actionRequest, e2.getClass());
                this.setForward((PortletRequest)actionRequest, "portlet.admin.error");
            }
            if (e2 instanceof CompanyMxException || e2 instanceof CompanyVirtualHostException || e2 instanceof CompanyWebIdException) {
                SessionErrors.add((PortletRequest)actionRequest, e2.getClass());
            }
            throw e2;
        }
    }

    @Override
    public ActionForward render(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        try {
            ActionUtil.getInstance((PortletRequest)renderRequest);
        }
        catch (Exception e2) {
            if (e2 instanceof NoSuchCompanyException || e2 instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)renderRequest, e2.getClass());
                return mapping.findForward("portlet.admin.error");
            }
            throw e2;
        }
        return mapping.findForward(this.getForward((PortletRequest)renderRequest, "portlet.admin.edit_instance"));
    }

    protected void updateInstance(ActionRequest actionRequest) throws Exception {
        long companyId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"companyId");
        String webId = ParamUtil.getString((PortletRequest)actionRequest, (String)"webId");
        String virtualHostname = ParamUtil.getString((PortletRequest)actionRequest, (String)"virtualHostname");
        String mx = ParamUtil.getString((PortletRequest)actionRequest, (String)"mx");
        String shardName = ParamUtil.getString((PortletRequest)actionRequest, (String)"shardName", (String)PropsValues.SHARD_DEFAULT_NAME);
        boolean system = false;
        int maxUsers = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"maxUsers", (int)0);
        boolean active = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"active");
        if (companyId <= 0L) {
            Company company = CompanyServiceUtil.addCompany((String)webId, (String)virtualHostname, (String)mx, (String)shardName, (boolean)system, (int)maxUsers, (boolean)active);
            ServletContext servletContext = (ServletContext)actionRequest.getAttribute("CTX");
            PortalInstances.initCompany(servletContext, company.getWebId());
        } else {
            CompanyServiceUtil.updateCompany((long)companyId, (String)virtualHostname, (String)mx, (int)maxUsers, (boolean)active);
        }
    }
}

